﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.IO.Ports;
using System.Windows.Controls.DataVisualization.Charting;
using System.ComponentModel;
using System.Collections.ObjectModel;
using SoftConsept.Collections;
using System.Threading;
using System.Timers;


namespace calboxgui
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

        #region fields
        SerialCommunications sc = new SerialCommunications();

        XMLDataStore xmlData = new XMLDataStore();
        List<Session> Sessions;
        ObservableCollectionEx<Session> SessionCollection;

        public ICommand FilterByWeekCommand { get { return new DelegateCommand(this.FilterWeek); } }

        ListCollectionView sortedList;
        ListCollectionView sortedListChart;

        bool calsSortFlag = true;
        bool dateSortFlag = true;
        bool minsSortFlag = true;

        public bool foundXbee = false;

        System.Threading.Thread xbeeThread;
        System.Timers.Timer timer = new System.Timers.Timer();
        System.Timers.Timer timer2 = new System.Timers.Timer();
        ConnectingWindow newWindow;

        System.Timers.Timer timer3 = new System.Timers.Timer(1000);
        static int countdown = 2;


        NewSessionWindow newWindow1;

        #endregion

        #region constructor
        public MainWindow()
        {
            newWindow = new ConnectingWindow(this);
            newWindow.Show();
            connectXBee();

            this.InitializeComponent();
            
            getValues();
            xmlData.loadSessionObjects();
            Sessions = xmlData.Sessions;
            SessionCollection = xmlData.SessionCollection;
            SessionList.DataContext = SessionCollection;
            sessionChart.DataContext = Sessions;

            sortedList = CollectionViewSource.GetDefaultView(SessionCollection) as ListCollectionView;
            sortedListChart = CollectionViewSource.GetDefaultView(SessionCollection) as ListCollectionView;

            DispatcherTimer timer = new DispatcherTimer(new TimeSpan(0, 0, 1), DispatcherPriority.Normal, delegate
            {
                this.TimeTextBlock.Text = DateTime.UtcNow.ToShortDateString() + " " + DateTime.UtcNow.ToShortTimeString();
            }, this.Dispatcher);


            getSessionSums(SessionCollection);

            sc.SerialPort.DataReceived += new SerialDataReceivedEventHandler(sp_DataReceived);

        }
        #endregion

        #region Public Methods
        public void getValues()
        {
            comPortLabel.Content = sc.PortName.ToString();
            baudRateLabel.Content = sc.BaudRate.ToString();
            dataBitsLabel.Content = sc.DataBits.ToString();
            parityLabel.Content = sc.Parity.ToString();
            stopbitsLabel.Content = sc.StopBits.ToString();
        }

        public void connectXBee()
        {
            bool weOpened = false;

            foreach (string port in sc.Ports)
            {
                if (!(sc.SerialPort.PortName == port))
                    sc.SerialPort.PortName = port;
                if (!sc.SerialPort.IsOpen)
                {
                    sc.SerialPort.Open();
                    weOpened = true;
                }

                //thread to wait for message
                ThreadStart test = new ThreadStart(ThreadJob);
                xbeeThread = new Thread(test);
                xbeeThread.Start();

                //send message to port
                sc.SerialPort.Write("+++");

                //sleep main thread while waiting for response
                Thread.Sleep(4000);

                if (foundXbee)
                {
                    break;
                }
                else if (weOpened)
                    sc.SerialPort.Close();
            }

            if (!foundXbee)
            {
                //Port not found
                //MessageBox.Show("NO XBEE FOUND");
                newWindow.searchingTextBlock.Text = "CalBOX360 Not Found! Check Connections...Closing";
                newWindow.ConnectingOKButton.Content = "Close";
                timer3.AutoReset = false;
                timer3.Elapsed += new ElapsedEventHandler(ProcessTimerEvent);
            }
            else
            {
                sc.PortName = sc.SerialPort.PortName;
                //MessageBox.Show("xbee Connectd to:" + sc.SerialPort.PortName);
                newWindow.searchingTextBlock.Text = "CalBOX360 connected!";
            }

            Thread.Sleep(5000);
        }

        // Method assigned to the timer delegate.
        private void ProcessTimerEvent(Object obj, ElapsedEventArgs e)
        {
            --countdown;
            // If countdown has reached 0, it's time to exit.
            if (countdown == 0)
            {
                timer3.Close();
                Environment.Exit(0);

            }
        }

        public void ThreadJob()
        {
            //timer 2 for checking message
            timer2.Interval = 100;
            timer2.Elapsed += new ElapsedEventHandler(timer2_Elapsed);
            //timer to end thread
            timer.Interval = 3000;
            timer.Elapsed += new ElapsedEventHandler(OnTimedEvent);
            timer.Start();
            timer2.Start();
        }

        //public void closePortButton_Click(object sender, RoutedEventArgs e)
        //{
        //    sc.SerialPort.Close();
        //}

        public void checkPortsForXbee()
        {
            //verifies xbee response from port
            string ATCommandReturn = sc.SerialPort.ReadExisting();

            if (ATCommandReturn == "OK\r")
            {
                foundXbee = true;
            }
        }

        public void sp_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            string incomingLine = sc.readSerialBuffer();


            //To Do: Validation
            if (sc.isValid)
            {
                xmlData.getPacketData(sc.PacketArray);
            }
            //XML
            
            
            //Thread Dispatcher - Delegate to Main GUI
            System.Threading.Thread threadGUI = new System.Threading.Thread(
             new System.Threading.ThreadStart(
               delegate()
               {
                   incomingTextBox.Dispatcher.Invoke(
                     System.Windows.Threading.DispatcherPriority.Normal,
                     new Action(
                       delegate()
                       {
                           incomingTextBox.AppendText("\n" + incomingLine + DateTime.Now.ToShortTimeString() + "\n" + DateTime.Now.ToShortDateString() + "\n");
                       }
                   ));
               }
               ));

            threadGUI.Start();


        }

        public void SessionFound()
        {
            newWindow1.Show();
        }
        #endregion

        #region Event Handlers
        private void OnTimedEvent(object source, ElapsedEventArgs e)
        {
            //on timer elapse, end thread and stop timers
            xbeeThread.Abort();
            timer2.Stop();
            timer.Stop();
        }

        private void timer2_Elapsed(object source, ElapsedEventArgs e)
        {
            //check for response 
            checkPortsForXbee();
        }
        #endregion

        #region Private Methods
        private void closeButton_Click(object sender, RoutedEventArgs e)
        {
            Application.Current.Shutdown();
        }

        private void Window_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            this.DragMove();
        }

        private void openPortButton_Click(object sender, RoutedEventArgs e)
        {
            //try
            //{
            //    // try to open the selected port:
            //    if (sc.SerialPort.IsOpen) sc.SerialPort.Close();
            //    sc.SerialPort.PortName = comCombo.SelectedItem.ToString();
            //    sc.BaudRate = Convert.ToInt32(baudRateTextBox.Text);
            //    sc.SerialPort.Open();

            //    sc.SerialPort.DataReceived += new
            //    SerialDataReceivedEventHandler(sp_DataReceived);
            //}
            //catch
            //{
            //    // give a message, if the port is not available:
            //    MessageBox.Show("Serial port " + sc.SerialPort.PortName +
            //       " cannot be opened!", "Serial Communications",
            //       MessageBoxButton.OK, MessageBoxImage.Warning);
            //}
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            newWindow.Focus();
        }

        private void calsSortButton_Click(object sender, RoutedEventArgs e)
        {
            sortedList.SortDescriptions.Clear();
            dateSortFlag = true;
            minsSortFlag = true;

            if (calsSortFlag)
            {
                sortedList.SortDescriptions.Add(new SortDescription("Cals", ListSortDirection.Descending));
                calsSortFlag = false;
            }
            else
            {
                sortedList.SortDescriptions.Add(new SortDescription("Cals", ListSortDirection.Ascending));
                calsSortFlag = true;
            }

            SessionList.DataContext = sortedList;
        }

        private void dateSortButton_Click(object sender, RoutedEventArgs e)
        {
            sortedList.SortDescriptions.Clear();
            calsSortFlag = true;
            minsSortFlag = true;

            if (dateSortFlag)
            {
                sortedList.SortDescriptions.Add(new SortDescription("TimeStamp", ListSortDirection.Ascending));
                dateSortFlag = false;
            }
            else
            {
                sortedList.SortDescriptions.Add(new SortDescription("TimeStamp", ListSortDirection.Descending));
                dateSortFlag = true;
            }

            SessionList.DataContext = sortedList;

        }

        private void OnMinutesButton_Click(object sender, RoutedEventArgs e)
        {
            bool isopen = sc.SerialPort.IsOpen;
            sortedList.SortDescriptions.Clear();
            calsSortFlag = true;
            dateSortFlag = true;

            if (minsSortFlag)
            {
                sortedList.SortDescriptions.Add(new SortDescription("Mins", ListSortDirection.Descending));
                minsSortFlag = false;
            }
            else
            {
                sortedList.SortDescriptions.Add(new SortDescription("Mins", ListSortDirection.Ascending));
                minsSortFlag = true;
            }

            SessionList.DataContext = sortedList;
        }




        private void getSessionSums(ObservableCollection<Session> temp)
        {
            double minsSum = 0;
            double calsSum = 0;
            double aveCals = 0;
            double aveMins = 0;
            int count = 0;

            double kilowatts = 0;

            foreach (Session s in temp)
            {
                minsSum += s.Mins;
                calsSum += s.Cals;
                count++;
            }

            //TimeSpan mins = new TimeSpan(0, minsSum, 0);

            TimeSpan totalTime = new TimeSpan(0, (int)minsSum, 0);

            kilowatts = (calsSum / (minsSum * 60)) * 4.184;

            totCalsTextBlock.Text = (calsSum + " calories");

            string duration = String.Format("{0:00} days {1:00} hrs {2:00} mins ", totalTime.Days, totalTime.Hours, totalTime.Minutes);
            
            totMinsTextBlock.Text = duration;

            var kilo = String.Format("{0:0.00 }", kilowatts );

            totPowerTextBlock.Text = kilo + " kW";
            totSessionsTextBlock.Text = count.ToString();

            aveCals = calsSum / count;
            aveMins = minsSum / count;

            var aveCalsString = String.Format("{0:.00} Cals/Session", aveCals);
            var aveMinsString = String.Format("{0:.00} Minutes/Session", aveMins);

            aveSessionTimeTextBlock.Text = aveMinsString;
            aveCalsTextBlock.Text = aveCalsString;


        }

        private CollectionView filterbyWeek(ObservableCollection<Session> weekCollection)
        {
            CollectionView byWeek = new CollectionView(weekCollection);

            ObservableCollection<Session> temp = new ObservableCollection<Session>();

            foreach (Session s in weekCollection)
            {

            }


            return byWeek;
        }

        private void FilterWeek()
        {
            this.sortedList.Filter = this.IsFromLastWeek;
        }

        private bool IsFromLastWeek(object obj)
        {
            TimeSpan week = new TimeSpan(7, 0, 0, 0);

            if ((obj as Session).TimeStamp <= DateTime.Now && (obj as Session).TimeStamp >= DateTime.Now.Subtract(week))
            {
                return true;
            }

            return false;
        }

        private void ButtonSortGraphWeek_Click(object sender, RoutedEventArgs e)
        {
            FilterWeek();
            chartLineSeries.Refresh();
            chartLineSeries.ItemsSource = SessionCollection;
            sessionChart.DataContext = sortedList;
            DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
            DTA.Minimum = DateTime.Now.Subtract(new TimeSpan(7, 0, 0, 0));
            DTA.IntervalType = DateTimeIntervalType.Weeks;
            DTA.Interval = 1;

        }

        private void ButtonSortGraphAll_Click(object sender, RoutedEventArgs e)
        {
            chartLineSeries.Points.Clear();
            chartLineSeries.Refresh();
            chartLineSeries.ItemsSource = null;
            chartLineSeries.ItemsSource = SessionCollection;
            sessionChart.DataContext = SessionCollection;

            DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
            DTA.Minimum = null;
            DTA.Interval = null;

            //sessionChart.Axes.Remove(DTA);
        }

        private void TabControl_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (e.Source is TabControl)
            {
                //sessionChart.DataContext = SessionCollection;
                sortedList.SortDescriptions.Clear();
                sortedList.Filter = null;

                if (MainTabControl.SelectedIndex == 1)
                {
                    filterSlider.Value = 5;

                    chartLineSeries.ItemsSource = null;
                    chartLineSeries.ItemsSource = SessionCollection;

                    DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelAllStyle");
                    DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
                    DTA.Minimum = null;
                    //DTA.IntervalType = DateTimeIntervalType
                    DTA.Interval = null;
                }

            }
        }

        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {

            //all
            if (e.NewValue == 5)
            {
                //chartLineSeries.Points.Clear();
                chartLineSeries.Refresh();
                chartLineSeries.ItemsSource = null;
                chartLineSeries.ItemsSource = SessionCollection;
                sessionChart.DataContext = SessionCollection;

                DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelAllStyle");
                DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
                DTA.Minimum = null;
                DTA.Interval = null;

            }

            else if (e.NewValue == 4)
            {
                chartLineSeries.Refresh();
                chartLineSeries.ItemsSource = SessionCollection;
                sessionChart.DataContext = SessionCollection;

                // DateTimeAxisLabel.StringFormatProperty = "{}{0:MMM d}"
                DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelDayStyle");
                DTA.IntervalType = DateTimeIntervalType.Hours;
                DTA.Maximum = DateTime.Now;
                DTA.Minimum = DateTime.Now.Subtract(new TimeSpan(1, 0, 0, 0));
                DTA.Interval = 3;
            }


             //week
            else if (e.NewValue == 3)
            {
                FilterWeek();
                chartLineSeries.Refresh();
                chartLineSeries.ItemsSource = SessionCollection;
                sessionChart.DataContext = sortedList;

                DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelWeekStyle");
                DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
                DTA.Minimum = DateTime.Now.Subtract(new TimeSpan(7, 0, 0, 0));
                DTA.IntervalType = DateTimeIntervalType.Days;
                DTA.Interval = 1;
            }

            //month
            else if (e.NewValue == 2)
            {

                chartLineSeries.Refresh();
                chartLineSeries.ItemsSource = SessionCollection;
                sessionChart.DataContext = sortedList;

                DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelMonthStyle");
                DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
                DTA.Minimum = DateTime.Now.Subtract(new TimeSpan(31, 0, 0, 0));
                DTA.IntervalType = DateTimeIntervalType.Weeks;
                DTA.Interval = 1;
            }

            //year
            else if (e.NewValue == 1)
            {

                chartLineSeries.Refresh();
                chartLineSeries.ItemsSource = SessionCollection;
                sessionChart.DataContext = sortedList;

                DTA.AxisLabelStyle = (Style)this.FindResource("DateTimeAxisLabelYearStyle");
                DTA.Maximum = DateTime.Now.Add(new TimeSpan(1, 0, 0, 0));
                DTA.Minimum = DateTime.Now.Subtract(new TimeSpan(182, 0, 0, 0));
                DTA.IntervalType = DateTimeIntervalType.Months;
                DTA.Interval = 1;
            }




        }
        #endregion

    }



}