﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO.Ports;

namespace calboxgui
{
    public class SerialCommunications
    {
        #region fields
        //serialPort Values
        public int _baudRate;
        public int _dataBits;
        public string _portName;
        public Parity _parity;
        public StopBits _stopBits;
        public string[] ports;
        public SerialPort sp;

        //Packet Array for holding packet values
        public string[] packetArray;

        public bool isValid = false;

        #endregion

        #region constructor
        public SerialCommunications()
        {
            //Constructor
            this._baudRate = 57600;
            this._dataBits = 8;
            this._portName = "COM3";
            this._stopBits = StopBits.One;
            this._parity = Parity.None;
            this.ports = SerialPort.GetPortNames();
            sp = new SerialPort();
            initializePort();
        }
        #endregion

        #region Properties
        public int BaudRate
        {
            get
            {
                return this._baudRate;
            }
            set
            {
                this._baudRate = value;
            }
        }

        public int DataBits
        {
            get
            {
                return this._dataBits;
            }
            set
            {
                this._dataBits = value;
            }
        }

        public string PortName
        {
            get
            {
                return this._portName;
            }
            set
            {
                this._portName = value;
            }
        }

        public string[] Ports
        {
            get
            {
                return this.ports;
            }
            set
            {
                this.ports = value;
            }
        }

        public SerialPort SerialPort
        {
            get
            {
                return this.sp;
            }
        }

        public StopBits StopBits
        {
            get
            {
                return this._stopBits;

            }
        }

        public Parity Parity
        {
            get
            {
                return this._parity;
            }
        }

        public string[] PacketArray
        {
            get
            {
                return this.packetArray;
            }
            set
            {
                this.packetArray = value;
            }
        }


        #endregion

        #region Private Methods
        private void initializePort()
        {
            this.sp.BaudRate = this._baudRate;
            this.sp.DataBits = this._dataBits;
            this.sp.PortName = this._portName;
            this.sp.StopBits = this._stopBits;
            this.sp.Parity = this._parity;
        }

        private bool validateData(string packet)
        {
            if (packet.StartsWith("@")) return true;
            else
            {
                //MessageBox.Show("Unexpected message format received", "Warning");
                return false;
            }
        }

        private void parseIncoming(string msg)
        {
            //remove @
            msg = msg.Substring(1);
            //split packet into 2 strings in a string[]
            PacketArray = msg.Split('.');
        }
        #endregion

        #region Public Methods

        public string readSerialBuffer()
        {
            // Show all the incoming data in the port's buffer
            string incomingLine = "";
            incomingLine = SerialPort.ReadExisting();
            isValid = validateData(incomingLine);

            if (isValid)
            {
                parseIncoming(incomingLine);
                System.Windows.MessageBox.Show("A new Session was received!");                
            }

            return incomingLine;
        }

        #endregion

    }
}
