﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace calboxgui
{
    public class SerialPortStatusNotifier : INotifyPropertyChanged
    {
        //<summary>
        //Used for updating status light of serial port connection

        public event PropertyChangedEventHandler PropertyChanged;

        private States _state;

        public enum States
        {
            OPEN,
            CLOSED
        }

        public States state
        {
            get {return _state;}
            set
            {
                if (value != _state)
                {
                    _state = value;
                    if (PropertyChanged != null)
                    {
                        PropertyChanged(this, new PropertyChangedEventArgs("State"));
                    }
                }
            }
        }

    }
}
