﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml;
using System.Collections.ObjectModel;
using System.Windows.Threading;
using System.Threading;
using System.Windows.Controls;

// TO DO: Change fields and properties to seconds;





namespace calboxgui
{
    class XMLDataStore
    {
        #region fields
        private string filename;
        //session list
        private List<Session> sessions = new List<Session>();
        private ObservableCollectionEx<Session> sessioncollection = new ObservableCollectionEx<Session>();
        public delegate void MethodInvoker();
        #endregion

        #region properties
        public List<Session> Sessions
        {
            get
            {
                return this.sessions;
            }
        }

        public ObservableCollectionEx<Session> SessionCollection
        {
            get
            {
                return this.sessioncollection;
            }
        }
        #endregion

        #region constructor
        public XMLDataStore()
        {
            //Constructor
            filename = Directory.GetCurrentDirectory() + "\\Sessions.xml";
        }
        #endregion

        #region Private Methods
        private void addSessionNode(int cals, int millis)
        {
            //fields
            int sessionID = 1;
            int minutes = TimeSpan.FromSeconds(millis).Minutes;
            DateTime timeStamp =  DateTime.Now;

            //load xml file
            XmlDocument doc = new XmlDocument();
            XmlTextReader reader = new XmlTextReader("C:\\Sessions.xml");
            reader.Read();
            // load reader
            doc.Load(reader);

            //add node
            XmlNode sessionNode = doc.CreateNode(XmlNodeType.Element, "Session", null);
            
            //add minutes
            XmlNode minNode = doc.CreateElement("Minutes");
            minNode.InnerText = minutes.ToString();

            //add calories
            XmlNode calNode = doc.CreateElement("Calories");
            calNode.InnerText = cals.ToString();

            //add timestamp
            XmlNode tsNode = doc.CreateElement("Timestamp");
            tsNode.InnerText = timeStamp.ToString();

            //check if child exists (session), if not make session #1, else find last child, grab session id + 1
            if (doc.LastChild.HasChildNodes)
            {
                XmlNode lastchild = doc.LastChild.LastChild;
                sessionID = Convert.ToInt32(lastchild.LastChild.LastChild.Value) + 1;
            }

            //create session element sessionID
            XmlNode sidNode = doc.CreateElement("SessionID");
            sidNode.InnerText = sessionID.ToString();

            //append child elements
            sessionNode.AppendChild(minNode);
            sessionNode.AppendChild(calNode);
            sessionNode.AppendChild(tsNode);
            sessionNode.AppendChild(sidNode);

            //append session node
            doc.DocumentElement.AppendChild(sessionNode);
            
            doc.Save(Console.Out);
            reader.Close();
            //to do: change saved location to project root
            doc.Save("C:\\Sessions.xml");

            Sessions.Add(new Session(sessionID, cals, minutes, timeStamp));
            SessionCollection.Add(new Session(sessionID, cals, minutes, timeStamp));

            //test.Dispatcher.Invoke((MethodInvoker)delegate
            //{
            //    Sessions.Add(new Session(sessionID, cals, minutes, timeStamp));
            //    SessionCollection.Add(new Session(sessionID, cals, minutes, timeStamp));
            //}
            //, null);
            
   

        }
        #endregion

        #region Public Methods
        public void getPacketData(string[] packetArray)
        {
            //convert strings to ints
            int cals = Convert.ToInt32(packetArray[0]);
            int millis = Convert.ToInt32(packetArray[1]);

            addSessionNode(cals, millis);
        }

        public void loadSessionObjects()
        {
            //fields
            int sid;
            int mins;
            int cals;          
            DateTime timeStamp;

            //load xml file
            XmlDocument doc = new XmlDocument();
            XmlTextReader reader = new XmlTextReader("C:\\Sessions.xml");
            reader.Read();
            // load reader
            doc.Load(reader);

            foreach (XmlNode session in doc.LastChild.ChildNodes)
            {
                sid = Convert.ToInt32(session.SelectSingleNode("descendant::SessionID").InnerText);
                cals = Convert.ToInt32(session.SelectSingleNode("descendant::Calories").InnerText);
                mins = Convert.ToInt32(session.SelectSingleNode("descendant::Minutes").InnerText);
                timeStamp = Convert.ToDateTime(session.SelectSingleNode("descendant::Timestamp").InnerText);

                Sessions.Add(new Session(sid,cals,mins,timeStamp));
                SessionCollection.Add(new Session(sid, cals, mins, timeStamp));
            }



        }
        #endregion

    }
}
