/*

CALBOX 360 ARDUINO CODE
Coded by Christopher Campbell
Senior Design II Spring 2010

*/

/*

 LCD circuit:
 * LCD RS pin to digital pin 12
 * LCD Enable pin to digital pin 11
 * LCD D4 pin to digital pin 5
 * LCD D5 pin to digital pin 4
 * LCD D6 pin to digital pin 3
 * LCD D7 pin to digital pin 2
 * 10K resistor:
 * ends to +5V and ground
 * wiper to LCD VO pin (pin 3)
 */



// include the library code:
#include <LiquidCrystal.h>
#include <avr/io.h>
#include <avr/wdt.h>

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

//int variables

int genAnalogPin = 0; //pin 0 Voltage
int genAnalogPin2 = 2; //pin 2 Current
int battAnalogPin = 4; //pin 4 Voltage

int val = 0;        //init temp value
float readVal = 0;  //variable to store high precision voltage
float battPercent = 0;  
float battVoltage = 0;  //variable to store high precision voltage
int metsVal = 0;
float calsVal = 0;
int metsValTemp = 0;
float totCals = 0;
int seconds = 0;

//push button
int switchPin = 8;
int val1;
int val2;
int buttonState;

//Time Variables
long TimeHr;
long TimeMin;
long TimeSec;
long Timems;


//METS AVERAGE ARRAY
float aveArray[3] = {
  0,0,0};
int i = 0;

void setup() {
  
  // set up the LCD's number of rows and columns: 
  lcd.begin(20, 4);

}

//*** Start Main Loop ***
void loop() {

  //this will clear values that will be updated
  lcd.clear();

  //draws LCD 
  drawlcdLayout();

 //determine battery charge
  calcBatt();

  //calculate METs
  int mets = metsCalc();
  
  //print calories burned , starting at row 2 column 12
  float tempPower = calcPower();
  
  //only increment if pedaling detected
  if(tempPower > 1)
  {
    totCals =  totCals + calcCalories(mets);

  }
  
  //print calories burned so far
  lcd.setCursor(14,0);
  lcd.print(totCals);

  //draw timer
  lcd.setCursor(10,3);
  CalcTime(millis());
  PrintTime();

  //convert session time to seconds
  seconds = (millis()/1000);

  //SEND PACKET ON PUSH OF BUTTON
  //Debouncing Circuit for push button:
  //If low, switch is pressed and transmission is sent over serial
  val1 = digitalRead(switchPin);
  delay(10);
  val2 = digitalRead(switchPin);
  if(val1 == val2)
  {
    if(digitalRead(switchPin) == LOW)
    {
      sendPacket(totCals,seconds);
      lcd.setCursor(7,1);
      lcd.clear();

      lcd.print("SENDING!!!!");
      delay(3000);

      //Reset_AVR();

    }
  }

  //loops every second : 1Hz
  delay(1000);
}


/**************** FUNCTIONS****************/

//function to read voltage from generator
float read_gen_volts(void){
  analogRead(genAnalogPin);
  delay(10);
  int val = analogRead(genAnalogPin);
  float volts = (float) val * (float) 0.0049;
  // volts = (volts * 0.88);
  return(volts);
}

//function to read voltage from battery 
float read_batt_volts(void){
  analogRead(battAnalogPin);
  delay(10);
  int val = analogRead(battAnalogPin);
  float volts = (float) val * (float) 0.0049;
  //volts = (volts * 0.88);
  return(volts);
}

//function to read voltage generator to calulcate current 
float read_gen_volts_2(void){
  analogRead(genAnalogPin2);
  delay(10);
  int val = analogRead(genAnalogPin2);
  float volts = (float) val * (float) 0.0049;
  //volts = (volts * 0.88);
  return(volts);
}


//function calculates the battery state of charge and prints out meter 
float calcBatt(void){

  float battVolts = read_batt_volts()*4.535;
  float power = calcPower();
  
  if (power > 1)
  {
    drawMeter(0,1);
    lcd.setCursor(10,1);
    lcd.print("CHARGING");
  }
 else{
   if (battVolts > 12.92){
      drawMeter(0,1);
      lcd.setCursor(10,1);
      lcd.print("SETTLING");
    }
    //100%
    else if (12.3 < battVolts && battVolts <= 12.92){
      drawMeter(7,1);
    }
    //90%
    else if (11.95 < battVolts && battVolts <= 12.3){
      drawMeter(5,1);
    } 
    //80%
    else  if (11.35 < battVolts && battVolts <= 11.95 ){    
      drawMeter(2,1);
    }  
    else 
    {
      drawMeter(0,1);
      lcd.setCursor(10,1);
      lcd.print("LOW BATT");
    }
  }
}


//calculates mets value based on power generated
int metsCalc(void){

  float pgen = calcPower();

  //Mets = 8
  if (pgen >= 210){
    metsVal = 8;

    drawMeter(10, 0);

    return metsVal;

  }

  //Mets = 7
  else if (181 < pgen && pgen < 210){
    metsVal = 7;

    drawMeter(7,0);

    return metsVal;

  }

  //Mets = 6
  else if (151 < pgen && pgen <= 181){
    metsVal = 6;

    drawMeter(6,0);

    return metsVal;

  }

  //Mets = 5
  else if (121 < pgen && pgen <= 151){
    metsVal = 5;

    drawMeter(5,0);

    return metsVal;

  } 

  //Mets = 4
  else  if (91 < pgen && pgen <= 121){    
    metsVal = 4;

    drawMeter(4,0);

    return metsVal;

  }

  //Mets = 3
  else  if (61 < pgen && pgen <= 91){    
    metsVal = 3;

    drawMeter(3,0);

    return metsVal;

  }
  //Mets = 2
  else  if (31 < pgen && pgen <= 61){    
    metsVal = 2;

    drawMeter(2,0);

    return metsVal;

  }
  //Mets = 1
  else 
  {
    drawMeter(0,0);
    metsVal = 1;
    return metsVal;
  }

}

calculates calories burned depending on Mets value
float calcCalories(int metsValTemp)
{
  calsVal = (metsValTemp * 3.5 * 70.3 * .0167)/200;
  return calsVal;

}

//print in HH:MM:SS format
void printTime(long sec){

  int hour,mins = 0;
  hour=sec/3600;
  sec=sec%3600;
  mins=sec/60;
  sec=sec%60;

  char hourString[3];
  char minString[3];
  char secString[3];

  itoa(sec, secString, 10);
  itoa(mins, minString, 10);
  itoa(hour, hourString, 10);


  char buffer[50];

  strcpy(buffer, hourString);
  strcat(buffer, ":");
  strcat(buffer, minString);
  strcat(buffer, ":");
  strcat(buffer, secString);

  lcd.setCursor(6,3);
  lcd.print(buffer);
  //  lcd.print(hourString);
  //  lcd.print(":");
  //  lcd.print(minString);
  //  lcd.print(":");
  //  lcd.print(secString);  

}


//******************************************************



void CalcTime (long Time)
{
  TimeSec = Time / 1000;
  Timems = Time % 1000;
  TimeMin = TimeSec /60;
  TimeSec = TimeSec % 60;
  TimeHr = TimeMin / 60;
  TimeMin = TimeMin % 60;
}

void PrintTime(void )
{
  if (TimeHr < 10) {
    lcd.print("0");
  }
  lcd.print(TimeHr); 
  lcd.print(":");
  if (TimeMin < 10) {
    lcd.print("0");
  }
  lcd.print(TimeMin);
  lcd.print(":");
  if (TimeSec < 10) {
    lcd.print("0");
  } 
  lcd.print(TimeSec); 
}

//sends packet of calories and seconds
void sendPacket(int cals, int seconds)
{
  //serial print packet in the format: @cals.seconds\n
  Serial.print('@');
  Serial.print(cals);
  Serial.print('.');
  Serial.print(seconds);
  Serial.print('\n');

}

//draws text and meter brackets
void drawlcdLayout()
{
  // Layout for LCD
  lcd.setCursor(0,1);
  lcd.print("BATT>>");
  lcd.setCursor(0,0);
  //lcd.print("Batt. %");
  lcd.print("CALS BURNED>>");
  lcd.setCursor(0,2);
  lcd.print("METS>>");
  lcd.setCursor(0,3);
  lcd.print("TIME>>");
  Serial.begin(57600);

  //push button
  pinMode(switchPin, INPUT);

  //draw meters

  //mets meter
  lcd.setCursor(8,2);
  lcd.print("[");
  //lcd.setCursor(6,2);
  //lcd.print(255, BYTE);
  lcd.setCursor(19,2);
  lcd.print("]");

  //bat meter
  lcd.setCursor(8,1);
  lcd.print("[");
  lcd.setCursor(19,1);
  lcd.print("]");

}

void Reset_AVR() 
{
  wdt_enable(WDTO_30MS); 
  while(1){
  } 
}

//draws level of meter
void drawMeter(int level, int type)
{
  //type 0 = mets
  //type 1 = battery
  int row = 0;

  if(type == 0)
    row = 2;
  else 
    row = 1;

  switch(level)
  {
  case 0:
    lcd.setCursor(9,row);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;


  case 1:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 2:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 3:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 4:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 5:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 6:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 7:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 8:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    lcd.print(" ");
    break;
  case 9:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(" ");
    break;
  case 10:
    lcd.setCursor(9,row);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    lcd.print(255, BYTE);
    break;
  }
}

//calcultes power from generator readings
float calcPower(void)
{
  float vgen = 0;
  float igen = 0;
  float power = 0;
  
  vgen = 5.02*(read_gen_volts());
  igen = (read_gen_volts_2())/(0.1);
  power = vgen * igen;
  
  return power;
}

//calculates current (NOT USED)
float calcIgen(void)
{
  float vgen = 0;
  float igen = 0;


  igen = (read_gen_volts_2())/(0.1);
  return igen;
}





