#include <SoftwareSerial.h>
#include <TinyGPS.h>
#include <SoftwareServo.h> 
#include <Wire.h>

#define RXPIN 2
#define TXPIN 3
#define GPSBAUD 4800

SoftwareSerial uart_gps(RXPIN, TXPIN);
void gpsdump(TinyGPS &gps);

SoftwareServo myservo;
TinyGPS gps;
int motor = 5;
float heading;
boolean rdystart1 = false;
boolean rdystart2 = false;
boolean rdystart3 = true;
float startlon = -1, startlat = -1;
float lon = 0, lat = 0;
int counter = 0;
boolean atlocation = false;
boolean returnhome = false;
boolean goinghome = false;
int closeness = 10;
char inData[10];

void setup(){
  
   Serial.begin(115200);
   uart_gps.begin(GPSBAUD);
   myservo.attach(9);
   pinMode(motor, OUTPUT);
   Wire.begin(4);
   Wire.onReceive(receiveEvent);
   Wire.onRequest(requestEvent);
   digitalWrite(motor, HIGH); // motor off
   feedgps();
   firsttime(gps);
}

//save start point as return home point
void firsttime(TinyGPS &gps) {
 
     feedgps();
     gps.f_get_position(&startlat, &startlon);

     //loop until valid data is stored into startlat and startlon
     while((startlat == -1 && startlon == -1) || (startlat == 1000 && startlon == 1000)) {
       feedgps();
       gps.f_get_position(&startlat, &startlon);
       delay(500);
     }
     //only true when valid return home point is stored.
     rdystart1 = true;    
}

void loop(){
  
  //three conditions for movement, valid start point, valid waypoint received, boat has not returned home yet
  if(rdystart1 && rdystart2 && rdystart3) {
    SoftwareServo::refresh();
    boolean newdata = false;
    unsigned long start = millis();
    
    // get new gps data every 1/4 of a second
    while (millis() - start < 250) {            
      SoftwareServo::refresh();
      if (feedgps())
        newdata = true;
    }
    SoftwareServo::refresh();
    
    //do distance calculations
    if (newdata) {
      gpsdump(gps);
      SoftwareServo::refresh();
    }
  }
}

//receive waypoint wirelessly from xbee
void receiveEvent(int howMany) { 

  char temp[9];
  int i = 0;
  int j;
  boolean neg = false;
  
  //Serial.println("onreceive");
  
  //read one character at a time
  while(Wire.available() > 0) {
    inData[i] = Wire.read();
    i++;
  }  
  i = 0;
  
  //check for negative sign on incoming data. If negative shift the hyphen out of array.
  if(inData[0] == '-') {
    for(j = 1; j < 9; j++) {
      temp[j-1] = inData[j];
    }
    neg = true;
  }
  
  //use ascii to float to convert data to a usable number
  if(counter == 0 && neg) {
    lat = atof(temp);
    lat = lat * -1;
    Serial.println(lat, 7);
    neg = false;
  }
  else if(counter == 0) {
    lat = atof(inData);
    Serial.println(lat, 7);
  }
  else if (counter == 1 && neg) {
    lon = atof(temp);
    rdystart2 = true;
    lon = lon * -1;
    Serial.println(lon,7);
    neg = false;
  }
  else if (counter == 1) {
    lon = atof(inData);
    rdystart2 = true;
    Serial.println(lon,7);
  }
  else {
    returnhome = true;
    goinghome = true;
    closeness = 5;
    digitalWrite(motor, LOW);
  }
}

//outputs sucessfully received data, and if at waypoint
void requestEvent() {
  
    char templat[11];
    char templon[11];
    int count;
    int j;
    
    char temparray[10];
    
    if(counter == 0) {
     
    // Wire.write(inData);
     Wire.write("Latitude Received");
      counter ++;
    }
    else if(counter == 1) {
      
     // Wire.write(inData);
     Wire.write("Longitude Received");
      counter ++;
      digitalWrite(motor, LOW);
    }
    
    else if(atlocation && counter == 2) {
      Wire.write("y");
    }
    else if(!atlocation && counter == 2) {
     Wire.write("n");
    } 
    
    if (returnhome) {
      Wire.write("Returning Home");
      returnhome = true;
      
    }    
}

//refresh GPS data
boolean feedgps() {
  
   while (uart_gps.available()){
  
      if (gps.encode(uart_gps.read()))
        return true;
  }
   return false;
}

//read data from GPS, call distance calculations function
void gpsdump(TinyGPS &gps){
  
     float latitude, longitude, travel;
     
     //get and store our current lat/ long       
     feedgps();
     gps.f_get_position(&latitude, &longitude);
     feedgps();
     travel = gps.f_course();
     distance(latitude, longitude,travel);
}

//calculates distance and heading to waypoint from current postion
void distance(float latitude, float longitude, float travel){
     
    float correction;
    float flat1=latitude;     
    float flon1=longitude;  
    float dist_calc=0;
    float dist_calc2=0;
    float diflat=0;
    float diflon=0;
    float x2lat;           
    float x2lon;
    
    if(goinghome) {       //go back home
      x2lat = startlat;
      x2lon = startlon; 
    }
    else {         //go to waypoint
      x2lat = lat;     
      x2lon = lon;
    }
    diflat=radians(x2lat-flat1);  //it must be done in radians
    flat1=radians(flat1);    //convert current latitude to radians
    x2lat=radians(x2lat);  //convert waypoint latitude to radians
    diflon=radians((x2lon)-(flon1));   //subtract and convert to radians
    dist_calc = (sin(diflat/2.0)*sin(diflat/2.0));
    dist_calc2= cos(flat1);
    dist_calc2*=cos(x2lat);
    dist_calc2*=sin(diflon/2.0);                                       
    dist_calc2*=sin(diflon/2.0);
    dist_calc +=dist_calc2;
    dist_calc=(2*atan2(sqrt(dist_calc),sqrt(1.0-dist_calc)));
    dist_calc*=6371000.0; //Converting to meters
    
    flon1 = radians(flon1);  //also must be done in radians
  
    x2lon = radians(x2lon);  //radians 
  
    heading = atan2(sin(x2lon-flon1)*cos(x2lat),cos(flat1)*sin(x2lat)-sin(flat1)*cos(x2lat)*cos(x2lon-flon1)),2*3.1415926535;
    
    heading = heading*180/3.1415926535;  // convert from radians to degrees
  
    int head = heading; //make it a integer
  
    if(head<0){
      heading+=360;   //if the heading is negative then add 360 to make it positive
    }
    if(dist_calc < closeness && goinghome) {
      digitalWrite(motor, HIGH);
      rdystart3 = false;
    }
      
    else if(dist_calc < closeness) {
   
      digitalWrite(motor, HIGH);   //turn motor off
      atlocation = true;
      while(returnhome != true) {
        
        unsigned long start2 = millis();
        while (millis() - start2 < 60000) {           
        if(returnhome == true) {
          break;
        }
      }
       returnhome = true;
       goinghome = true;
      }
      
      //wait for sensors to gather data
      digitalWrite(motor, LOW);  //turn motor back on
    }
   
    correction = travel - heading;
    int hd = travel;

    SoftwareServo::refresh();
    if(correction <= 30 && correction >= -30) { // no valid heading or on course so go straight
      moveServo(130);
    }
    else if(correction > -180 && correction < -30) { //turn right 
      moveServo(175);
    }
    else if (correction < -180 ) { //go left
      moveServo(85);
    }
    else if (correction > 30 && correction < 180) { //go left
      moveServo(85);
    }
    else if (correction >= 180 ) { //go right
      moveServo(175);
    }
    SoftwareServo::refresh();
}

void moveServo(int angle){
    myservo.attach(9);
    myservo.write(angle);  
    myservo.detach();  
}


