#include <SoftwareSerial.h>      //SoftwareSerial library is used to so the other digital I/O pins can be used for serial communications and we won't be limited to TX/RX on just pins 0 and 1.
#include <Wire.h>                //Wire library is used here so we can implement the I2C communication between the sensor microcontroller and the navigation microcontroller.

#define rx 2                     //pin 2 will be used to receive data from the circuits/sensors
#define tx 3                     //pin 3 will be used to transmit data to the circuits/sensors

SoftwareSerial myserial(rx, tx); //define how the soft serial port is going to work. 
SoftwareSerial xbee(10,11);

const byte addressTX0 = 4; // the multiplexer address select lines TX
const byte addressTX1 = 5;
const byte addressTX2 = 6;

const byte addressRX0 = 7; // the multiplexer address select lines RX
const byte addressRX1 = 8;
const byte addressRX2 = 9;

int i=0, printcounter = 0;
float temp;
char c;
char check1[10];
char check2[10];
char sensor_data[20];     //we make a 20 byte character array to hold incoming data from the chosen sensor.
char computerdata[20];    //we make a 20 byte character array to hold incoming data from a pc/mac/other.
char command[3];
char endcommand = 'E';    //endcommand of 'E' is to used to tell the water quality to stop polling for data 
byte received_from_computer=0;     //we need to know how many characters have been received from computer                                 
byte received_from_sensor=0;       //we need to know how many characters have been received from sensor
byte string_received=0;            //used to identify when we have received a string
String test;
String test2;
boolean sensorsOff=false;
boolean atLocation=false;        //atLocation tells us if the boat has reach the requested location
boolean reenter=true;            //reenter is used for another input of latitude/longitude if the first entry is not valid


void setup(){
     Serial.begin(38400);         //enable the hardware serial port for debugging
     myserial.begin(38400);       //enable the software serial port to receive/transmit data to sensors/circuit
     xbee.begin(9600);            //enable the software serial port to receive/transmit data to/from the xbees
     
     Wire.begin();     //begin I2C communication

     pinMode (addressTX0, OUTPUT); //enable TX pins as OUTPUT
     pinMode (addressTX1, OUTPUT); 
     pinMode (addressTX2, OUTPUT);
     
     pinMode (addressRX0, OUTPUT); //enable RX pins as OUTPUT
     pinMode (addressRX1, OUTPUT); 
     pinMode (addressRX2, OUTPUT);
     
     pinMode (12, OUTPUT); // enable pin 12 as OUTPUT for temp sensor
     
     while(reenter){ //while reenter is true, the user will be continuously prompted to input latitude coordinates
       latitude();  // latitude() will determine if the coodinate is valid, if valid then reenter = false.
     }
     checkLatitude(); //verify that the latitude coordinate was sent to the navigation microcontroller
     reenter = true; //set reenter back to true so the user will be prompted to enter longitude coordinates until they are valid
     
     while(reenter){
       longitude(); //longitude() willl determine if the coordinate is valid, if valid then reenter = false.
     }
     checkLongitude(); //verify that longitude coordinate was sent to the navigation microcontroller
     printMenu();
}
  
 
void computerSent(String test){     
        if(test == "p" || test == "P"){ //character entered is a p then enter pH sensor.
             sensorsOff=false; // Reset variable to false, sensor is turned on.
             xbee.println();
             xbee.println("Reading pH: ");
             command[0] = 'R';  //'R' command is sent to the circuit to poll for water quality once
             for(i=0;i<15;i++){ //polls for water quality
                 readSensor(0); //configure the multiplexer for the pH circuit 
                 //delay(100);
                 readsomething(); //read data back from the circuit
             }
             xbee.println("Please Enter Selection");
             //printMenu(); 
             xbee.listen(); //listen for additional commands from the xbee
        }
        
        else if(test == "o" || test == "O"){ //character entered is a o then enter ORP sensor.
             sensorsOff=false; // Reset variable to false, sensor is turned on.
             xbee.println();
             xbee.println("Reading ORP: ");
             command[0] = 'R'; //'R' command is sent to the circuit to poll for water quality once
             for(i=0;i<15;i++){
                 readSensor(1); // configure the multiplexer for the ORP circuit
                 readsomething(); //read data back from the circuit
             }
             xbee.println("Please Enter Selection");
             //printMenu();
             xbee.listen(); //listen for additional commands from the xbee
        }
        else if(test == "d" || test == "D"){ //character entered is a d then enter DO sensor.
             sensorsOff=false; // Reset variable to false, sensor is turned on.
             xbee.println();
             xbee.println("Reading DO: ");
             command[0] = 'R'; //'R' command is sent to the circuit to poll for water quality once
             for(i=0;i<15;i++){
                 readSensor(2); // configure the multiplexer for the DO circuit
                 readsomething(); //read data back from the circuit
             }
             xbee.println("Please Enter Selection");
             //printMenu();
             xbee.listen(); //listen for additional commands from the xbee
        }
        else if(test == "c" || test == "C"){ //if the first character entered is a D then enter Cond sensor.
             sensorsOff=false; // Reset variable to false, sensor is turned on.
             xbee.println();
             xbee.println("Reading Conductivity: ");
             command[0] = 'R'; //'R' command is sent to the circuit to poll for water quality once
             for(i=0;i<15;i++){
                 readSensor(3); // configure the multiplexer for the Cond circuit
                 readsomething(); //read data back from circuit
                 delay(1000); //we need a delay here because Cond takes longer to poll water quality
             }
             xbee.println("Please Enter Selection");
             //printMenu();
             xbee.listen(); //listen for additional commands from the xbee
        }
        else if(test == "t" || test == "T")
        {
          sensorsOff=false;
          xbee.println();
          xbee.println("Reading temperature: ");
          for(i=0;i<15;i++){
            temp = readTemp();
            xbee.println(temp);
          }
          xbee.println("Please Enter Selection");
          //printMenu();
          xbee.listen(); 
          
        }
        else if(test == "h" || test =="H")
        {
          returnHome(); //instruct the navigation microcontroller to return to its original location
        }
        else if(test == "Config Menu")
        {
          
            //turnOff();
            sensorsOff = true; // Sensors have been turned off, set variable to true.
            myserial.flush(); //flush out any data the sensor was sending to the user that may still be in the myserial port.
            
            xbee.println("Which sensor do you want to control?");
            xbee.println("pH: Enter \"pH Sensor\"");
            xbee.println("ORP: Enter \"ORP Sensor\"");
            xbee.println("D.O.: Enter \"DO Sensor\"");
            xbee.println("Cond: Enter \"Cond Sensor\"");
        }
        else if(sensorsOff && test == "pH Sensor")
        {
          while(xbee.available() == 0){ //this needs to be worked on!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            clearData(computerdata);
            received_from_computer=xbee.readBytesUntil(13,computerdata,20);
            //xbee.println(computerdata);
            test2 = computerdata;
            if(test2 == "Turn off LED")
            {
              command[0] = 'L';
              command[1] = '0';
              readSensor(0);
              break;
            }
            else if(test2 == "Turn on LED"){
              xbee.println("TURNED ON LED");
              command[0] = 'L';
              command[1] = '1';
              readSensor(0);
              break;
            }
            else if(test2 == "Reset"){
              xbee.println("Resetting pH Sensor to factory settings");
              command[0] = 'X';
              readSensor(0);
              break;
            }
            else if(test2 == "Calibrate pH 7"){
              command[0] = 'S';
              readSensor(0);
              break;
            }
            else if(test2 == "Calibrate pH 4"){
              command[0] = 'F';
              readSensor(0);
              break;
            }
            else if(test2 == "Calibrate pH 10"){
              command[0] = 'T';
              readSensor(0);
              break;
            }
          }
          clearData(computerdata);
        }
        else if(sensorsOff && test == "ORP Sensor")
        {
          while(xbee.available() == 0) //this needs to be worked on!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          {
            clearData(computerdata);
            received_from_computer=xbee.readBytesUntil(13,computerdata,20);
            xbee.println(computerdata);
            test2 = computerdata;
            if(test2 == "Turn off LED")
            {
              command[0] = 'L';
              command[1] = '0';
              readSensor(1);
              break;
            }
            else if(test2 == "Turn on LED"){
              xbee.println("TURNED ON LED");
              command[0] = 'L';
              command[1] = '1';
              readSensor(1);
              break;
            }
            else if(test2 == "Reset"){
              xbee.println("Resetting pH Sensor to factory settings");
              command[0] = 'X';
              readSensor(1);
              break;
            }
            else if(test2 == "Increase ORP offset"){
              command[0] = '+';
              readSensor(1);
              break;
            }
            else if(test2 == "Decrease ORP offset"){
              command[0] = '-';
              readSensor(1);
              break;
            }
          }
          clearData(computerdata);
        }
        else if(sensorsOff && test == "DO Sensor")
        {
          while(xbee.available() == 0) //this needs to be worked on!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          {
            clearData(computerdata);
            received_from_computer=xbee.readBytesUntil(13,computerdata,20);
            xbee.println(computerdata);
            test2 = computerdata;
            if(test2 == "Turn off LED")
            {
              command[0] = 'L';
              command[1] = '0';
              readSensor(2);
              break;
            }
            else if(test2 == "Turn on LED"){
              xbee.println("TURNED ON LED");
              command[0] = 'L';
              command[1] = '1';
              readSensor(2);
              break;
            }
            else if(test2 == "Reset")
            {
              command[0] = 'X';
              readSensor(2);
              break;
            }
            else if(test2 == "Calibrate DO")
            {
              command[0] = 'M';
              readSensor(2);
              break;
            }
          }
        }
        else if(sensorsOff && test == "Cond Sensor")
        {
          xbee.println("Inside Cond sensor from Menu");
          clearData(computerdata);
        }
        
     else //main else statement from printMenu
        {
        xbee.println("Invalid entry. Please try again");
        clearData(computerdata);
        printMenu();
        }
}
 
void readSensor (const byte which)
{
  digitalWrite (addressTX0, (which & 1) ? HIGH : LOW); //configures the multiplexer for which circuit to transmit data to
  digitalWrite (addressTX1, (which & 2) ? HIGH : LOW);
  digitalWrite (addressTX2, (which & 4) ? HIGH : LOW);
  delay(500);
  
  digitalWrite (addressRX0, (which & 1) ? HIGH : LOW); //configures the multiplexer for which circuit to read from
  digitalWrite (addressRX1, (which & 2) ? HIGH : LOW);
  digitalWrite (addressRX2, (which & 4) ? HIGH : LOW);
  delay(500);
  
  computerdata[received_from_computer]=0; //we add a 0 to the spot in the array just after the last character we received.. This will stop us from transmitting incorrect data that may have been left in the buffer. 
  myserial.print(command);           //we transmit the data received from the laptop through the soft serial port to the specified circuit
  myserial.print('\r');  //all data sent to a circuit must end with a <CR>.
  
  delay(500);
  myserial.print(command);   //retransmit the command again in case the first command was not recognized
  myserial.print('\r');
  clearData(command);
}


float readTemp(void){
    float v_out;             //voltage output from temp sensor 
    float temp;              //the final temperature is stored here
    digitalWrite(A0, LOW);   //set pull-up on analog pin
    digitalWrite(12, HIGH);   //set pin 2 high, this will turn on temp sensor
    delay(1000);              //wait 1 second for temp to stabilize
    v_out = analogRead(0);   //read the input pin
    digitalWrite(12, LOW);    //set pin 2 low, this will turn off temp sensor
    v_out*=.0048;            //convert ADC points to volts (we are using .0048 because this device is running at 5 volts)
    v_out*=1000;             //convert volts to millivolts
    temp= 0.0512 * v_out -20.5128; //the equation from millivolts to temperature
    return temp;             //send back the temp 
}

void clearData(char data[20]){
  memset(&computerdata[0], 0, sizeof(computerdata)); //clear computer data so we can input a new command
}

void readsomething(){ 
  myserial.listen();
  if(myserial.available() > 0){    //if we see that the circuit has sent a character.
     received_from_sensor=myserial.readBytesUntil(13,sensor_data,20); //we read the data sent from the circuit until we see a <CR>. We also count how many character have been received.  
     sensor_data[received_from_sensor]=0;  //we add a 0 to the spot in the array just after the last character we received. This will stop us from transmitting incorrect data that may have been left in the buffer. 
     string_received=1;                //a flag used when the Arduino is controlling the circuit to let us know that a complete string has been received.
     xbee.println(sensor_data);     //transmit that data received from the circuit to the xbee.
   }    
}

void longitude(){
  char longdata[10];
  xbee.println("Please enter longitude");
  
  while(xbee.available() < 10) {}
  for(i=0;i<10;i++){
    longdata[i] = xbee.read();
    longdata[i+1] = '\0';
  }
         
  for(int x=0;x<10;x++){  
    if(longdata[x] > '9' || longdata[x] < '-'){
      xbee.println();
      xbee.println("Not a valid input");
      xbee.println("Please re-enter longitude");
      return;
    }
  } 
         
  Wire.beginTransmission(4);
  for(i=0;i<10;i++){
    Wire.write(longdata[i]); 
    //xbee.println(longdata[i]);            
  }
  reenter = false;
  //xbee.print("This is GPS Data: ");
  //xbee.println(longdata);
  Wire.endTransmission();    // stop transmitting
  delay(500);
  
}

void checkLongitude(){
//  Wire.requestFrom(4, 10);
//  int q = 0;
//  while(Wire.available()>0)
//  {
//    check2[q] = Wire.read();
//    //xbee.println(poop[q]);
//    q++;
//  }
//  xbee.println();
//  xbee.println("This longitude was sent to the navigation microcontroller");
//  for(q=0;q<10;q++)
//  {
//    xbee.print(check2[q]);
//  }
//  xbee.println();
//  delay(500);


  Wire.requestFrom(4, 18);
  xbee.println();
  while(Wire.available()){
    char c = Wire.read();
    xbee.print(c);
  }
  xbee.println();
  delay(500);

}

void latitude(){
  xbee.println("Please enter latitude");
  char latdata[10];
  while(xbee.available() < 10) {}
  for(i=0;i<10;i++){            //send 10 byte of data 
     latdata[i] = xbee.read();
     latdata[i+1] = '\0';
   }
    
  for(int x =0;x<10;x++){  
  if(latdata[x] > '9' || latdata[x] < '-'){
      xbee.println();
      xbee.println("Not a valid input");
      xbee.println("Please re-enter latitude");
      return;
    }
  }  
         
   Wire.beginTransmission(4);
   for(i=0;i<10;i++){
     Wire.write(latdata[i]); 
     //xbee.println(latdata[i]);             
   }
   reenter = false;
   //xbee.print("This is GPS Data: ");
   //xbee.println(latdata);
   Wire.endTransmission();    // stop transmitting
   delay(500);     
}

void checkLatitude(){
//  Wire.requestFrom(4, 17);
//  int q = 0;
//  while(Wire.available()>0)
//    {
//      check1[q] = Wire.read();
//      //xbee.println(poop[q]);
//      q++;
//    }
//  xbee.println();  
//  xbee.println("This latitude was sent to the navigation microcontroller");
//  for(q=0;q<10;q++)
//    {
//      xbee.print(check1[q]);
//    }
//  xbee.println();  
//  delay(500);
  Wire.requestFrom(4, 17);
  xbee.println();
  while(Wire.available()){
    char c = Wire.read();
    xbee.print(c);
  }
  xbee.println();
  delay(500);
}

void printMenu(){
  
  xbee.println("Each sensor will poll data for ~5-7 seconds");
  xbee.println("p - pH Sensor");
  xbee.println("o - ORP Sensor");
  xbee.println("d - DO Sensor");
  xbee.println("c - Cond Sensor");
  xbee.println("t - Temp Sensor");
  xbee.println("h - Return Home");
  xbee.println("Config Menu - Configure sensors");
  
}

void returnHome(){
  Wire.beginTransmission(4);
  Wire.write("h");
  Wire.endTransmission(4);
  delay(1000);
  xbee.println();
  Wire.requestFrom(4, 14);
  while(Wire.available()){
    //xbee.println("waitng for return home");
    char c = Wire.read();
    xbee.print(c);
  }
  //xbee.println("Returning");
  delay(500);
  
}

void loop(){
  
  if(atLocation == false){ //loop throught this if statement until the boat arrives to correct destination
    delay(1000);
    Wire.requestFrom(4, 1); //request a byte from slave
    while(Wire.available()){ 
      char c = Wire.read(); // receive a byte as character
      //xbee.print(c);
      xbee.print("t");

      if(c == 'y'){ // if the byte received from slave is a 'y' then the boat as arrived
        //xbee.println(c);
        xbee.println();
        xbee.println("W.A.R Boat is at the location");
        xbee.println("Please Enter Selection");
        atLocation = true; //set boolean to true to break from if statement and continue with other code
        //printMenu();
       }
       else
         atLocation = false;
    }
  }
  delay(1000);
  
  if(xbee.available()>0 && atLocation == true){
    memset(&computerdata[0], 0, sizeof(computerdata));
    received_from_computer=xbee.readBytesUntil(13,computerdata,20);
    test = computerdata;
//    xbee.println();
//    xbee.print("This is the input: ");
//    xbee.println(test);
    computerSent(test);
    memset(&computerdata[0], 0, sizeof(computerdata));
  } 
} 
