/*
 * Bluetooth.h
 *
 *  Created on: Mar 18, 2015
 *      Author: Andrew Mendez
 */

#include "Gesture.h"


#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>
#include <math.h>
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"//library to have nice function to printf




#ifndef BLUETOOTH_H_
#define BLUETOOTH_H_

//members
char BU_Bluetooth_MSG[66];
char Bluetooth_A_MSG[2];
char Bluetooth_B_MSG[22];
bool Bluetooth_determineMessage=true;
bool Bluetooth_is_A_MSG=false;
bool Bluetooth_is_B_MSG=false;
bool Bluetooth_is_C_MSG=false;
bool Bluetooth_is_D_MSG=false;
bool Bluetooth_is_E_MSG=false;
bool Bluetooth_is_F_MSG=false;
bool Bluetooth_is_G_MSG=false;
bool Bluetooth_is_H_MSG=false;
bool Bluetooth_is_I_MSG=false;

int Bluetooth_MSGCount=0;
int Bluetooth_tempPos[5]={90,90,90,90,90};
int Bluetooth_servoPos[5];
int Bluetooth_tempGest_index=-1;
Gesture Bluetooth_tempGest;
//Gesture gestures[5];
//int bluetooth_tempServoPos[5] = {88,88,88,88,88};
//char bluetooth_servoPos[3];
	//gestures[0].servoPositions[0]=12;


int m_msgCount;
int m_gesturesActiveCount;
//methods


/*
 * Funcction test initalization of gestures
 */
//Bluetooth_initalizeGesture(){
//
//	int k;
//		for(k=0;k<5;k++){
////			gestures[0].servoPositions[k]=90;
//		gestures[0].servoPositions[k] = bluetooth_tempServoPos[k];
//		}
//
//}
/*
 * convert servo pos (a max 3 digit integer) to character array
 */
//void Bluetooth_convertServoPositionToMessage(int num){
//
//	int count2=0;
//	int l;
//
//	for(l=2;l>=0;l--){
//		int k = num/pow(10,l); //get digit
//
//		char c = '0'+k;//convert to character
//
//		MC_servoPos[count2++]=c;//store in message
//
//		num = num- k*pow(10,l);//decrease number
//	}
//
//}
/*
 * function to pass servo pos in real time
 */
//void Bluetooth_passToServo(int pos[]){
//	//convert servo position to character message
//int j;
//int k;
//	char MC_servoPos[3];
//	ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
//
//
//		for(j=0;j<5;j++){
//			ROM_UARTCharPutNonBlocking(UART4_BASE,'.');
//				 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//				 Bluetooth_convertServoPositionToMessage(pos[j]);
//		 for(k=0;k<3;k++)
//		    {
//			//method only gets one character at a time!
//			ROM_UARTCharPutNonBlocking(UART4_BASE,MC_servoPos[k]);
//
//
//			        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
//			        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//
//			 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
//		}
//
//		}
//
//}

/*
 * function to test temporary gesture
 */
void printTempGesture(){

    ROM_UARTCharPutNonBlocking(UART0_BASE,Bluetooth_tempGest.command[12]);


   // printf("Gesture:\n");

//    int k;
//    //printf("gesture name: ");
//    for (k=0;k<15; k++) {
//        printf("%c",tempGest.command[k]);
//    }
//   // printf("\nstart Position: ");
//
//    for (k=0; k<5; k++) {
//        printf("%d ",tempGest.startPos[k]);
//    }
//    printf("\nEnd position:");
//    for (k=0; k<5; k++) {
//        printf("%d ",tempGest.endPos[k]);
//    }
//    printf("\npressure Threshold: %d\n",tempGest.pressThreshold);
}





/*
 *  parse Message A
 *
 *  ex: A.0
 */

void parseAMessage(char msg[]){

	//get second character
	char m = msg[1];
	//convert single character to integer

	int index=m - '0';//convert character to int
	// ROM_UARTCharPutNonBlocking(UART0_BASE,(index+49));
	//pass index value to completeGesture function
	if(index>-1 && index<5){
		MC_completeGesture(index);
	}
	else{
		//print Err
		ROM_UARTCharPutNonBlocking(UART0_BASE,'E');
		ROM_UARTCharPutNonBlocking(UART0_BASE,'R');
		ROM_UARTCharPutNonBlocking(UART0_BASE,'R');
	}



}


/*
 * function to parse B message
 */

////count will help determine integer to store
//void parseBMessage(){
//
//  //pass S character
//	ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
//    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//    //ROM_UARTCharPutNonBlocking(UART4_BASE,'.');
//      //  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//	//loop through whole array, send each character to servo controller
//	int z;
//	 for(z=1;z<22;z++)
//			    {
//		 if(z==1){
//			 SysCtlDelay(7000000*4);
//		 }
//		 if(z==18){
//			 ROM_UARTCharPutNonBlocking(UART0_BASE,'k');
//		 }
//
//
//		//ROM_UARTCharPut(UART4_BASE,Bluetooth_MSG[z]);
//		//ROM_UARTCharPutNonBlocking(UART4_BASE,Bluetooth_MSG[z]);
//		// SysCtlDelay(7000000);
//		SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//		//SysCtlDelay(7000000*4);//need delay here!
//
//
//	}
//	 int pos[]={90,90,90,90,90};
//	 MC_passToServos(pos);
//
//    //now pass command to servo controller, and done :)
////    MC_passToServos(Bluetooth_tempPos);
////	 SysCtlDelay(7000000/2);//need delay here!
////	 MC_passToServos(defaultGest.servoPositions);
//
//
//}

/*
 * function used to parse the B message recieved from bluetooth
 */
void parseBMessage(char msg[],int start,int count){

    //will need temp char[] to hold individual position


    //loop through entire message
    int i;
    bool firstDot=false;//will determine when to start adding char

    int stInd=0;
    int end=0;
    char pos[3];
    //have temporary array to store integers

    int msgCount=0;
    int servoCount=0;
    //printf("count at: %d\n",count);
    for(i=start;i<count;i++){
        //find position between two periods
        //int st
        //int end//end=i-1

        //check if reached other period or reached end of array
         if((firstDot && BU_Bluetooth_MSG[i]=='.') ){
            end=i-1;

            int l;
             //has to be local
            for(l=stInd;l<=(end);l++){
                pos[msgCount]=BU_Bluetooth_MSG[l];
                msgCount++;
              // printf("%c",msg[l]);
            }

             Bluetooth_servoPos[servoCount]=atoi(pos);
             servoCount++;
            // printf("number res: %d\n",servoPos[servoCount-1]);

             //reset array
             for(l=0;l<3;l++){
                 pos[l]='\0';
             }

               firstDot=false;
             msgCount=0;

            // printf("\n");
        }
        //CHECK if seeing first period
        if((firstDot==false && BU_Bluetooth_MSG[i]=='.')){
            firstDot=true;
            stInd=i+1;
        }
        //third case, reached end of message
        if (firstDot==true && i==count-1) {
            int l;
            // char pos[count-stInd];//has to be local
            for(l=stInd;l<(count);l++){
                pos[msgCount]=BU_Bluetooth_MSG[l];
                 msgCount++;
               // printf("%c",msg[l]);
            }

            Bluetooth_servoPos[servoCount]=atoi(pos);
            servoCount++;

            //reset array IMPORTANT TRICK, ATOI WILL IGNORE NULL CHARS
            for(l=0;l<3;l++){
                pos[l]='\0';
            }

              //printf("final number res: %d\n",servoPos[servoCount-1]);
            msgCount=0;

        }



        //find first period
       // printf("in at: %d\n",i);
        //find second period




        }

    //print final servo count

    //printf("Result servo pos\n");
//    for (i=0; i<5; i++) {
//         //printf("%d ",servoPos[i]);
//    }

    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

    //now pass command to servo controller, and done :)
        MC_passToServos(Bluetooth_servoPos);

        //reset servos
        int z;
        for(z=0;z<5;z++){
        	Bluetooth_servoPos[z]=0;
        }


}

/*
 * function used to convert character servo pos to integer servo pos
 *
 * NOTE: VERY SIMILAR TO parseBMessage(...)
 * 	->except, does not send array to servo controller
 *
 */
void convertMSGtoArray(char msg[],int start,int count){

    //will need temp char[] to hold individual position


    //loop through entire message
    int i;
    bool firstDot=false;//will determine when to start adding char

    int stInd=0;
    int end=0;
    char pos[3];
    //have temporary array to store integers

    int msgCount=0;
    int servoCount=0;
    //printf("count at: %d\n",count);
    for(i=start;i<count;i++){
        //find position between two periods
        //int st
        //int end//end=i-1

        //check if reached other period or reached end of array
         if((firstDot && msg[i]=='.') ){
            end=i-1;

            int l;
             //has to be local
            for(l=stInd;l<=(end);l++){
                pos[msgCount]=msg[l];
                msgCount++;
              // printf("%c",msg[l]);
            }

             Bluetooth_servoPos[servoCount++]=atoi(pos);
            // printf("number res: %d\n",servoPos[servoCount-1]);

             //reset array
             for(l=0;l<3;l++){
                 pos[l]='\0';
             }

               firstDot=false;
             msgCount=0;

            // printf("\n");
        }
        //CHECK if seeing first period
        if((firstDot==false && msg[i]=='.')){
            firstDot=true;
            stInd=i+1;
        }
        //third case, reached end of message
        if (firstDot==true && i==count-1) {
            int l;
            // char pos[count-stInd];//has to be local
            for(l=stInd;l<(count);l++){
                pos[msgCount]=msg[l];
                 msgCount++;
               // printf("%c",msg[l]);
            }

            Bluetooth_servoPos[servoCount++]=atoi(pos);

            //reset array IMPORTANT TRICK, ATOI WILL IGNORE NULL CHARS
            for(l=0;l<3;l++){
                pos[l]='\0';
            }

              //printf("final number res: %d\n",servoPos[servoCount-1]);
            msgCount=0;

        }



        //find first period
       // printf("in at: %d\n",i);
        //find second period




        }

    //print final servo count

    //printf("Result servo pos\n");
//    for (i=0; i<5; i++) {
//         //printf("%d ",servoPos[i]);
//    }

    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

    //now pass command to servo controller, and done :)
       // MC_passToServos(Bluetooth_servoPos);


}

/*
 * function used to store correct range in temp Gesture structure
 */
void storeSection(char msg[],int st,int end,int msgIndex) {

	//NOTE : NEED TO IGNORE THIS
    if (msgIndex==0) {
        //store result message in offset
    	//Bluetooth_tempGest.offset=msg[st+1];
    	Bluetooth_tempGest_index=2;
    }
    else if (msgIndex==1){//store array pos in start array
    	convertMSGtoArray(msg, st, end);
        int k;
        for (k=0; k<5; k++) {
        	Bluetooth_tempGest.startPos[k]=Bluetooth_servoPos[k];
        }

    }
    else if (msgIndex==2){//store array pos in start array
    	convertMSGtoArray(msg, st, end);
        int k;
        for (k=0; k<5; k++) {
        	Bluetooth_tempGest.endPos[k]=Bluetooth_servoPos[k];
        }

    }
    else if (msgIndex==3){//store command name
        int k;
        int nameCount=0;
        for (k=st+1;k<(st+1)+15; k++) {
        	if(k<end){
        	Bluetooth_tempGest.command[nameCount++]=msg[k];
        	}
        	else if(k>end){
        		Bluetooth_tempGest.command[nameCount++]='*';
        	}
        }

    }

}

/*
 * function to run demo gesture sent from
 * ...bluetooth module
 */
void runDemoGesture(){

	//send start pos to servo controller
	 MC_passToServos(defaultGest.servoPositions);
		SysCtlDelay(70000000);//delay to show servo's holding

	//send end pos to servo controller
	 MC_passToServos(Bluetooth_tempGest.endPos);
		SysCtlDelay(70000000);//delay to show servo's holding

	//revert back to default gesture
	// MC_passToServos(defaultGest.servoPositions);
}

/*
 * function to store temp Gesture to gesture array
 *
 * NOTE: NEED TO UPDATE IMPLEMENTATION TO
 * ...GESTUREs RUN TO [startPos,endPos,default], NOT servoPos
 *
 */
void parseDMessage(char msg[]){

	//get second character
	char m = msg[1];
	//convert single character to integer

	int index=m - '0';//convert character to int
	// ROM_UARTCharPutNonBlocking(UART0_BASE,(index+49));
	//pass index value to completeGesture function
	if(index>-1 && index<5){
		MC_deleteGesture(index);
	}
	else{
		//print Err
		ROM_UARTCharPutNonBlocking(UART0_BASE,'E');
		ROM_UARTCharPutNonBlocking(UART0_BASE,'R');
		ROM_UARTCharPutNonBlocking(UART0_BASE,'R');
		ROM_UARTCharPutNonBlocking(UART0_BASE,'2');
	}



}



	void storeTempToGestureArray(){

		//use index : Bluetooth_tempGest_index

		//copy command name
		    int k;

		    for (k=0;k<15; k++) {
		       // printf("%c",tempGest.command[k]);
		    	gestures[Bluetooth_tempGest_index].command[k]=Bluetooth_tempGest.command[k];
		    }

		//copy startPos

				//
				    for (k=0; k<5; k++) {
				        //printf("%d ",tempGest.startPos[k]);
				    	gestures[Bluetooth_tempGest_index].startPos[k]=Bluetooth_tempGest.startPos[k];
				    }

		//copy endPos

						    for (k=0; k<5; k++) {
						    	gestures[Bluetooth_tempGest_index].endPos[k]=Bluetooth_tempGest.endPos[k];
						    }

		//copy pressureThreshold
		//    printf("\npressure Threshold: %d\n",tempGest.pressThreshold);
		gestures[Bluetooth_tempGest_index].pressThreshold=Bluetooth_tempGest.pressThreshold;
	ROM_UARTCharPut(UART0_BASE,gestures[Bluetooth_tempGest_index].pressThreshold);


	}

	/*
	 * this function will find available space in Memory
	 * NOTE: predefine to only hold 5 gestures
	 */
	void findSpaceToStoreGestInMemory(){

		int indFree=-1;
		int k;
		//loop to find a gesture that is free
		//...recently has been deleted
		for(k=0;k<5;k++){
			//available space at this index
			if(gestures[k].startPos[0]==-1){
				indFree=k;
			}
		}

		//check if found available space in memory
		if(indFree>-1){
			Bluetooth_tempGest_index=indFree;
			storeTempToGestureArray();

		}
		//else, send I message to app signifiying that no available
		//...space in memory
		else if(indFree==-1){

		    ROM_UARTCharPutNonBlocking(UART7_BASE,'I');

			SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

			ROM_UARTCharPutNonBlocking(UART7_BASE,'/');

					SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

		}

	}

/*
 * function to parse c message
 * store temp gesture
 *
 * offset: int [fixed] {1 dot}
 * servoPosition - startPos: int [5] [variable]->use special function {5 dots}
 * endPosition  - endPos: int [5]  [variable] ->use special function {5 dots}
 *
 * char command[20] [fixed] {1 dot}
 *
 * pressure sense: int [fixed] {1 dot}
 *
 *
 *NOTE: last paramater helps seperate between C message and E message
 *		->type==0: E message, means to store as temp, then run the gesture
 *		->type==1: C message, means to store as temp, then store it in gestures array from offset
 *
 */
void parse_Eand_C_Message(char msg[],int count,int type){

    int periodCnt=0;
    int msgPeriodCnt[4]={1,5,5,1};
    int msgPeriodCount=0;//used to determine what msg its parsing
    int i;
    bool lookingForSection=false;
    int start=0;
    int end;
     //printf("\n");
    for (i=1; i<count; i++) {


        if (msg[i]=='.'&&lookingForSection) {


            //decide if this period is the actual period were looking for
            if (periodCnt==msgPeriodCnt[msgPeriodCount]) {
                lookingForSection=false;
                end=i;//store index of last character in section
                periodCnt=0;

                //parse section
                storeSection(msg, start, end, msgPeriodCount);
                msgPeriodCount++;//increment period to next section

                int k;
                for(k=start;k<end;k++){
                   // printf("%c",msg[k]);
                }
                //printf("\n");
            }
            else{
                periodCnt++;
            }


        }


        //loop through all characters
        if (msg[i]=='.'&&!lookingForSection) {
            lookingForSection=true;
            periodCnt++;
            start=i;//store start character
        }


        //find start character

        //find end character
        //send range and which message to store to

        //reset values






    }//end of for loop

    //finally get last section of message
    char PressThresh=msg[count-1];
    Bluetooth_tempGest.pressThreshold=PressThresh-'0';
    //printf("%c\n",PressThresh);

    //print temporary gesture
    printTempGesture();

    //here test for which message this is, type E or C
    if(type==0){//this message is a type E message

    	//run demo gesture function
    	runDemoGesture();
    }
    else if(type==1){//this message is a type C message

    	//store this temp gesture to the gesture array with the
    	//->index stored in:   Bluetooth_tempGest_index

    	//first run function to determine index ro store in memory

    	findSpaceToStoreGestInMemory();

    	//storeTempToGestureArray();
    }


}

/*
 *  function to pass H message
 *
 *  use boolean active [5]
 *  int gesturesActiveCount=0;
 *
 *  1) loop through all gestures [i]
 *  	->check startPos[j], if any -1, then deleted
 *  	set active[i]=false;
 *  	else{
 *  		active=true
 *  		gesturesActiveCount++;
 *  	}
 *
 *  	PutChar(UART7_BASE,'H');
 *  		delay()
 *  		char m = gesturesActiveCount+'0'
 *  	PutChar(UART7_BASE,m);
 *
 *  2) loop through all gestures again [i]
 *  	if (active[i]==true){
 *  	PutChar(UART7_BASE,'.');//start
 *  	delay()
 *  		loop through gesture command[k]{
 *  			if(command[k]!='\0'){
 *  				PutChar(UART7_BASE,command[k]);
 *  			}
 *  			else{
 *  			PutChar(UART7_BASE,'/');//to indicate ignore space
 *  			}
 *  			}
 *  			PutChar(UART7_BASE,'.');end
 *  				delay()
 *  	}
 *
 */
void send_H_Message(){

	bool active[5];
	char array[100];
	//int m_msgCount;

	m_msgCount=0;
	 //int m_gesturesActiveCount;

	 m_gesturesActiveCount=0;

	 int i;

	 //1) check how many gestures are active
	 //look through gestures
	 for(i=0;i<5;i++){

		 //check if the first servoPos is not -1
		 if(gestures[i].startPos[0]>=0){
			 active[i]=true;//set to active gesture
			 m_gesturesActiveCount++;
		 }

		 //else , it will be false

	 }

	 //put H to bluetooth
	 array[m_msgCount]='H';
	 m_msgCount++;
	   // ROM_UARTCharPutNonBlocking(UART7_BASE,'H');
	    //SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	 array[m_msgCount]='.';
	 m_msgCount++;

	 //put '.' to bluetooth
	   // ROM_UARTCharPutNonBlocking(UART7_BASE,'.');
	   // SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

	    //pass number of active gestures
	    //  		char m = gesturesActiveCount+'0'
	   //  	PutChar(UART7_BASE,m);

	    char m = m_gesturesActiveCount+'0';

	    array[m_msgCount]=m;
	    m_msgCount++;
	   // ROM_UARTCharPutNonBlocking(UART7_BASE,m);

	    /*
	     *  2) loop through all gestures again [i]
 *  	if (active[i]==true){
 *  	PutChar(UART7_BASE,'.');//start
 *  	delay()
 *  		loop through gesture command[k]{
 *  			if(command[k]!='\0'){
 *  				PutChar(UART7_BASE,command[k]);
 *  			}
 *  			else{
 *  			PutChar(UART7_BASE,'/');//to indicate ignore space
 *  			}
 *  			}
 *  			PutChar(UART7_BASE,'.');end
 *  				delay()
 *  	}
	     */

		  ROM_UARTCharPutNonBlocking(UART7_BASE,active[0]);

	    for(i=0;i<5;i++){

	    		if(active[i]){

	    			int k;
	    			array[m_msgCount++]='.';
	    			// ROM_UARTCharPutNonBlocking(UART7_BASE,'.');
	    				  //  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	    			for(k=0;k<15;k++){

//	    				 if(gestures[i].command[k]=='\0'){//place random character to ignore
//	    					 ROM_UARTCharPutNonBlocking(UART7_BASE, '*');
//
//	    							 SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//	    				}

	    				  if(gestures[i].command[k]=='\0'){
													//send to bluetooth
													break;

													// break;
													//ROM_UARTCharPutNonBlocking(UART7_BASE,gestures[i].command[k]);
												  //  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

	    					    				 		    				 	    				}
	    				  else if(gestures[i].command[k]=='*'){

	    				  	    					  if(k>0 && gestures[i].command[k-1]!= '*'){
	    				  	    						  break;
	    				  	    					  }
	    				  	    					array[m_msgCount]='*';
	    				  	    					m_msgCount++;
	    				  	    					break;

	    				  	    					 // break;
	    				  	    				  }
	    				  else if(gestures[i].command[k]!='*'){
	    				 	    					//send to bluetooth
	    				 		 	 	 	 	 	 array[m_msgCount]=gestures[i].command[k];
	    				 		 	 	 	 	 	// break;
	    				 		 	 	 	 	m_msgCount++;
	    				 		 	 	 	 	 	 //break;
	    				 	    				    //ROM_UARTCharPutNonBlocking(UART7_BASE,gestures[i].command[k]);
	    				 	    				  //  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

	    				 	    				}



	    			}//end of for loop

//	    			 ROM_UARTCharPutNonBlocking(UART7_BASE,'.');
//	    				    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

	    		}

	    		//case gesture is not active, send ***
	    		else if(!active[i]){
	    							//array[m_msgCount]='.';
	    							//m_msgCount++;
	    			    			// ROM_UARTCharPutNonBlocking(UART7_BASE,'.');
	    			    				    				  //  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	    							array[m_msgCount]='*';
	    							m_msgCount++;
	    							//ROM_UARTCharPutNonBlocking(UART7_BASE,'*');
	    			    			//SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	    			    			// ROM_UARTCharPutNonBlocking(UART7_BASE,'*');in old

	    			    				    			//SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	    			    				    			 //ROM_UARTCharPutNonBlocking(UART7_BASE,'*');//in old
	    			    				    				    			//SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
	    			    		}


	    }

	    array[m_msgCount]='/';
	    m_msgCount++;
	    int n;
	    for(n=0;n<m_msgCount;n++){
	    	ROM_UARTCharPutNonBlocking(UART7_BASE,array[n]);
			  SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

	    }
	   // ROM_UARTCharPutNonBlocking(UART7_BASE,'/');
	    //SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms



}
/*
 * function to parse F message
 *
 * just execute H message function
 *
 */
void parseFMessage(){

	//send h message to bluetooth
	send_H_Message();

}

/*
 * function to parse G message
 *
 * This will set the MC to either autonomous mode or teaching mode
 */
void parseGMessage(){

	//if false, set it to true
	if(MC_TEACHING_MODE==false){
		MC_TEACHING_MODE=true;
	}
	//if true, set to false
	else if(MC_TEACHING_MODE==true){
		MC_TEACHING_MODE=false;
	}


}




/*
 *  Determine which message is being received
 */
//need global variables bool determineMessage, bool isA, and char[3]
void determineMessage(char inByte){

}

/*
 * receive message function
 *
 *  This function will recieve all messages from the Interrupt
 *
 *  ->Here pass it to be parsed
 *
 *
 *
 *  ->messages: A.0 , B.XXX.XXX.XXX.XXX.XXX ,
 *
 *  -> If message is A, passed gesture from index and
 *
 *  -> If message is B, the parsed message will store into a temp array
 *
 */




/* ORIGINALLY TESTED HERE, BUT BELONGS IN MC
 * convert servo pos (a max 3 digit integer) to character array
 */
//void Bluetooth_convertServoPositionToMessage(int num){
//
//	int count=0;
//	int i;
//
//	for(i=2;i>=0;i--){
//		int k = num/pow(10,i); //get digit
//
//		char c = '0'+k;//convert to character
//
//		bluetooth_servoPos[count++]=c;//store in message
//
//		num = num- k*pow(10,i);//decrease number
//	}
//
//}

///*  ORIGINALLY TESTED HERE, BUT BELONGS IN MC
// * send message function
// */
//
//void Bluetooth_TestSendServoPos(){
//	int k;
//	int j;
//
//	ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
//		 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//
//
//
//	//convert servo position to character message
//	for(j=0;j<5;j++){
//		ROM_UARTCharPutNonBlocking(UART4_BASE,'.');
//			 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//	Bluetooth_convertServoPositionToMessage(gestures[0].servoPositions[j]);
//	 for(k=0;k<3;k++)
//	    {
//		//method only gets one character at a time!
//		ROM_UARTCharPutNonBlocking(UART4_BASE,bluetooth_servoPos[k]);
//
//
//		        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
//		        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//
//		 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
//	}
//
//	}
//
//}

/*
 * function to determine what type of message was sent
 */
void Bluetooth_decodeMessage(char k){
	if(k=='A'){
		Bluetooth_is_A_MSG=true;
	}
	else if(k=='B'){
		Bluetooth_is_B_MSG=true;
	}
	else if(k=='C'){
		Bluetooth_is_C_MSG=true;
	}
	else if(k=='E'){
			Bluetooth_is_E_MSG=true;
		}
	else if(k=='D'){
		Bluetooth_is_D_MSG=true;
	}
	else if(k=='F'){
		Bluetooth_is_F_MSG=true;
	}
	else if(k=='G'){
		Bluetooth_is_G_MSG=true;
	}

}

/*
 * function to parse according messages
 */
void Bluetooth_parseAccordingMessage(char msg[],int count){

	if(Bluetooth_is_A_MSG){

		//pass to function
		char temp[2];

		temp[0]=msg[1];
		temp[1]=msg[2];

		parseAMessage(temp);

		//reset values
		Bluetooth_is_A_MSG=false;
	}
	else if(Bluetooth_is_B_MSG){
		//pass to function
		parseBMessage(msg,0,count);
		//reset values
		Bluetooth_is_B_MSG=false;
	}
	else if(Bluetooth_is_C_MSG){
		//pass to function
		parse_Eand_C_Message(msg,count,1);
		//reset values
		Bluetooth_is_C_MSG=false;

		MC_storeInMemory();
	}
	else if(Bluetooth_is_E_MSG){
			//pass to function
		parse_Eand_C_Message(msg,count,0);
			//reset values
			Bluetooth_is_E_MSG=false;
		}
	else if(Bluetooth_is_D_MSG){

		char temp[2];

				temp[0]=msg[1];
				temp[1]=msg[2];
				//pass to function
				parseDMessage(temp);
		//reset values
		Bluetooth_is_D_MSG=false;


	}
	else if(Bluetooth_is_F_MSG){

		//pass to function
		parseFMessage();
		//reset values
		Bluetooth_is_F_MSG=false;
	}
	else if(Bluetooth_is_G_MSG){
		parseGMessage();
		Bluetooth_is_G_MSG=false;
	}
}


/*
 * function to parse total message sent
 */
void Bluetooth_parseMessage(char msg[], int length){

	//determine what type of message
	Bluetooth_decodeMessage(msg[0]);
	//pass to according function
	Bluetooth_parseAccordingMessage(msg,length);

}

//void Bluetooth_parseMessage(char k){
//	//check if were finding a new message
//	    	if(Bluetooth_determineMessage){
//
//	    			// is it A?
//	     			if(k=='A'){
//	     				//set is A message to true
//	     				Bluetooth_is_A_MSG=true;
//	     				Bluetooth_determineMessage=false;//set determineMessage to false
//	     				//ROM_UARTCharPutNonBlocking(UART0_BASE,'X');
//	     				//ROM_UARTCharPutNonBlocking(UART0_BASE,':');
//	     				//ROM_UARTCharPutNonBlocking(UART0_BASE,c);
//	     			}
//	    			// is it B?
//	     			else if(k=='B'){
//	     			        Bluetooth_is_B_MSG=true;
//	     			        Bluetooth_determineMessage=false;
//	     			       ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
//	    		            SysCtlDelay(g_ui32SysClock / (1000 * 10));//delay
//
//	     			    }
//
//	    	}
//
//	    	//we know which message it is and we need to parse it
//	    	else{
//	    		if(Bluetooth_is_A_MSG){
//	    			Bluetooth_A_MSG[Bluetooth_MSGCount++]=k;
//	    			//ROM_UARTCharPutNonBlocking(UART0_BASE,'D');
//	    			//ROM_UARTCharPutNonBlocking(UART0_BASE,':');
//	    			     				ROM_UARTCharPutNonBlocking(UART0_BASE,Bluetooth_A_MSG[Bluetooth_MSGCount-1]);
//	    			if(Bluetooth_MSGCount>=2){//if count reaches three, call parse message
//	    				//reset values
//	    				parseAMessage(Bluetooth_A_MSG);
//	    				Bluetooth_determineMessage=true;//reset determine Message to true
//	    				Bluetooth_is_A_MSG=false;//reset is A message false
//	    				//MSGcount=0;//set count to zero
//
//	    			}
//	    		}
//
//	    		else if(Bluetooth_is_B_MSG){
//	    		            ///
//	    		           // printf("B!\n");
//
//	    		    //SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//
//	    		            if(Bluetooth_MSGCount<20){
//	    		            Bluetooth_B_MSG[Bluetooth_MSGCount++]=k;
//	    		            ROM_UARTCharPutNonBlocking(UART4_BASE, k);
//	    		            SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay
//	    		           // printf("<>%c ", Bluetooth_B_MSG[Bluetooth_MSGCount-1]);
//	    		            }
//	    		            if(Bluetooth_MSGCount>=20){
//	    		            	 //SysCtlDelay(g_ui32SysClock / (1000 * 10));//delay
//
//	    		            //Here will need to keep collecting message until find 'E' char
//	    		          //  printf("reached: %c! size:%d\n",k,Bluetooth_MSGCount);
//	    		                //int k;
////	    		                for(k=0;k<Bluetooth_MSGCount;k++){
////	    		                // printf("%c",Bluetooth_B_MSG[k]);
////	    		                }
//
//	    		             //  printf("\n");
//	    		            //once 'E' found, send message to parseB function, and reset values
//	    		              //  parseBMessage(Bluetooth_B_MSG, Bluetooth_MSGCount);
////	    		                int m;
////	    		                ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
////	    		                for(m=0;m<Bluetooth_MSGCount;m++){
////	    		                	//pass messages straight to servo controller
////	    		                	  ROM_UARTCharPutNonBlocking(UART4_BASE, Bluetooth_B_MSG[m]);
////	    		                	        SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
////	    		                }
//	    		                Bluetooth_MSGCount=0;
//	    		            //reset values
//	    		            Bluetooth_determineMessage=true;
//	    		            Bluetooth_is_B_MSG=false;
//	    		            }
//
//	    		}
//
//	    		//BUG FIX LOG 1: CASE WHEN A WAS NOT ASSESSED CORRECTLY
//	    		//... SO CHECK IN THIS CASE SO THAT WE DONT MISS THE GESTURE COMMAND
//	    		//...request sRUNNING
////	    		else{
////	    		//print misc message
////
////	    			//ROM_UARTCharPutNonBlocking(UART0_BASE,k);
////	    			//case where it misses the A:
////	    			if(k=='A'){
////	    				Bluetooth_is_A_MSG=true;
////	    				Bluetooth_determineMessage=false;//set determineMessage to false
////	    			}
////
////	    		            else if(k=='B'){
////	    		                Bluetooth_is_B_MSG=true;
////	    		                Bluetooth_determineMessage=false;
////	    		                ROM_UARTCharPutNonBlocking(UART4_BASE,'S');
////		    		            SysCtlDelay(g_ui32SysClock / (1000 * 10));//delay
////
////	    		            }
////
////	    			ROM_UARTCharPutNonBlocking(UART0_BASE,k);
////
////	    		}
//
//
//	    	}
//}

void
Bluetooth_HC_06IntHandler2(void)
{
    uint32_t ui32Status;

    //int MSGcount=0;//count used for storing recieved message
    //
    // Get the interrrupt status.
    //
    ui32Status = ROM_UARTIntStatus(UART7_BASE, true);

    //
    // Clear the asserted interrupts.
    //
    ROM_UARTIntClear(UART7_BASE, ui32Status);



    ROM_UARTCharPutNonBlocking(UART0_BASE,'B');
    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
    ROM_UARTCharPutNonBlocking(UART0_BASE,':');
    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
    ROM_UARTCharPutNonBlocking(UART0_BASE,' ');
    SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
//    //
    // Loop while there are characters in the receive FIFO.
    //
    //char msg[64];
    //int Bluetooth_cnt=0;
    //SysCtlDelay(g_ui32SysClock / (1000 * 10));//delay of 10ms
    while(ROM_UARTCharsAvail(UART7_BASE))
    {
        //
        // Read the next character from the UART and write it back to the UART.
        //
    	char k;
    	k= ROM_UARTCharGetNonBlocking(UART7_BASE);
 //ROM_UARTCharPutNonBlocking(UART0_BASE,
   //                              k);

    	if(k=='/'){
    		Bluetooth_determineMessage=false;
    	}
    	if(Bluetooth_determineMessage==true&&k!='/'){
    		BU_Bluetooth_MSG[Bluetooth_MSGCount]=k;
    	Bluetooth_MSGCount++;
    	}

    	//Bluetooth_parseMessage(k);


    	}//end of while loop
    //Bluetooth_MSGCount--;//decrement to start at open space
    	//this case, message was not fully recieved
    	if(Bluetooth_determineMessage && Bluetooth_MSGCount>0){
    		//Bluetooth_MSGCount--;
    		//Bluetooth_MSGCount++;
    	}
    	else if(!Bluetooth_determineMessage){
    ROM_UARTCharPutNonBlocking(UART6_BASE,BU_Bluetooth_MSG[12]);
    //Bluetooth_cnt=0;

    Bluetooth_parseMessage(BU_Bluetooth_MSG,Bluetooth_MSGCount);

    	Bluetooth_MSGCount=0;
    	//need to reset all conditions here to parse new message!
    	Bluetooth_determineMessage=true;//reset determine Message to true

    	//reset array

    	int j;
    	    	for(j=0;j<66;j++){
    	    		BU_Bluetooth_MSG[j]='\0';
    	    	}


    	    	int k;
    	    	    	    	for(k=0;k<66;k++){
    	    	    	    		BU_Bluetooth_MSG[k]='\0';
    	    	    	    	}


    }
       // Bluetooth_is_A_MSG=false;//reset is A message false



    ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
}

/*
 * realtime Passing to Servo
 */

/*
 * BluetoothUART handler function
 */
//*****************************************************************************
//Interrupt Code(1)
// The HC-06 (UART_7) interrupt handler for hardware UART.
//
//added by Andrew Mendez: 1/28/15
//*****************************************************************************
void
Bluetooth_HC_06IntHandler(void)
{
    uint32_t ui32Status;

    //
    // Get the interrrupt status.
    //
    ui32Status = ROM_UARTIntStatus(UART7_BASE, true);

    //
    // Clear the asserted interrupts.
    //
    ROM_UARTIntClear(UART7_BASE, ui32Status);



    //ROM_UARTCharPutNonBlocking(UART0_BASE,'B');
    //ROM_UARTCharPutNonBlocking(UART0_BASE,':');
    //ROM_UARTCharPutNonBlocking(UART0_BASE,' ');
    //
    // Loop while there are characters in the receive FIFO.
    //
    while(ROM_UARTCharsAvail(UART7_BASE))
    {
        //
        // Read the next character from the UART and write it back to the UART.
        //
    	char c;
    	c= ROM_UARTCharGetNonBlocking(UART7_BASE);
        //SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms

        ROM_UARTCharPutNonBlocking(UART6_BASE,
                                  c);
        SysCtlDelay(g_ui32SysClock / (1000 * 10));//delay of 10ms




    }
    //MC_ResetServos(Bluetooth_tempPos);


	// MC_ResetServos(defaultGest.servoPositions);
   //  MC_SendServoPos(Bluetooth_tempPos,defaultGest.servoPositions);
    // SysCtlDelay(7000000);//need delay here!
    // MC_SendServoPos(defaultGest.servoPositions,Bluetooth_tempPos);
   // MC_SendServoPos(defaultGest.servoPositions,gestures[0].servoPositions);

    ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
}

/*
 * Initalize Bluetooth function
 */

void initalizeBluetooth(){

	 //
	    // Enable the peripherals used by this example.(2)
	    //

	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART7);
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);

	//configure GPIO C4 and C5 for hardware UART(2)
	 GPIOPinConfigure(GPIO_PC4_U7RX);
	 GPIOPinConfigure(GPIO_PC5_U7TX);
	 ROM_GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_4 | GPIO_PIN_5);


	  //configure hardware UART(1)

	    ROM_UARTConfigSetExpClk(UART7_BASE, g_ui32SysClock, 115200,
	                            (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE |
	                             UART_CONFIG_PAR_NONE));

	 //register the handler function used to handle interrupt

	    UARTIntRegister(UART7_BASE,Bluetooth_HC_06IntHandler2);

	    //Interrupt(3)--------------
	        ROM_IntEnable(INT_UART7);//enable the interrupt for UART7
	         ROM_UARTIntEnable(UART7_BASE, UART_INT_RX | UART_INT_RT);//enable the UART interrupt for UART7

	         int k;
	             	    	    	    	for(k=0;k<66;k++){
	             	    	    	    		BU_Bluetooth_MSG[k]='\0';
	             	    	    	    	}
}

#endif /* BLUETOOTH_H_ */
