/*
 * MainController.h
 *
 *  Created on: Mar 18, 2015
 *      Author: Andrew Mendez
 */
#include "Gesture.h"
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"//library to have nice function to printf
#include "driverlib/eeprom.h"
#include "driverlib/eeprom.c"
#include "driverlib/flash.h"


Gesture gestures[5];
Gesture defaultGest;


//ONLY USED TO HARD CODE GESTURES IN EEPROM,
//KEEP COMENTED SO DO NOT RUN OUT OF RAM!
char MC_posOfAllGestures[230];//hold all servo positions of all gestures, and default;
uint32_t tempStorage[230];
/*
 * THIS boolean indicates whether we are in autonomous mode or teaching mode
 * false is AUTONOMOUS MODE
 * true is TEACHING MODE
 */

//int SC_grasp[5][5];
//int SC_tempPos[5];

bool MC_TEACHING_MODE;
bool MC_isMid;
bool MC_isHigh;

int MC_tempServoPos[5] = {180,180,180,0,180};
//int MC_defaultServoPos[5] = {0,0,0,0,0};
int stPos[5]={90,90,90,90,90};
int MC_defaultServoPos[5] = {180,180,180,180,180};//FOR  IPPA SERVOS

char MC_servoPos[3];


//****************************************************************************
//
// System clock rate in Hz.
//
//****************************************************************************
uint32_t g_ui32SysClock;


#ifndef MAINCONTROLLER_H_
#define MAINCONTROLLER_H_

/*
 * initalize EEPROM function
 */

void MC_initalizeEEPROM(){

	  ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_EEPROM0);//activate EEPROM
	        EEPROMInit();//EEPROM Start
}

/*
 * reset EEPROM function
 *
 * This will reset the data that is in the EEPROM function to
 * factory settings
 *
 */

void MC_resetEEPROM(){
	EEPROMMassErase();
}



//TASKS IN MEMORY WILL BE STORED AS SO

//uint32_t tasks[25]//for all 5 gestures with each 5 servo pos
//uint32_t names[100]// for all 5 names with each name being 29 chars

//TASK will define either a grasp or a gesture

//methods

/*
 * Store task method
 *
 * * This will locate the spot in memory the gesture the user wants to add
 *
 * The function will fetch all tasks that are residing in memory
 *
 * locate the right one,
 *
 * 			-> use i*4 to find start address of where to add task in array
 * 			-> determine i*20 in char array to find start pos of where to add name
 * 			-> ... in char array
 *
 * will receive an int[] position as a parameter
 *
 * will store into EEPROM as uint32[] arr
 *
 * USED FOR GLOBAL CASE
 */
//void storeTask(int index,int arr[]){
//
//	//convert all elements to uint32
//
//	//load them to new uint32_t array
//
//	//store them in EEPROM
//
//
//
////	MC_posOfAllGestures[index*5]=arr[0];
////	MC_posOfAllGestures[index*5+1]=arr[1];
////	MC_posOfAllGestures[index*5+2]=arr[2];
////	MC_posOfAllGestures[index*5+3]=arr[3];
////	MC_posOfAllGestures[index*5+4]=arr[4];
//
//	if(index==0){
//		MC_posOfAllGestures[0]=arr[0];
//			MC_posOfAllGestures[1]=arr[1];
//			MC_posOfAllGestures[2]=arr[2];
//			MC_posOfAllGestures[3]=arr[3];
//			MC_posOfAllGestures[4]=arr[4];
//
//	}
//	else if(index==1){
//		MC_posOfAllGestures[5]=arr[0];
//					MC_posOfAllGestures[6]=arr[1];
//					MC_posOfAllGestures[7]=arr[2];
//					MC_posOfAllGestures[8]=arr[3];
//					MC_posOfAllGestures[9]=arr[4];
//
//	}
//	else if(index==2){
//		MC_posOfAllGestures[10]=arr[0];
//					MC_posOfAllGestures[11]=arr[1];
//					MC_posOfAllGestures[12]=arr[2];
//					MC_posOfAllGestures[13]=arr[3];
//					MC_posOfAllGestures[14]=arr[4];
//
//	}else if(index==3){
//		MC_posOfAllGestures[15]=arr[0];
//							MC_posOfAllGestures[16]=arr[1];
//							MC_posOfAllGestures[17]=arr[2];
//							MC_posOfAllGestures[18]=arr[3];
//							MC_posOfAllGestures[19]=arr[4];
//
//
//	}else if (index==4){
//
//		MC_posOfAllGestures[20]=arr[0];
//					MC_posOfAllGestures[21]=arr[1];
//					MC_posOfAllGestures[22]=arr[2];
//					MC_posOfAllGestures[23]=arr[3];
//					MC_posOfAllGestures[24]=arr[4];
//	}
//
//}


/*
 * retreive task method from memory
 */

void retrieveTask(int index,uint32_t arr[]){

	  gestures[index].servoPositions[0]=(int)arr[index*5];
	  gestures[index].servoPositions[1]=(int)arr[index*5+1];
	  gestures[index].servoPositions[2]=(int)arr[index*5+2];
	  gestures[index].servoPositions[3]=(int)arr[index*5+3];
	  gestures[index].servoPositions[4]=(int)arr[index*5+4];

}

/*
 * intiatlize task method from memory
 */

void initalizeTask(int index,uint32_t arr[]){

	  gestures[index].servoPositions[0]=(int)arr[0];
	  gestures[index].servoPositions[1]=(int)arr[1];
	  gestures[index].servoPositions[2]=(int)arr[2];
	  gestures[index].servoPositions[3]=(int)arr[3];
	  gestures[index].servoPositions[4]=(int)arr[4];

}

/*
 * all start positions will be in i*3
 /*
 * convert message to int (atoi)
 */

void getStartPos(int index){
    char msg[3];
    int k;
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[index*15+k];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].startPos[0]=-1;
    }
    else{
    gestures[index].startPos[0]=atoi(msg);
    }

    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }

    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[index*15+k+3];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].startPos[1]=-1;
    }
    else{
        gestures[index].startPos[1]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[index*15+k+6];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].startPos[2]=-1;
    }
    else{
        gestures[index].startPos[2]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[index*15+k+9];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].startPos[3]=-1;
    }
    else{
        gestures[index].startPos[3]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }

    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[index*15+k+12];
    }
    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].startPos[4]=-1;
    }
    else{
        gestures[index].startPos[4]=atoi(msg);
    }

    // gestures[index].startPos[4]=atoi(msg);
}

/*
 * convert servo pos (a max 3 digit integer) to character array
 */
void MC_convertServoPositionToMessage(int num){

	int count2=0;
	int l;

	if(num>0){
	for(l=2;l>=0;l--){
		int k = num/pow(10,l); //get digit

		char c = '0'+k;//convert to character

		MC_servoPos[count2++]=c;//store in message

		num = num- k*pow(10,l);//decrease number
	}
	}
	else {
		MC_servoPos[0]='0';//store in message
		MC_servoPos[1]='0';//store in message
		MC_servoPos[2]='0';//store in message
	}

}

void setStartPos(index){
    //char msg[3];
    int k;
    //get message of character

    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].startPos[0]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[index*15+k]='*';
         //   printf("%c ",MC_posOfAllGestures[index*15+k]);
        }

    }
    else{
    MC_convertServoPositionToMessage(gestures[index].startPos[0]);
    for(k=0;k<3;k++){
        MC_posOfAllGestures[index*15+k]=MC_servoPos[k];
       // printf("%c ",MC_posOfAllGestures[index*15+k]);
    }
    }
     //printf("\n");
    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].startPos[1]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[index*15+k+3]='*';
        //    printf("%c ",MC_posOfAllGestures[index*15+k]);
        }

    }
    else{
    MC_convertServoPositionToMessage(gestures[index].startPos[1]);
    for(k=0;k<3;k++){
        MC_posOfAllGestures[index*15+k+3]=MC_servoPos[k];
      //  printf("%c ",MC_posOfAllGestures[index*15+k+3]);
    }
    }
    // printf("\n");

    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].startPos[2]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[index*15+k+6]='*';
         //   printf("%c ",MC_posOfAllGestures[index*15+k+6]);
        }

    }
    else{
    MC_convertServoPositionToMessage(gestures[index].startPos[2]);
    for(k=0;k<3;k++){
        MC_posOfAllGestures[index*15+k+6]=MC_servoPos[k];
       // printf("%c ",MC_posOfAllGestures[index*15+k+6]);
    }
    }
     //printf("\n");

    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].startPos[3]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[index*15+k+9]='*';
         //   printf("%c ",MC_posOfAllGestures[index*15+k+9]);
        }

    }
    else{
    MC_convertServoPositionToMessage(gestures[index].startPos[3]);
    for(k=0;k<3;k++){
        MC_posOfAllGestures[index*15+k+9]=MC_servoPos[k];
       // printf("%c ",MC_posOfAllGestures[index*15+k+9]);
    }
    }
     //printf("\n");
    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].startPos[4]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[index*15+k+12]='*';
          //  printf("%c ",MC_posOfAllGestures[index*15+k+12]);
        }

    }
    else{
    MC_convertServoPositionToMessage(gestures[index].startPos[4]);
    for(k=0;k<3;k++){
        MC_posOfAllGestures[index*15+k+12]=MC_servoPos[k];
        //printf("%c ",MC_posOfAllGestures[index*15+k+12]);
    }
    }
   // MC_posOfAllGestures[index*5]= MC_
     //MC_posOfAllGestures[index*5+1]= (char)gestures[index].startPos[1];
     //MC_posOfAllGestures[index*5+2]= (char)gestures[index].startPos[2];
     //MC_posOfAllGestures[index*5+3]= (char)gestures[index].startPos[3];
     //MC_posOfAllGestures[index*5+4]= (char)gestures[index].startPos[4];
}

void getEndPos(int index){
    char msg[3];
    int k;
    int baseAddr=75;
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[baseAddr+index*15+k];
    }


    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].endPos[0]=-1;
    }
    else{
        gestures[index].endPos[0]=atoi(msg);
    }

    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }

    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[baseAddr+index*15+k+3];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].endPos[1]=-1;
    }
    else{
        gestures[index].endPos[1]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[baseAddr+index*15+k+6];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].endPos[2]=-1;
    }
    else{
        gestures[index].endPos[2]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }
    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[baseAddr+index*15+k+9];
    }

    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].endPos[3]=-1;
    }
    else{
        gestures[index].endPos[3]=atoi(msg);
    }
    //reset array
    for(k=0;k<3;k++){
        msg[k]='\0';
    }

    for(k=0;k<3;k++){
        msg[k]=MC_posOfAllGestures[baseAddr+index*15+k+12];
    }
    //if servoPos was a msg of "***", then
    //...that gesture was deleted, and set to -1
    if (msg[0]=='*') {
        gestures[index].endPos[4]=-1;
    }
    else{
        gestures[index].endPos[4]=atoi(msg);
    }
    //gestures[index].endPos[4]=  ;
}

/*
 * Weird bug: can set high character value but cannot retrieve and print
 */

void setEndPos(index){
    //char msg[3];
    int k;
    int baseAddr=75;
    //get message of character
    if (gestures[index].endPos  [0]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k]='*';
        //    printf("%c ",MC_posOfAllGestures[index*15+k]);
        }

    }
    else{
        MC_convertServoPositionToMessage(gestures[index].endPos[0]);
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k]=MC_servoPos[k];
      //      printf("%c ",MC_posOfAllGestures[index*15+k]);
        }
    }
    //printf("\n");
    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].endPos[1]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+3]='*';
        //    printf("%c ",MC_posOfAllGestures[index*15+k]);
        }

    }
    else{
        MC_convertServoPositionToMessage(gestures[index].endPos[1]);
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+3]=MC_servoPos[k];
      //      printf("%c ",MC_posOfAllGestures[index*15+k+3]);
        }
    }
    //printf("\n");

    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].endPos[2]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+6]='*';
        //    printf("%c ",MC_posOfAllGestures[index*15+k+6]);
        }

    }
    else{
        MC_convertServoPositionToMessage(gestures[index].endPos[2]);
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+6]=MC_servoPos[k];
      //      printf("%c ",MC_posOfAllGestures[index*15+k+6]);
        }
    }
    //printf("\n");

    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].endPos[3]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+9]='*';
        //    printf("%c ",MC_posOfAllGestures[index*15+k+9]);
        }

    }
    else{
        MC_convertServoPositionToMessage(gestures[index].endPos[3]);
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+9]=MC_servoPos[k];
      //      printf("%c ",MC_posOfAllGestures[index*15+k+9]);
        }
    }
    //printf("\n");
    //If value of servoPos is -1, gesture
    //...is deleted
    if (gestures[index].endPos[4]<0) {
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+12]='*';
            //printf("%c ",MC_posOfAllGestures[index*15+k+12]);
        }

    }
    else{
        MC_convertServoPositionToMessage(gestures[index].endPos[4]);
        for(k=0;k<3;k++){
            MC_posOfAllGestures[baseAddr+index*15+k+12]=MC_servoPos[k];
           // printf("%c ",MC_posOfAllGestures[index*15+k+12]);
        }
    }
    //for(k=0;k<3;k++){
    //char c = MC_posOfAllGestures[147];
    //char d = MC_posOfAllGestures[148];
    //char e = MC_posOfAllGestures[149];
         //int indexed=baseAddr+index*15+k+12;
      //  printf("%c %c %c ",c,d,e);
   // }
    // MC_posOfAllGestures[index*5]= MC_
    //MC_posOfAllGestures[index*5+1]= (char)gestures[index].startPos[1];
    //MC_posOfAllGestures[index*5+2]= (char)gestures[index].startPos[2];
    //MC_posOfAllGestures[index*5+3]= (char)gestures[index].startPos[3];
    //MC_posOfAllGestures[index*5+4]= (char)gestures[index].startPos[4];
}

/*
 * function to get command names of gestures
 */
void getNames(){
    int baseAddr=150;
    //get first name
    int i;

    int addr = baseAddr;
    int count=0;

    for (i=addr; i<(addr+15); i++) {
        gestures[0].command[count++]=MC_posOfAllGestures[i];
       // printf("%c",gestures[0].command[count-1]);
    }
     //printf("\n");

    //get second name

     addr = baseAddr+1*15;
     count=0;

    for (i=addr; i<(addr+15); i++) {
        gestures[1].command[count++]=MC_posOfAllGestures[i];
       // printf("%c",gestures[1].command[count-1]);
    }
     //printf("\n");

    //get third name

    addr = baseAddr+2*15;
    count=0;

    for (i=addr; i<(addr+15); i++) {
        gestures[2].command[count++]=MC_posOfAllGestures[i];
       // printf("%c",gestures[2].command[count-1]);
    }
     //printf("\n");
    //get fourth name

    addr = baseAddr+3*15;
    count=0;

    for (i=addr; i<(addr+15); i++) {
        gestures[3].command[count++]=MC_posOfAllGestures[i];
       // printf("%c",gestures[3].command[count-1]);
    }
     //printf("\n");

    //get fifth name

    addr = baseAddr+4*15;
    count=0;

    for (i=addr; i<(addr+15); i++) {
        gestures[4].command[count++]=MC_posOfAllGestures[i];
      //  printf("%c",gestures[4].command[count-1]);
    }
    // printf("\n");

}

/*
 * function to set names of gestures into the giant array
 *  ...which will be stored in memory
 */

void setNames(){
    int baseAddr=150;
    //get first name
    int i;

    int addr = baseAddr;
    int count=0;


    //get gesture characters, store it into the correct
    //index of the array
    for (i=0; i<15; i++) {
        if (gestures[0].command[i]=='\0') {
            MC_posOfAllGestures[baseAddr+i]= '*';
        }
        else{
        MC_posOfAllGestures[baseAddr+i]= gestures[0].command[i];
        }
        //printf("%c",MC_posOfAllGestures[baseAddr+i]);
    }
    //printf("\n");

    //store second gesture
    for (i=0; i<15; i++) {
        if (gestures[1].command[i]=='\0') {
            MC_posOfAllGestures[baseAddr+i+15]= '*';
        }
        else{
        MC_posOfAllGestures[baseAddr+15+i]= gestures[1].command[i];
        }
        //printf("%c",MC_posOfAllGestures[baseAddr+15+i]);
    }
    //printf("\n");

    //store third gesture
    for (i=0; i<15; i++) {
        if (gestures[2].command[i]=='\0') {
            MC_posOfAllGestures[baseAddr+i+15*2]= '*';
        }
        else{
        MC_posOfAllGestures[baseAddr+15*2+i]= gestures[2].command[i];
        }
        //printf("%c",MC_posOfAllGestures[baseAddr+15*2+i]);
    }
    //printf("\n");

    //store fourth gesture
    for (i=0; i<15; i++) {
        if (gestures[3].command[i]=='\0') {
            MC_posOfAllGestures[baseAddr+i+15*3]= '*';
        }
        else{
        MC_posOfAllGestures[baseAddr+15*3+i]= gestures[3].command[i];
        }
        //printf("%c",MC_posOfAllGestures[baseAddr+15*3+i]);
    }
    //printf("\n");

    //store fifth gesture
    for (i=0; i<15; i++) {
        if (gestures[4].command[i]=='\0') {
            MC_posOfAllGestures[baseAddr+i+15*4]= '*';
        }
        else{
        MC_posOfAllGestures[baseAddr+15*4+i]= gestures[4].command[i];
        }
       // printf("%c",MC_posOfAllGestures[baseAddr+15*4+i]);
    }
    //printf("\n");
}

/*
 * function to get pressure thresholds
 */
void getPressure(){
    gestures[0].pressThreshold=MC_posOfAllGestures[225]-'0';
    //printf("%d ",gestures[0].pressThreshold);
    gestures[1].pressThreshold=MC_posOfAllGestures[226]-'0';
    //printf("%d ",gestures[1].pressThreshold);
    gestures[2].pressThreshold=MC_posOfAllGestures[227]-'0';
    //printf("%d ",gestures[2].pressThreshold);
    gestures[3].pressThreshold=MC_posOfAllGestures[228]-'0';
    //printf("%d ",gestures[3].pressThreshold);
    gestures[4].pressThreshold=MC_posOfAllGestures[229]-'0';
    //printf("%d ",gestures[4].pressThreshold);
}

/*
 * function to set pressure thesholds
 */
void setPressure(){

        MC_posOfAllGestures[225]= gestures[0].pressThreshold+'0';
    //printf("%c ",  MC_posOfAllGestures[225]);
    MC_posOfAllGestures[226]=gestures[1].pressThreshold+'0';
    //printf("%c ",  MC_posOfAllGestures[226]);
    MC_posOfAllGestures[227]= gestures[2].pressThreshold+'0';
    //printf("%c ",  MC_posOfAllGestures[227]);
    MC_posOfAllGestures[228]= gestures[3].pressThreshold+'0';
    //printf("%c ",  MC_posOfAllGestures[228]);
    MC_posOfAllGestures[229]= gestures[4].pressThreshold+'0';
    //printf("%c ",  MC_posOfAllGestures[229]);

}

/*
 * funtion converts big array to be
 * ...unit32_t and ready to store in memory
 */

void convertChartoUnit32Array(){
	int i;
	for(i=0;i<230;i++){
		tempStorage[i]=(uint32_t) MC_posOfAllGestures[i];
	}
}

void convertUnit32ArrayToCharArray(){
	int i;
	for(i=0;i<230;i++){
		 MC_posOfAllGestures[i]=(char)tempStorage[i];
	}
}
//----------------------------------------------------------------------------------



/*
 * Load all gestures function
 * USED FOR GLOBAL CASE!
 */
//void loadAllGestures(){
//
//
//
//
//	//store to task 1
//	retrieveTask(0,MC_posOfAllGestures);
//
//		//store task 2
//		retrieveTask(1,MC_posOfAllGestures);
//
//
//			//store task 3
//			retrieveTask(2,MC_posOfAllGestures);
//
//
//				//store task 4
//				retrieveTask(3,MC_posOfAllGestures);
//
//
//
//				//store task 5
//					retrieveTask(4,MC_posOfAllGestures);
//
//
//}

/*
 * this functions gets gestures from memory
 * ...and loads them to the gestures
 */
void loadGesturesfromMemory(){
	getStartPos(0);
	    getStartPos(1);
	    getStartPos(2);
	    getStartPos(3);
	    getStartPos(4);

	    getEndPos(0);
	    getEndPos(1);
	    getEndPos(2);
	    getEndPos(3);
	    getEndPos(4);

	    getNames();
	    getPressure();

}

/*
 * this functions stores all gestures into memory
 *
 *
 */
void storeGesturesInMemory(){
	    setStartPos(0);
	    setStartPos(1);
	    setStartPos(2);
	    setStartPos(3);
	    setStartPos(4);

	    setEndPos(0);
	     setEndPos(1);
	     setEndPos(2);
	     setEndPos(3);
	     setEndPos(4);
	     setEndPos(5);

	    setNames();
	    setPressure();

}

void loadAllGestures2(uint32_t arr[]){




//	//store to task 1
//	retrieveTask(0,arr);
//
//		//store task 2
//		retrieveTask(1,arr);
//
//
//			//store task 3
//			retrieveTask(2,arr);
//
//
//				//store task 4
//				retrieveTask(3,arr);
//
//
//
//				//store task 5
//					retrieveTask(4,arr);


}

/*
 * removeTaskMethod
 *
 * This will retrieve the gesture the user wants to delete
 *
 * The function will fetch all tasks that are residing in memory
 *
 * locate the right one,
 *
 * 			-> add -1 for all servo positions so signifies its empty
 * 			-> add -1 in char array to signify no gesture name is there
 *
 *
 *
 */
void removeTaskMethod(int index){

}






MC_initalizeGesture(){

	int k;
		for(k=0;k<5;k++){
//			gestures[0].servoPositions[k]=90;
		gestures[0].servoPositions[k] = MC_tempServoPos[k];
		}

}

/*
 * MC_convertIntArrtoUIntArr() function
 *
 * helper function to convert an integer array to a uint arry
 * to be stored in non-volatile memory
 *
 * assume length of the arr input will be 5
 *
 * use memory allocation and pointer to return  result
 *
 *
 */
//void MC_convertIntArrto_UInt32_T_Arr(int arr[]){
//
//	//uint32_t* res=(uint32_t*)malloc(sizeof(uint32_t) * 5);
//
//		MC_res[0]= arr[0];
//		MC_res[1]= arr[1];
//		MC_res[2]= arr[2];
//		MC_res[3]= arr[3];
//		MC_res[4]= arr[4];
//
//
//
//
//}

/*
 * MC_convertUIntArrtoIntArrto() function
 *
 * helper function to convert an integer array to a uint arry
 * to be stored in non-volatile memory
 *
 * assume length of the arr input will be 5
 *
 * use memory allocation and pointer to return  result
 *
 */
int* MC_convert_UInt32_T_ArrtoIntArrto(uint32_t arr[]){

	int* res=malloc(sizeof(int)*5);
	int i;
		for(i=0;i<5;i++){
		res[i]=(int) arr[i];
	}

	return res;

}

/*
 * this program will read from flash memory
 * to get all of the data
 *
 * the plan is to loop all 230 elements in increments
 *  of 4 bytes
 *
 *  INSPIRATION: googles gs logger for TM4C123G
 *
 *  link to code and insight in evernote!
 */
void readFromFlash(){

	uint32_t addr=0x10000;
	char data;
	int i;
	for(i=0;i<230;i++){
		MC_posOfAllGestures[i]=(char)HWREG(addr);

		//UARTCharPut(UART0_BASE,data);
		addr+=4;//have to increment in 4 bytes (1 word)

	}

}

//MC_tempServoPos[5] = {179,179,179,179,179};

/*
 * function to initalize all gestures
 *
 * here the gestures will be fetched from the EEPROM Memory and
 * ...will populate the Gesture Structure
 *
 *
 */

void MC_storeInMemory(){

	storeGesturesInMemory();
	convertChartoUnit32Array();
	//										 uint32_t addr = 0x400AF040;
	FlashErase(0x10000);
	FlashProgram(tempStorage,0x10000,sizeof(tempStorage));
}
MC_initalizeAllGestures(){

	//---------------------------------------------------------
	int k;
	//char command[15];

//		for(k=0;k<5;k++){
////			gestures[0].servoPositions[k]=90;
//			gestures[0].startPos[k]= stPos[k];
//		gestures[0].endPos[k] = MC_tempServoPos[k];
//		}
//
//		gestures[0].command[0]='a';
//		gestures[0].command[1]='p';
//		gestures[0].command[2]='p';
//		gestures[0].command[3]='l';
//		gestures[0].command[4]='e';
//		//gestures[0].command[5]='r';
//		//gestures[0].command[6]='e';
//		//gestures[0].command[7]='1';
//
//		//storeTask(0,MC_tempServoPos);
//		//store in memory
//
//		//gesture 0:
//		/*
//		 * MC_tempServoPos[0];
//		MC_tempServoPos[1];
//		MC_tempServoPos[2];
//		MC_tempServoPos[3];
//		MC_tempServoPos[4];
//		 */
//
//		//Gesture  to be stored in memory
//		//gesture 2
//		MC_tempServoPos[0]=180;
//		MC_tempServoPos[1]=180;
//		MC_tempServoPos[2]=180;
//		MC_tempServoPos[3]=180;
//		MC_tempServoPos[4]=0;
//
//		//store in memory
//
//		for(k=0;k<5;k++){
//		//			gestures[0].servoPositions[k]=90;
//			gestures[1].startPos[k]= stPos[k];
//					gestures[1].endPos[k] = MC_tempServoPos[k];
//				}
//
//		//initalize names
//
//		gestures[1].command[0]='h';
//				gestures[1].command[1]='a';
//				gestures[1].command[2]='n';
//				gestures[1].command[3]='d';
//				//gestures[1].command[4]='u';
//				//gestures[1].command[5]='r';
//				//gestures[1].command[6]='e';
//				//gestures[1].command[7]='2';
//
//		//storeTask(1,MC_tempServoPos);
//				//gesture 3
//				MC_tempServoPos[0]=0;
//				MC_tempServoPos[1]=0;
//				MC_tempServoPos[2]=0;
//				MC_tempServoPos[3]=0;
//				MC_tempServoPos[4]=0;
//
//				//store in memory
//
//				for(k=0;k<5;k++){
//				//			gestures[0].servoPositions[k]=90;
//					gestures[2].startPos[k]= stPos[k];
//										gestures[2].endPos[k] = MC_tempServoPos[k];
//						}
//				//initalize names
//
//				gestures[2].command[0]='p';
//						gestures[2].command[1]='e';
//						gestures[2].command[2]='a';
//						gestures[2].command[3]='c';
//						gestures[2].command[4]='e';
//						//gestures[2].command[5]='r';
//						//gestures[2].command[6]='e';
//						//gestures[2].command[7]='3';
//				//storeTask(2,MC_tempServoPos);
//				//test for small servo: ES: 08A
//				//gesture 4
//				MC_tempServoPos[0]=123;
//						MC_tempServoPos[1]=180;
//						MC_tempServoPos[2]=180;
//						MC_tempServoPos[3]=180;
//						MC_tempServoPos[4]=180;
//
//						//store in memory
//
//						for(k=0;k<5;k++){
//						//			gestures[0].servoPositions[k]=90;
//							gestures[3].startPos[k]= stPos[k];
//												gestures[3].endPos[k] = MC_tempServoPos[k];
//								}
//
//
//						for(k=0;k<5;k++){
//												//			gestures[0].servoPositions[k]=90;
//													gestures[4].startPos[k]= stPos[k];
//																		gestures[4].endPos[k] = MC_tempServoPos[k];
//														}
//
//						gestures[3].command[0]='p';
//								gestures[3].command[1]='o';
//								gestures[3].command[2]='i';
//								gestures[3].command[3]='n';
//								gestures[3].command[4]='t';
//								//gestures[3].command[5]='r';
//								//gestures[3].command[6]='e';
//								//gestures[3].command[7]='4';
//
//
//								gestures[4].command[0]='r';
//										gestures[4].command[1]='o';
//										gestures[4].command[2]='c';
//										gestures[4].command[3]='k';
										//gestures[4].command[4]='u';
										//gestures[4].command[5]='r';
										//gestures[4].command[6]='e';
										//gestures[4].command[7]='5';

										//storeGesturesInMemory();
										//convertChartoUnit32Array();
										 uint32_t addr = 0x400AF040;
										// FlashErase(0x10000);
										 //FlashProgram(tempStorage,0x10000,sizeof(tempStorage));
										// FlashRead(tempStorage,0x10000,sizeof(tempStorage);
										//  EEPROMProgram(tempStorage,addr,sizeof(tempStorage));

										  //read all gestures from memory!
											//EEPROMRead(tempStorage,0x10000,sizeof(tempStorage));
										 readFromFlash();
											//convertUnit32ArrayToCharArray();



										//UARTCharPut(UART0_BASE,MC_posOfAllGestures[23]);

										 loadGesturesfromMemory();
										 UARTCharPut(UART0_BASE,gestures[0].command[3]);
										  //

						//storeTask(3,MC_tempServoPos);
						//storeTask(4,MC_tempServoPos);
//---------------------------------------------------------

//	int k;
//
//	//store in memory
//						MC_tempServoPos[0]=180;
//							MC_tempServoPos[1]=180;
//							MC_tempServoPos[2]=180;
//							MC_tempServoPos[3]=180;
//							MC_tempServoPos[4]=180;
//	storeTask(0,MC_tempServoPos);
//
//		//store in memory
//
//		//gesture 0:
//		/*
//		 * MC_tempServoPos[0];
//		MC_tempServoPos[1];
//		MC_tempServoPos[2];
//		MC_tempServoPos[3];
//		MC_tempServoPos[4];
//		 */
//
//		//Gesture  to be stored in memory
//		//gesture 2
//		MC_tempServoPos[0]=180;
//		MC_tempServoPos[1]=180;
//		MC_tempServoPos[2]=180;
//		MC_tempServoPos[3]=180;
//		MC_tempServoPos[4]=0;
//
//		//store in memory
//		storeTask(1,MC_tempServoPos);
//
//
//
//
//
//				//gesture 3
//				MC_tempServoPos[0]=0;
//				MC_tempServoPos[1]=0;
//				MC_tempServoPos[2]=0;
//				MC_tempServoPos[3]=0;
//				MC_tempServoPos[4]=0;
//
//				storeTask(2,MC_tempServoPos);
//				//store in memory
//
////
//				//test for small servo: ES: 08A
//				//gesture 4
//				MC_tempServoPos[0]=123;
//						MC_tempServoPos[1]=180;
//						MC_tempServoPos[2]=180;
//						MC_tempServoPos[3]=180;
//					MC_tempServoPos[4]=180;
//						//store in memory
//						storeTask(3,MC_tempServoPos);
//
//						storeTask(4,MC_tempServoPos);

						//test storing last gesture in memory
						// uint32_t addr = 0x400AF040;
					//	 uint32_t read[25];
//						  MC_convertIntArrto_UInt32_T_Arr(gestures[3].servoPositions);
						 //int z;
//						 for(z=0;z<25;z++){
//
//							 if(MC_posOfAllGestures[z]>=(uint32_t)0){
//								 UARTCharPut(UART0_BASE,'D');
//							 }
//						 }
				 			//UARTCharPut(UART0_BASE,'D');

						  //store pos in memory
						 //MC_posOfAllGestures
						// EEPROMProgram(MC_posOfAllGestures,addr,sizeof(MC_posOfAllGestures));
						 //EEPROMProgram(MC_res,addr,sizeof(MC_res));
//						 if(EEPROMProgram(MC_res,addr,sizeof(MC_res))!=(uint32_t)0){
//							c
//						 }
//
//
//
//						 //read all gestures from memory!
//						 EEPROMRead(MC_posOfAllGestures,addr,sizeof(MC_posOfAllGestures));
						 //EEPROMRead(read,addr,sizeof(read));
//
//						 //load all gestures from memory into gesture structs
						// loadAllGestures2(read);
						// free(read);
		// loadAllGestures();THIS ONE IS USED FOR WHEN YOU HAVE THE DATA ARRAY AS A GLOBAL VAR
//
//						 if(gestures[0].servoPositions[0]>=0){
//							 UARTCharPut(UART0_BASE,'D');
//						 }

						 //read from memory

						 // uint32_t read[30];
						  //EEPROMRead(read,addr,sizeof(read));
						  //UARTCharPut(UART0_BASE,'D');

//						  for(z=0;z<25;z++){
//							  if(MC_posOfAllGestures[z]>0){
//								  UARTCharPut(UART0_BASE,'D');
//							  }
//						  }



						//test retrieving it from memory
						 // retrieveTask(0,read);





}


/*
 * initalize default gesture function
 */

MC_initalizeDefaultGesture(){

	int k;
			for(k=0;k<5;k++){
	//			gestures[0].servoPositions[k]=90;
			defaultGest.servoPositions[k] = MC_defaultServoPos[k];
			}
}



/*
 * function used to reset servos to default pos
 *
 */

void MC_ResetServos(int pos[]){
	//convert servo position to character message
int j;
int k;
ROM_UARTCharPutNonBlocking(UART6_BASE,'S');
SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//convert servo position to character message
		for(j=0;j<5;j++){
			ROM_UARTCharPutNonBlocking(UART6_BASE,'.');
				 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
		MC_convertServoPositionToMessage(pos[j]);
		 for(k=0;k<3;k++)
		    {
			//method only gets one character at a time!
			ROM_UARTCharPutNonBlocking(UART6_BASE,MC_servoPos[k]);


			        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
			        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!

			 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
		}

		}

		SysCtlDelay(7000000);//need delay here!


}


/*
 * send servo positions in real time
 *
 * USED TO EXECUTE GESTURES
 *		->NEED CHECK CONDITION TO SEE IF SERVO POS ARE VALID
 *
 */
void MC_passToServos(int pos[]){
	//convert servo position to character message
int j;
int k;
bool servosValid=true;
	//check if servo pos are valid

	for(k=0;k<5;k++){
		if(pos[k]<=-1){
			servosValid=false;
		}
	}

	//if(servosValid){
ROM_UARTCharPutNonBlocking(UART6_BASE,'S');
		 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
		//send temp array to servo controller

		//convert servo position to character message
			for(j=0;j<5;j++){
				ROM_UARTCharPutNonBlocking(UART6_BASE,'.');
					 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
			MC_convertServoPositionToMessage(pos[j]);
			 for(k=0;k<3;k++)
			    {
				//method only gets one character at a time!
				ROM_UARTCharPutNonBlocking(UART6_BASE,MC_servoPos[k]);


				        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
				        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!

				 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
			}

			}


		//}//end of if statement


}

/*
 * function to delete gesture
 *
 * parameters: msg: D.0/
 *
 * just like the A function
 *
 * ... index = msg[st+1] -'0'
 *
 *pass to function to null any values
 */
void MC_deleteGesture(int index){


	 int k;

	 //set all gesture name characters to /0

			    for (k=0;k<15; k++) {
			       // printf("%c",tempGest.command[k]);
			    	gestures[index].command[k]='*';
			    }

			    //set all startPos to -1


					//
					    for (k=0; k<5; k++) {
					        //printf("%d ",tempGest.startPos[k]);
					    	gestures[index].startPos[k]=-1;
					    }

					    //set all end Pos to -1

							    for (k=0; k<5; k++) {
							    	gestures[index].endPos[k]=-1;
							    }

			//set pressure sensor to -1
			//    printf("\npressure Threshold: %d\n",tempGest.pressThreshold);
			gestures[index].pressThreshold=-1;


}

/*
 * send message function
 *
 * NOTE THIS IS FOR GRASPING ONLY
 */

void MC_SendServoPos(int pos[],int end[]){
	int k;
	int j;
	//boolean isNagative=false;//this boolean statement used to determine if moving foward or back

	//if()

		 //update 4/4/15 : get every index and make incremental array to send servo pos to
		 int incArray[5];
		 for(j=0;j<5;j++){
			 incArray[j]=(end[j]-pos[j])/5;
		 }

	//int incMatrix[5][5];
	int f;
	int d;
	for( f=0;f<5;f++){
		//make temp array to send pos
		int tempPos[5];
		for(d=0;d<5;d++){
		//	if(incArray[d]>=0){
			tempPos[d]=pos[d]+incArray[d]*(f+1);
			//}
			//else if(incArray[d]<0){
				//tempPos[d]=pos[d]+incArray[d]*(f+1);
			//}
		}

		if(!MC_isHigh){
		ROM_UARTCharPutNonBlocking(UART6_BASE,'S');
		 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
		//send temp array to servo controller

		//convert servo position to character message
			for(j=0;j<5;j++){
				ROM_UARTCharPutNonBlocking(UART6_BASE,'.');
					 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
			MC_convertServoPositionToMessage(tempPos[j]);
			 for(k=0;k<3;k++)
			    {
				//method only gets one character at a time!
				ROM_UARTCharPutNonBlocking(UART6_BASE,MC_servoPos[k]);


				        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
				        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!

				 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
			}

			}
			//ROM_UARTCharPutNonBlocking(UART4_BASE,'.');
			//set delay to temp pause and wait
			SysCtlDelay(70000000/5);//delay to show servo's holding
		}//end of if statement
	}


	//convert servo position to character message
//		for(j=0;j<5;j++){
//			ROM_UARTCharPutNonBlocking(UART4_BASE,'.');
//				 SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//		MC_convertServoPositionToMessage(pos[j]);
//		 for(k=0;k<3;k++)
//		    {
//			//method only gets one character at a time!
//			ROM_UARTCharPutNonBlocking(UART4_BASE,MC_servoPos[k]);
//
//
//			        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
//			        SysCtlDelay(g_ui32SysClock / (1000 * 3));//need delay here!
//
//			 //ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
//		}
//
//		}

}



/*
 * SendTaskToServo method
 *
 * Method comprised of
 *
 * ->Converting the Servo Position to a character array,
 * ->Sending the message to the servo controller
 *
 *  Parameters: Gesture
 */
void MC_sendTaskToServo(Gesture g){

	//call MC_
	//MC_SendServoPos(g.servoPositions,g.defaultGest);
}

/*
 * Complete Task Method
 *
 * This method will be the task of completing either a gesture or a grasp
 *
 * This will be done by:
 *
 * -> Send Servo Positions for the Servo Controller to Move to
 *
 * -> Receive message back from Servo Controller that it is done
 *
 * -> add delay for 4 second (REALLY SHOULD BE WAIT FOR EMG SIGNAL)
 *
 * -> Send Servo Default Position for the Servo Controller to move to
 * 		*simulate a releasing of the task
 */
void MC_completeTask(Gesture startGesture, Gesture endGesture){

	// MC_sendTaskToServo(startGesture);
	        SysCtlDelay(70000000);//delay to show servo's holding
	   //     MC_sendTaskToServo(endGesture);

}



/*
 * this function will be used when the bluetooth system parses message to
 * complete a certain gesture
 *
 * NOTE : FOR GRABBING ONLY
 *
 */

//NOTE: USE THIS ONE FOR BLUETOOTH
void MC_completeGesture(int index){

	//MC_SendServoPos(defaultGest.servoPositions,startGesture.servoPositions);
	//move to start Position

				SysCtlDelay(70000000/10);//delay to show servo's holding
				MC_passToServos(gestures[index].startPos);
		        SysCtlDelay(70000000);//delay to show servo's holding
		    	//move to end position
		        MC_passToServos(gestures[index].endPos);
		        SysCtlDelay(70000000);//delay to show servo's holding
		        //move to default
		        MC_passToServos(defaultGest.servoPositions);
		        //MC_SendServoPos(startGesture.servoPositions,defaultGest.servoPositions);
}

/*
 * DefaultUARTIntHandler
 */

//*****************************************************************************
//
// The UART interrupt handler.
//
//*****************************************************************************
void
UARTIntHandler(void)
{
    uint32_t ui32Status;

    //
    // Get the interrrupt status.
    //
    ui32Status = ROM_UARTIntStatus(UART0_BASE, true);

    //
    // Clear the asserted interrupts.
    //
    ROM_UARTIntClear(UART0_BASE, ui32Status);

    //
    // Loop while there are characters in the receive FIFO.
    //
    while(ROM_UARTCharsAvail(UART0_BASE))
    {
        //
        // Read the next character from the UART and write it back to the UART.
        //
    	char c;
        	c= ROM_UARTCharGetNonBlocking(UART0_BASE);

        	//this thing will do a broadcast
            ROM_UARTCharPutNonBlocking(UART7_BASE,
                                      c);
            ROM_UARTCharPutNonBlocking(UART6_BASE,
                                                 c);


        //
        // Blink the LED to show a character transfer is occuring.
        //
        //GPIOPinWrite(GPIO_PORTN_BASE, GPIO_PIN_0, GPIO_PIN_0);

        //
        // Delay for 10 millisecond.  Each SysCtlDelay is about 3 clocks.
        //
        SysCtlDelay(g_ui32SysClock / (1000 * 3));

        //
        // Turn off the LED
        //
      //  GPIOPinWrite(GPIO_PORTN_BASE, GPIO_PIN_0, 0);
    }
}

#endif /* MAINCONTROLLER_H_ */
