/*
 * SensorController.h
 *
 *  Created on: Mar 18, 2015
 *      Author: Andrew Mendez
 */
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

//#include "MainController.h"
#ifndef SENSORCONTROLLER_H_
#define SENSORCONTROLLER_H_

int32_t i32val;//value which will store the input values from the input pin
int32_t i32valPin1;//value which will store the input values from the input pin
int32_t i32valPin2;//value which will store the input values from the input pin
int32_t i32valPin3;//value which will store the input values from the input pin

bool SC_TaskTriggered;//this will help prevent task only triggered once not +1 times,
bool startGrasp=false;
bool movingGrasp=false;

int SC_grasp[5][5];
int SC_tempPos[5];
int SC_moveCount;

//methods

/*
 * Initalize Sensor controller by initalizing GPIO pins PDO
 */

void initalizeSensorController(){
	//initalize port
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL);//NEED TO DO THIS, else error will be thrown

    //set pin 0 and port D to be input and SW controlled
    	    ROM_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE,GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2| GPIO_PIN_3);
    	    //ROM_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE,GPIO_PIN_1);
    	    //ROM_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE,GPIO_PIN_2);
    	    //ROM_GPIOPinTypeGPIOInput(GPIO_PORTL_BASE,GPIO_PIN_3);
    	    SC_TaskTriggered=false;

    	    int k;

//    	    SC_grasp[0][0]=36;
//    	    SC_grasp[0][1]=36;
//    	    SC_grasp[0][2]=36;
//    	    SC_grasp[0][3]=36;
//    	    SC_grasp[0][4]=36;
//
//    	    SC_grasp[1][0]=72;
//    	    SC_grasp[1][1]=72;
//    	    SC_grasp[1][2]=72;
//    	    SC_grasp[1][3]=72;
//    	    SC_grasp[1][4]=72;
//
//    	    SC_grasp[2][0]=108;
//    	       	    SC_grasp[2][1]=108;
//    	       	    SC_grasp[2][2]=108;
//    	       	    SC_grasp[2][3]=108;
//    	       	    SC_grasp[2][4]=108;
//
//    	       	  SC_grasp[3][0]=144;
//    	       	    	    SC_grasp[3][1]=144;
//    	       	    	    SC_grasp[3][2]=144;
//    	       	    	    SC_grasp[3][3]=144;
//    	       	    	    SC_grasp[3][4]=144;
//
//    	       	    	 SC_grasp[4][0]=160;
//    	       	    	    SC_grasp[4][1]=160;
//    	       	    	   SC_grasp[4][2]=160;
//    	       	    	 SC_grasp[4][3]=160;
//    	       	    	 SC_grasp[4][4]=160;

    	    SC_grasp[0][0]=160;
    	        	    SC_grasp[0][1]=160;
    	        	    SC_grasp[0][2]=160;
    	        	    SC_grasp[0][3]=160;
    	        	    SC_grasp[0][4]=160;

    	        	    SC_grasp[1][0]=144;
    	        	    SC_grasp[1][1]=144;
    	        	    SC_grasp[1][2]=144;
    	        	    SC_grasp[1][3]=144;
    	        	    SC_grasp[1][4]=144;

    	        	    SC_grasp[2][0]=108;
    	        	       	    SC_grasp[2][1]=108;
    	        	       	    SC_grasp[2][2]=108;
    	        	       	    SC_grasp[2][3]=108;
    	        	       	    SC_grasp[2][4]=108;

    	        	       	  SC_grasp[3][0]=144;
    	        	       	    	    SC_grasp[3][1]=72;
    	        	       	    	    SC_grasp[3][2]=72;
    	        	       	    	    SC_grasp[3][3]=72;
    	        	       	    	    SC_grasp[3][4]=72;

    	        	       	    	 SC_grasp[4][0]=0;
    	        	       	    	    SC_grasp[4][1]=0;
    	        	       	    	   SC_grasp[4][2]=0;
    	        	       	    	 SC_grasp[4][3]=0;
    	        	       	    	 SC_grasp[4][4]=0;


    	       	    	 SC_moveCount=0;
}

/*
 *  check trigger pin function
 *
 *  This function will check all of the pins that will trigger a gesture when emitted
 *
 *  if either pin is high, trigger MC to start grasp
 *
 *  Will check PD0 for EMG sensor msg that ATMega328p will process
 *
 */
	void SC_checkTaskTriggerPins(){

		/*A variable is created to store the return value of GPIOPinRead and then checked if its 0 or not.
				 *
				 * We use a value that is a 32 but value to store the value of the input of the pin. This 32 bit value
				 * enables to read all the 8 pins at the same time, however since we only set one pin of all pins on the port
				 * to one value, we can ignore bits 32-8 from the return packet. Because we set PD0 as input, bit 0 is the bit
				 * we check to see if zero or one, so the only possible valuw we would see is in between 0 and 1
				 *
				 * To look at any pin enabled on a port and see if it is HIGH or low, we can do the following
				 * (i32val & GPIO_PIN_#)==1, then High, else, GPIO_PIN_X is low
				 */


		/*
		 * --------------> NOTE MAKE SURE NOT READING PRESSURE THRESHOLD OF -1, may be a possibility
		 */

		if(MC_TEACHING_MODE==false){
				i32val =GPIOPinRead(GPIO_PORTL_BASE,GPIO_PIN_0);
				i32valPin1=GPIOPinRead(GPIO_PORTL_BASE,GPIO_PIN_1);
				i32valPin2=GPIOPinRead(GPIO_PORTL_BASE,GPIO_PIN_2);
				i32valPin3=GPIOPinRead(GPIO_PORTL_BASE,GPIO_PIN_3);
				//i32val++;
				//display value in console
				//ROM_UARTCharPut(UART0_BASE,c);
		//		if(ROM_GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_0)==0){
		//		ROM_UARTCharPutNonBlocking(UART0_BASE,'0');
		//		}




				if((i32val&GPIO_PIN_0)==0){
						//ROM_UARTCharPutNonBlocking(UART0_BASE,'0');
					SC_TaskTriggered=false;
						}
				if((i32valPin1&GPIO_PIN_1)==0){
										//ROM_UARTCharPutNonBlocking(UART0_BASE,'0');
									SC_TaskTriggered=false;
										}

		//		 if(ROM_GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_0)!=0){
		//			ROM_UARTCharPutNonBlocking(UART0_BASE,'1');
		//		}



				/*
											 * fourth check: if MED pin is high,
											 * ... then set boolean isMid to true
											 * *****use i32valPin2******
											 */
//					    if((i32valPin2&GPIO_PIN_2)!=0&&!SC_TaskTriggered&&movingGrasp ){
//												//MC_isMid=true;
//											//MC_ResetServos(defaultGest.servoPositions);
//											startGrasp=false;
//											//SC_TaskTriggered=false;
//											SC_moveCount=0;
//											}
//
//
//											/*
//											 * fourth check: if High pin is high,
//											 * ... then set boolean isHigh to true
//											*  ****use i32valPin3******
//											 */
//						if((i32valPin3&GPIO_PIN_3)!=0&&!SC_TaskTriggered&&movingGrasp ){
//											//MC_isHigh=true;
//							//MC_ResetServos(defaultGest.servoPositions);
//											startGrasp=false;
//											//SC_TaskTriggered=false;
//											SC_moveCount=0;
//											//MC_ResetServos(defaultGest.servoPositions);
//
//											}



//											if((i32valPin3&GPIO_PIN_3)==0&&startGrasp){
//												//ROM_UARTCharPutNonBlocking(UART0_BASE,'0');
//													//SC_TaskTriggered=false;
//													//MC_isHigh=false;
//
//
//																			}




				/*
				* second check: if EMG triggers and hand has not moved
				* go to start pos, grab
				*/
				if((i32val&GPIO_PIN_0)!=0 && !SC_TaskTriggered&&startGrasp==false){
					startGrasp=true;
					movingGrasp=true;
						ROM_UARTCharPutNonBlocking(UART0_BASE,'S');
						 SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
						ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
						SC_TaskTriggered=true;



						//call MC to complete task
					//MC_passToServos(Bluetooth_tempPos);
						        //MC_sendTaskToServo(gestures[2]);
					//MC_SendServoPos(defaultGest.servoPositions,gestures[0].endPos);
						        //SysCtlDelay(SysCtlClockGet()/(1000*250));//need delay here!
								 //SysCtlDelay(7000000*2);//need delay here!
								// MC_ResetServos(defaultGest.servoPositions);
						//MC_SendServoPos(gestures[0].endPos,defaultGest.servoPositions);
								 //MC_passToServos(defaultGest.servoPositions);


						}

				/*
				 * third check: if Dist Sensor triggers and hand
				 * ...has not grasped, then start grab
				 */

				if((i32valPin1&GPIO_PIN_1)!=0 && !SC_TaskTriggered&&startGrasp==false){
									startGrasp=true;
									movingGrasp=true;
										ROM_UARTCharPutNonBlocking(UART0_BASE,'S');
										 SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
										ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
										SC_TaskTriggered=true;



										//call MC to complete task
									//MC_passToServos(Bluetooth_tempPos);
										        //MC_sendTaskToServo(gestures[2]);
									//MC_SendServoPos(defaultGest.servoPositions,gestures[0].endPos);
										        //SysCtlDelay(SysCtlClockGet()/(1000*250));//need delay here!
												 //SysCtlDelay(7000000*2);//need delay here!
												// MC_ResetServos(defaultGest.servoPositions);
										//MC_SendServoPos(gestures[0].endPos,defaultGest.servoPositions);
												 //MC_passToServos(defaultGest.servoPositions);


										}


				/*
								 * first check: if EMG triggers and hand has moved
								 * go to default, release
								 */
								if((i32val&GPIO_PIN_0)!=0&&!SC_TaskTriggered&&startGrasp==true&&movingGrasp==false){

									SC_TaskTriggered=true;
									startGrasp=false;
									movingGrasp=false;
									//movingGrasp=false;
														ROM_UARTCharPutNonBlocking(UART0_BASE,'S');
														 SysCtlDelay(g_ui32SysClock / (1000 * 3));//delay of 10ms
														ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');
														SC_TaskTriggered=true;
														SC_moveCount=0;

														MC_ResetServos(defaultGest.servoPositions);
														// SysCtlDelay(7000000*2);//need delay here!



														//call MC to complete task
													//MC_passToServos(Bluetooth_tempPos);
														        //MC_sendTaskToServo(gestures[2]);
														//MC_SendServoPos(gestures[0].endPos,defaultGest.servoPositions);

													//MC_SendServoPos(defaultGest.servoPositions,gestures[0].endPos);
														        //SysCtlDelay(SysCtlClockGet()/(1000*250));//need delay here!
																 //SysCtlDelay(7000000*2);//need delay here!
																// MC_ResetServos(defaultGest.servoPositions);
																 //MC_passToServos(defaultGest.servoPositions);


														}
				//UARTSend((uint8_t *)"TEST", 5);
				//delay 100ms
				if((i32valPin2&GPIO_PIN_2)==0&&(i32valPin3&GPIO_PIN_3)==0&&!SC_TaskTriggered&&startGrasp&&movingGrasp){
								//if(!SC_TaskTriggered&&startGrasp&&movingGrasp){

								//ROM_UARTCharPutNonBlocking(UART0_BASE,'0');
																						//SC_TaskTriggered=false;
																						//MC_isMid=false;
																				int k;
																				if(SC_moveCount<5){
																				for(k=0;k<5;k++){
																					SC_tempPos[k]=SC_grasp[SC_moveCount][k];
																				}
																				MC_ResetServos(SC_tempPos);
																				//SysCtlDelay(7000000/5);//need delay here!

																				SC_moveCount++;
																				}
																				else if(SC_moveCount>=5){
																					movingGrasp=false;
																				}

																			}



				 SysCtlDelay(7000000/5);//need delay here!
				//ROM_UARTCharPutNonBlocking(UART0_BASE,'\n');

	}//end of if statement

	}



/*
 * Sensor Controller Interrupt Handler
 */


#endif /* SENSORCONTROLLER_H_ */
