# KnightHome Backend

## Requirements

* NodeJS v5.7.0 Stable
* MongoDB 3.2.0

## Development Setup

ESLint
---
We use [ESLint](http://eslint.org/) to ensure a consistent code style and avoid buggy code.

**Live Linting with Sublime Text:**

1. Get ESLint using ```npm install -g eslint```
2. Install [Sublime Package Control](https://packagecontrol.io/installation)
3. Install [SublimeLinter](http://www.sublimelinter.com/en/latest/installation.html#installing-via-pc)
4. Install [SublimeLinter-eslint](https://github.com/roadhump/SublimeLinter-eslint#linter-installation)


## Deployment Setup

1. Install Node.JS v5.7.0, MongoDB 3.2.0
2. Run `npm install` in this directory.
3. Configure Express.js and MongoDB settings in `config.json`
3. Run `node knighthome.js`.
4. (optional) Use forever to install KnightHome's backend as a service: `sudo npm install -g forever forever-service && sudo forever-service install knighthome -s knighthome.js`
5. (optional) Use a webserver like nginx to reverse proxy secure traffic to this service running on localhost.
