exports.isInvalidDeviceSettings = function(deviceModel, deviceType, deviceSettings) {
    if (!deviceType) return new Error('missing device type');
    if (!deviceSettings) return new Error('missing device settings');

    var attrs = Object.keys(deviceModel.schema.paths);

    for (var i = 0; i < attrs.length; i++) {
        var settingPath = attrs[i].split('.');

        if (settingPath[0] !== 'settings') continue;
        if (settingPath[1] !== deviceType) continue;
        if (settingPath[2] in deviceSettings) continue;

        return new Error('missing setting value: ' + settingPath[2]);
    }
};

exports.parseTypeFromHardwareId = function(id) {
    if (typeof id !== 'string') return undefined;

    var types = {
        '00': 'wall_switch',
        '01': 'wall_outlet',
        '10': 'door_lock',
        '11': 'hvac'
    };

    return types[id.substr(0, 2)];
};
