module.exports = function(app, db) {
    app.auth = function(req, res, next) {
        if (!req.session._id) {
            return res.status(401).json({
                message: 'authentication required'
            });
        }

        if (!req.header('authorization') || req.session.token !== req.header('authorization').split(' ')[1]) {
            return res.status(403).json({
                message: 'forbidden'
            });
        }

        db.User.findOne({
            _id: req.session._id
        }, function(err, user) {
            if (err) {
                return res.status(500).json({
                    message: 'internal server error'
                });
            }

            req.user = user;
            next();
        });
    };

    app.use('/user', require('./routes/user')(app, db));
    app.use('/devices', require('./routes/devices')(app, db));
    app.use('/tasks', require('./routes/tasks')(app, db));
    app.use('/schedules', require('./routes/schedules')(app, db));
    app.use('/energy', require('./routes/energy')(app, db));

    // 404 all non-existent API routes
    app.use('/*', function(req, res) {
        res.status(404).json({
            message: 'Not Found'
        });
    });
};
