var app = angular.module('api', []);

app.factory('API', function($http) {
    var prefix = window.cordova ? 'https://knighthome.xyz/api/' : '/api/';

    var request = function(method, path, options) {
        options = options || {};

        var params = options.params;
        var data = options.data;
        var token = localStorage.getItem('sessionToken');

        return $http({
            url: prefix + path,
            params: params,
            data: data,
            headers: {
                Authorization: token ? 'Session ' + token : undefined
            },
            timeout: 30000,
            method: method,
            withCredentials: token ? true : false
        });
    };

    return {
        prefix: function() {
            return prefix;
        },
        delete: function(path, options) {
            return request('DELETE', path, options);
        },
        get: function(path, options) {
            return request('GET', path, options);
        },
        post: function(path, options) {
            return request('POST', path, options);
        },
        put: function(path, options) {
            return request('PUT', path, options);
        }
    };
});
