document.addEventListener('deviceready', function() {
    // Setup status bar
    StatusBar.overlaysWebView(false);
    StatusBar.backgroundColorByHexString('#f8f8f8');
}, false);

$('body').on('click', '#navbar .navbar-nav a', function() {
    if ($('#navbar').hasClass('in')) $('.navbar-toggle').click();
});

var app = angular.module('KnightHome', ['ui.router', 'ui.bootstrap', 'auth', 'api', 'login', 'register', 'devices', 'tasks', 'energy', 'chart.js', 'angular-cron-jobs', 'schedules', 'user']);

app.config(function($stateProvider, $urlRouterProvider/* , $locationProvider */) {
    /* $locationProvider.html5Mode({
        enabled: true,
        requireBase: true
    }); */

    var authenticate = function($q, User, $state, $timeout, $location) {
        var deferred = $q.defer();

        User.checkAuthentication(function(data) {
            var returnTo = $location.path();

            if ($location.search()) {
                var qs = jQuery.param($location.search());

                if (qs.length) {
                    returnTo += '?' + qs;
                }
            }

            if (!data) {
                $timeout(function() {
                    $state.go('login', { return_to: returnTo });
                });
                return deferred.reject();
            }

            deferred.resolve(User);
        });

        return deferred.promise;
    };

    $stateProvider
    .state('login', {
        url: '/login?{return_to:any}&{error:any}',
        templateUrl: 'partials/login.html',
        controller: 'login',
        title: 'Login'
    })
    .state('register', {
        url: '/register?{return_to:any}&{error:any}',
        templateUrl: 'partials/register.html',
        controller: 'register',
        title: 'Register'
    })
    .state('devices', {
        url: '/devices',
        templateUrl: 'partials/devices.html',
        title: 'Devices',
        controller: 'devices',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('tasks', {
        url: '/tasks',
        templateUrl: 'partials/tasks.html',
        title: 'Tasks',
        controller: 'tasks',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('tasks_edit', {
        url: '/tasks/:id',
        templateUrl: 'partials/tasks_edit.html',
        title: 'Edit Task',
        controller: 'tasks_edit',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('schedules', {
        url: '/schedules',
        templateUrl: 'partials/schedules.html',
        title: 'Schedules',
        controller: 'schedules',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('energy', {
        url: '/energy',
        templateUrl: 'partials/energy.html',
        title: 'Energy',
        controller: 'energy',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('user', {
        url: '/user',
        templateUrl: 'partials/user.html',
        title: 'Profile',
        controller: 'user',
        resolve: {
            authenticate: authenticate
        }
    })
    .state('404', {
        url: '/404',
        templateUrl: 'partials/not_found.html',
        title: '404 Not Found'
    });

    $urlRouterProvider.when('', '/devices');
    $urlRouterProvider.when('/', '/devices');

    $urlRouterProvider.otherwise('/404');
});

app.config(function($httpProvider) {
    $httpProvider.defaults.headers.common['Cache-Control'] = 'no-cache';
    $httpProvider.defaults.headers.common.Pragma = 'no-cache';

    $httpProvider.interceptors.push('LoginCheck');
});

app.run(function($rootScope, $state, $stateParams) {
    $rootScope.$state = $state;
    $rootScope.$stateParams = $stateParams;

    document.addEventListener('deviceready', function() {
        $rootScope.mobileDevice = true;
        $rootScope.$apply();
    }, false);
});

app.factory('Alert', function($window) {
    $window.toastr.options = {
        'closeButton': true,
        'debug': false,
        'progressBar': true,
        'positionClass': 'toast-top-right',
        'onclick': null,
        'showDuration': '400',
        'hideDuration': '1000',
        'timeOut': '7000',
        'extendedTimeOut': '1000',
        'showEasing': 'swing',
        'hideEasing': 'linear',
        'showMethod': 'fadeIn',
        'hideMethod': 'fadeOut'
    };

    return {
        new: function(severity, message) {
            $window.toastr[severity](message);
        }
    };
});
