var app = angular.module('auth', []);

app.factory('LoginCheck', function($q, $location, $injector) {
    return {
        response: function(response) {
            return response || $q.when(response);
        },
        responseError: function(rejection) {
            var $state = $injector.get('$state');
            if (rejection.status === 401 && ['/login', '/register'].indexOf($location.path()) > -1) $state.go('login', { return_to: $location.path() });
            return $q.reject(rejection);
        }
    };
});

app.factory('User', function($rootScope, $location, $timeout, $state, $modal, $http, $window, API) {
    var user = {};

    user.checkAuthentication = function(callback) {
        if (user._id) return callback(user);

        API.get('user').success(function(data) {
            user.setUserData(data);
            callback(data);
        }).error(function() {
            callback(null);
        });
    };

    user.setUserData = function(data) {
        Object.keys(data).forEach(function(key) {
            user[key] = data[key];
        });
    };

    user.setSession = function(callback) {
        API.get('user').success(function(data) {
            if (callback) callback();
            user.setUserData(data);
        }).error(function() {
            user.logout();
        });
    };

    user.isAuthenticated = function() {
        return !!user._id;
    };

    user.logout = function() {
        localStorage.removeItem('sessionToken');

        Object.keys(user).forEach(function(key) {
            if (typeof user[key] === 'function') return;

            delete user[key];
        });

        $state.transitionTo('login');
    };

    user.login = function(form, redirect) {
        if (!redirect || redirect.charAt(0) !== '/' || redirect.charAt(1) === '/') redirect = '/devices';

        API.post('user', {
            data: form
        }).success(function(data) {
            localStorage.setItem('sessionToken', data.sessionToken);

            user.setSession(function() {
                $window.location = '#' + redirect;
            });
        }).error(function(d) {
            $state.transitionTo(form.action, { error: d.message });
        });
    };

    // Saved session token, login
    if (localStorage.getItem('sessionToken')) user.setSession();

    return user;
});

app.run(function($rootScope, User) {
    $rootScope.User = User;
});
