var app = angular.module('devices', []);

app.controller('devices', function($scope, $state, $interval, $timeout, $stateParams, $modal, API, Alert) {
    var updateDevices = function() {
        API.get('devices').success(function(d) {
            $scope.devices = d;
        });
    };

    updateDevices();

    var updateDevicesInterval = $interval(function() {
        updateDevices();
    }, 5000);

    $scope.$on('$destroy', function() {
        $interval.cancel(updateDevicesInterval);
    });

    $scope.add = function() {
        $modal.open({
            templateUrl: 'partials/devices.add-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.device = {};
                $scope.wifi = {
                    channel: 11
                };

                $scope.step = 1;

                var sap = new SoftAPSetup({ host: '192.168.0.1', timeout: 10000, protocol: 'http', port: 80 });

                function connect(err) {
                    if (err) {
                        return Alert.new('error', 'error configuring wifi on device');
                    }

                    sap.connect(function(connErr) {
                        if (connErr) {
                            return Alert.new('error', 'error connecting to wifi on device');
                        }

                        $scope.$apply(function() {
                            $scope.step = 4;
                        });
                    });
                }

                function configure(err, dat) {
                    if (err) {
                        return Alert.new('error', 'error getting wifi networks on device');
                    }

                    $scope.$apply(function() {
                        $scope.step = 3;
                        $scope.wifiNetworks = dat;
                    });
                }

                function scan(err) {
                    if (err) {
                        return Alert.new('error', 'error getting public key on device');
                    }

                    $scope.$apply(function() {
                        $scope.step = 2;
                    });

                    sap.scan(configure);
                }

                function key(err) {
                    if (err) {
                        return Alert.new('error', 'error setting claim code on device');
                    }

                    sap.publicKey(scan);
                }

                var waiting = false;
                function claim(err) {
                    if (err && !waiting) {
                        waiting = true;
                        return $timeout(function() {
                            waiting = false;
                            sap.deviceInfo(claim);
                        }, 5000);
                    }

                    sap.setClaimCode('wat', key);
                }

                sap.deviceInfo(claim);

                $scope.add = function() {
                    API.post('devices', {
                        data: $scope.device
                    }).success(function() {
                        updateDevices();
                        $scope.close();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.setupWiFi = function() {
                    sap.configure($scope.wifi, connect);
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.toggleState = function(device, settingKey) {
        settingKey = settingKey || 'enabled';

        device.settings[settingKey] = device.settings[settingKey] ? false : true;

        API.put('devices/' + device._id, {
            data: device
        });
    };

    $scope.modifySettings = function(device) {
        $modal.open({
            templateUrl: 'partials/devices.settings-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.device = angular.copy(device);

                $scope.update = function() {
                    API.put('devices/' + device._id, {
                        data: $scope.device
                    }).success(function() {
                        updateDevices();
                        $scope.close();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.remove = function() {
                    API.delete('devices/' + device._id).success(function() {
                        updateDevices();
                        $scope.close();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.modifyControls = function(device) {
        $modal.open({
            templateUrl: 'partials/devices.controls-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.device = angular.copy(device);

                $scope.update = function() {
                    API.put('devices/' + device._id, {
                        data: $scope.device
                    }).success(function() {
                        updateDevices();
                        $scope.close();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };
});

app.filter('capitalize', function() {
    return function(input) {
        if (!input) return;

        return input.substring(0, 1).toUpperCase() + input.substring(1);
    };
});
