var app = angular.module('energy', []);

app.controller('energy', function($scope, $state, $stateParams, $modal, API, Alert) {
    var updateGraph = function(resolution) {
        $scope.totals = {
            year: 0,
            month: 0,
            week: 0,
            day: 0
        };

        var startingTimes = {
            day: moment().startOf('day').toISOString(),
            week: moment().startOf('week').toISOString(),
            month: moment().startOf('month').toISOString(),
            year: moment().startOf('year').toISOString()
        };

        API.get('devices').success(function(devices) {
            // Door locks do not measure power usage (battery)
            devices = devices.filter(function(a) {
                return a.type !== 'door_lock';
            });

            $scope.devices = devices;

            API.get('energy').success(function(d) {
                d.forEach(function(stat) {
                    Object.keys(startingTimes).forEach(function(type) {
                        if (new Date(startingTimes[type]) > new Date(stat.createdAt)) return;

                        $scope.totals[type] += stat.daily;
                    });
                });

                $scope.graphSeries = ['Total'].concat(devices.map(function(dev) {
                    return dev.name;
                }));

                $scope.graphData = [];

                if (resolution === 'day') {
                    $scope.graphLabels = [
                        '12am', '1am', '2am', '3am', '4am', '5am', '6am', '7am',
                        '8am', '9am', '10am', '11am', '12pm', '1pm', '2pm', '3pm',
                        '4pm', '5pm', '6pm', '7pm', '8pm', '9pm', '10pm', '11pm'
                    ];

                    devices.map(function(dev) {
                        return dev._id;
                    }).forEach(function(dev) {
                        var data = (d.find(function(stat) {
                            return stat.device === dev && startingTimes.day === stat.createdAt;
                        }) || { hourly: (function() {
                            var hours = [];
                            for (var i = 0; i < 24; i++) {
                                hours.push(0);
                            }
                            return hours;
                        })() }).hourly;

                        data = Object.keys(data).map(function(m) {
                            return data[m];
                        }) || [];

                        $scope.graphData.push(data);
                    });

                    var totalDay = [];
                    for (var tdi = 0; tdi < $scope.graphData.length; tdi++) {
                        for (var tdj = 0; tdj < $scope.graphLabels.length; tdj++) {
                            if (!totalDay[tdj]) totalDay[tdj] = 0;

                            totalDay[tdj] += $scope.graphData[tdi][tdj];
                        }
                    }

                    $scope.graphData.unshift(totalDay);
                } else if (resolution === 'week') {
                    $scope.graphLabels = [
                        'Sun', 'Mon', 'Tues', 'Wed', 'Thurs', 'Fri', 'Sat'
                    ];

                    devices.map(function(dev) {
                        return dev._id;
                    }).forEach(function(dev) {
                        var data = [];

                        for (var i = 0; i < $scope.graphLabels.length; i++) {
                            var day = moment(startingTimes.week).add(i, 'days').toISOString();

                            var total = (d.find(function(stat) {
                                return stat.device === dev && day === stat.createdAt;
                            }) || { daily: 0 }).daily;

                            data.push(total);
                        }

                        $scope.graphData.push(data);
                    });

                    var totalWeek = [];
                    for (var twi = 0; twi < $scope.graphData.length; twi++) {
                        for (var twj = 0; twj < $scope.graphLabels.length; twj++) {
                            if (!totalWeek[twj]) totalWeek[twj] = 0;

                            totalWeek[twj] += $scope.graphData[twi][twj];
                        }
                    }

                    $scope.graphData.unshift(totalWeek);
                } else if (resolution === 'month') {
                    $scope.graphLabels = [];

                    for (var i = 0; i < moment().daysInMonth(); i++) {
                        $scope.graphLabels.push((i + 1).toString());
                    }

                    ['Total'].concat(devices.map(function(dev) {
                        return dev._id;
                    })).forEach(function(dev) {
                        var data = [];

                        for (var j = 0; j < moment().daysInMonth(); j++) {
                            var total = 0;

                            d.forEach(function(stat) {
                                if (moment(startingTimes.month).add(j, 'days').toISOString() !== stat.createdAt) return;

                                if (dev !== 'Total' && stat.device !== dev) {
                                    return;
                                }

                                total += stat.daily;
                            });

                            data.push(total);
                        }

                        $scope.graphData.push(data);
                    });
                } else if (resolution === 'year') {
                    $scope.graphLabels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'];

                    ['Total'].concat(devices.map(function(dev) {
                        return dev._id;
                    })).forEach(function(dev) {
                        var data = [];

                        for (var j = 0; j < 12; j++) {
                            var total = 0;

                            d.forEach(function(stat) {
                                if (
                                    moment(startingTimes.year).add(j, 'months').toDate() > new Date(stat.createdAt) ||
                                    moment(startingTimes.year).add(j + 1, 'months').toDate() < new Date(stat.createdAt)
                                ) return;

                                if (dev !== 'Total' && stat.device !== dev) {
                                    return;
                                }

                                total += stat.daily;
                            });

                            data.push(total);
                        }

                        $scope.graphData.push(data);
                    });
                }
            });
        });
    };

    $scope.graphType = 'week';

    $scope.$watch('graphType', function(newType, oldType) {
        if (newType === oldType) return;

        updateGraph(newType);
    });

    updateGraph('week');

    var updateGoals = function() {
        API.get('energy/goals').success(function(goals) {
            goals.forEach(function(goal) {
                var perc = (goal.usage / goal.limit) * 100;

                goal.percentage = Math.round(perc);

                if (perc >= 100) {
                    goal.progressColor = 'danger';
                } else if (perc >= 80) {
                    goal.progressColor = 'warning';
                } else {
                    goal.progressColor = 'success';
                }
            });

            $scope.goals = goals;
        });
    };

    updateGoals();

    $scope.addGoal = function() {
        var devices = $scope.devices;

        $modal.open({
            templateUrl: 'partials/energy.goals.add-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.form = {};
                $scope.devices = devices;

                $scope.add = function() {
                    API.post('energy/goals', {
                        data: $scope.form
                    }).success(function() {
                        $scope.close();
                        updateGoals();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.editGoal = function(goal) {
        $modal.open({
            templateUrl: 'partials/energy.goals.edit-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.goal = goal;

                $scope.update = function() {
                    API.put('energy/goals/' + encodeURIComponent(goal._id), {
                        data: $scope.goal
                    }).success(function() {
                        $scope.close();
                        updateGoals();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.remove = function() {
                    API.delete('energy/goals/' + encodeURIComponent(goal._id)).success(function() {
                        $scope.close();
                        updateGoals();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };
});

app.filter('capitalize', function() {
    return function(input) {
        if (!input) return;

        return input.substring(0, 1).toUpperCase() + input.substring(1);
    };
});

app.filter('device', function() {
    return function(input, devices) {
        if (!input) return {};

        return devices.find(function(d) {
            return input === d._id;
        }).name;
    };
});
