var app = angular.module('schedules', []);

app.controller('schedules', function($scope, $state, $stateParams, $modal, API, Alert) {
    var updateSchedules = function() {
        API.get('tasks').success(function(d) {
            $scope.tasks = d;

            API.get('schedules').success(function(e) {
                $scope.scheduledTasks = e;
            });
        });
    };

    updateSchedules();

    $scope.add = function() {
        var tasks = $scope.tasks;

        $modal.open({
            templateUrl: 'partials/schedules.add-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.form = {};
                $scope.tasks = tasks;

                $scope.add = function() {
                    API.post('schedules', {
                        data: $scope.form
                    }).success(function() {
                        $scope.close();
                        updateSchedules();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.edit = function(schedule) {
        var tasks = $scope.tasks;

        $modal.open({
            templateUrl: 'partials/schedules.edit-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.form = angular.copy(schedule);
                $scope.tasks = tasks;

                $scope.update = function() {
                    API.put('schedules/' + encodeURIComponent(schedule._id), {
                        data: $scope.form
                    }).success(function() {
                        $scope.close();
                        updateSchedules();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.remove = function() {
                    API.delete('schedules/' + encodeURIComponent(schedule._id)).success(function() {
                        $scope.close();
                        updateSchedules();
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };
});
