var app = angular.module('tasks', []);

app.controller('tasks', function($scope, $state, $stateParams, $modal, API, Alert) {
    var updateTasks = function() {
        API.get('tasks').success(function(d) {
            $scope.tasks = d;
        });
    };

    updateTasks();

    $scope.add = function() {
        $modal.open({
            templateUrl: 'partials/tasks.add-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.form = {};

                $scope.add = function() {
                    API.post('tasks', {
                        data: $scope.form
                    }).success(function(d) {
                        $scope.close();
                        $state.transitionTo('tasks_edit', { id: d._id });
                    }).error(function(data) {
                        Alert.new('error', data.message);
                    });
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.run = function(task) {
        API.post('tasks/' + encodeURIComponent(task._id) + '/run').success(function() {
            Alert.new('success', 'Task successfully executed');
        }).error(function(data) {
            Alert.new('error', data.message);
        });
    };
});

app.controller('tasks_edit', function($scope, $state, $stateParams, $modal, API, Alert) {
    API.get('devices').success(function(devices) {
        $scope.devices = {};

        devices.forEach(function(d) {
            $scope.devices[d._id] = d;
        });
    });

    var updateTask = function() {
        API.get('tasks/' + encodeURIComponent($stateParams.id)).success(function(d) {
            $scope.task = d;
        });
    };

    updateTask();

    $scope.addDevice = function() {
        var actions = $scope.task.actions;
        var devices = $scope.devices;

        $modal.open({
            templateUrl: 'partials/tasks_edit.add_device-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.devices = devices;

                $scope.add = function() {
                    actions.push({
                        device: $scope.device._id,
                        settings: angular.copy($scope.device.settings)
                    });
                    $scope.close();
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.toggleDeviceState = function(device, settingKey) {
        settingKey = settingKey || 'enabled';

        device.settings[settingKey] = device.settings[settingKey] ? false : true;
    };

    $scope.removeDevice = function(action) {
        $scope.task.actions.splice($scope.task.actions.indexOf(action), 1);
    };

    $scope.modifyDeviceControls = function(action) {
        $modal.open({
            templateUrl: 'partials/devices.controls-modal.html',
            controller: function($scope, $modalInstance) { //eslint-disable-line
                $scope.device = action;

                $scope.update = function() {
                    $scope.close();
                };

                $scope.close = function() {
                    $modalInstance.dismiss('cancel');
                };
            }
        });
    };

    $scope.remove = function() {
        API.delete('tasks/' + encodeURIComponent($stateParams.id)).success(function() {
            Alert.new('success', 'Task deleted');
            $state.transitionTo('tasks');
        }).error(function(data) {
            Alert.new('error', data.message);
        });
    };

    $scope.update = function() {
        API.put('tasks/' + encodeURIComponent($stateParams.id), {
            data: $scope.task
        }).success(function() {
            Alert.new('success', 'Task updated');
            updateTask();
        }).error(function(data) {
            Alert.new('error', data.message);
        });
    };
});

app.filter('capitalize', function() {
    return function(input) {
        if (!input) return;

        return input.substring(0, 1).toUpperCase() + input.substring(1);
    };
});
