var app = angular.module('user', []);

app.controller('user', function($scope, $state, $stateParams, $modal, User, API, Alert) {
    var updateUser = function() {
        API.get('user').success(function(d) {
            delete d.password;

            $scope.user = d;
        });
    };

    updateUser();

    $scope.editUser = function() {
        API.put('user', {
            data: $scope.user
        }).success(function(d) {
            updateUser();
            User.setUserData(d);
            Alert.new('success', 'Profile saved');
            $scope.editing = false;
        }).error(function(data) {
            Alert.new('error', data.message);
        });
    };

    $scope.deleteUser = function() {
        API.delete('user', {
            data: $scope.user
        }).success(function() {
            User.logout();
            Alert.new('success', 'Account deleted');
        }).error(function(data) {
            Alert.new('error', data.message);
        });
    };
});
