#include <math.h>
#include "Preprocessor.h"
#include "MainLED.h"

#include <Wire.h>
#include "globals.h"    
// This slave's address
#define ADDRESS 0x04
// Max bytes based on master's code
#define MAX_WRITE 24
#define MAX_READ 32
// Buffers for data transfers
char data_in[ MAX_READ ];
char data_out[ MAX_WRITE ];
int sensorValue;
double voltage [12];


// Reads data in buffer (mainly for testing purposes)
void readData( char count ) {
  int i;
  for( i = 0; i < count; i++ )
    steps[i] = data_in [i];
}
void getVolts() {
  double samples[12] = {0};
  for( int i = 0; i < 6; i++ ) {
    sensorValue = analogRead(A0);
    samples[0] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A1);
    samples[1] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A2);
    samples[2] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A3);
    samples[3] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A4);
    samples[4] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A5);
    samples[5] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A6);
    samples[6] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A7);
    samples[7] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A8);
    samples[8] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A9);
    samples[9] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A10);
    samples[10] += sensorValue * (5.0 / 1023.0);
    sensorValue = analogRead(A11);
    samples[11] += sensorValue * (5.0 / 1023.0);
    delay(500);
  }

  for( int i = 0; i < 12; i++ )
    voltage[i] = samples[i] / 6.0;
  
  Serial.println("Done Measuring");
}
// Gets pressure values
void getPressures() {
  getVolts();
  int i;
  int j = 0;
  for( i = 0; i < MAX_WRITE; i++) {
    int test2 = (int)voltage[j];
    int test3 = (int)((voltage[j++] - test2)*100);
    data_out[i] = test2;
    i = i+1;
    data_out[i] = test3;
  }
}
// Clears out buffers
void reset() {
  int i;
  for( i = 0; i < MAX_WRITE; i++ ) {
    data_out[i] = 0;
    data_in[i] = 0;
  }
  for( i = MAX_WRITE; i < MAX_READ; i++ ) {
    data_in[i] = 0;
  } 
}

// When the master sends this slave data
// Could use size variable to make this more dynamic-esque
void receiveData( int size ) {
  // first byte is the command. My code ignores this
    char count = -1;
    int data;
    while( Wire.available() ) {
      data = Wire.read();
      if( count == -1) {
        count++;
        continue;
      }
      data_in[ count++ ] = data;
      
      }
      
  if(component){
    int i = 0;
    if(data_in[0] == 0){
      Serial.print("Diode");
      diode = true;
      for(i = 0; i <=10; i++){
	      if(i == 1 || i == 5 || i == 7){
	        steps[i] = 90;
	      }
	      else{
	        steps[i] = 0;
	      }
      }
      i1 = data_in[1];
      Serial.print(i1);
    }
    else if(data_in[0] == 1){
      mosfet = true;
      for(i = 0; i <=10; i++){
	      if(i == 1 || i == 5 || i == 9){
          if(i == 9){
            steps[i] = 110;
          }
          else{
	          steps[i] = 90;
          }
	      }
	      else{
	        steps[i] = 0;
	      }
      }
      i1 = data_in[1];
    }
    else if(data_in[0] == 2){
      bjt = true; 
      for(i = 0; i <=10; i++){
	      if(i == 6){
	        steps[i] = 90;
	      }
	      else{
	        steps[i] = 0;
	      }
      }
      // 180417 zf: implement Ic, ratio for Ib speed
      // i2 = data_in[1];
      // i1 = data_in[2];
      i1 = data_in[1];
      ratio = data_in[2];
      
      Serial.print(i1);
      Serial.print(ratio);
    }
    component = false;
    need_to_component_turn = true;
  }
  else if(new_entry){
    readData( count );
    new_entry = false;
    need_to_turn = true;
    Serial.println("Data in: ");
    for(count =0; count<11; count++){
      Serial.print(steps[count]);
      Serial.print(" ");
    }
    Serial.println();
  }
  // ZF
  else{
    if (data_in[0] == 99) {
    need_to_reset = true;
    Serial.println( "Resetting\n" );
    }
  }
}


// Sends data to master when it is prompted by it
void sendData() {
  if(need_to_send == true){
    Wire.write( data_out, MAX_WRITE );
    Serial.println("Real Data Sent");

    // ZF: Don't reset until told too by the Pi
    //need_to_reset = true;
    
  }
  // reset();
}

