#include <stdlib.h>
#include "MainLED.h"
#include "Preprocessor.h"

// MainLED is a class that controls the LEDs for each device
MainLED _main;

// Keeps track of which device is currently active
uint8_t comp;

// Instantiates a new object for each component
void InitLEDs()
{
  _main.birth();  
}

// Stores which component to illuminate
void SetComponent( uint8_t _component )
{
  comp = _component;
  
  if( comp > 2  || comp < 0 )
    comp = _DIODE;
   
  
  _main.select( comp );  
}

// Sets delay function for diode or mosfet. i1 is the current (Id or Ids)
void SetCurrent( uint8_t i1 )
{
  if( comp == _DIODE )
    _main.init( i1 );
  else if( comp == _MOSFET )
    _main.init( i1 );
  else if( comp == _BJT )
    shutdown( -1 );
}

// Sets delay function for any component. i1 are the current (Id, Ids, or Ice and Ibe resp)
void SetCurrent( uint8_t i1, uint8_t i2 )
{
  if( comp == _DIODE )
    _main.init( i1 );
  else if( comp == _MOSFET )
    _main.init( i1 );
  else if( comp == _BJT )
  {
    if( i1 > 0 )
      _main.init( i1 + 50, i2 / 2 );
    else
      _main.init( i1, 99 );
  }
}

// Sends pulse for the selected component's next illumination
void Pulse() 
{
  _main.run(); 
}

// Sets all LEDs to black
void ResetLEDs()
{
  Serial.println( "Reseting\n" );
  _main.reset();  
}

// Terminates program by catching it into an infinite loop (Error handling)
void shutdown( int ex ) 
{  
  Serial.print( "Shutdown():\n" );
  
  if( ex == -1 )
    Serial.print( "Not enough current for BJT run\n" );
  
  while(true) {} 
}
