#include "Arduino.h"
#include "BJT.h"
#include "Diode.h"
#include "Preprocessor.h"

BJT::BJT()
{
  // 180417 zf: keeps track to know when to pulse Ib
  counter = 0;

  uint16_t n1 = SIZE_BJT_BE;
  uint8_t p1 = PIN_BJT_BE;
  
  be = new Diode( n1, p1 );

  uint16_t n2 = SIZE_BJT_CE;
  uint8_t p2 = PIN_BJT_CE;

  ce = new Diode( n2, p2 );
  Serial.print("MosfetGate: ");
  Serial.println(ce->leds->mosfetGate);
}

void BJT::pulse( uint32_t color1, uint32_t color2, uint32_t color3 )
{ 
  // 180417 zf: implement bjt current
  ce->pulse( color2, color3 );
  if( ratio != 99 )
  {
    if( counter < ratio )
    { 
      counter++;
    }
    else
    {
      counter = 0;
      be->pulse( color1 );
    } 
  }
  else
    be->pulse( color1 );
  // be->pulse( color1 );
  // ce->pulse( color2, color3 );
  // set color so ie B = blue, C = yellow -> E = green
}

void BJT::init( float _i1, float _i2 )
{
  // 180417 zf: second varibale has ratio, first has ic
  // be->init( _i1 );
  // ce->init( _i2 );
  ce->init( _i1 );
  ratio = _i2;
  
  if( ratio != 99 )
    be->setBJT();
  else
    be->init( _i1 );
}

BJT::~BJT()
{
  delete be;
  delete ce;
}

void BJT::reset( void )
{
  ce->reset();
  be->reset();
}
