
#include "LEDs.h"
#include "Diode.h"
#include "Preprocessor.h"

#include "Arduino.h"

void Diode::setBJT()
{
  leds->setBJT();
}

void Diode::pulse( uint32_t color )
{
  leds->lightUp( color );
}

void Diode::pulse( uint32_t color1, uint32_t color2 )
{
  leds->lightUp( color1, color2 );
}

void Diode::init( float _i )
{
  leds->setIntensity( _i );
}

void Diode::reset( void )
{
  leds->reset();
}

// Only call if BJT!!
Diode::Diode( uint16_t n, uint8_t p )
{
  leds = new LEDs( n, p );
  leds->begin();
  leds->show();

}

Diode::Diode()
{
  leds = new LEDs( SIZE_DIODE, PIN_DIODE );
  leds->begin();
  leds->show();

}

Diode::~Diode()
{
  delete leds;
}

