
#include <math.h>

#include "Adafruit_NeoPixel.h"
#include "LEDs.h"
#include "Preprocessor.h"

#include "Arduino.h"

LEDs::LEDs( uint16_t n, uint8_t p ) : Adafruit_NeoPixel( n, p, NEOPIXEL_TYPE )
{
  //neoPixelType t = NEOPIXEL_TYPE;
  counter = 0;

  black = Color( 0, 0 , 0 );

  Serial.print( "LEDs::LEDs(): Count: " );
  Serial.print( n );
  Serial.println( p );

  bjtJoint = 20 + 10 - 3;
  mosfetGate = false;

  setBrightness( 255 );

  bjtBase = false;
}

LEDs::~LEDs()
{
  reset();
  Serial.println( "Reset\n" );
}

void LEDs::setBJT()
{
  wait = 0;
  newRun = true;
  bjtBase = true;
  Serial.println( "setBJT()" );
  mosfetGate = false;
}

void LEDs::setIntensity( float current )
{ 
  newRun = true;
  mosfetGate = false;
  bjtBase = false;
  if( current != 0 )
  {
    // Change to make brighter or not depending on how scale line works
    float multiplierI = 10.0;
    float incI = 0.0;
    float scaleI = ( current - MINI ) / ( MAXI - MINI ); 
    mosfetGate = false;
    wait = int( ceil( ( 1 / scaleI ) * multiplierI + incI ) ); // 1 / speed
    fprintf( stdout, "Wait: %u\n", wait );
  }
  // fix this
  else
  {
    Serial.print("I: ");
    Serial.println(current);
    wait = 255;    
    mosfetGate = true;
    setBrightness( 255  );
  }  
  /* 
  float multiplierV = 255.0;
  float incV = 0.0;
  float scaleV = ( MAXV - MINV ) / ( voltage - MINV );
 
  brightness = int( ceil( scaleV * multiplierV + incV ) );
  setBrightness( brightness );
  fprintf( stdout, "Brightness: %u\n", brightness );
  */
}

// Illumination patterns
void LEDs::reset( void )
{
  for( int i = 0; i < numPixels(); i++ )
    setPixelColor( i, black );

  show();
}

void LEDs::lightUp( uint32_t color )
{
  if( newRun )
  {
    counter = 0;
    newRun = false;
  } 

  if( !mosfetGate )
  {
    if( endOfStrand() )
      counter = 0;

    reset();
    setPixelColor( counter, color );
    setPixelColor( ( counter + 1 ) % numPixels(), color );
    setPixelColor( ( counter + 2 ) % numPixels(), color );
 
    show();
  
    delay( wait );
  
    counter++; 
  }
  else
  {  
    for( int i = 0; i < numPixels(); i++ )
      setPixelColor( i, color );
    delay( wait );
    show();
  }
}

void LEDs::lightUp( uint32_t color1, uint32_t color2  )
{
  if( newRun )
  {
    counter = 0;
    newRun = false;
  } 
  if(!mosfetGate){
  if( endOfStrand() )
    counter = 0;

  uint8_t current, future1, future2;
  
  reset();  

  current = ( counter );
  if( current <= bjtJoint )
    setPixelColor( current, color1 );
  else
    setPixelColor( current, color2 ); 
  future1 = ( counter + 1 ) % SIZE_BJT_CE;
  if( future1 <= bjtJoint )
    setPixelColor( future1, color1 );
  else
    setPixelColor( future1, color2 );
  future2 = ( counter + 2 ) % SIZE_BJT_CE;
  if( future2 <= bjtJoint )
    setPixelColor( future2, color1 );
  else
    setPixelColor( future2, color2 );
  
  show();
  
  delay( wait );
  
  counter++;  
}
else{
  for( int i = 0; i < numPixels(); i++ )
    if( i <= bjtJoint )
    {
      setPixelColor( i, color1 );
    }
    else
       setPixelColor( i, color2 );
    delay( wait );
    show();
}
}

uint32_t LEDs::wheel( uint8_t wheelPos )
{
  Serial.println( wheelPos );

  wheelPos = 255 - wheelPos;
  if( wheelPos < 85 )
    return Color( 255 - wheelPos * 3, 0, wheelPos * 3 );

  if( wheelPos < 170 )
  {
    wheelPos -= 85;
    return Color( 0, wheelPos * 3, 255 - wheelPos * 3 );
  }

  wheelPos -= 170;
  return Color( wheelPos * 3, 255 - wheelPos * 3, 0 ); 
}

bool LEDs::endOfStrand( void )
{
  return ( counter == numPixels() );
}
