
#include "LEDs.h"
#include "MOSFET.h"
#include "Preprocessor.h"

#include "Arduino.h"

void MOSFET::pulse( uint32_t color1, uint32_t color2 )
{
  ds->lightUp( color2 );
  gs->lightUp( color1 );
}

void MOSFET::init( float _i1 )
{
  ds->setIntensity( _i1 );
  gs->setIntensity( 0.0 );
}

MOSFET::MOSFET()
{
  ds = new LEDs( SIZE_MOSFET_DS, PIN_MOSFET_DS );
  gs = new LEDs( SIZE_MOSFET_GS, PIN_MOSFET_GS );
 
  ds->begin();
  gs->begin();
  ds->show();
  gs->show();

}

MOSFET::~MOSFET()
{
  delete ds;
  delete gs;
}

void MOSFET::reset( void )
{
  ds->reset();
  gs->reset();
}
