#include "Arduino.h"
#include "MainLED.h"
#include "Diode.h"
#include "MOSFET.h"
#include "BJT.h"
#include "Preprocessor.h"
#include "LEDs.h"

MainLED::MainLED( void )
{
  bjt = NULL;
  mosfet = NULL;
  diode = NULL;

  component = -1; 

  colorCounter = 0;

  blue = LEDs::Color( 0, 0, 255 );
  yellow = LEDs::Color( 255, 255, 0 );
  green = LEDs::Color( 0, 128, 0 );

}

void MainLED::birth()
{
  bjt = new BJT();
  Serial.println("I called BJT");
  mosfet = new MOSFET();
  diode = new Diode();
}

void MainLED::reset()
{
  bjt->reset();

  mosfet->reset();

  diode->reset();
}

void MainLED::select( uint8_t _component )
{
  component = _component;
  Serial.print( component );
  Serial.print( " selected\n" );   
} 

void MainLED::init( float i1 )
{
  switch( component )
  {
    case _BJT:
      Serial.print( "MainLED::init(): Not enough parameters\n" );
    case _MOSFET:
      mosfet->init( i1 );
    break;
    case _DIODE:
      if( diode )
        diode->init( i1 );
    break;
    default:
      Serial.print( "Error: MainLED::init():\n" );
  }
  Serial.print( "Current: " ); 
  Serial.println( i1 ); 
}

void MainLED::init( float i1, float i2 )
{
  switch( component )
  {
    case _BJT:
      Serial.println("Updating BJT From LEDs");
      bjt->init( i1, i2 ); // be( i1, v1 ), ce( i2, v2 )
      Serial.println(bjt->ce->leds->mosfetGate);
    break;;
    case _MOSFET:
      mosfet->init( i1 );
    break;;
    case _DIODE:
      if( diode )
        diode->init( i1 );
    break;;
    default:
      Serial.print( "Error: MainLED::init():\n" );
  }
  Serial.print( "Current: " ); 
  Serial.print( i1 ); 
  Serial.print( ", " );
  Serial.println( i2 );
}

void MainLED::run()
{
  switch( component )
  {
    case _BJT:
      bjt->pulse( yellow, blue, green );
    break;
    case _MOSFET:
      mosfet->pulse( yellow, blue );
    break;
    case _DIODE:
      if( diode ) 
        diode->pulse( blue );
    break;
    default:
      Serial.print( "Error: MainLED::run():\n" );
  }
//  Serial.println( colorCounter );
  colorCounter++;
} 

MainLED::~MainLED()
{
  if( bjt );
    delete bjt;
  if( mosfet )
    delete mosfet;
  if( diode )
    delete diode;
}

void MainLED::EasterEgg()
{
}
