#ifndef MAINLED_H
#define MAINLED_H

#include "Arduino.h"
#include "Diode.h"
#include "MOSFET.h"
#include "BJT.h"


class MainLED
{
  private:
    uint8_t component; 
    BJT * bjt;
    MOSFET * mosfet;
    Diode * diode;

    uint8_t colorCounter;

    uint32_t blue;
    uint32_t yellow;
    uint32_t green;

  public:
    MainLED();
    ~MainLED();

    void birth();

    void select( uint8_t _component );
    void init( float i1 );
    void init( float i1, float i2 );
    void stop();
    void run();
    void reset();

    void EasterEgg();
};

#endif
