# This file was automatically generated by SDx

# Add procedures for decoding keys...
#  Common with --xp vivado_prop:* - Used to get all synthesis runs
proc get_all_synth_runs {} {
  return [get_runs -filter {IS_SYNTHESIS == 1}]
}

#  Common with --xp vivado_prop:* - Used to get all OOC synthesis runs
proc get_all_ooc_synth_runs {} {
  return [get_runs -filter {IS_SYNTHESIS == 1 && NAME != "synth_1"}]
}

#  Common with --xp vivado_prop:* - Used to get all HLS OOC synthesis runs
proc get_all_kernel_synth_runs {} {
  set krnl_runs {}
  set cand_runs [get_runs -filter {IS_SYNTHESIS == 1}]
  foreach cand_run $cand_runs {
    set cand_fs [get_property srcset $cand_run]
    if {[get_property fileset_type $cand_fs] != "BlockSrcs"} {continue}
    set cand_files [get_files -of_objects $cand_fs -norecurse]
    if {[llength $cand_files] != 1} {continue}
    set cand_file [lindex $cand_files 0]
    if {[get_property FILE_TYPE $cand_file] != "IP"} {continue}
    set cand_ip [get_ips -all [get_property IP_TOP $cand_file]]
    if {$cand_ip == {}} {continue}
    set prop_val [get_property SDX_KERNEL $cand_ip]
    if {[get_property SDX_KERNEL $cand_ip] && [get_property SDX_KERNEL_TYPE $cand_ip] eq "hls"} {lappend krnl_runs $cand_run}
  }
  return $krnl_runs
}

# Add all of the report configuration data
set new_configs {}

# Evaluate all report configurations
foreach new_config $new_configs {
  set type     [dict get $new_config type]
  set name     [dict get $new_config name]
  set steps    [dict get $new_config steps]
  set runs     [dict get $new_config runs]
  set options  [dict get $new_config options]
  set expanded_runs {}
  foreach run $runs {
    # The {*} won't add if lists are empty and flattens the lists
    if {$run == "__ALL_SYNTH__"} {
      lappend expanded_runs {*}[get_all_synth_runs]
    } elseif {$run == "__OOC__"} {
      lappend expanded_runs {*}[get_all_ooc_synth_runs]
    } elseif {$run == "__KERNEL__"} {
      lappend expanded_runs {*}[get_all_kernel_synth_runs]
    } else {
      lappend expanded_runs {*}$run
    }
  }
  if {[llength $expanded_runs] == 0} {
    continue
  }
  # If we did multiple expansions we don't want duplicates...
  set unique_runs [lsort -unique $expanded_runs]
  if {[llength $options] == 0} {
    set options ""
  } else {
    set options "-options {$options}"
  }
# check for report name collision
  set current_config [get_report_configs $name]
  if {[llength $current_config] > 0} {
    puts "WARNING: Report config with name $name already exists. Replacing the existing report"
    delete_report_configs [get_report_configs $name]
  }
  
  set eval_report_command "create_report_config -report_name $name -report_type $type -steps {$steps} -runs {$unique_runs} $options"
  add_to_steps_log $steps_log "internal step: $eval_report_command"
  eval $eval_report_command
}

