/*

  HelloWorld.ino

  Universal 8bit Graphics Library (https://github.com/olikraus/u8g2/)

  Copyright (c) 2016, olikraus@gmail.com
  All rights reserved.

  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this list 
    of conditions and the following disclaimer.
    
  * Redistributions in binary form must reproduce the above copyright notice, this 
    list of conditions and the following disclaimer in the documentation and/or other 
    materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  

*/

#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

/*
  U8g2lib Example Overview:
    Frame Buffer Examples: clearBuffer/sendBuffer. Fast, but may not work with all Arduino boards because of RAM consumption
    Page Buffer Examples: firstPage/nextPage. Less RAM usage, should work with all Arduino boards.
    U8x8 Text Only Example: No RAM usage, direct communication with display controller. No graphics, 8x8 Text only.
    
*/

//U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_MIRROR, /* reset=*/ U8X8_PIN_NONE);
// End of constructor list


void setup(void) {
  u8g2.begin();
  u8g2.setPowerSave(0);
}

void loop(void) {
  for(int i = 0; i < 20; i++)
  {    
    u8g2.clearBuffer();					// clear the internal memory
    u8g2.setFont(u8g2_font_victoriamedium8_8r);
    u8g2.setCursor(33,20);
    u8g2.print("mph");
    
    u8g2.setCursor(0,40);
    u8g2.print("mpg");
    u8g2.setCursor(0,50);
    u8g2.print("avg 30");
    u8g2.setCursor(0,60);
    u8g2.print("cur 40");

    u8g2.setFont(u8g2_font_open_iconic_arrow_2x_t);
    u8g2.setCursor(90,15);
    u8g2.write(65);

    u8g2.setFont(u8g2_font_victoriamedium8_8r);
    u8g2.setCursor(70,30);
    u8g2.print("2.1 mi");
    u8g2.setCursor(70,40);
    u8g2.print("Gemini");
    u8g2.setCursor(70,50);
    u8g2.print("Blvd");
  
    
    u8g2.setFont(u8g2_font_courB18_tf);	// choose a suitable font
    if(i < 10)
    {
      u8g2.setCursor(15,20);
      u8g2.print(i);
    }
    
    else if (i > 9)
    {
      u8g2.setCursor(0,20);
      u8g2.print(i);
    }
    
   
   // u8g2.drawStr(0,10,"Hello World!");	// write something to the internal memory
   // u8g2.drawStr(0,40, str);
    //u8g2.setCursor(0,10);
   // u8g2.print("Hello world!");
    //u8g2.setCursor(0,0);
    //u8g2.print("Hello");
    u8g2.sendBuffer();					// transfer internal memory to the display
    delay(1000);  
  }
}
