#include <SoftwareSerial.h>
// Setting up Fona Library
#include "Adafruit_FONA.h"
//SoftwareSerial sim808(10,11);
#define FONA_RX 11
#define FONA_TX 10
#define FONA_RST 4
SoftwareSerial fonaSS = SoftwareSerial(FONA_TX, FONA_RX);
SoftwareSerial *fonaSerial = &fonaSS;
Adafruit_FONA fona = Adafruit_FONA(FONA_RST);

#include <OBD2UART.h>
#define mySerial Serial1
COBD obd;

#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

/*
  U8g2lib Example Overview:
    Frame Buffer Examples: clearBuffer/sendBuffer. Fast, but may not work with all Arduino boards because of RAM consumption
    Page Buffer Examples: firstPage/nextPage. Less RAM usage, should work with all Arduino boards.
    U8x8 Text Only Example: No RAM usage, direct communication with display controller. No graphics, 8x8 Text only.
    
*/

//U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_MIRROR, /* reset=*/ U8X8_PIN_NONE);
// End of constructor list

const int xInput = A0;
const int yInput = A1;
const int zInput = A2;
const int buttonPin = 2;

//// Raw Ranges:
//// initialize to mid-range and allow calibration to
//// find the minimum and maximum for each axis
//int xRawMin = 512;
//int xRawMax = 512;
//
//int yRawMin = 512;
//int yRawMax = 512;
//
//int zRawMin = 512;
//int zRawMax = 512;

int xRawMin = 409;
int xRawMax = 613;

int yRawMin = 403;
int yRawMax = 606;

int zRawMin = 425;
int zRawMax = 629;

// Take multiple samples to reduce noise
const int sampleSize = 10;

int time = millis();
int counter = 0;
float latitude, longitude;
char clat[10];
char clong[10];
boolean gps_success;

// OBD variable init
int value, maxSpeed = 0, curSpeed, speedMPH, maf, currentMPG;


const int testPin = 2;
//char phone_no[] = "7724537459";
//String data[5];
//#define DEBUG true
//String state, timegps, latitude = "28.6013", longitude = "-81.1984";
boolean calibrated = false;
bool sentMessage = false, crashDetected = false;
void setup() {

  u8g2.begin();
  u8g2.setPowerSave(0);
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_victoriamedium8_8r);
  u8g2.setCursor(30,30);
  u8g2.print("Powering on...");
  u8g2.sendBuffer();
  delay(500);


  
  mySerial.begin(115200);
  obd.begin();
  do
  {
    mySerial.print("Init...");
  }
  while(!obd.init());
    
  //while (! Serial);

  Serial.begin(115200);
  Serial.println(F("Adafruit FONA 808 & 3G GPS demo"));
  Serial.println(F("Initializing FONA... (May take a few seconds)"));
  fonaSerial->begin(4800);
  if (! fona.begin(*fonaSerial)) {
    Serial.println(F("Couldn't find FONA"));
    while(1);
  }
  Serial.println(F("FONA is OK"));
  // Try to enable GPRS
  

  Serial.println(F("Enabling GPS..."));
  fona.enableGPS(true);
  Serial.println("Throgh gps");
  // put your setup code here, to run once:
  analogReference(EXTERNAL);
  //sim808.begin(9600);
  //Serial.begin(9600);

//  sim808.println("AT+CSMP=17,167,2,0");
//  delay(100);
//  sim808.println("AT+CMGF=1");
//  delay(400);
  
  
  
  //gps_success = fona.getGPS(&latitude, &longitude);

}

void loop() {
  Serial.println("In Loop");
  float latitude, longitude;
  char clat[10];
  char clong[10];
  char message[140];
 
  

//  while(!gps_success && !calibrated)
//  {
//    u8g2.clearBuffer();
//    u8g2.setFont(u8g2_font_courB18_tf);
//    u8g2.setCursor(15,20);
//    u8g2.print("Calibrating GPS");
//  }
  if (calibrated) // was if(gps_success) 
  {
    
    
//    if(counter == 1000)
//    {
//      counter = 0;
//    }
    
    
    if(time % 50 == 0)
    {
      u8g2.clearBuffer();          // clear the internal memory
      u8g2.setFont(u8g2_font_victoriamedium8_8r);
      u8g2.setCursor(33,20);
      u8g2.print("mph");
    
      u8g2.setCursor(0,40);
      u8g2.print("mpg");
      u8g2.setCursor(0,50);
      u8g2.print("avg 30");
      u8g2.setCursor(0,60);
      u8g2.print("cur 40");
  
      u8g2.setFont(u8g2_font_open_iconic_arrow_2x_t);
      u8g2.setCursor(90,15);
      u8g2.write(65);
  
      u8g2.setFont(u8g2_font_victoriamedium8_8r);
      u8g2.setCursor(70,30);
      u8g2.print("2.1 mi");
      u8g2.setCursor(70,40);
      u8g2.print("Gemini");
      u8g2.setCursor(70,50);
      u8g2.print("Blvd");

      if(obd.readPID(PID_SPEED, curSpeed))
      {
        speedMPH = curSpeed * 0.621371; // converting kph to mph
        
        u8g2.setFont(u8g2_font_courB18_tf); // choose a suitable font
        if(speedMPH < 10)
        {
          u8g2.setCursor(15,20);
          u8g2.print(speedMPH);
        }
      
        else if (speedMPH > 9)
        {
          u8g2.setCursor(0,20);
          u8g2.print(speedMPH);
        }
        
      
      }
      
      u8g2.sendBuffer();
    }
     
     // u8g2.drawStr(0,10,"Hello World!");  // write something to the internal memory
     // u8g2.drawStr(0,40, str);
      //u8g2.setCursor(0,10);
     // u8g2.print("Hello world!");
      //u8g2.setCursor(0,0);
      //u8g2.print("Hello");
                // transfer internal memory to the display
  
    
    // put your main code here, to run repeatedly:
    int xRaw = ReadAxis(xInput);
    int yRaw = ReadAxis(yInput);
    int zRaw = ReadAxis(zInput);
    
    if(time % 200 == 0)
    {
//      Serial.print("Raw Ranges: X: ");
//      Serial.print(xRawMin);
//      Serial.print("-");
//      Serial.print(xRawMax);
//      
//      Serial.print(", Y: ");
//      Serial.print(yRawMin);
//      Serial.print("-");
//      Serial.print(yRawMax);
//      
//      Serial.print(", Z: ");
//      Serial.print(zRawMin);
//      Serial.print("-");
//      Serial.print(zRawMax);
//      Serial.println();
//      Serial.print(xRaw);
//      Serial.print(", ");
//      Serial.print(yRaw);
//      Serial.print(", ");
//      Serial.print(zRaw);
      
      // Convert raw values to 'milli-Gs"
      long xScaled = map(xRaw, xRawMin, xRawMax, -1000, 1000);
      long yScaled = map(yRaw, yRawMin, yRawMax, -1000, 1000);
      long zScaled = map(zRaw, zRawMin, zRawMax, -1000, 1000);
    
      // re-scale to fractional Gs
      float xAccel = xScaled / 1000.0;
      float yAccel = yScaled / 1000.0;
      float zAccel = zScaled / 1000.0;
    
//      Serial.print(" :: ");
//      Serial.print(xAccel);
//      Serial.print("G, ");
//      Serial.print(yAccel);
//      Serial.print("G, ");
//      Serial.print(zAccel);
//      Serial.println("G");
  
      //if(time % 200 == 0)
      //{
        if(zAccel > 1.5 || zAccel < -1.5 || yAccel > 1.5 || yAccel < -1.5 || xAccel > 1.5 || xAccel < -1.5 )
        {
          Serial.println("CRASH");
          fona.getGPS(&latitude, &longitude);
          dtostrf(latitude, 4, 4, clat);
          dtostrf(longitude, 4, 4, clong);
          sprintf(message, "ALERT: Huddy Buddy detected a crash. Visit Google Maps link for location: http://maps.google.com/maps?q=%s,%s", clat, clong);
          char number[21] = "7724537459";
          fona.sendSMS(number, message);
          u8g2.clearBuffer();
          u8g2.setFont(u8g2_font_courB18_tf);
          u8g2.setCursor(15,20);
          u8g2.print("CRASH");
          u8g2.sendBuffer();
          delay(30000);
          //crashDetected = true;
        }
      //}
     //delay(200);
    }

      
//  if(crashDetected == true && sentMessage == false)
//  {
//      sim808.print("AT+CMGS=\"");
//      sim808.print(phone_no);
//      sim808.println("\"");
//      
//      delay(300);
//  
//      sim808.print("http://maps.google.com/maps?q=");
//      sim808.print(latitude);
//      sim808.print(",");
//      sim808.print (longitude);
//      delay(200);
//      sim808.println((char)26); // End AT command with a ^Z, ASCII code 26
//      delay(200);
//      sim808.println();
//      sentMessage = true;
//      delay(20000);
//      sim808.flush();
//  }
  

    
//    if(time % 10000 == 0)
//    {
//      u8g2.setFont(u8g2_font_courB18_tf); // choose a suitable font
//      if(counter/10 < 10)
//      {
//        u8g2.setCursor(15,20);
//        u8g2.print(counter/10);
//      }
//    
//      else if (counter/10 > 9)
//      {
//        u8g2.setCursor(0,20);
//        u8g2.print(counter/10);
//      }
//      counter++;
//      u8g2.sendBuffer();
//    }
  }
  else
  {
    u8g2.clearBuffer();
    u8g2.setFont(u8g2_font_courB18_tf);
    u8g2.setCursor(15,20);
    u8g2.print("Calibrating GPS");
    u8g2.sendBuffer();
    if(gps_success = fona.getGPS(&latitude, &longitude)) // COULD RETURN INFINITE FALSE
    {
      calibrated = true;
      Serial.print("GPS lat:");
      Serial.println(latitude, 6);
      Serial.print("GPS long:");
      Serial.println(longitude, 6);
    }
    else
    {
      delay(5000);
    }
  }





}

//
// Read "sampleSize" samples and report the average
//
int ReadAxis(int axisPin)
{
  long reading = 0;
  analogRead(axisPin);
  delay(1);
  for (int i = 0; i < sampleSize; i++)
  {
    reading += analogRead(axisPin);
  }
  return reading/sampleSize;
}

//
// Find the extreme raw readings from each axis
//
void AutoCalibrate(int xRaw, int yRaw, int zRaw)
{
  Serial.println("Calibrate");
  if (xRaw < xRawMin)
  {
    xRawMin = xRaw;
  }
  if (xRaw > xRawMax)
  {
    xRawMax = xRaw;
  }
  
  if (yRaw < yRawMin)
  {
    yRawMin = yRaw;
  }
  if (yRaw > yRawMax)
  {
    yRawMax = yRaw;
  }

  if (zRaw < zRawMin)
  {
    zRawMin = zRaw;
  }
  if (zRaw > zRawMax)
  {
    zRawMax = zRaw;
  }
}
