/*
 * Huddy Buddy
 * Group 6
 * Senior Design II - Spring 2020
 * University of Central Florida
 * 
 * 
 * 
 * This Sketch is to be used with the Huddy Buddy, 
 * a Heads Up Display with advanced features to
 * increase driver awareness and safety. 
 * 
 * *************************************
 * *            INSTRUCTIONS           *
 * *************************************
 * 
 * To use, plug in the OBDII adapter into the vehicle.
 * The module will start and a boot screen will appear.
 * If "Initializing OBD" is stuck, power cycle the SIM808
 * module by pressing the PWR button, and then IMMEDIATELY
 * press the reset button on the Arduino Mega 2560. Continue
 * this process until the system boots properly.
 * 
 * 
 * 
 */

// Initialize FONA libraries
#include <SoftwareSerial.h>
// Setting up Fona Library
#include "Adafruit_FONA.h"
//SoftwareSerial sim808(10,11);
#define FONA_RX 11
#define FONA_TX 10
#define FONA_RST 4 // not used
SoftwareSerial fonaSS = SoftwareSerial(FONA_TX, FONA_RX);
SoftwareSerial *fonaSerial = &fonaSS;
Adafruit_FONA fona = Adafruit_FONA(FONA_RST);

// Initialize OBD2 Libraries
#include <OBD2UART.h>
#define mySerial Serial1
COBD obd;

// Initialize u8g2 OLED libraries
#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

// Initialize Huddy Buddy Logo
#define hb_logo_width 48
#define hb_logo_height 48
static unsigned char hb_logo_bits[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x52, 0xAF, 0x49, 0xF2, 0xFF, 
  0x0F, 0x00, 0x07, 0x00, 0x80, 0xFF, 0x2F, 0x80, 0x1F, 0x40, 0x00, 0xFF, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x07, 0xFE, 0x7F, 0xE0, 0x7F, 0xF0, 0x0F, 0xFC, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x0F, 0xFC, 0x7F, 0xE0, 0x3F, 0xF0, 0x1F, 0xFC, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x0F, 0xFC, 0x7F, 0xE0, 0x7F, 0xF0, 0x1F, 0xFC, 
  0xFF, 0xE0, 0x7F, 0xE0, 0x1F, 0xFC, 0x7F, 0xE0, 0x3F, 0xF0, 0x0F, 0xFC, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x0F, 0xFE, 0x7F, 0xE0, 0x7F, 0xF0, 0x0F, 0xFE, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x07, 0xFF, 0x7F, 0x00, 0x04, 0xA0, 0xC1, 0xFF, 
  0x7F, 0x00, 0x00, 0x00, 0xE0, 0xFF, 0x7F, 0x00, 0x00, 0x40, 0x80, 0xFF, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x07, 0xFE, 0x7F, 0xE0, 0x7F, 0xF0, 0x0F, 0xFC, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x1F, 0xF8, 0x7F, 0xE0, 0x7F, 0xF0, 0x3F, 0xF8, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x1F, 0xF8, 0x7F, 0xE0, 0x3F, 0xF0, 0x3F, 0xF0, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x3F, 0xF0, 0x7F, 0xE0, 0x7F, 0xF0, 0x3F, 0xF8, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x3F, 0xF0, 0x7F, 0xE0, 0x7F, 0xF0, 0x1F, 0xF8, 
  0x7F, 0xE0, 0x7F, 0xE0, 0x1F, 0xF8, 0x7F, 0xE0, 0x7F, 0xE0, 0x0F, 0xFC, 
  0x7F, 0xC0, 0x3F, 0xE0, 0x07, 0xFE, 0x0F, 0x00, 0x07, 0x00, 0x00, 0xFF, 
  0x0F, 0x00, 0x0F, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
  };

// Call OLED with the specified chipset. Uncomment second definition for mirrored display.
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);
//U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_MIRROR, /* reset=*/ U8X8_PIN_NONE);

// Initialize Accelerometer Values
// The Raw range was calibrated to be accurate values based on 
// device at rest.
const int xInput = A0;
const int yInput = A1;
const int zInput = A2;
const int buttonPin = 2;

//// Raw Ranges:
//// initialize to mid-range and allow calibration to
//// find the minimum and maximum for each axis
//int xRawMin = 512;
//int xRawMax = 512;
//
//int yRawMin = 512;
//int yRawMax = 512;
//
//int zRawMin = 512;
//int zRawMax = 512;

int xRawMin = 409;
int xRawMax = 613;

int yRawMin = 403;
int yRawMax = 606;

int zRawMin = 425;
int zRawMax = 629;

// Take multiple samples to reduce noise
const int sampleSize = 10;

// Init variables for sim text
int time = millis();
int counter = 0;
float latitude, longitude;
char clat[10];
char clong[10];
boolean gps_success;

// OBD variable init
int value, maxSpeed = 0, curSpeed, speedMPH, maf, currentMPG;
float mafVal = 0, curMPG = 0, roundedMPG = 0;
String strMPG;

const int testPin = 2;
//char phone_no[] = "7724537459";
//String data[5];
//#define DEBUG true
//String state, timegps, latitude = "28.6013", longitude = "-81.1984";
boolean calibrated = false;
bool sentMessage = false, crashDetected = false;
void setup() {

  // Start the OLED
  u8g2.begin();
  u8g2.setPowerSave(0);
  u8g2.clearBuffer();          // clear the internal memory
//  u8g2.setFont(u8g2_font_victoriamedium8_8r);
//  u8g2.setCursor(30,30);
//  u8g2.print("Powering on...");
//  u8g2.setCursor(50,30);
//  u8g2.print("Please wait :)");

  // Draw Huddy Buddy Logo and version number, 5 sec delay
  u8g2.drawXBM(0,0,hb_logo_width,hb_logo_height,hb_logo_bits);
  u8g2.setFont(u8g2_font_t0_12_tf);
  u8g2.setCursor(58,10);
  u8g2.print("Huddy Buddy");
  u8g2.setCursor(58,22);
  u8g2.print("Version 1.0");
  u8g2.sendBuffer();
  delay(5000);

  // Start power on process with status on OLED
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_t0_12_tf);
  u8g2.setCursor(20,20);
  u8g2.print("Powering On...");
  u8g2.setCursor(15,32);
  u8g2.print("Initializing OBD");
  u8g2.sendBuffer();

  // Begin connection to OBD with mySerial. 
  // do while until obd is initialized
  mySerial.begin(115200);
  obd.begin();
  do
  {
    mySerial.print("Init...");
  }
  while(!obd.init());
    
  // Begin connection to SIM808 with the FONA Library
  // Used example sketch from FonaTEST
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_t0_12_tf);
  u8g2.setCursor(20,20);
  u8g2.print("Powering On...");
  u8g2.setCursor(0,32);
  u8g2.print("Initializing SIM808");
  u8g2.sendBuffer();
  
  Serial.begin(115200);
  Serial.println(F("Adafruit FONA 808 & 3G GPS demo"));
  Serial.println(F("Initializing FONA... (May take a few seconds)"));
  fonaSerial->begin(4800);
  if (! fona.begin(*fonaSerial)) {
    Serial.println(F("Couldn't find FONA"));
    while(1);
  }
  Serial.println(F("FONA is OK"));
  // Try to enable GPRS

  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_t0_12_tf);
  u8g2.setCursor(20,20);
  u8g2.print("Powering On...");
  u8g2.setCursor(15,32);
  u8g2.print("Enabling GPS");
  u8g2.sendBuffer();

  Serial.println(F("Enabling GPS..."));
  fona.enableGPS(true);

  // Begin Accelerometer
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_t0_12_tf);
  u8g2.setCursor(20,20);
  u8g2.print("Powering On...");
  u8g2.setCursor(15,32);
  u8g2.print("Initizalizing Accelerometer");
  u8g2.sendBuffer();

  analogReference(EXTERNAL);
 
}

void loop() {
  
  // Initialize local loop vars
  float latitude, longitude;
  char clat[10];
  char clong[10];
  char message[140];

  // We need to be calibrated to the GPS signal before continuing.
  // When calibrated, the system will enter the main program. 
  // Else, it will wait until a connection is made.
  
  if (calibrated) // was if(gps_success) 
  {
    
   
    // Every 50 milliseconds, get data from OBD 
    // and print to OLED.
       
    if(time % 50 == 0)
    {
      // Set up display frame with Constant text
      u8g2.clearBuffer();          // clear the internal memory
      u8g2.setFont(u8g2_font_victoriamedium8_8r);
      u8g2.setCursor(33,20);
      u8g2.print("mph");
    
      u8g2.setCursor(0,40);
      u8g2.print("mpg");
      //u8g2.setCursor(0,50);
      //u8g2.print("avg 30");
      
  
      u8g2.setFont(u8g2_font_open_iconic_arrow_2x_t);
      u8g2.setCursor(90,15);
      u8g2.write(65);
  
      u8g2.setFont(u8g2_font_victoriamedium8_8r);
      u8g2.setCursor(70,30);
      u8g2.print("2.1 mi");
      u8g2.setCursor(70,40);
      u8g2.print("Gemini");
      u8g2.setCursor(70,50);
      u8g2.print("Blvd");
      
      // Get speed from OBD, convert to MPH, and display on OLED.
      // Added logic to make displaying more fluid by taking values
      // less than 10 and making the single digit appear as a right
      // bias.
      if(obd.readPID(PID_SPEED, curSpeed))
      {
        speedMPH = curSpeed * 0.621371; // converting kph to mph
        
        u8g2.setFont(u8g2_font_courB18_tf); // choose a suitable font
        if(speedMPH < 10)
        {
          u8g2.setCursor(15,20);
          u8g2.print(speedMPH);
        }
      
        else if (speedMPH > 9)
        {
          u8g2.setCursor(0,20);
          u8g2.print(speedMPH);
        }
      }

      // Get Mass Air Flow value from OBD, which is used for MPG calculation, then
      // print MPG on OLED.
      if(obd.readPID(PID_MAF_FLOW, maf))
      {
        // currentMPG is derived from the MAF and speed of the vehicle, as well as conversion values
        // given by https://github.com/oesmith/obdgpslogger/blob/master/doc/mpg-calculation
        // NOTE: To get a realistic factor, divide again by 100
        
        currentMPG = ((14.7 * 6.17 * 454 * curSpeed * 0.621371) / (3600 * maf / 100)) / 100;
        u8g2.setFont(u8g2_font_courB14_tf);
        if(currentMPG < 10)
        {
          u8g2.setCursor(10,40);
          u8g2.print(currentMPG);
        }
      
        else if (currentMPG > 9)
        {
          u8g2.setCursor(0,40);
          u8g2.print(currentMPG);
        }
        u8g2.setFont(u8g2_font_victoriamedium8_8r);
        u8g2.setCursor(25,40);
        u8g2.print("mpg");
        
      }
      
      u8g2.sendBuffer();
    }
       
    
    // Read values from Accelerometer
    int xRaw = ReadAxis(xInput);
    int yRaw = ReadAxis(yInput);
    int zRaw = ReadAxis(zInput);

    // Every 200 milliseconds, check accelerometer for high g forces.
    if(time % 200 == 0)
    {
      
      // Convert raw values to 'milli-Gs"
      long xScaled = map(xRaw, xRawMin, xRawMax, -1000, 1000);
      long yScaled = map(yRaw, yRawMin, yRawMax, -1000, 1000);
      long zScaled = map(zRaw, zRawMin, zRawMax, -1000, 1000);
    
      // re-scale to fractional Gs
      float xAccel = xScaled / 1000.0;
      float yAccel = yScaled / 1000.0;
      float zAccel = zScaled / 1000.0;
    
      // If the accelerometer reads value OVER or UNDER 1.5g from any axis, enter emergency routine
      if(zAccel > 1.5 || zAccel < -1.5 || yAccel > 1.5 || yAccel < -1.5 || xAccel > 1.5 || xAccel < -1.5 )
      {
        // Get current GPS Coordinates from SIM808
        fona.getGPS(&latitude, &longitude);

        // Convert float lat and long to char array to print into string
        dtostrf(latitude, 4, 4, clat);
        dtostrf(longitude, 4, 4, clong);

        // Set up full message string with char array coords at the end of a google maps link.
        sprintf(message, "ALERT: Huddy Buddy detected a crash. Visit Google Maps link for location: http://maps.google.com/maps?q=%s,%s", clat, clong);
        // Declare number to send emergency text
        char number[21] = "7724537459";
        // Send the text message to the designated number
        fona.sendSMS(number, message);
        // Print crash on OLED
        u8g2.clearBuffer();
        u8g2.setFont(u8g2_font_courB18_tf);
        u8g2.setCursor(15,20);
        u8g2.print("CRASH");
        u8g2.sendBuffer();
        // Delay 30 seconds
        delay(30000);
         
      }
    }
  }
  else
  {
    // GPS is not calibrated. Print status on OLED and check for GPS connection.
    // If no connection is made, delay 5 seconds.
    u8g2.clearBuffer();
    u8g2.setFont(u8g2_font_t0_12_tf);
    u8g2.setCursor(20,20);
    u8g2.print("Powering On...");
    u8g2.setCursor(15,32);
    u8g2.print("Calibrating GPS");
    u8g2.sendBuffer();
    if(gps_success = fona.getGPS(&latitude, &longitude)) // COULD RETURN INFINITE FALSE
    {
      calibrated = true;
      Serial.print("GPS lat:");
      Serial.println(latitude, 6);
      Serial.print("GPS long:");
      Serial.println(longitude, 6);
    }
    else
    {
      delay(5000);
    }
  }





}

//
// Read "sampleSize" samples and report the average
//
int ReadAxis(int axisPin)
{
  long reading = 0;
  analogRead(axisPin);
  delay(1);
  for (int i = 0; i < sampleSize; i++)
  {
    reading += analogRead(axisPin);
  }
  return reading/sampleSize;
}

//
// Find the extreme raw readings from each axis
//
void AutoCalibrate(int xRaw, int yRaw, int zRaw)
{
  Serial.println("Calibrate");
  if (xRaw < xRawMin)
  {
    xRawMin = xRaw;
  }
  if (xRaw > xRawMax)
  {
    xRawMax = xRaw;
  }
  
  if (yRaw < yRawMin)
  {
    yRawMin = yRaw;
  }
  if (yRaw > yRawMax)
  {
    yRawMax = yRaw;
  }

  if (zRaw < zRawMin)
  {
    zRawMin = zRaw;
  }
  if (zRaw > zRawMax)
  {
    zRawMax = zRaw;
  }
}
