//Battery voltage test
#include <OBD2UART.h>
#define mySerial Serial1

// screen defs
#include <Arduino.h>
#include <U8x8lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
U8X8_SH1106_128X64_NONAME_HW_I2C u8x8(/* reset=*/ U8X8_PIN_NONE);

//PID_RPM
COBD obd;

void ShowVoltage(float v)
{
Serial.println(v);

}

void setup()
{
  u8x8.begin();
  u8x8.setPowerSave(0);
    
  delay(500);
  mySerial.begin(115200);
  Serial.begin(115200);
  // this will begin serial
  obd.begin();
  // initialize OBD-II adapter until success
  do
  {
  mySerial.println("Init...");
  }
  while (!obd.init());

}

void loop()
{
   u8x8.setContrast(255);
   u8x8.setFont(u8x8_font_victoriamedium8_r);
    u8x8.setCursor(4,1.95);
    u8x8.print("mph");
    
    u8x8.setCursor(0,3);
    u8x8.print("mpg");
    u8x8.setCursor(0,4);
    u8x8.print("avg 30");
    u8x8.setCursor(0,5);
    u8x8.print("cur 40");
  
    u8x8.setCursor(10,1.5);
  //  u8x8.print(char(60)); // <
  //  u8x8.print(char(45)); // -
  //  u8x8.print(char(45)); // -
  
  // in open iconic font, 65 is left arrow
    u8x8.setFont(u8x8_font_open_iconic_arrow_2x2);
    u8x8.write(65);
    
    u8x8.setFont(u8x8_font_victoriamedium8_r);
    u8x8.setCursor(9,3);
    u8x8.print("2.1 mi");
  
    u8x8.setCursor(9,4);
    u8x8.print("Gemini");
    u8x8.setCursor(9,5);
    u8x8.print("Blvd");

  
  
  
  float v = obd.getVoltage();
  int value;
  int maxSpeed = 0, speed, speedMPH, maf, currentMPG;
  //ShowVoltage(v);
    if (obd.readPID(PID_RPM, value)) {
      // RPM is successfully read and its value stored in variable 'value'
      // light on LED when RPM exceeds 3000
     // Serial.println(value);
    }
  
    if(obd.readPID(PID_SPEED, speed))
    {
      
        speedMPH = speed * 0.621371;
        //Serial.print("speed is ") ;
        //Serial.print(speedMPH);
        //Serial.print("\t current mpg is: ");
        //Serial.print
        //delay(1000);     
      u8x8.setFont(u8x8_font_courB18_2x3_f);
      
      if(speedMPH > 9)
      {
        u8x8.setCursor(0,0);
        u8x8.print(speedMPH);
      }
      else if(speedMPH < 10)
      {
        // clear first decimal in case anything is present
        u8x8.setCursor(0,0);
        u8x8.write(8);
        
        u8x8.setCursor(1,0);
        u8x8.write(8); 
        
        u8x8.setCursor(2,0);
        u8x8.print(speedMPH);
      }
      delay(50);   
      
    }
  
    if(obd.readPID(PID_MAF_FLOW, maf))
    {
      currentMPG = (maf * 710.7) / speedMPH;
        
        //Serial.print("\t current mpg is: ");
        //Serial.print(currentMPG);
        //Serial.print("\r");
      
    }

    
   
        
   

  
  
  
  //Serial.println(rpm);
  //Serial.print(v);

}
