/*
    MIT License

    Copyright (c) 2018-2019, Alexey Dynda

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/
/*
 * ssd1306xled_font6x8 is by Neven Boyanov
 * ssd1306xled_font8x16 is by Neven Boyanov
 *
 * @created: 2014-08-12
 * @author: Neven Boyanov
 *
 * Copyright (c) 2015 Neven Boyanov, Tinusaur Team. All Rights Reserved.
 * Distributed as open source software under MIT License, see LICENSE.txt file.
 * Please, as a favour, retain the link http://tinusaur.org to The Tinusaur Project.
 *
 * Source code available at: https://bitbucket.org/tinusaur/ssd1306xled
 *
 */

#include "canvas/fonts/fonts.h"

/* Standard ASCII 6x8 font */
const PROGMEM uint8_t ssd1306xled_font6x8 []=
{
  0x00, 0x06, 0x08, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // sp
  0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, // !
  0x00, 0x00, 0x07, 0x00, 0x07, 0x00, // "
  0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14, // #
  0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12, // $
  0x00, 0x23, 0x13, 0x08, 0x64, 0x62, // %
  0x00, 0x36, 0x49, 0x55, 0x22, 0x50, // &
  0x00, 0x00, 0x05, 0x03, 0x00, 0x00, // '
  0x00, 0x00, 0x1c, 0x22, 0x41, 0x00, // (
  0x00, 0x00, 0x41, 0x22, 0x1c, 0x00, // )
  0x00, 0x14, 0x08, 0x3E, 0x08, 0x14, // *
  0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, // +
  0x00, 0x00, 0x00, 0xA0, 0x60, 0x00, // ,
  0x00, 0x08, 0x08, 0x08, 0x08, 0x08, // -
  0x00, 0x00, 0x60, 0x60, 0x00, 0x00, // .
  0x00, 0x20, 0x10, 0x08, 0x04, 0x02, // /
  0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
  0x00, 0x00, 0x42, 0x7F, 0x40, 0x00, // 1
  0x00, 0x42, 0x61, 0x51, 0x49, 0x46, // 2
  0x00, 0x21, 0x41, 0x45, 0x4B, 0x31, // 3
  0x00, 0x18, 0x14, 0x12, 0x7F, 0x10, // 4
  0x00, 0x27, 0x45, 0x45, 0x45, 0x39, // 5
  0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30, // 6
  0x00, 0x01, 0x71, 0x09, 0x05, 0x03, // 7
  0x00, 0x36, 0x49, 0x49, 0x49, 0x36, // 8
  0x00, 0x06, 0x49, 0x49, 0x29, 0x1E, // 9
  0x00, 0x00, 0x36, 0x36, 0x00, 0x00, // :
  0x00, 0x00, 0x56, 0x36, 0x00, 0x00, // ;
  0x00, 0x08, 0x14, 0x22, 0x41, 0x00, // <
  0x00, 0x14, 0x14, 0x14, 0x14, 0x14, // =
  0x00, 0x00, 0x41, 0x22, 0x14, 0x08, // >
  0x00, 0x02, 0x01, 0x51, 0x09, 0x06, // ?
  0x00, 0x32, 0x49, 0x59, 0x51, 0x3E, // @
  0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C, // A
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x36, // B
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, // C
  0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C, // D
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x41, // E
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x01, // F
  0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A, // G
  0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, // H
  0x00, 0x00, 0x41, 0x7F, 0x41, 0x00, // I
  0x00, 0x20, 0x40, 0x41, 0x3F, 0x01, // J
  0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, // K
  0x00, 0x7F, 0x40, 0x40, 0x40, 0x40, // L
  0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
  0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F, // N
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, // O
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x06, // P
  0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E, // Q
  0x00, 0x7F, 0x09, 0x19, 0x29, 0x46, // R
  0x00, 0x46, 0x49, 0x49, 0x49, 0x31, // S
  0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, // T
  0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F, // U
  0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F, // V
  0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F, // W
  0x00, 0x63, 0x14, 0x08, 0x14, 0x63, // X
  0x00, 0x07, 0x08, 0x70, 0x08, 0x07, // Y
  0x00, 0x61, 0x51, 0x49, 0x45, 0x43, // Z
  0x00, 0x00, 0x7F, 0x41, 0x41, 0x00, // [
  0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55, // 55
  0x00, 0x00, 0x41, 0x41, 0x7F, 0x00, // ]
  0x00, 0x04, 0x02, 0x01, 0x02, 0x04, // ^
  0x00, 0x40, 0x40, 0x40, 0x40, 0x40, // _
  0x00, 0x00, 0x01, 0x02, 0x04, 0x00, // '
  0x00, 0x20, 0x54, 0x54, 0x54, 0x78, // a
  0x00, 0x7F, 0x48, 0x44, 0x44, 0x38, // b
  0x00, 0x38, 0x44, 0x44, 0x44, 0x20, // c
  0x00, 0x38, 0x44, 0x44, 0x48, 0x7F, // d
  0x00, 0x38, 0x54, 0x54, 0x54, 0x18, // e
  0x00, 0x08, 0x7E, 0x09, 0x01, 0x02, // f
  0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C, // g
  0x00, 0x7F, 0x08, 0x04, 0x04, 0x78, // h
  0x00, 0x00, 0x44, 0x7D, 0x40, 0x00, // i
  0x00, 0x40, 0x80, 0x84, 0x7D, 0x00, // j
  0x00, 0x7F, 0x10, 0x28, 0x44, 0x00, // k
  0x00, 0x00, 0x41, 0x7F, 0x40, 0x00, // l
  0x00, 0x7C, 0x04, 0x18, 0x04, 0x78, // m
  0x00, 0x7C, 0x08, 0x04, 0x04, 0x78, // n
  0x00, 0x38, 0x44, 0x44, 0x44, 0x38, // o
  0x00, 0xFC, 0x24, 0x24, 0x24, 0x18, // p
  0x00, 0x18, 0x24, 0x24, 0x18, 0xFC, // q
  0x00, 0x7C, 0x08, 0x04, 0x04, 0x08, // r
  0x00, 0x48, 0x54, 0x54, 0x54, 0x20, // s
  0x00, 0x04, 0x3F, 0x44, 0x40, 0x20, // t
  0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C, // u
  0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C, // v
  0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C, // w
  0x00, 0x44, 0x28, 0x10, 0x28, 0x44, // x
  0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C, // y
  0x00, 0x44, 0x64, 0x54, 0x4C, 0x44, // z
  0x00, 0x00, 0x08, 0x77, 0x00, 0x00, // {
  0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, // |
  0x00, 0x00, 0x77, 0x08, 0x00, 0x00, // }
  0x00, 0x10, 0x08, 0x10, 0x08, 0x00, // ~
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, // horiz lines // DEL
  0x00 /* This byte is required for italic type of font */
};

const PROGMEM uint8_t ssd1306xled_font8x16[] = {
    0x00, // 0x00 means fixed font type - the only supported by the library
    0x08, // 0x08 = 8 - font width in pixels
    0x10, // 0x10 = 16 - font height in pixels
    0x20,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //   0
    0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x30, 0x00, 0x00, 0x00, // ! 1
    0x00, 0x10, 0x0C, 0x06, 0x10, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // " 2
    0x40, 0xC0, 0x78, 0x40, 0xC0, 0x78, 0x40, 0x00, 0x04, 0x3F, 0x04, 0x04, 0x3F, 0x04, 0x04, 0x00, // # 3
    0x00, 0x70, 0x88, 0xFC, 0x08, 0x30, 0x00, 0x00, 0x00, 0x18, 0x20, 0xFF, 0x21, 0x1E, 0x00, 0x00, // $ 4
    0xF0, 0x08, 0xF0, 0x00, 0xE0, 0x18, 0x00, 0x00, 0x00, 0x21, 0x1C, 0x03, 0x1E, 0x21, 0x1E, 0x00, // % 5
    0x00, 0xF0, 0x08, 0x88, 0x70, 0x00, 0x00, 0x00, 0x1E, 0x21, 0x23, 0x24, 0x19, 0x27, 0x21, 0x10, // & 6
    0x10, 0x16, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ' 7
    0x00, 0x00, 0x00, 0xE0, 0x18, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x07, 0x18, 0x20, 0x40, 0x00, // ( 8
    0x00, 0x02, 0x04, 0x18, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x18, 0x07, 0x00, 0x00, 0x00, // ) 9
    0x40, 0x40, 0x80, 0xF0, 0x80, 0x40, 0x40, 0x00, 0x02, 0x02, 0x01, 0x0F, 0x01, 0x02, 0x02, 0x00, // * 10
    0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x1F, 0x01, 0x01, 0x01, 0x00, // + 11
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xB0, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, // , 12
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // - 13
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, // . 14
    0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x18, 0x04, 0x00, 0x60, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, // / 15
    0x00, 0xE0, 0x10, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x00, 0x0F, 0x10, 0x20, 0x20, 0x10, 0x0F, 0x00, // 0 16
    0x00, 0x10, 0x10, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3F, 0x20, 0x20, 0x00, 0x00, // 1 17
    0x00, 0x70, 0x08, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00, 0x30, 0x28, 0x24, 0x22, 0x21, 0x30, 0x00, // 2 18
    0x00, 0x30, 0x08, 0x88, 0x88, 0x48, 0x30, 0x00, 0x00, 0x18, 0x20, 0x20, 0x20, 0x11, 0x0E, 0x00, // 3 19
    0x00, 0x00, 0xC0, 0x20, 0x10, 0xF8, 0x00, 0x00, 0x00, 0x07, 0x04, 0x24, 0x24, 0x3F, 0x24, 0x00, // 4 20
    0x00, 0xF8, 0x08, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x19, 0x21, 0x20, 0x20, 0x11, 0x0E, 0x00, // 5 21
    0x00, 0xE0, 0x10, 0x88, 0x88, 0x18, 0x00, 0x00, 0x00, 0x0F, 0x11, 0x20, 0x20, 0x11, 0x0E, 0x00, // 6 22
    0x00, 0x38, 0x08, 0x08, 0xC8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, // 7 23
    0x00, 0x70, 0x88, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00, 0x1C, 0x22, 0x21, 0x21, 0x22, 0x1C, 0x00, // 8 24
    0x00, 0xE0, 0x10, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x00, 0x00, 0x31, 0x22, 0x22, 0x11, 0x0F, 0x00, // 9 25
    0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, // : 26
    0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x00, // ; 27
    0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, // < 28
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, // = 29
    0x00, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, // > 30
    0x00, 0x70, 0x48, 0x08, 0x08, 0x08, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x30, 0x36, 0x01, 0x00, 0x00, // ? 31
    0xC0, 0x30, 0xC8, 0x28, 0xE8, 0x10, 0xE0, 0x00, 0x07, 0x18, 0x27, 0x24, 0x23, 0x14, 0x0B, 0x00, // @ 32
    0x00, 0x00, 0xC0, 0x38, 0xE0, 0x00, 0x00, 0x00, 0x20, 0x3C, 0x23, 0x02, 0x02, 0x27, 0x38, 0x20, // A 33
    0x08, 0xF8, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x20, 0x3F, 0x20, 0x20, 0x20, 0x11, 0x0E, 0x00, // B 34
    0xC0, 0x30, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x07, 0x18, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, // C 35
    0x08, 0xF8, 0x08, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x20, 0x3F, 0x20, 0x20, 0x20, 0x10, 0x0F, 0x00, // D 36
    0x08, 0xF8, 0x88, 0x88, 0xE8, 0x08, 0x10, 0x00, 0x20, 0x3F, 0x20, 0x20, 0x23, 0x20, 0x18, 0x00, // E 37
    0x08, 0xF8, 0x88, 0x88, 0xE8, 0x08, 0x10, 0x00, 0x20, 0x3F, 0x20, 0x00, 0x03, 0x00, 0x00, 0x00, // F 38
    0xC0, 0x30, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x07, 0x18, 0x20, 0x20, 0x22, 0x1E, 0x02, 0x00, // G 39
    0x08, 0xF8, 0x08, 0x00, 0x00, 0x08, 0xF8, 0x08, 0x20, 0x3F, 0x21, 0x01, 0x01, 0x21, 0x3F, 0x20, // H 40
    0x00, 0x08, 0x08, 0xF8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3F, 0x20, 0x20, 0x00, 0x00, // I 41
    0x00, 0x00, 0x08, 0x08, 0xF8, 0x08, 0x08, 0x00, 0xC0, 0x80, 0x80, 0x80, 0x7F, 0x00, 0x00, 0x00, // J 42
    0x08, 0xF8, 0x88, 0xC0, 0x28, 0x18, 0x08, 0x00, 0x20, 0x3F, 0x20, 0x01, 0x26, 0x38, 0x20, 0x00, // K 43
    0x08, 0xF8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x3F, 0x20, 0x20, 0x20, 0x20, 0x30, 0x00, // L 44
    0x08, 0xF8, 0xF8, 0x00, 0xF8, 0xF8, 0x08, 0x00, 0x20, 0x3F, 0x00, 0x3F, 0x00, 0x3F, 0x20, 0x00, // M 45
    0x08, 0xF8, 0x30, 0xC0, 0x00, 0x08, 0xF8, 0x08, 0x20, 0x3F, 0x20, 0x00, 0x07, 0x18, 0x3F, 0x00, // N 46
    0xE0, 0x10, 0x08, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x0F, 0x10, 0x20, 0x20, 0x20, 0x10, 0x0F, 0x00, // O 47
    0x08, 0xF8, 0x08, 0x08, 0x08, 0x08, 0xF0, 0x00, 0x20, 0x3F, 0x21, 0x01, 0x01, 0x01, 0x00, 0x00, // P 48
    0xE0, 0x10, 0x08, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x0F, 0x18, 0x24, 0x24, 0x38, 0x50, 0x4F, 0x00, // Q 49
    0x08, 0xF8, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x20, 0x3F, 0x20, 0x00, 0x03, 0x0C, 0x30, 0x20, // R 50
    0x00, 0x70, 0x88, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x38, 0x20, 0x21, 0x21, 0x22, 0x1C, 0x00, // S 51
    0x18, 0x08, 0x08, 0xF8, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x20, 0x3F, 0x20, 0x00, 0x00, 0x00, // T 52
    0x08, 0xF8, 0x08, 0x00, 0x00, 0x08, 0xF8, 0x08, 0x00, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x00, // U 53
    0x08, 0x78, 0x88, 0x00, 0x00, 0xC8, 0x38, 0x08, 0x00, 0x00, 0x07, 0x38, 0x0E, 0x01, 0x00, 0x00, // V 54
    0xF8, 0x08, 0x00, 0xF8, 0x00, 0x08, 0xF8, 0x00, 0x03, 0x3C, 0x07, 0x00, 0x07, 0x3C, 0x03, 0x00, // W 55
    0x08, 0x18, 0x68, 0x80, 0x80, 0x68, 0x18, 0x08, 0x20, 0x30, 0x2C, 0x03, 0x03, 0x2C, 0x30, 0x20, // X 56
    0x08, 0x38, 0xC8, 0x00, 0xC8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x20, 0x3F, 0x20, 0x00, 0x00, 0x00, // Y 57
    0x10, 0x08, 0x08, 0x08, 0xC8, 0x38, 0x08, 0x00, 0x20, 0x38, 0x26, 0x21, 0x20, 0x20, 0x18, 0x00, // Z 58
    0x00, 0x00, 0x00, 0xFE, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x40, 0x40, 0x40, 0x00, // [ 59
    0x00, 0x0C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x38, 0xC0, 0x00, // \ 60
    0x00, 0x02, 0x02, 0x02, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7F, 0x00, 0x00, 0x00, // ] 61
    0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ^ 62
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // _ 63
    0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ` 64
    0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x19, 0x24, 0x22, 0x22, 0x22, 0x3F, 0x20, // a 65
    0x08, 0xF8, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x11, 0x20, 0x20, 0x11, 0x0E, 0x00, // b 66
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x0E, 0x11, 0x20, 0x20, 0x20, 0x11, 0x00, // c 67
    0x00, 0x00, 0x00, 0x80, 0x80, 0x88, 0xF8, 0x00, 0x00, 0x0E, 0x11, 0x20, 0x20, 0x10, 0x3F, 0x20, // d 68
    0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x1F, 0x22, 0x22, 0x22, 0x22, 0x13, 0x00, // e 69
    0x00, 0x80, 0x80, 0xF0, 0x88, 0x88, 0x88, 0x18, 0x00, 0x20, 0x20, 0x3F, 0x20, 0x20, 0x00, 0x00, // f 70
    0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x6B, 0x94, 0x94, 0x94, 0x93, 0x60, 0x00, // g 71
    0x08, 0xF8, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x20, 0x3F, 0x21, 0x00, 0x00, 0x20, 0x3F, 0x20, // h 72
    0x00, 0x80, 0x98, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3F, 0x20, 0x20, 0x00, 0x00, // i 73
    0x00, 0x00, 0x00, 0x80, 0x98, 0x98, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x80, 0x80, 0x7F, 0x00, 0x00, // j 74
    0x08, 0xF8, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x20, 0x3F, 0x24, 0x02, 0x2D, 0x30, 0x20, 0x00, // k 75
    0x00, 0x08, 0x08, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3F, 0x20, 0x20, 0x00, 0x00, // l 76
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x20, 0x3F, 0x20, 0x00, 0x3F, 0x20, 0x00, 0x3F, // m 77
    0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x20, 0x3F, 0x21, 0x00, 0x00, 0x20, 0x3F, 0x20, // n 78
    0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x00, // o 79
    0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0xFF, 0xA1, 0x20, 0x20, 0x11, 0x0E, 0x00, // p 80
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x0E, 0x11, 0x20, 0x20, 0xA0, 0xFF, 0x80, // q 81
    0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x00, 0x20, 0x20, 0x3F, 0x21, 0x20, 0x00, 0x01, 0x00, // r 82
    0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x33, 0x24, 0x24, 0x24, 0x24, 0x19, 0x00, // s 83
    0x00, 0x80, 0x80, 0xE0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x20, 0x00, 0x00, // t 84
    0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x1F, 0x20, 0x20, 0x20, 0x10, 0x3F, 0x20, // u 85
    0x80, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x01, 0x0E, 0x30, 0x08, 0x06, 0x01, 0x00, // v 86
    0x80, 0x80, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80, 0x0F, 0x30, 0x0C, 0x03, 0x0C, 0x30, 0x0F, 0x00, // w 87
    0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x20, 0x31, 0x2E, 0x0E, 0x31, 0x20, 0x00, // x 88
    0x80, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x81, 0x8E, 0x70, 0x18, 0x06, 0x01, 0x00, // y 89
    0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x21, 0x30, 0x2C, 0x22, 0x21, 0x30, 0x00, // z 90
    0x00, 0x00, 0x00, 0x00, 0x80, 0x7C, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x40, 0x40, // { 91
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, // | 92
    0x00, 0x02, 0x02, 0x7C, 0x80, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x3F, 0x00, 0x00, 0x00, 0x00, // } 93
    0x00, 0x06, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ~ 94
};

const PROGMEM uint8_t ssd1306xled_font6x8_German []=
{
    0x01, 0x06, 0x08, 0x20,
    0x00, 0xE4, 0x01, // Ulmaute unicode
    0x38, 0x45, 0x44, 0x39, 0x44, 0x00, // ä
    0x00, 0xF6, 0x01,
    0x38, 0x45, 0x44, 0x45, 0x38, 0x00, // ö
    0x00, 0xFC, 0x01,
    0x3C, 0x41, 0x40, 0x41, 0x3C, 0x00, // ü
    0x00, 0xC4, 0x01,
    0x00, 0xF0, 0x29, 0x24, 0x29, 0xF0, // Ä
    0x00, 0xD6, 0x01,
    0x00, 0x78, 0x85, 0x84, 0x85, 0x78, // Ö
    0x00, 0xDC, 0x01,
    0x00, 0x7C, 0x81, 0x80, 0x81, 0x7C, // Ü
    0x00, 0x00, 0x00, // End of unicode tables
};

/* Standard ASCII 6x8_AB font */
const PROGMEM uint8_t ssd1306xled_font6x8_AB []=
{
  0x00, 0x06, 0x08, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // sp
  0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, // !
  0x00, 0x00, 0x07, 0x00, 0x07, 0x00, // "
  0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14, // #
  0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12, // $
  0x00, 0x23, 0x13, 0x08, 0x64, 0x62, // %
  0x00, 0x36, 0x49, 0x55, 0x22, 0x50, // &
  0x00, 0x00, 0x05, 0x03, 0x00, 0x00, // '
  0x00, 0x00, 0x1c, 0x22, 0x41, 0x00, // (
  0x00, 0x00, 0x41, 0x22, 0x1c, 0x00, // )
  0x00, 0x14, 0x08, 0x3E, 0x08, 0x14, // *
  0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, // +
  0x00, 0x00, 0x00, 0xA0, 0x60, 0x00, // ,
  0x00, 0x08, 0x08, 0x08, 0x08, 0x08, // -
  0x00, 0x00, 0x60, 0x60, 0x00, 0x00, // .
  0x00, 0x20, 0x10, 0x08, 0x04, 0x02, // /
  0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
  0x00, 0x00, 0x42, 0x7F, 0x40, 0x00, // 1
  0x00, 0x42, 0x61, 0x51, 0x49, 0x46, // 2
  0x00, 0x21, 0x41, 0x45, 0x4B, 0x31, // 3
  0x00, 0x18, 0x14, 0x12, 0x7F, 0x10, // 4
  0x00, 0x27, 0x45, 0x45, 0x45, 0x39, // 5
  0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30, // 6
  0x00, 0x01, 0x71, 0x09, 0x05, 0x03, // 7
  0x00, 0x36, 0x49, 0x49, 0x49, 0x36, // 8
  0x00, 0x06, 0x49, 0x49, 0x29, 0x1E, // 9
  0x00, 0x00, 0x36, 0x36, 0x00, 0x00, // :
  0x00, 0x00, 0x56, 0x36, 0x00, 0x00, // ;
  0x00, 0x08, 0x14, 0x22, 0x41, 0x00, // <
  0x00, 0x14, 0x14, 0x14, 0x14, 0x14, // =
  0x00, 0x00, 0x41, 0x22, 0x14, 0x08, // >
  0x00, 0x02, 0x01, 0x51, 0x09, 0x06, // ?
  0x00, 0x32, 0x49, 0x59, 0x51, 0x3E, // @
  0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C, // A
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x36, // B
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, // C
  0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C, // D
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x41, // E
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x01, // F
  0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A, // G
  0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, // H
  0x00, 0x00, 0x41, 0x7F, 0x41, 0x00, // I
  0x00, 0x20, 0x40, 0x41, 0x3F, 0x01, // J
  0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, // K
  0x00, 0x7F, 0x40, 0x40, 0x40, 0x40, // L
  0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
  0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F, // N
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, // O
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x06, // P
  0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E, // Q
  0x00, 0x7F, 0x09, 0x19, 0x29, 0x46, // R
  0x00, 0x46, 0x49, 0x49, 0x49, 0x31, // S
  0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, // T
  0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F, // U
  0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F, // V
  0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F, // W
  0x00, 0x63, 0x14, 0x08, 0x14, 0x63, // X
  0x00, 0x07, 0x08, 0x70, 0x08, 0x07, // Y
  0x00, 0x61, 0x51, 0x49, 0x45, 0x43, // Z
  0x00, 0x00, 0x7F, 0x41, 0x41, 0x00, // [
  0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55, // 55
  0x00, 0x00, 0x41, 0x41, 0x7F, 0x00, // ]
  0x00, 0x04, 0x02, 0x01, 0x02, 0x04, // ^
  0x00, 0x40, 0x40, 0x40, 0x40, 0x40, // _
  0x00, 0x00, 0x01, 0x02, 0x04, 0x00, // '
  0x00 /* This byte is required for italic type of font */
};

const uint8_t digital_font5x7_123[] PROGMEM =
{
    0x00, 0x05, 0x07, 0x30,
    0x36, 0x41, 0x41, 0x36, 0x00, // char '0' (0x30/48)
    0x00, 0x00, 0x00, 0x36, 0x00, // char '1' (0x31/49)
    0x30, 0x49, 0x49, 0x06, 0x00, // char '2' (0x32/50)
    0x00, 0x49, 0x49, 0x36, 0x00, // char '3' (0x33/51)
    0x06, 0x08, 0x08, 0x36, 0x00, // char '4' (0x34/52)
    0x06, 0x49, 0x49, 0x30, 0x00, // char '5' (0x35/53)
    0x36, 0x49, 0x49, 0x30, 0x00, // char '6' (0x36/54)
    0x00, 0x01, 0x01, 0x36, 0x00, // char '7' (0x37/55)
    0x36, 0x49, 0x49, 0x36, 0x00, // char '8' (0x38/56)
    0x06, 0x49, 0x49, 0x36, 0x00, // char '9' (0x39/57)
};

const uint8_t digital_font5x7[] PROGMEM =
{
    0x00, 0x05, 0x07, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, // char ' ' (0x20/32)
    0x00, 0x00, 0x2E, 0x00, 0x00, // char '!' (0x21/33)
    0x06, 0x00, 0x06, 0x00, 0x00, // char '"' (0x22/34)
    0x14, 0x7F, 0x14, 0x7F, 0x14, // char '#' (0x23/35)
    0x06, 0x49, 0x7F, 0x49, 0x30, // char '$' (0x24/36)
    0x24, 0x10, 0x08, 0x24, 0x00, // char '%' (0x25/37)
    0x36, 0x49, 0x36, 0x50, 0x00, // char '&' (0x26/38)
    0x00, 0x00, 0x00, 0x06, 0x00, // char ''' (0x27/39)
    0x00, 0x41, 0x36, 0x00, 0x00, // char '(' (0x28/40)
    0x00, 0x36, 0x41, 0x00, 0x00, // char ')' (0x29/41)
    0x00, 0x08, 0x00, 0x00, 0x00, // char '*' (0x2A/42)
    0x00, 0x08, 0x1C, 0x08, 0x00, // char '+' (0x2B/43)
    0x40, 0x20, 0x00, 0x00, 0x00, // char ',' (0x2C/44)
    0x00, 0x08, 0x08, 0x00, 0x00, // char '-' (0x2D/45)
    0x20, 0x00, 0x00, 0x00, 0x00, // char '.' (0x2E/46)
    0x00, 0x30, 0x06, 0x00, 0x00, // char '/' (0x2F/47)
    0x36, 0x41, 0x41, 0x36, 0x00, // char '0' (0x30/48)
    0x00, 0x00, 0x00, 0x36, 0x00, // char '1' (0x31/49)
    0x30, 0x49, 0x49, 0x06, 0x00, // char '2' (0x32/50)
    0x00, 0x49, 0x49, 0x36, 0x00, // char '3' (0x33/51)
    0x06, 0x08, 0x08, 0x36, 0x00, // char '4' (0x34/52)
    0x06, 0x49, 0x49, 0x30, 0x00, // char '5' (0x35/53)
    0x36, 0x49, 0x49, 0x30, 0x00, // char '6' (0x36/54)
    0x00, 0x01, 0x01, 0x36, 0x00, // char '7' (0x37/55)
    0x36, 0x49, 0x49, 0x36, 0x00, // char '8' (0x38/56)
    0x06, 0x49, 0x49, 0x36, 0x00, // char '9' (0x39/57)
    0x00, 0x14, 0x00, 0x00, 0x00, // char ':' (0x3A/58)
    0x20, 0x14, 0x00, 0x00, 0x00, // char ';' (0x3B/59)
    0x00, 0x08, 0x14, 0x22, 0x00, // char '<' (0x3C/60)
    0x00, 0x14, 0x14, 0x14, 0x00, // char '=' (0x3D/61)
    0x00, 0x22, 0x14, 0x08, 0x00, // char '>' (0x3E/62)
    0x00, 0x01, 0x31, 0x06, 0x00, // char '?' (0x3F/63)
    0x36, 0x49, 0x55, 0x59, 0x2E, // char '@' (0x40/64)
    0x36, 0x09, 0x09, 0x36, 0x00, // char 'A' (0x41/65)
    0x77, 0x49, 0x49, 0x36, 0x00, // char 'B' (0x42/66)
    0x36, 0x41, 0x41, 0x00, 0x00, // char 'C' (0x43/67)
    0x77, 0x41, 0x41, 0x36, 0x00, // char 'D' (0x44/68)
    0x36, 0x49, 0x49, 0x00, 0x00, // char 'E' (0x45/69)
    0x36, 0x09, 0x09, 0x00, 0x00, // char 'F' (0x46/70)
    0x36, 0x41, 0x51, 0x30, 0x00, // char 'G' (0x47/71)
    0x36, 0x08, 0x08, 0x36, 0x00, // char 'H' (0x48/72)
    0x00, 0x00, 0x36, 0x00, 0x00, // char 'I' (0x49/73)
    0x00, 0x40, 0x40, 0x36, 0x00, // char 'J' (0x4A/74)
    0x36, 0x08, 0x14, 0x22, 0x00, // char 'K' (0x4B/75)
    0x36, 0x40, 0x40, 0x00, 0x00, // char 'L' (0x4C/76)
    0x36, 0x01, 0x06, 0x01, 0x36, // char 'M' (0x4D/77)
    0x36, 0x04, 0x10, 0x36, 0x00, // char 'N' (0x4E/78)
    0x36, 0x41, 0x41, 0x36, 0x00, // char 'O' (0x4F/79)
    0x36, 0x09, 0x09, 0x06, 0x00, // char 'P' (0x50/80)
    0x36, 0x41, 0x21, 0x56, 0x00, // char 'Q' (0x51/81)
    0x36, 0x09, 0x19, 0x26, 0x00, // char 'R' (0x52/82)
    0x06, 0x49, 0x49, 0x30, 0x00, // char 'S' (0x53/83)
    0x00, 0x01, 0x37, 0x01, 0x00, // char 'T' (0x54/84)
    0x36, 0x40, 0x40, 0x36, 0x00, // char 'U' (0x55/85)
    0x36, 0x40, 0x36, 0x00, 0x00, // char 'V' (0x56/86)
    0x36, 0x40, 0x30, 0x40, 0x36, // char 'W' (0x57/87)
    0x36, 0x08, 0x08, 0x36, 0x00, // char 'X' (0x58/88)
    0x06, 0x48, 0x48, 0x36, 0x00, // char 'Y' (0x59/89)
    0x20, 0x51, 0x49, 0x45, 0x02, // char 'Z' (0x5A/90)
    0x77, 0x41, 0x41, 0x00, 0x00, // char '[' (0x5B/91)
    0x00, 0x06, 0x30, 0x00, 0x00, // char '\' (0x5C/92)
    0x00, 0x41, 0x41, 0x77, 0x00, // char ']' (0x5D/93)
    0x00, 0x02, 0x01, 0x02, 0x00, // char '^' (0x5E/94)
    0x00, 0x40, 0x40, 0x00, 0x00, // char '_' (0x5F/95)
    0x00, 0x01, 0x02, 0x00, 0x00, // char '`' (0x60/96)
    0x20, 0x54, 0x54, 0x38, 0x40, // char 'a' (0x61/97)
    0x00, 0x36, 0x48, 0x30, 0x00, // char 'b' (0x62/98)
    0x30, 0x48, 0x48, 0x00, 0x00, // char 'c' (0x63/99)
    0x30, 0x48, 0x48, 0x76, 0x00, // char 'd' (0x64/100)
    0x38, 0x54, 0x54, 0x08, 0x00, // char 'e' (0x65/101)
    0x08, 0x6C, 0x0A, 0x00, 0x00, // char 'f' (0x66/102)
    0x08, 0x54, 0x54, 0x38, 0x00, // char 'g' (0x67/103)
    0x36, 0x08, 0x08, 0x30, 0x00, // char 'h' (0x68/104)
    0x00, 0x34, 0x00, 0x00, 0x00, // char 'i' (0x69/105)
    0x00, 0x40, 0x34, 0x00, 0x00, // char 'j' (0x6A/106)
    0x36, 0x10, 0x28, 0x00, 0x00, // char 'k' (0x6B/107)
    0x36, 0x00, 0x00, 0x00, 0x00, // char 'l' (0x6C/108)
    0x30, 0x08, 0x10, 0x08, 0x30, // char 'm' (0x6D/109)
    0x30, 0x08, 0x08, 0x30, 0x00, // char 'n' (0x6E/110)
    0x30, 0x48, 0x48, 0x30, 0x00, // char 'o' (0x6F/111)
    0x78, 0x14, 0x14, 0x08, 0x00, // char 'p' (0x70/112)
    0x08, 0x14, 0x14, 0x68, 0x00, // char 'q' (0x71/113)
    0x30, 0x08, 0x08, 0x00, 0x00, // char 'r' (0x72/114)
    0x08, 0x54, 0x54, 0x20, 0x00, // char 's' (0x73/115)
    0x08, 0x2C, 0x48, 0x00, 0x00, // char 't' (0x74/116)
    0x30, 0x40, 0x40, 0x30, 0x00, // char 'u' (0x75/117)
    0x30, 0x40, 0x30, 0x00, 0x00, // char 'v' (0x76/118)
    0x30, 0x40, 0x20, 0x40, 0x30, // char 'w' (0x77/119)
    0x28, 0x10, 0x10, 0x28, 0x00, // char 'x' (0x78/120)
    0x08, 0x50, 0x50, 0x38, 0x00, // char 'y' (0x79/121)
    0x24, 0x34, 0x2C, 0x24, 0x00, // char 'z' (0x7A/122)
    0x08, 0x36, 0x41, 0x00, 0x00, // char '{' (0x7B/123)
    0x00, 0x36, 0x00, 0x00, 0x00, // char '|' (0x7C/124)
    0x00, 0x41, 0x36, 0x08, 0x00, // char '}' (0x7D/125)
    0x08, 0x08, 0x10, 0x10, 0x00, // char '~' (0x7E/126)
    0x36, 0x41, 0x36, 0x00, 0x00, // char '' (0x7F/127)
};

const uint8_t digital_font5x7_AB[] PROGMEM =
{
    0x00, 0x05, 0x07, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, // char ' ' (0x20/32)
    0x00, 0x00, 0x2E, 0x00, 0x00, // char '!' (0x21/33)
    0x06, 0x00, 0x06, 0x00, 0x00, // char '"' (0x22/34)
    0x14, 0x7F, 0x14, 0x7F, 0x14, // char '#' (0x23/35)
    0x06, 0x49, 0x7F, 0x49, 0x30, // char '$' (0x24/36)
    0x24, 0x10, 0x08, 0x24, 0x00, // char '%' (0x25/37)
    0x36, 0x49, 0x36, 0x50, 0x00, // char '&' (0x26/38)
    0x00, 0x00, 0x00, 0x06, 0x00, // char ''' (0x27/39)
    0x00, 0x41, 0x36, 0x00, 0x00, // char '(' (0x28/40)
    0x00, 0x36, 0x41, 0x00, 0x00, // char ')' (0x29/41)
    0x00, 0x08, 0x00, 0x00, 0x00, // char '*' (0x2A/42)
    0x00, 0x08, 0x1C, 0x08, 0x00, // char '+' (0x2B/43)
    0x40, 0x20, 0x00, 0x00, 0x00, // char ',' (0x2C/44)
    0x00, 0x08, 0x08, 0x00, 0x00, // char '-' (0x2D/45)
    0x20, 0x00, 0x00, 0x00, 0x00, // char '.' (0x2E/46)
    0x00, 0x30, 0x06, 0x00, 0x00, // char '/' (0x2F/47)
    0x36, 0x41, 0x41, 0x36, 0x00, // char '0' (0x30/48)
    0x00, 0x00, 0x00, 0x36, 0x00, // char '1' (0x31/49)
    0x30, 0x49, 0x49, 0x06, 0x00, // char '2' (0x32/50)
    0x00, 0x49, 0x49, 0x36, 0x00, // char '3' (0x33/51)
    0x06, 0x08, 0x08, 0x36, 0x00, // char '4' (0x34/52)
    0x06, 0x49, 0x49, 0x30, 0x00, // char '5' (0x35/53)
    0x36, 0x49, 0x49, 0x30, 0x00, // char '6' (0x36/54)
    0x00, 0x01, 0x01, 0x36, 0x00, // char '7' (0x37/55)
    0x36, 0x49, 0x49, 0x36, 0x00, // char '8' (0x38/56)
    0x06, 0x49, 0x49, 0x36, 0x00, // char '9' (0x39/57)
    0x00, 0x14, 0x00, 0x00, 0x00, // char ':' (0x3A/58)
    0x20, 0x14, 0x00, 0x00, 0x00, // char ';' (0x3B/59)
    0x00, 0x08, 0x14, 0x22, 0x00, // char '<' (0x3C/60)
    0x00, 0x14, 0x14, 0x14, 0x00, // char '=' (0x3D/61)
    0x00, 0x22, 0x14, 0x08, 0x00, // char '>' (0x3E/62)
    0x00, 0x01, 0x31, 0x06, 0x00, // char '?' (0x3F/63)
    0x36, 0x49, 0x55, 0x59, 0x2E, // char '@' (0x40/64)
    0x36, 0x09, 0x09, 0x36, 0x00, // char 'A' (0x41/65)
    0x77, 0x49, 0x49, 0x36, 0x00, // char 'B' (0x42/66)
    0x36, 0x41, 0x41, 0x00, 0x00, // char 'C' (0x43/67)
    0x77, 0x41, 0x41, 0x36, 0x00, // char 'D' (0x44/68)
    0x36, 0x49, 0x49, 0x00, 0x00, // char 'E' (0x45/69)
    0x36, 0x09, 0x09, 0x00, 0x00, // char 'F' (0x46/70)
    0x36, 0x41, 0x51, 0x30, 0x00, // char 'G' (0x47/71)
    0x36, 0x08, 0x08, 0x36, 0x00, // char 'H' (0x48/72)
    0x00, 0x00, 0x36, 0x00, 0x00, // char 'I' (0x49/73)
    0x00, 0x40, 0x40, 0x36, 0x00, // char 'J' (0x4A/74)
    0x36, 0x08, 0x14, 0x22, 0x00, // char 'K' (0x4B/75)
    0x36, 0x40, 0x40, 0x00, 0x00, // char 'L' (0x4C/76)
    0x36, 0x01, 0x06, 0x01, 0x36, // char 'M' (0x4D/77)
    0x36, 0x04, 0x10, 0x36, 0x00, // char 'N' (0x4E/78)
    0x36, 0x41, 0x41, 0x36, 0x00, // char 'O' (0x4F/79)
    0x36, 0x09, 0x09, 0x06, 0x00, // char 'P' (0x50/80)
    0x36, 0x41, 0x21, 0x56, 0x00, // char 'Q' (0x51/81)
    0x36, 0x09, 0x19, 0x26, 0x00, // char 'R' (0x52/82)
    0x06, 0x49, 0x49, 0x30, 0x00, // char 'S' (0x53/83)
    0x00, 0x01, 0x37, 0x01, 0x00, // char 'T' (0x54/84)
    0x36, 0x40, 0x40, 0x36, 0x00, // char 'U' (0x55/85)
    0x36, 0x40, 0x36, 0x00, 0x00, // char 'V' (0x56/86)
    0x36, 0x40, 0x30, 0x40, 0x36, // char 'W' (0x57/87)
    0x36, 0x08, 0x08, 0x36, 0x00, // char 'X' (0x58/88)
    0x06, 0x48, 0x48, 0x36, 0x00, // char 'Y' (0x59/89)
    0x20, 0x51, 0x49, 0x45, 0x02, // char 'Z' (0x5A/90)
    0x77, 0x41, 0x41, 0x00, 0x00, // char '[' (0x5B/91)
    0x00, 0x06, 0x30, 0x00, 0x00, // char '\' (0x5C/92)
    0x00, 0x41, 0x41, 0x77, 0x00, // char ']' (0x5D/93)
    0x00, 0x02, 0x01, 0x02, 0x00, // char '^' (0x5E/94)
    0x00, 0x40, 0x40, 0x00, 0x00, // char '_' (0x5F/95)
    0x00, 0x01, 0x02, 0x00, 0x00, // char '`' (0x60/96)
};

const PROGMEM uint8_t ssd1306xled_font5x7 []=
{
  0x00, 0x05, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, // sp
  0x00, 0x00, 0x5F, 0x00, 0x00, // !
  0x00, 0x03, 0x00, 0x03, 0x00, // "
  0x14, 0x3E, 0x14, 0x3E, 0x14, // #
  0x24, 0x2A, 0x7F, 0x2A, 0x12, // $
  0x43, 0x33, 0x08, 0x66, 0x61, // %
  0x36, 0x49, 0x55, 0x22, 0x50, // &
  0x00, 0x05, 0x03, 0x00, 0x00, // '
  0x00, 0x1C, 0x22, 0x41, 0x00, // (
  0x00, 0x41, 0x22, 0x1C, 0x00, // )
  0x14, 0x08, 0x3E, 0x08, 0x14, // *
  0x08, 0x08, 0x3E, 0x08, 0x08, // +
  0x00, 0x50, 0x30, 0x00, 0x00, // ,
  0x08, 0x08, 0x08, 0x08, 0x08, // -
  0x00, 0x60, 0x60, 0x00, 0x00, // .
  0x20, 0x10, 0x08, 0x04, 0x02, // /
  0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
  0x00, 0x04, 0x02, 0x7F, 0x00, // 1
  0x42, 0x61, 0x51, 0x49, 0x46, // 2
  0x22, 0x41, 0x49, 0x49, 0x36, // 3
  0x18, 0x14, 0x12, 0x7F, 0x10, // 4
  0x27, 0x45, 0x45, 0x45, 0x39, // 5
  0x3E, 0x49, 0x49, 0x49, 0x32, // 6
  0x01, 0x01, 0x71, 0x09, 0x07, // 7
  0x36, 0x49, 0x49, 0x49, 0x36, // 8
  0x26, 0x49, 0x49, 0x49, 0x3E, // 9
  0x00, 0x36, 0x36, 0x00, 0x00, // :
  0x00, 0x56, 0x36, 0x00, 0x00, // ;
  0x08, 0x14, 0x22, 0x41, 0x00, // <
  0x14, 0x14, 0x14, 0x14, 0x14, // =
  0x00, 0x41, 0x22, 0x14, 0x08, // >
  0x02, 0x01, 0x51, 0x09, 0x06, // ?
  0x3E, 0x41, 0x59, 0x55, 0x5E, // @
  0x7E, 0x09, 0x09, 0x09, 0x7E, // A
  0x7F, 0x49, 0x49, 0x49, 0x36, // B
  0x3E, 0x41, 0x41, 0x41, 0x22, // C
  0x7F, 0x41, 0x41, 0x41, 0x3E, // D
  0x7F, 0x49, 0x49, 0x49, 0x41, // E
  0x7F, 0x09, 0x09, 0x09, 0x01, // F
  0x3E, 0x41, 0x41, 0x49, 0x3A, // G
  0x7F, 0x08, 0x08, 0x08, 0x7F, // H
  0x00, 0x41, 0x7F, 0x41, 0x00, // I
  0x30, 0x40, 0x40, 0x40, 0x3F, // J
  0x7F, 0x08, 0x14, 0x22, 0x41, // K
  0x7F, 0x40, 0x40, 0x40, 0x40, // L
  0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
  0x7F, 0x02, 0x04, 0x08, 0x7F, // N
  0x3E, 0x41, 0x41, 0x41, 0x3E, // O
  0x7F, 0x09, 0x09, 0x09, 0x06, // P
  0x1E, 0x21, 0x21, 0x21, 0x5E, // Q
  0x7F, 0x09, 0x09, 0x09, 0x76, // R
  0x26, 0x49, 0x49, 0x49, 0x32, // S
  0x01, 0x01, 0x7F, 0x01, 0x01, // T
  0x3F, 0x40, 0x40, 0x40, 0x3F, // U
  0x1F, 0x20, 0x40, 0x20, 0x1F, // V
  0x7F, 0x20, 0x10, 0x20, 0x7F, // W
  0x41, 0x22, 0x1C, 0x22, 0x41, // X
  0x07, 0x08, 0x70, 0x08, 0x07, // Y
  0x61, 0x51, 0x49, 0x45, 0x43, // Z
  0x00, 0x7F, 0x41, 0x00, 0x00, // [
  0x02, 0x04, 0x08, 0x10, 0x20, // 55
  0x00, 0x00, 0x41, 0x7F, 0x00, // ]
  0x04, 0x02, 0x01, 0x02, 0x04, // ^
  0x40, 0x40, 0x40, 0x40, 0x40, // _
  0x00, 0x01, 0x02, 0x04, 0x00, // `
  0x20, 0x54, 0x54, 0x54, 0x78, // a
  0x7F, 0x44, 0x44, 0x44, 0x38, // b
  0x38, 0x44, 0x44, 0x44, 0x44, // c
  0x38, 0x44, 0x44, 0x44, 0x7F, // d
  0x38, 0x54, 0x54, 0x54, 0x18, // e
  0x04, 0x04, 0x7E, 0x05, 0x05, // f
  0x08, 0x54, 0x54, 0x54, 0x3C, // g
  0x7F, 0x08, 0x04, 0x04, 0x78, // h
  0x00, 0x44, 0x7D, 0x40, 0x00, // i
  0x20, 0x40, 0x44, 0x3D, 0x00, // j
  0x7F, 0x10, 0x28, 0x44, 0x00, // k
  0x00, 0x41, 0x7F, 0x40, 0x00, // l
  0x7C, 0x04, 0x78, 0x04, 0x78, // m
  0x7C, 0x08, 0x04, 0x04, 0x78, // n
  0x38, 0x44, 0x44, 0x44, 0x38, // o
  0x7C, 0x14, 0x14, 0x14, 0x08, // p
  0x08, 0x14, 0x14, 0x14, 0x7C, // q
  0x00, 0x7C, 0x08, 0x04, 0x04, // r
  0x48, 0x54, 0x54, 0x54, 0x20, // s
  0x04, 0x04, 0x3F, 0x44, 0x44, // t
  0x3C, 0x40, 0x40, 0x20, 0x7C, // u
  0x1C, 0x20, 0x40, 0x20, 0x1C, // v
  0x3C, 0x40, 0x30, 0x40, 0x3C, // w
  0x44, 0x28, 0x10, 0x28, 0x44, // x
  0x0C, 0x50, 0x50, 0x50, 0x3C, // y
  0x44, 0x64, 0x54, 0x4C, 0x44, // z
  0x00, 0x08, 0x36, 0x41, 0x41, // {
  0x00, 0x00, 0x7F, 0x00, 0x00, // |
  0x41, 0x41, 0x36, 0x08, 0x00, // }
  0x02, 0x01, 0x02, 0x04, 0x02, // ~
  0x14, 0x14, 0x14, 0x14, 0x14, // horiz lines // DEL
  0x00 /* This byte is required for italic type of font */
};

const PROGMEM uint8_t ssd1306xled_font5x7_AB []=
{
  0x00, 0x05, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, // sp
  0x00, 0x00, 0x5F, 0x00, 0x00, // !
  0x00, 0x03, 0x00, 0x03, 0x00, // "
  0x14, 0x3E, 0x14, 0x3E, 0x14, // #
  0x24, 0x2A, 0x7F, 0x2A, 0x12, // $
  0x43, 0x33, 0x08, 0x66, 0x61, // %
  0x36, 0x49, 0x55, 0x22, 0x50, // &
  0x00, 0x05, 0x03, 0x00, 0x00, // '
  0x00, 0x1C, 0x22, 0x41, 0x00, // (
  0x00, 0x41, 0x22, 0x1C, 0x00, // )
  0x14, 0x08, 0x3E, 0x08, 0x14, // *
  0x08, 0x08, 0x3E, 0x08, 0x08, // +
  0x00, 0x50, 0x30, 0x00, 0x00, // ,
  0x08, 0x08, 0x08, 0x08, 0x08, // -
  0x00, 0x60, 0x60, 0x00, 0x00, // .
  0x20, 0x10, 0x08, 0x04, 0x02, // /
  0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
  0x00, 0x04, 0x02, 0x7F, 0x00, // 1
  0x42, 0x61, 0x51, 0x49, 0x46, // 2
  0x22, 0x41, 0x49, 0x49, 0x36, // 3
  0x18, 0x14, 0x12, 0x7F, 0x10, // 4
  0x27, 0x45, 0x45, 0x45, 0x39, // 5
  0x3E, 0x49, 0x49, 0x49, 0x32, // 6
  0x01, 0x01, 0x71, 0x09, 0x07, // 7
  0x36, 0x49, 0x49, 0x49, 0x36, // 8
  0x26, 0x49, 0x49, 0x49, 0x3E, // 9
  0x00, 0x36, 0x36, 0x00, 0x00, // :
  0x00, 0x56, 0x36, 0x00, 0x00, // ;
  0x08, 0x14, 0x22, 0x41, 0x00, // <
  0x14, 0x14, 0x14, 0x14, 0x14, // =
  0x00, 0x41, 0x22, 0x14, 0x08, // >
  0x02, 0x01, 0x51, 0x09, 0x06, // ?
  0x3E, 0x41, 0x59, 0x55, 0x5E, // @
  0x7E, 0x09, 0x09, 0x09, 0x7E, // A
  0x7F, 0x49, 0x49, 0x49, 0x36, // B
  0x3E, 0x41, 0x41, 0x41, 0x22, // C
  0x7F, 0x41, 0x41, 0x41, 0x3E, // D
  0x7F, 0x49, 0x49, 0x49, 0x41, // E
  0x7F, 0x09, 0x09, 0x09, 0x01, // F
  0x3E, 0x41, 0x41, 0x49, 0x3A, // G
  0x7F, 0x08, 0x08, 0x08, 0x7F, // H
  0x00, 0x41, 0x7F, 0x41, 0x00, // I
  0x30, 0x40, 0x40, 0x40, 0x3F, // J
  0x7F, 0x08, 0x14, 0x22, 0x41, // K
  0x7F, 0x40, 0x40, 0x40, 0x40, // L
  0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
  0x7F, 0x02, 0x04, 0x08, 0x7F, // N
  0x3E, 0x41, 0x41, 0x41, 0x3E, // O
  0x7F, 0x09, 0x09, 0x09, 0x06, // P
  0x1E, 0x21, 0x21, 0x21, 0x5E, // Q
  0x7F, 0x09, 0x09, 0x09, 0x76, // R
  0x26, 0x49, 0x49, 0x49, 0x32, // S
  0x01, 0x01, 0x7F, 0x01, 0x01, // T
  0x3F, 0x40, 0x40, 0x40, 0x3F, // U
  0x1F, 0x20, 0x40, 0x20, 0x1F, // V
  0x7F, 0x20, 0x10, 0x20, 0x7F, // W
  0x41, 0x22, 0x1C, 0x22, 0x41, // X
  0x07, 0x08, 0x70, 0x08, 0x07, // Y
  0x61, 0x51, 0x49, 0x45, 0x43, // Z
  0x00, 0x7F, 0x41, 0x00, 0x00, // [
  0x02, 0x04, 0x08, 0x10, 0x20, // 55
  0x00, 0x00, 0x41, 0x7F, 0x00, // ]
  0x04, 0x02, 0x01, 0x02, 0x04, // ^
  0x40, 0x40, 0x40, 0x40, 0x40, // _
  0x00, 0x01, 0x02, 0x04, 0x00, // `
  0x00,
};


/* Standard ASCII 11x16 font with digits only (Ascii codes 32 - 64) */
const PROGMEM uint8_t courier_new_font11x16_digits []=
{
    0x00, 0x0B, 0x10, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // char  
    0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00,  // char !
    0x00, 0x00, 0x1C, 0xFC, 0x1C, 0x00, 0x00, 0x1C, 0xFC, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // char "
    0x30, 0x30, 0xFF, 0xFF, 0x30, 0x30, 0xFF, 0xFF, 0x30, 0x30, 0x00, 0x03, 0x03, 0x3F, 0x3F, 0x03, 0x03, 0x3F, 0x3F, 0x03, 0x03, 0x00,  // char #
    0x00, 0x38, 0x7C, 0x4C, 0xCF, 0xCF, 0xCC, 0x9C, 0x9C, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0C, 0x7C, 0x7C, 0x0C, 0x0F, 0x07, 0x00, 0x00,  // char $
    0x00, 0x1C, 0xA2, 0xA2, 0xE2, 0xDC, 0x40, 0x60, 0x20, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x0E, 0x11, 0x11, 0x11, 0x0E, 0x00, 0x00,  // char %
    0x00, 0x00, 0xB0, 0xF8, 0xCC, 0x8C, 0x0C, 0x0C, 0x8C, 0x80, 0x00, 0x00, 0x0F, 0x0F, 0x19, 0x18, 0x19, 0x1B, 0x0F, 0x1F, 0x19, 0x00,  // char &
    0x00, 0x00, 0x00, 0x00, 0x1C, 0xFC, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // char '
    0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xF8, 0x1E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1F, 0x78, 0x60, 0x00, 0x00,  // char (
    0x00, 0x00, 0x06, 0x1E, 0xF8, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,  // char )
    0x00, 0x00, 0x18, 0x98, 0xF0, 0xFE, 0xFE, 0xF0, 0x98, 0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,  // char *
    0x80, 0x80, 0x80, 0x80, 0xF8, 0xF8, 0x80, 0x80, 0x80, 0x80, 0x00, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x1F, 0x01, 0x01, 0x01, 0x01, 0x00,  // char +
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3C, 0x04, 0x00, 0x00, 0x00, 0x00,  // char ,
    0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // char -
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00,  // char .
    0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xFC, 0x1F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7C, 0x1F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,  // char /
    0x00, 0xF0, 0xFC, 0x0E, 0x06, 0x06, 0x0E, 0xFC, 0xF0, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x18, 0x18, 0x1C, 0x0F, 0x03, 0x00, 0x00,  // char 0
    0x00, 0x0C, 0x0C, 0x0C, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x00, 0x00,  // char 1
    0x00, 0x18, 0x1C, 0x0E, 0x06, 0x86, 0xCE, 0x7C, 0x38, 0x00, 0x00, 0x00, 0x18, 0x1C, 0x1E, 0x1B, 0x19, 0x18, 0x18, 0x18, 0x00, 0x00,  // char 2
    0x00, 0x0C, 0x0C, 0xC6, 0xC6, 0xC6, 0xE6, 0xFC, 0x38, 0x00, 0x00, 0x0C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x19, 0x0F, 0x07, 0x00, 0x00,  // char 3
    0x00, 0x80, 0xC0, 0x70, 0x38, 0x0E, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x1B, 0x1B, 0x1F, 0x1F, 0x1B, 0x00, 0x00,  // char 4
    0x00, 0x00, 0xFE, 0xFE, 0x66, 0x66, 0xE6, 0xC6, 0x80, 0x00, 0x00, 0x00, 0x0C, 0x1C, 0x18, 0x18, 0x18, 0x1C, 0x0F, 0x07, 0x00, 0x00,  // char 5
    0x00, 0xE0, 0xF8, 0xDC, 0x6C, 0x66, 0xE6, 0xC6, 0x86, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x18, 0x18, 0x1C, 0x0F, 0x07, 0x00, 0x00,  // char 6
    0x00, 0x0E, 0x0E, 0x06, 0x06, 0x86, 0xF6, 0xFE, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00,  // char 7
    0x00, 0x38, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xFC, 0x38, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x18, 0x18, 0x18, 0x18, 0x0F, 0x07, 0x00, 0x00,  // char 8
    0x00, 0x78, 0xFC, 0xCE, 0x86, 0x86, 0xCE, 0xFC, 0xF0, 0x00, 0x00, 0x00, 0x18, 0x18, 0x19, 0x19, 0x0D, 0x0E, 0x07, 0x01, 0x00, 0x00,  // char 9
    0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00,  // char :
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x38, 0x0C, 0x04, 0x00, 0x00, 0x00,  // char ;
    0x80, 0xC0, 0xC0, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0C, 0x0C, 0x00, 0x00, 0x01, 0x01, 0x03, 0x06, 0x06, 0x0C, 0x0C, 0x18, 0x18, 0x00,  // char <
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,  // char =
    0x0C, 0x0C, 0x18, 0x18, 0x30, 0x30, 0x60, 0xC0, 0xC0, 0x80, 0x80, 0x18, 0x18, 0x0C, 0x0C, 0x06, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00,  // char >
    0x00, 0x00, 0x38, 0x3C, 0x8C, 0x8C, 0xCC, 0xFC, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x19, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,  // char ?
    0x00, 0x00, 0xF8, 0x04, 0xC2, 0x22, 0x22, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x10, 0x21, 0x22, 0x22, 0x13, 0x00, 0x00, 0x00,  // char @
    0x00 /* This byte is required for italic type of font */
};

const uint8_t comic_sans_font24x32_123[] PROGMEM =
{
    0x00, 0x18, 0x20, 0x20,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char  
    0x00,  0x00,  0xF0,  0xF8,  0xF8,  0xF0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x7F,  0xFF,  0xFF,  0x7F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0C,  0x1E,  0x1E,  0x0C,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char !
    0x00,  0xF8,  0xF8,  0xF8,  0x00,  0x00,  0x00,  0xF8,  0xF8,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0F,  0x1F,  0x1F,  0x00,  0x00,  0x00,  0x1F,  0x1F,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char "
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xF0,  0xF8,  0xF8,  0x70,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xF0,  0xF8,  0xF8,  0x70,  0x00,  0x00,  0x06,  0x0F,  0x0F,  0x0F,  0x8F,  0xFF,  0xFF,  0xFF,  0xFF,  0x1F,  0x0F,  0x0F,  0x0F,  0x0F,  0x8F,  0xFF,  0xFF,  0xFF,  0xFF,  0x1F,  0x0F,  0x0F,  0x1C,  0x3C,  0x3C,  0xFC,  0xFC,  0xFE,  0xFF,  0x7F,  0x3F,  0x3F,  0x3C,  0x3C,  0x3C,  0x3C,  0xFC,  0xFC,  0xFF,  0xFF,  0x3F,  0x3F,  0x3C,  0x3C,  0x3C,  0x3C,  0x00,  0x00,  0x0E,  0x1F,  0x1F,  0x1F,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x1E,  0x1F,  0x1F,  0x0F,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char #
    0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xC0,  0xE0,  0xFE,  0xFF,  0xFF,  0xFF,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x78,  0xFE,  0xFF,  0xFF,  0xE7,  0xC3,  0xC1,  0xFF,  0xFF,  0xFF,  0xFF,  0xC0,  0xC0,  0xC1,  0x81,  0x81,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x01,  0x03,  0x03,  0x03,  0xFF,  0xFF,  0xFF,  0xFF,  0x03,  0x03,  0x07,  0x8F,  0xFF,  0xFF,  0xFE,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,  0x06,  0x0F,  0x1F,  0x1F,  0x1E,  0x1E,  0x1E,  0xFF,  0xFF,  0xFF,  0xFF,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,   // Code for char $
    0x00,  0x00,  0xE0,  0xF0,  0xF8,  0xFC,  0x3C,  0x3C,  0x3C,  0xFC,  0xF8,  0xF0,  0xE0,  0x00,  0x00,  0x00,  0xC0,  0xE0,  0xF0,  0xF0,  0x60,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x07,  0xC3,  0xF0,  0xFC,  0xFF,  0x3F,  0x1F,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xF8,  0xFE,  0xFF,  0x3F,  0x0F,  0x03,  0xF0,  0xFC,  0xFE,  0xFF,  0x1F,  0x0F,  0x0F,  0x1F,  0xFE,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x06,  0x0F,  0x0F,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x07,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x07,   // Code for char %
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xCF,  0xFF,  0xFF,  0xFF,  0xF8,  0xF8,  0x7F,  0x3F,  0x1F,  0x07,  0x80,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xF8,  0xFC,  0xFE,  0xFF,  0x0F,  0x07,  0x03,  0x01,  0x03,  0x0F,  0x3F,  0xFF,  0xFE,  0xF8,  0xFF,  0xFF,  0xFF,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x07,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x03,  0x0F,  0x1F,  0x3F,  0x3E,  0x18,  0x00,  0x00,  0x00,  0x00,   // Code for char &
    0x00,  0x00,  0x00,  0x00,  0x00,  0xF8,  0xF8,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x1F,  0x1F,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char '
    0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF0,  0xF8,  0x78,  0x30,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xF8,  0xFE,  0xFF,  0x7F,  0x0F,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x0F,  0x3F,  0xFF,  0xFF,  0xF8,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char (
    0x00,  0x30,  0x78,  0xF8,  0xF0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x0F,  0x7F,  0xFF,  0xFE,  0xF8,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF8,  0xFF,  0xFF,  0x3F,  0x0F,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char )
    0x00,  0x80,  0xC0,  0xC0,  0x80,  0x80,  0xF0,  0xF8,  0xF8,  0xF0,  0x80,  0x80,  0x80,  0x80,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x33,  0x7B,  0x7B,  0x3F,  0x1F,  0x1F,  0x0F,  0x3F,  0x7F,  0xFF,  0xF7,  0x67,  0x03,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char *
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xE0,  0xF0,  0xF0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x06,  0x0E,  0x0E,  0x0E,  0x0E,  0xFF,  0xFF,  0xFF,  0x0E,  0x0E,  0x0E,  0x0E,  0x0E,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char +
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xF8,  0xFC,  0x7C,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char ,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x08,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x1C,  0x08,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char -
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x18,  0x3C,  0x3C,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char .
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xF0,  0xF0,  0x60,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xF8,  0xFE,  0xFF,  0x3F,  0x0F,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xF0,  0xFC,  0xFE,  0x7F,  0x1F,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0C,  0x1F,  0x1F,  0x0F,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char /
    0x00,  0x00,  0x00,  0x00,  0xC0,  0xC0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xF0,  0xFE,  0xFF,  0xFF,  0x0F,  0x03,  0x01,  0x00,  0x00,  0x00,  0x00,  0x01,  0x01,  0x07,  0xFF,  0xFF,  0xFF,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x1F,  0xFF,  0xFF,  0xFF,  0xE0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xFF,  0xFF,  0xFF,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x0F,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 0
    0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0x80,  0xC0,  0xE0,  0xF0,  0xF0,  0xF0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x07,  0x0F,  0x0F,  0x07,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x06,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x06,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 1
    0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x07,  0x03,  0x03,  0x01,  0x80,  0x80,  0xC0,  0xE0,  0xF1,  0xFF,  0xFF,  0x7F,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xE0,  0xF8,  0xFC,  0xFE,  0x3E,  0x1F,  0x0F,  0x07,  0x07,  0x03,  0x01,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x07,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0E,  0x06,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 2
    0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x03,  0xC1,  0xE1,  0xE0,  0xE0,  0xF0,  0xF0,  0xF9,  0xFF,  0x7F,  0x3F,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xC0,  0x80,  0x00,  0x01,  0x01,  0x01,  0x03,  0x03,  0x87,  0xFF,  0xFF,  0xFE,  0xFC,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x0F,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 3
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF0,  0xF0,  0xE0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xE0,  0xF0,  0xF8,  0xFC,  0x7E,  0x1F,  0x0F,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x18,  0x3C,  0x3E,  0x3F,  0x3F,  0x3F,  0x3F,  0x3D,  0x3C,  0x3C,  0x3C,  0x3C,  0xFF,  0xFF,  0xFF,  0xFF,  0x3C,  0x3C,  0x3C,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x07,  0x0F,  0x0F,  0x07,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 4
    0x00,  0x20,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0x60,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xF0,  0xFF,  0xFF,  0xFF,  0xF8,  0xFC,  0x7C,  0x7C,  0x3C,  0x3C,  0x3C,  0x3C,  0x7C,  0xF8,  0xF8,  0xF0,  0xE0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x81,  0xC3,  0xC3,  0xC3,  0x81,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xFF,  0xFF,  0xFF,  0x3F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x0F,  0x0F,  0x1F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 5
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF0,  0xF0,  0xF0,  0x60,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xF0,  0xFC,  0xFE,  0xFF,  0xDF,  0xEF,  0xE7,  0xE3,  0xE1,  0xE0,  0xE0,  0xE0,  0xC0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x7F,  0xFF,  0xFF,  0xFF,  0x83,  0x03,  0x01,  0x01,  0x01,  0x01,  0x01,  0x01,  0x03,  0x87,  0xFF,  0xFF,  0xFF,  0xFC,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x07,  0x0F,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 6
    0x00,  0x60,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0x60,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xE0,  0xF0,  0xFC,  0xFE,  0xFF,  0x3F,  0x0F,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xF0,  0xFC,  0xFF,  0xFF,  0x3F,  0x0F,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0E,  0x1F,  0x1F,  0x1F,  0x07,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 7
    0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x1F,  0x7F,  0xFF,  0xFF,  0xF1,  0xF0,  0xE0,  0xE0,  0xE0,  0xE0,  0xF0,  0xF1,  0xFF,  0xFF,  0xBF,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xF8,  0xFE,  0xFF,  0xFF,  0x8F,  0x07,  0x03,  0x03,  0x01,  0x01,  0x03,  0x03,  0x03,  0x87,  0xFF,  0xFF,  0xFF,  0xFC,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x07,  0x0F,  0x0F,  0x1F,  0x1E,  0x1E,  0x1E,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 8
    0x00,  0x00,  0x80,  0xC0,  0xC0,  0xE0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x7E,  0xFF,  0xFF,  0xFF,  0xC3,  0x81,  0x00,  0x00,  0x00,  0x00,  0x00,  0x81,  0x83,  0xC7,  0xFF,  0xFF,  0xFF,  0xFC,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x07,  0x07,  0x0F,  0x0F,  0x8F,  0x8F,  0xCF,  0xCF,  0xFF,  0xFF,  0xFF,  0x7F,  0x3F,  0x0F,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0C,  0x1E,  0x1E,  0x1E,  0x1F,  0x0F,  0x0F,  0x07,  0x07,  0x03,  0x03,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char 9
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x70,  0xF8,  0xF8,  0xF8,  0x70,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xC0,  0xE0,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x03,  0x07,  0x07,  0x07,  0x03,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char :
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x70,  0xF8,  0xF8,  0xF8,  0x70,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x30,  0x7C,  0x7E,  0x3F,  0x0F,  0x06,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char ;
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xF0,  0xF0,  0xF8,  0x78,  0x30,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x06,  0x0E,  0x0F,  0x1F,  0x3F,  0x7F,  0xFB,  0xF1,  0xE0,  0xE0,  0xC0,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x01,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char <
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0xE3,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char =
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x30,  0x78,  0xF8,  0xF8,  0xF0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x80,  0xC0,  0xE0,  0xE0,  0xF1,  0xF9,  0xFB,  0x7F,  0x7F,  0x3F,  0x1F,  0x0E,  0x0E,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x03,  0x03,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char >
    0x00,  0x00,  0x80,  0xC0,  0xE0,  0xE0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xE0,  0xE0,  0xC0,  0x80,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x03,  0x03,  0x01,  0x01,  0x00,  0x00,  0x00,  0x81,  0x81,  0xC3,  0xFF,  0xFF,  0xFF,  0x7C,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x38,  0x7C,  0x7C,  0x7E,  0x1F,  0x1F,  0x0F,  0x07,  0x03,  0x03,  0x01,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0E,  0x1F,  0x1F,  0x1F,  0x0E,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   // Code for char ?
};

// ----------------------------------------------------------------------------
/// ##################################################################################################
/// Calibri
// ---------------------------------------------
// -@--@@--@----------@----@-@--------@@@--@@---
// -@--@@--@----------@----@-@-------@--@-@-@---
// -@--@@--@-@@@@-@@@-@--@@@-@---@@@-@--@---@---
// --@@-@@@--@--@-@---@-@--@-@--@--@-@--@---@---
// --@@--@@--@--@-@---@-@--@-@--@--@-@--@---@---
// --@@--@@--@--@-@---@-@--@----@--@-@--@---@---
// --@@--@@--@@@@-@---@--@@@-@@--@@@-@@@--@@@@@-
// --------------------------------@------------
// --------------------------------@------------
const uint8_t free_calibri11x12[] PROGMEM =
{
//  type|width|height|first char
    0x02, 0x0B, 0x0A, 0x20,
// GROUP first ' ' total 96 chars
//  unicode(LSB,MSB)|count
    0x00, 0x20, 0x60, // unicode record
    0x00, 0x00, 0x00, 0x00, // char ' ' (0x0020/32)
    0x00, 0x00, 0x02, 0x08, // char '!' (0x0021/33)
    0x00, 0x02, 0x03, 0x04, // char '"' (0x0022/34)
    0x00, 0x05, 0x05, 0x08, // char '#' (0x0023/35)
    0x00, 0x0A, 0x05, 0x09, // char '$' (0x0024/36)
    0x00, 0x14, 0x07, 0x08, // char '%' (0x0025/37)
    0x00, 0x1B, 0x07, 0x08, // char '&' (0x0026/38)
    0x00, 0x22, 0x01, 0x04, // char ''' (0x0027/39)
    0x00, 0x23, 0x02, 0x0A, // char '(' (0x0028/40)
    0x00, 0x27, 0x02, 0x0A, // char ')' (0x0029/41)
    0x00, 0x2B, 0x04, 0x04, // char '*' (0x002A/42)
    0x00, 0x2F, 0x05, 0x07, // char '+' (0x002B/43)
    0x00, 0x34, 0x02, 0x0A, // char ',' (0x002C/44)
    0x00, 0x38, 0x03, 0x06, // char '-' (0x002D/45)
    0x00, 0x3B, 0x01, 0x08, // char '.' (0x002E/46)
    0x00, 0x3C, 0x04, 0x0A, // char '/' (0x002F/47)
    0x00, 0x44, 0x04, 0x08, // char '0' (0x0030/48)
    0x00, 0x48, 0x05, 0x08, // char '1' (0x0031/49)
    0x00, 0x4D, 0x04, 0x08, // char '2' (0x0032/50)
    0x00, 0x51, 0x04, 0x08, // char '3' (0x0033/51)
    0x00, 0x55, 0x06, 0x08, // char '4' (0x0034/52)
    0x00, 0x5B, 0x04, 0x08, // char '5' (0x0035/53)
    0x00, 0x5F, 0x04, 0x08, // char '6' (0x0036/54)
    0x00, 0x63, 0x04, 0x08, // char '7' (0x0037/55)
    0x00, 0x67, 0x04, 0x08, // char '8' (0x0038/56)
    0x00, 0x6B, 0x04, 0x08, // char '9' (0x0039/57)
    0x00, 0x6F, 0x02, 0x08, // char ':' (0x003A/58)
    0x00, 0x71, 0x03, 0x0A, // char ';' (0x003B/59)
    0x00, 0x77, 0x05, 0x07, // char '<' (0x003C/60)
    0x00, 0x7C, 0x04, 0x07, // char '=' (0x003D/61)
    0x00, 0x80, 0x04, 0x07, // char '>' (0x003E/62)
    0x00, 0x84, 0x04, 0x08, // char '?' (0x003F/63)
    0x00, 0x88, 0x09, 0x09, // char '@' (0x0040/64)
    0x00, 0x9A, 0x06, 0x08, // char 'A' (0x0041/65)
    0x00, 0xA0, 0x04, 0x08, // char 'B' (0x0042/66)
    0x00, 0xA4, 0x05, 0x08, // char 'C' (0x0043/67)
    0x00, 0xA9, 0x05, 0x08, // char 'D' (0x0044/68)
    0x00, 0xAE, 0x04, 0x08, // char 'E' (0x0045/69)
    0x00, 0xB2, 0x04, 0x08, // char 'F' (0x0046/70)
    0x00, 0xB6, 0x05, 0x08, // char 'G' (0x0047/71)
    0x00, 0xBB, 0x05, 0x08, // char 'H' (0x0048/72)
    0x00, 0xC0, 0x01, 0x08, // char 'I' (0x0049/73)
    0x00, 0xC1, 0x03, 0x08, // char 'J' (0x004A/74)
    0x00, 0xC4, 0x05, 0x08, // char 'K' (0x004B/75)
    0x00, 0xC9, 0x04, 0x08, // char 'L' (0x004C/76)
    0x00, 0xCD, 0x07, 0x08, // char 'M' (0x004D/77)
    0x00, 0xD4, 0x05, 0x08, // char 'N' (0x004E/78)
    0x00, 0xD9, 0x05, 0x08, // char 'O' (0x004F/79)
    0x00, 0xDE, 0x04, 0x08, // char 'P' (0x0050/80)
    0x00, 0xE2, 0x06, 0x09, // char 'Q' (0x0051/81)
    0x00, 0xEE, 0x05, 0x08, // char 'R' (0x0052/82)
    0x00, 0xF3, 0x04, 0x08, // char 'S' (0x0053/83)
    0x00, 0xF7, 0x05, 0x08, // char 'T' (0x0054/84)
    0x00, 0xFC, 0x05, 0x08, // char 'U' (0x0055/85)
    0x01, 0x01, 0x06, 0x08, // char 'V' (0x0056/86)
    0x01, 0x07, 0x09, 0x08, // char 'W' (0x0057/87)
    0x01, 0x10, 0x06, 0x08, // char 'X' (0x0058/88)
    0x01, 0x16, 0x05, 0x08, // char 'Y' (0x0059/89)
    0x01, 0x1B, 0x05, 0x08, // char 'Z' (0x005A/90)
    0x01, 0x20, 0x02, 0x0A, // char '[' (0x005B/91)
    0x01, 0x24, 0x04, 0x09, // char '\' (0x005C/92)
    0x01, 0x2C, 0x02, 0x0A, // char ']' (0x005D/93)
    0x01, 0x30, 0x04, 0x05, // char '^' (0x005E/94)
    0x01, 0x34, 0x06, 0x08, // char '_' (0x005F/95)
    0x01, 0x3A, 0x03, 0x02, // char '`' (0x0060/96)
    0x01, 0x3D, 0x04, 0x08, // char 'a' (0x0061/97)
    0x01, 0x41, 0x04, 0x08, // char 'b' (0x0062/98)
    0x01, 0x45, 0x04, 0x08, // char 'c' (0x0063/99)
    0x01, 0x49, 0x04, 0x08, // char 'd' (0x0064/100)
    0x01, 0x4D, 0x04, 0x08, // char 'e' (0x0065/101)
    0x01, 0x51, 0x04, 0x08, // char 'f' (0x0066/102)
    0x01, 0x55, 0x05, 0x0A, // char 'g' (0x0067/103)
    0x01, 0x5F, 0x04, 0x08, // char 'h' (0x0068/104)
    0x01, 0x63, 0x01, 0x08, // char 'i' (0x0069/105)
    0x01, 0x64, 0x02, 0x0A, // char 'j' (0x006A/106)
    0x01, 0x68, 0x04, 0x08, // char 'k' (0x006B/107)
    0x01, 0x6C, 0x01, 0x08, // char 'l' (0x006C/108)
    0x01, 0x6D, 0x07, 0x08, // char 'm' (0x006D/109)
    0x01, 0x74, 0x04, 0x08, // char 'n' (0x006E/110)
    0x01, 0x78, 0x04, 0x08, // char 'o' (0x006F/111)
    0x01, 0x7C, 0x04, 0x0A, // char 'p' (0x0070/112)
    0x01, 0x84, 0x04, 0x0A, // char 'q' (0x0071/113)
    0x01, 0x8C, 0x03, 0x08, // char 'r' (0x0072/114)
    0x01, 0x8F, 0x03, 0x08, // char 's' (0x0073/115)
    0x01, 0x92, 0x03, 0x08, // char 't' (0x0074/116)
    0x01, 0x95, 0x04, 0x08, // char 'u' (0x0075/117)
    0x01, 0x99, 0x05, 0x08, // char 'v' (0x0076/118)
    0x01, 0x9E, 0x08, 0x08, // char 'w' (0x0077/119)
    0x01, 0xA6, 0x04, 0x08, // char 'x' (0x0078/120)
    0x01, 0xAA, 0x05, 0x0A, // char 'y' (0x0079/121)
    0x01, 0xB4, 0x04, 0x08, // char 'z' (0x007A/122)
    0x01, 0xB8, 0x03, 0x0A, // char '{' (0x007B/123)
    0x01, 0xBE, 0x01, 0x0A, // char '|' (0x007C/124)
    0x01, 0xC0, 0x02, 0x0A, // char '}' (0x007D/125)
    0x01, 0xC4, 0x05, 0x04, // char '~' (0x007E/126)
    0x01, 0xC9, 0x06, 0x08, // char '' (0x007F/127)
//    0x01, 0xD0,
    0x01, 0xCF,
    // char ' ' (0x0020/32)
    0xBE, 0x80, // char '!' (0x0021/33)
    0x0E, 0x00, 0x0E, // char '"' (0x0022/34)
    0x28, 0xFE, 0x28, 0xF8, 0x2E, // char '#' (0x0023/35)
    0x80, 0x8E, 0x92, 0x93, 0x62, 0x00, 0x00, 0x01, 0x00, 0x00, // char '$' (0x0024/36)
    0x1E, 0x92, 0x7E, 0x10, 0xFC, 0x92, 0xF0, // char '%' (0x0025/37)
    0x00, 0xE4, 0x9A, 0xAA, 0xCE, 0x70, 0x80, // char '&' (0x0026/38)
    0x0E, // char ''' (0x0027/39)
    0xFC, 0x03, 0x00, 0x03, // char '(' (0x0028/40)
    0x03, 0xFC, 0x03, 0x00, // char ')' (0x0029/41)
    0x06, 0x0F, 0x06, 0x00, // char '*' (0x002A/42)
    0x10, 0x10, 0x7C, 0x10, 0x10, // char '+' (0x002B/43)
    0x00, 0x80, 0x02, 0x01, // char ',' (0x002C/44)
    0x20, 0x20, 0x20, // char '-' (0x002D/45)
    0x80, // char '.' (0x002E/46)
    0x00, 0xE0, 0x1C, 0x03, 0x03, 0x00, 0x00, 0x00, // char '/' (0x002F/47)
    0xFC, 0x82, 0x82, 0x7E, // char '0' (0x0030/48)
    0x84, 0x82, 0xFE, 0x80, 0x80, // char '1' (0x0031/49)
    0x84, 0xC2, 0xA2, 0x9C, // char '2' (0x0032/50)
    0x82, 0x92, 0x92, 0x6E, // char '3' (0x0033/51)
    0x30, 0x28, 0x26, 0xFE, 0x20, 0x20, // char '4' (0x0034/52)
    0x9E, 0x92, 0x92, 0x62, // char '5' (0x0035/53)
    0x7C, 0x96, 0x92, 0x72, // char '6' (0x0036/54)
    0xC2, 0x72, 0x1E, 0x06, // char '7' (0x0037/55)
    0xEC, 0x92, 0x92, 0x6E, // char '8' (0x0038/56)
    0x9C, 0x92, 0xD2, 0x7C, // char '9' (0x0039/57)
    0x88, 0x88, // char ':' (0x003A/58)
    0x00, 0x88, 0x88, 0x02, 0x01, 0x00, // char ';' (0x003B/59)
    0x10, 0x30, 0x28, 0x28, 0x44, // char '<' (0x003C/60)
    0x50, 0x50, 0x50, 0x50, // char '=' (0x003D/61)
    0x44, 0x28, 0x28, 0x10, // char '>' (0x003E/62)
    0x02, 0xB2, 0x92, 0x0C, // char '?' (0x003F/63)
    0x00, 0xF8, 0x84, 0x72, 0x4A, 0x6A, 0x7A, 0x42, 0x3C, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, // char '@' (0x0040/64)
    0x80, 0x70, 0x2E, 0x26, 0x38, 0xC0, // char 'A' (0x0041/65)
    0xFE, 0x92, 0x92, 0x6E, // char 'B' (0x0042/66)
    0x7C, 0xC6, 0x82, 0x82, 0x44, // char 'C' (0x0043/67)
    0xFE, 0x82, 0x82, 0xC6, 0x7C, // char 'D' (0x0044/68)
    0xFE, 0x92, 0x92, 0x92, // char 'E' (0x0045/69)
    0xFE, 0x12, 0x12, 0x12, // char 'F' (0x0046/70)
    0x7C, 0xC6, 0x82, 0x92, 0xF6, // char 'G' (0x0047/71)
    0xFE, 0x10, 0x10, 0x10, 0xFE, // char 'H' (0x0048/72)
    0xFE, // char 'I' (0x0049/73)
    0x80, 0x80, 0xFE, // char 'J' (0x004A/74)
    0xFE, 0x10, 0x3C, 0xC6, 0x82, // char 'K' (0x004B/75)
    0xFE, 0x80, 0x80, 0x80, // char 'L' (0x004C/76)
    0xFE, 0x06, 0x38, 0xC0, 0x38, 0x06, 0xFE, // char 'M' (0x004D/77)
    0xFE, 0x06, 0x18, 0xE0, 0xFE, // char 'N' (0x004E/78)
    0x7C, 0x86, 0x82, 0xC6, 0x7C, // char 'O' (0x004F/79)
    0xFE, 0x12, 0x12, 0x0C, // char 'P' (0x0050/80)
    0x7C, 0x86, 0x82, 0xC6, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, // char 'Q' (0x0051/81)
    0xFE, 0x12, 0x12, 0xEC, 0x00, // char 'R' (0x0052/82)
    0x8C, 0x92, 0x92, 0x62, // char 'S' (0x0053/83)
    0x02, 0x02, 0xFE, 0x02, 0x02, // char 'T' (0x0054/84)
    0x7E, 0x80, 0x80, 0x80, 0x7E, // char 'U' (0x0055/85)
    0x06, 0x3C, 0xE0, 0xE0, 0x1C, 0x06, // char 'V' (0x0056/86)
    0x00, 0x0E, 0xF0, 0xF0, 0x0E, 0x1E, 0xF0, 0xF0, 0x0E, // char 'W' (0x0057/87)
    0x82, 0x6E, 0x38, 0x38, 0xC6, 0x00, // char 'X' (0x0058/88)
    0x02, 0x0C, 0xF0, 0x0C, 0x02, // char 'Y' (0x0059/89)
    0x82, 0xE2, 0x92, 0x8E, 0x82, // char 'Z' (0x005A/90)
    0xFF, 0x01, 0x03, 0x02, // char '[' (0x005B/91)
    0x01, 0x0E, 0x70, 0x80, 0x00, 0x00, 0x00, 0x01, // char '\' (0x005C/92)
    0x01, 0xFF, 0x02, 0x03, // char ']' (0x005D/93)
    0x1C, 0x02, 0x0C, 0x10, // char '^' (0x005E/94)
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // char '_' (0x005F/95)
    0x00, 0x01, 0x02, // char '`' (0x0060/96)
    0xE8, 0xA8, 0xA8, 0xF8, // char 'a' (0x0061/97)
    0xFE, 0x88, 0x88, 0x70, // char 'b' (0x0062/98)
    0x70, 0x88, 0x88, 0x88, // char 'c' (0x0063/99)
    0x70, 0x88, 0x88, 0xFE, // char 'd' (0x0064/100)
    0x70, 0xA8, 0xA8, 0xB0, // char 'e' (0x0065/101)
    0x08, 0xFE, 0x0A, 0x02, // char 'f' (0x0066/102)
    0x78, 0xA8, 0xA8, 0xB8, 0x08, 0x03, 0x02, 0x02, 0x03, 0x00, // char 'g' (0x0067/103)
    0xFE, 0x08, 0x08, 0xF8, // char 'h' (0x0068/104)
    0xFA, // char 'i' (0x0069/105)
    0x00, 0xFA, 0x02, 0x03, // char 'j' (0x006A/106)
    0xFE, 0x20, 0x50, 0x88, // char 'k' (0x006B/107)
    0xFE, // char 'l' (0x006C/108)
    0xF8, 0x08, 0x08, 0xF8, 0x08, 0x08, 0xF8, // char 'm' (0x006D/109)
    0xF8, 0x08, 0x08, 0xF8, // char 'n' (0x006E/110)
    0xF8, 0x88, 0x88, 0xF8, // char 'o' (0x006F/111)
    0xF8, 0x88, 0x88, 0x70, 0x03, 0x00, 0x00, 0x00, // char 'p' (0x0070/112)
    0x70, 0x88, 0x88, 0xF8, 0x00, 0x00, 0x00, 0x03, // char 'q' (0x0071/113)
    0xF8, 0x08, 0x08, // char 'r' (0x0072/114)
    0x98, 0xA8, 0xE8, // char 's' (0x0073/115)
    0x08, 0xFC, 0x88, // char 't' (0x0074/116)
    0xF8, 0x80, 0x80, 0xF8, // char 'u' (0x0075/117)
    0x18, 0x70, 0xC0, 0x60, 0x18, // char 'v' (0x0076/118)
    0x08, 0x70, 0xC0, 0x38, 0x38, 0xC0, 0x70, 0x08, // char 'w' (0x0077/119)
    0x88, 0x70, 0x70, 0x88, // char 'x' (0x0078/120)
    0x18, 0x70, 0xC0, 0x70, 0x08, 0x00, 0x02, 0x01, 0x00, 0x00, // char 'y' (0x0079/121)
    0xC8, 0xE8, 0xB8, 0x88, // char 'z' (0x007A/122)
    0x10, 0xEE, 0x01, 0x00, 0x01, 0x02, // char '{' (0x007B/123)
    0xFF, 0x03, // char '|' (0x007C/124)
    0xCF, 0x30, 0x03, 0x00, // char '}' (0x007D/125)
    0x0C, 0x04, 0x08, 0x08, 0x0C, // char '~' (0x007E/126)
    0xFE, 0x82, 0x8A, 0xAA, 0x82, 0xFE, // char '' (0x007F/127)
    0x00, 0x00, 0x00, // end of unicode tables
    // FONT REQUIRES 859 BYTES
};

// ------------------------
// ------------------------
// -@@@@-------------------
// @@--@-------------------
// @@--@-@--@-@--@--@-@-@@-
// -@@@@-@--@-@--@-@@-@-@--
// -@--@-@--@-@--@@-@-@@@--
// @@--@-@--@-@--@@-@-@-@--
// @@--@-@@@@@@@-@--@-@-@@-
// ------------@-----------
// ------------@-----------
const uint8_t free_calibri11x12_cyrillic[] PROGMEM =
{
//  type|width|height|first char
    0x02, 0x0A, 0x0B, 0x00,
// GROUP first 'А' total 64 chars
//  unicode(LSB,MSB)|count
    0x04, 0x10, 0x40, // unicode record
    0x00, 0x00, 0x06, 0x09, // char 'А' (0x0410/1040)
    0x00, 0x0C, 0x05, 0x09, // char 'Б' (0x0411/1041)
    0x00, 0x16, 0x04, 0x09, // char 'В' (0x0412/1042)
    0x00, 0x1E, 0x04, 0x09, // char 'Г' (0x0413/1043)
    0x00, 0x26, 0x07, 0x0B, // char 'Д' (0x0414/1044)
    0x00, 0x34, 0x04, 0x09, // char 'Е' (0x0415/1045)
    0x00, 0x3C, 0x09, 0x09, // char 'Ж' (0x0416/1046)
    0x00, 0x4E, 0x04, 0x09, // char 'З' (0x0417/1047)
    0x00, 0x56, 0x05, 0x09, // char 'И' (0x0418/1048)
    0x00, 0x60, 0x05, 0x09, // char 'Й' (0x0419/1049)
    0x00, 0x6A, 0x05, 0x09, // char 'К' (0x041A/1050)
    0x00, 0x74, 0x06, 0x09, // char 'Л' (0x041B/1051)
    0x00, 0x80, 0x07, 0x09, // char 'М' (0x041C/1052)
    0x00, 0x8E, 0x05, 0x09, // char 'Н' (0x041D/1053)
    0x00, 0x98, 0x05, 0x09, // char 'О' (0x041E/1054)
    0x00, 0xA2, 0x05, 0x09, // char 'П' (0x041F/1055)
    0x00, 0xAC, 0x04, 0x09, // char 'Р' (0x0420/1056)
    0x00, 0xB4, 0x05, 0x09, // char 'С' (0x0421/1057)
    0x00, 0xBE, 0x05, 0x09, // char 'Т' (0x0422/1058)
    0x00, 0xC8, 0x07, 0x09, // char 'У' (0x0423/1059)
    0x00, 0xD6, 0x07, 0x09, // char 'Ф' (0x0424/1060)
    0x00, 0xE4, 0x06, 0x09, // char 'Х' (0x0425/1061)
    0x00, 0xF0, 0x06, 0x0B, // char 'Ц' (0x0426/1062)
    0x00, 0xFC, 0x05, 0x09, // char 'Ч' (0x0427/1063)
    0x01, 0x06, 0x08, 0x09, // char 'Ш' (0x0428/1064)
    0x01, 0x16, 0x09, 0x0B, // char 'Щ' (0x0429/1065)
    0x01, 0x28, 0x06, 0x09, // char 'Ъ' (0x042A/1066)
    0x01, 0x34, 0x07, 0x09, // char 'Ы' (0x042B/1067)
    0x01, 0x42, 0x05, 0x09, // char 'Ь' (0x042C/1068)
    0x01, 0x4C, 0x05, 0x09, // char 'Э' (0x042D/1069)
    0x01, 0x56, 0x08, 0x09, // char 'Ю' (0x042E/1070)
    0x01, 0x66, 0x05, 0x09, // char 'Я' (0x042F/1071)
    0x01, 0x70, 0x04, 0x09, // char 'а' (0x0430/1072)
    0x01, 0x78, 0x05, 0x09, // char 'б' (0x0431/1073)
    0x01, 0x82, 0x04, 0x09, // char 'в' (0x0432/1074)
    0x01, 0x8A, 0x03, 0x09, // char 'г' (0x0433/1075)
    0x01, 0x90, 0x06, 0x0B, // char 'д' (0x0434/1076)
    0x01, 0x9C, 0x04, 0x09, // char 'е' (0x0435/1077)
    0x01, 0xA4, 0x07, 0x09, // char 'ж' (0x0436/1078)
    0x01, 0xB2, 0x04, 0x09, // char 'з' (0x0437/1079)
    0x01, 0xBA, 0x04, 0x09, // char 'и' (0x0438/1080)
    0x01, 0xC2, 0x04, 0x09, // char 'й' (0x0439/1081)
    0x01, 0xCA, 0x04, 0x09, // char 'к' (0x043A/1082)
    0x01, 0xD2, 0x05, 0x09, // char 'л' (0x043B/1083)
    0x01, 0xDC, 0x06, 0x09, // char 'м' (0x043C/1084)
    0x01, 0xE8, 0x04, 0x09, // char 'н' (0x043D/1085)
    0x01, 0xF0, 0x04, 0x09, // char 'о' (0x043E/1086)
    0x01, 0xF8, 0x04, 0x09, // char 'п' (0x043F/1087)
    0x02, 0x00, 0x04, 0x0B, // char 'р' (0x0440/1088)
    0x02, 0x08, 0x04, 0x09, // char 'с' (0x0441/1089)
    0x02, 0x10, 0x05, 0x09, // char 'т' (0x0442/1090)
    0x02, 0x1A, 0x05, 0x0B, // char 'у' (0x0443/1091)
    0x02, 0x24, 0x07, 0x0B, // char 'ф' (0x0444/1092)
    0x02, 0x32, 0x04, 0x09, // char 'х' (0x0445/1093)
    0x02, 0x3A, 0x05, 0x0B, // char 'ц' (0x0446/1094)
    0x02, 0x44, 0x04, 0x09, // char 'ч' (0x0447/1095)
    0x02, 0x4C, 0x06, 0x09, // char 'ш' (0x0448/1096)
    0x02, 0x58, 0x07, 0x0B, // char 'щ' (0x0449/1097)
    0x02, 0x66, 0x06, 0x09, // char 'ъ' (0x044A/1098)
    0x02, 0x72, 0x06, 0x09, // char 'ы' (0x044B/1099)
    0x02, 0x7E, 0x04, 0x09, // char 'ь' (0x044C/1100)
    0x02, 0x86, 0x04, 0x09, // char 'э' (0x044D/1101)
    0x02, 0x8E, 0x07, 0x09, // char 'ю' (0x044E/1102)
    0x02, 0x9C, 0x04, 0x09, // char 'я' (0x044F/1103)
    0x02, 0xA6,
    0x00, 0xE0, 0x5C, 0x4C, 0x70, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, // char 'А' (0x0410/1040)
    0xFC, 0x24, 0x24, 0xE4, 0xC4, 0x01, 0x01, 0x01, 0x01, 0x00, // char 'Б' (0x0411/1041)
    0xFC, 0x24, 0x24, 0xDC, 0x01, 0x01, 0x01, 0x00, // char 'В' (0x0412/1042)
    0xFC, 0x04, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, // char 'Г' (0x0413/1043)
    0x00, 0xC0, 0x7C, 0x04, 0x04, 0xFC, 0x00, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'Д' (0x0414/1044)
    0xFC, 0x24, 0x24, 0x24, 0x01, 0x01, 0x01, 0x01, // char 'Е' (0x0415/1045)
    0x8C, 0xDC, 0x20, 0x20, 0xFC, 0x20, 0x20, 0xDC, 0x8C, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'Ж' (0x0416/1046)
    0x04, 0x24, 0xFC, 0xDC, 0x01, 0x01, 0x01, 0x00, // char 'З' (0x0417/1047)
    0xFC, 0x80, 0x70, 0x08, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'И' (0x0418/1048)
    0xFC, 0x83, 0x72, 0x0B, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'Й' (0x0419/1049)
    0xFC, 0x20, 0x20, 0xD0, 0x0C, 0x01, 0x00, 0x00, 0x01, 0x01, // char 'К' (0x041A/1050)
    0x00, 0xC0, 0x7C, 0x04, 0x04, 0xFC, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'Л' (0x041B/1051)
    0xFC, 0x0C, 0x70, 0x80, 0x70, 0x0C, 0xFC, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, // char 'М' (0x041C/1052)
    0xFC, 0x20, 0x20, 0x20, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'Н' (0x041D/1053)
    0xF8, 0x0C, 0x04, 0x8C, 0xF8, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'О' (0x041E/1054)
    0xFC, 0x04, 0x04, 0x04, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x01, // char 'П' (0x041F/1055)
    0xFC, 0x24, 0x24, 0x18, 0x01, 0x00, 0x00, 0x00, // char 'Р' (0x0420/1056)
    0xF8, 0x8C, 0x04, 0x04, 0x88, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'С' (0x0421/1057)
    0x04, 0x04, 0xFC, 0x04, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, // char 'Т' (0x0422/1058)
    0x00, 0x0C, 0x30, 0xC0, 0x30, 0x0C, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, // char 'У' (0x0423/1059)
    0x70, 0xD8, 0x88, 0xFC, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, // char 'Ф' (0x0424/1060)
    0x04, 0xDC, 0x70, 0x70, 0x8C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, // char 'Х' (0x0425/1061)
    0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'Ц' (0x0426/1062)
    0x1C, 0x30, 0x20, 0x20, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x01, // char 'Ч' (0x0427/1063)
    0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // char 'Ш' (0x0428/1064)
    0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'Щ' (0x0429/1065)
    0x04, 0x04, 0xFC, 0x20, 0xE0, 0xE0, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'Ъ' (0x042A/1066)
    0xFC, 0x20, 0x20, 0xE0, 0xC0, 0x00, 0xFC, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, // char 'Ы' (0x042B/1067)
    0xFC, 0x20, 0x20, 0xE0, 0xC0, 0x01, 0x01, 0x01, 0x01, 0x00, // char 'Ь' (0x042C/1068)
    0x04, 0x24, 0x24, 0xFC, 0xF8, 0x01, 0x01, 0x01, 0x01, 0x00, // char 'Э' (0x042D/1069)
    0xFC, 0x20, 0x70, 0xF8, 0x04, 0x04, 0xDC, 0xF8, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'Ю' (0x042E/1070)
    0x98, 0xFC, 0x24, 0x24, 0xFC, 0x01, 0x01, 0x00, 0x00, 0x01, // char 'Я' (0x042F/1071)
    0xD0, 0x50, 0x50, 0xF0, 0x01, 0x01, 0x01, 0x01, // char 'а' (0x0430/1072)
    0x00, 0xF8, 0xAC, 0x94, 0xF4, 0x00, 0x00, 0x01, 0x01, 0x00, // char 'б' (0x0431/1073)
    0xF0, 0x50, 0x50, 0xB0, 0x01, 0x01, 0x01, 0x01, // char 'в' (0x0432/1074)
    0xF0, 0x10, 0x10, 0x01, 0x00, 0x00, // char 'г' (0x0433/1075)
    0x00, 0xC0, 0x70, 0x10, 0xF0, 0x00, 0x07, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'д' (0x0434/1076)
    0xE0, 0x50, 0x50, 0x60, 0x00, 0x01, 0x01, 0x01, // char 'е' (0x0435/1077)
    0x10, 0xB0, 0x40, 0xF0, 0x40, 0xF0, 0x90, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, // char 'ж' (0x0436/1078)
    0x10, 0x50, 0x50, 0xB0, 0x01, 0x01, 0x01, 0x01, // char 'з' (0x0437/1079)
    0xF0, 0xC0, 0x20, 0xF0, 0x01, 0x00, 0x00, 0x01, // char 'и' (0x0438/1080)
    0xF0, 0xC6, 0x24, 0xF6, 0x01, 0x00, 0x00, 0x01, // char 'й' (0x0439/1081)
    0xF0, 0x40, 0xF0, 0x10, 0x01, 0x00, 0x01, 0x01, // char 'к' (0x043A/1082)
    0x00, 0xC0, 0x70, 0x10, 0xF0, 0x01, 0x01, 0x00, 0x00, 0x01, // char 'л' (0x043B/1083)
    0xF0, 0xE0, 0x00, 0xE0, 0xF0, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, // char 'м' (0x043C/1084)
    0xF0, 0x40, 0x40, 0xF0, 0x01, 0x00, 0x00, 0x01, // char 'н' (0x043D/1085)
    0xF0, 0x10, 0x10, 0xF0, 0x01, 0x01, 0x01, 0x01, // char 'о' (0x043E/1086)
    0xF0, 0x10, 0x10, 0xF0, 0x01, 0x00, 0x00, 0x01, // char 'п' (0x043F/1087)
    0xF0, 0x10, 0x10, 0xE0, 0x07, 0x01, 0x01, 0x00, // char 'р' (0x0440/1088)
    0xE0, 0x10, 0x10, 0x10, 0x00, 0x01, 0x01, 0x01, // char 'с' (0x0441/1089)
    0x10, 0x10, 0xF0, 0x10, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, // char 'т' (0x0442/1090)
    0x30, 0xE0, 0x80, 0xE0, 0x10, 0x00, 0x04, 0x03, 0x00, 0x00, // char 'у' (0x0443/1091)
    0xE0, 0xB0, 0x10, 0xFC, 0x10, 0x10, 0xE0, 0x00, 0x01, 0x01, 0x07, 0x01, 0x01, 0x00, // char 'ф' (0x0444/1092)
    0x10, 0xE0, 0xE0, 0x10, 0x01, 0x00, 0x00, 0x01, // char 'х' (0x0445/1093)
    0xF0, 0x00, 0x00, 0xF0, 0x00, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'ц' (0x0446/1094)
    0x70, 0x40, 0x40, 0xF0, 0x00, 0x00, 0x00, 0x01, // char 'ч' (0x0447/1095)
    0xF0, 0x00, 0x00, 0xF0, 0x00, 0xF0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // char 'ш' (0x0448/1096)
    0xF0, 0x00, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, // char 'щ' (0x0449/1097)
    0x10, 0x10, 0xF0, 0x20, 0xE0, 0xE0, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'ъ' (0x044A/1098)
    0xF0, 0x20, 0x20, 0xE0, 0x00, 0xF0, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, // char 'ы' (0x044B/1099)
    0xF0, 0x20, 0xE0, 0xE0, 0x01, 0x01, 0x01, 0x00, // char 'ь' (0x044C/1100)
    0x50, 0x50, 0xF0, 0xE0, 0x01, 0x01, 0x01, 0x00, // char 'э' (0x044D/1101)
    0xF0, 0x40, 0xE0, 0xB0, 0x10, 0xB0, 0xE0, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // char 'ю' (0x044E/1102)
    0xB0, 0xD0, 0x50, 0xF0, 0x01, 0x01, 0x00, 0x01, // char 'я' (0x044F/1103)
    0x00, 0x00, 0x00, // end of unicode tables
    // FONT REQUIRES 944 BYTES
};

// --------@----------------
// -@@-@@---@---------------
// -------------------------
// --@@----@@@@--@@@--@@-@@-
// --@@----@----@--@--------
// --@-@---@----@-@@--@---@-
// -@--@---@@@@-@-@@--@@-@--
// -@@@@---@----@--@@--@-@--
// -@---@--@----@---@--@@@--
// @----@--@@@@-@-@@@---@---
// ---------------------@---
// --------------------@----
const uint8_t free_calibri11x12_latin[] PROGMEM =
{
//  type|width|height|first char
    0x02, 0x0A, 0x0C, 0x00,
// GROUP first '¡' total 95 chars
//  unicode(LSB,MSB)|count
    0x00, 0xA1, 0x5F, // unicode record
    0x00, 0x00, 0x02, 0x0B, // char '¡' (0x00A1/161)
    0x00, 0x04, 0x04, 0x0A, // char '¢' (0x00A2/162)
    0x00, 0x0C, 0x05, 0x0A, // char '£' (0x00A3/163)
    0x00, 0x16, 0x05, 0x0A, // char '¤' (0x00A4/164)
    0x00, 0x20, 0x06, 0x0A, // char '¥' (0x00A5/165)
    0x00, 0x2C, 0x01, 0x0C, // char '¦' (0x00A6/166)
    0x00, 0x2E, 0x04, 0x0B, // char '§' (0x00A7/167)
    0x00, 0x36, 0x05, 0x04, // char '¨' (0x00A8/168)
    0x00, 0x3B, 0x07, 0x0A, // char '©' (0x00A9/169)
    0x00, 0x49, 0x03, 0x09, // char 'ª' (0x00AA/170)
    0x00, 0x4F, 0x04, 0x09, // char '«' (0x00AB/171)
    0x00, 0x57, 0x05, 0x08, // char '¬' (0x00AC/172)
    0x00, 0x5C, 0x03, 0x08, // char '­' (0x00AD/173)
    0x00, 0x5F, 0x04, 0x06, // char '®' (0x00AE/174)
    0x00, 0x63, 0x04, 0x04, // char '¯' (0x00AF/175)
    0x00, 0x67, 0x03, 0x06, // char '°' (0x00B0/176)
    0x00, 0x6A, 0x05, 0x0A, // char '±' (0x00B1/177)
    0x00, 0x74, 0x03, 0x06, // char '²' (0x00B2/178)
    0x00, 0x77, 0x03, 0x06, // char '³' (0x00B3/179)
    0x00, 0x7A, 0x03, 0x04, // char '´' (0x00B4/180)
    0x00, 0x7D, 0x05, 0x0C, // char 'µ' (0x00B5/181)
    0x00, 0x87, 0x05, 0x0B, // char '¶' (0x00B6/182)
    0x00, 0x91, 0x02, 0x07, // char '·' (0x00B7/183)
    0x00, 0x93, 0x02, 0x0C, // char '¸' (0x00B8/184)
    0x00, 0x97, 0x02, 0x06, // char '¹' (0x00B9/185)
    0x00, 0x99, 0x03, 0x09, // char 'º' (0x00BA/186)
    0x00, 0x9F, 0x04, 0x09, // char '»' (0x00BB/187)
    0x00, 0xA7, 0x07, 0x0A, // char '¼' (0x00BC/188)
    0x00, 0xB5, 0x07, 0x0A, // char '½' (0x00BD/189)
    0x00, 0xC3, 0x07, 0x0A, // char '¾' (0x00BE/190)
    0x00, 0xD1, 0x04, 0x0B, // char '¿' (0x00BF/191)
    0x00, 0xD9, 0x06, 0x0A, // char 'À' (0x00C0/192)
    0x00, 0xE5, 0x06, 0x0A, // char 'Á' (0x00C1/193)
    0x00, 0xF1, 0x06, 0x0A, // char 'Â' (0x00C2/194)
    0x00, 0xFD, 0x06, 0x0A, // char 'Ã' (0x00C3/195)
    0x01, 0x09, 0x06, 0x0A, // char 'Ä' (0x00C4/196)
    0x01, 0x15, 0x06, 0x0A, // char 'Å' (0x00C5/197)
    0x01, 0x21, 0x08, 0x0A, // char 'Æ' (0x00C6/198)
    0x01, 0x31, 0x05, 0x0C, // char 'Ç' (0x00C7/199)
    0x01, 0x3B, 0x05, 0x0A, // char 'È' (0x00C8/200)
    0x01, 0x45, 0x04, 0x0A, // char 'É' (0x00C9/201)
    0x01, 0x4D, 0x05, 0x0A, // char 'Ê' (0x00CA/202)
    0x01, 0x57, 0x05, 0x0A, // char 'Ë' (0x00CB/203)
    0x01, 0x61, 0x03, 0x0A, // char 'Ì' (0x00CC/204)
    0x01, 0x67, 0x03, 0x0A, // char 'Í' (0x00CD/205)
    0x01, 0x6D, 0x05, 0x0A, // char 'Î' (0x00CE/206)
    0x01, 0x77, 0x05, 0x0A, // char 'Ï' (0x00CF/207)
    0x01, 0x81, 0x06, 0x0A, // char 'Ð' (0x00D0/208)
    0x01, 0x8D, 0x05, 0x0A, // char 'Ñ' (0x00D1/209)
    0x01, 0x97, 0x05, 0x0A, // char 'Ò' (0x00D2/210)
    0x01, 0xA1, 0x05, 0x0A, // char 'Ó' (0x00D3/211)
    0x01, 0xAB, 0x05, 0x0A, // char 'Ô' (0x00D4/212)
    0x01, 0xB5, 0x05, 0x0A, // char 'Õ' (0x00D5/213)
    0x01, 0xBF, 0x05, 0x0A, // char 'Ö' (0x00D6/214)
    0x01, 0xC9, 0x04, 0x09, // char '×' (0x00D7/215)
    0x01, 0xD1, 0x06, 0x0B, // char 'Ø' (0x00D8/216)
    0x01, 0xDD, 0x05, 0x0A, // char 'Ù' (0x00D9/217)
    0x01, 0xE7, 0x05, 0x0A, // char 'Ú' (0x00DA/218)
    0x01, 0xF1, 0x05, 0x0A, // char 'Û' (0x00DB/219)
    0x01, 0xFB, 0x05, 0x0A, // char 'Ü' (0x00DC/220)
    0x02, 0x05, 0x05, 0x0A, // char 'Ý' (0x00DD/221)
    0x02, 0x0F, 0x04, 0x0A, // char 'Þ' (0x00DE/222)
    0x02, 0x17, 0x05, 0x0A, // char 'ß' (0x00DF/223)
    0x02, 0x21, 0x04, 0x0A, // char 'à' (0x00E0/224)
    0x02, 0x29, 0x04, 0x0A, // char 'á' (0x00E1/225)
    0x02, 0x31, 0x04, 0x0A, // char 'â' (0x00E2/226)
    0x02, 0x39, 0x05, 0x0A, // char 'ã' (0x00E3/227)
    0x02, 0x43, 0x05, 0x0A, // char 'ä' (0x00E4/228)
    0x02, 0x4D, 0x04, 0x0A, // char 'å' (0x00E5/229)
    0x02, 0x55, 0x07, 0x0A, // char 'æ' (0x00E6/230)
    0x02, 0x63, 0x04, 0x0C, // char 'ç' (0x00E7/231)
    0x02, 0x6B, 0x04, 0x0A, // char 'è' (0x00E8/232)
    0x02, 0x73, 0x04, 0x0A, // char 'é' (0x00E9/233)
    0x02, 0x7B, 0x04, 0x0A, // char 'ê' (0x00EA/234)
    0x02, 0x83, 0x05, 0x0A, // char 'ë' (0x00EB/235)
    0x02, 0x8D, 0x03, 0x0A, // char 'ì' (0x00EC/236)
    0x02, 0x93, 0x03, 0x0A, // char 'í' (0x00ED/237)
    0x02, 0x99, 0x04, 0x0A, // char 'î' (0x00EE/238)
    0x02, 0xA1, 0x04, 0x0A, // char 'ï' (0x00EF/239)
    0x02, 0xA9, 0x05, 0x0A, // char 'ð' (0x00F0/240)
    0x02, 0xB3, 0x05, 0x0A, // char 'ñ' (0x00F1/241)
    0x02, 0xBD, 0x04, 0x0A, // char 'ò' (0x00F2/242)
    0x02, 0xC5, 0x04, 0x0A, // char 'ó' (0x00F3/243)
    0x02, 0xCD, 0x04, 0x0A, // char 'ô' (0x00F4/244)
    0x02, 0xD5, 0x05, 0x0A, // char 'õ' (0x00F5/245)
    0x02, 0xDF, 0x05, 0x0A, // char 'ö' (0x00F6/246)
    0x02, 0xE9, 0x05, 0x09, // char '÷' (0x00F7/247)
    0x02, 0xF3, 0x05, 0x0B, // char 'ø' (0x00F8/248)
    0x02, 0xFD, 0x04, 0x0A, // char 'ù' (0x00F9/249)
    0x03, 0x05, 0x04, 0x0A, // char 'ú' (0x00FA/250)
    0x03, 0x0D, 0x04, 0x0A, // char 'û' (0x00FB/251)
    0x03, 0x15, 0x05, 0x0A, // char 'ü' (0x00FC/252)
    0x03, 0x1F, 0x05, 0x0C, // char 'ý' (0x00FD/253)
    0x03, 0x29, 0x04, 0x0C, // char 'þ' (0x00FE/254)
    0x03, 0x31, 0x05, 0x0C, // char 'ÿ' (0x00FF/255)
    0x03, 0x3E,
    0x10, 0x90, 0x00, 0x07, // char '¡' (0x00A1/161)
    0xE0, 0xB0, 0x18, 0x10, 0x00, 0x01, 0x03, 0x01, // char '¢' (0x00A2/162)
    0x40, 0xF0, 0x58, 0x48, 0x18, 0x02, 0x03, 0x02, 0x02, 0x02, // char '£' (0x00A3/163)
    0x10, 0xE0, 0x20, 0x20, 0xD0, 0x00, 0x03, 0x01, 0x01, 0x02, // char '¤' (0x00A4/164)
    0x48, 0x58, 0xE0, 0x70, 0x48, 0x00, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, // char '¥' (0x00A5/165)
    0x3C, 0x0F, // char '¦' (0x00A6/166)
    0xF8, 0xA8, 0x68, 0xC0, 0x04, 0x05, 0x05, 0x07, // char '§' (0x00A7/167)
    0x08, 0x08, 0x00, 0x08, 0x08, // char '¨' (0x00A8/168)
    0xF0, 0x08, 0xF4, 0x94, 0x94, 0x04, 0xF8, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, // char '©' (0x00A9/169)
    0x68, 0x68, 0x70, 0x01, 0x01, 0x01, // char 'ª' (0x00AA/170)
    0xE0, 0x10, 0xE0, 0x10, 0x00, 0x01, 0x00, 0x01, // char '«' (0x00AB/171)
    0x40, 0x40, 0x40, 0x40, 0xC0, // char '¬' (0x00AC/172)
    0x80, 0x80, 0x80, // char '­' (0x00AD/173)
    0x3C, 0x2C, 0x24, 0x18, // char '®' (0x00AE/174)
    0x00, 0x08, 0x08, 0x08, // char '¯' (0x00AF/175)
    0x38, 0x28, 0x38, // char '°' (0x00B0/176)
    0x20, 0x20, 0xF8, 0x20, 0x20, 0x02, 0x02, 0x02, 0x02, 0x02, // char '±' (0x00B1/177)
    0x24, 0x34, 0x2C, // char '²' (0x00B2/178)
    0x2C, 0x2C, 0x34, // char '³' (0x00B3/179)
    0x00, 0x08, 0x04, // char '´' (0x00B4/180)
    0xE0, 0x00, 0x00, 0xE0, 0x00, 0x0F, 0x02, 0x02, 0x03, 0x02, // char 'µ' (0x00B5/181)
    0x70, 0x78, 0xF8, 0x08, 0xF8, 0x00, 0x00, 0x07, 0x00, 0x07, // char '¶' (0x00B6/182)
    0x40, 0x40, // char '·' (0x00B7/183)
    0x00, 0x00, 0x08, 0x0C, // char '¸' (0x00B8/184)
    0x08, 0x3C, // char '¹' (0x00B9/185)
    0x78, 0x48, 0x78, 0x01, 0x01, 0x01, // char 'º' (0x00BA/186)
    0x10, 0xE0, 0x10, 0xE0, 0x01, 0x00, 0x01, 0x00, // char '»' (0x00BB/187)
    0x10, 0x78, 0x80, 0x40, 0xB0, 0xC8, 0x00, 0x00, 0x02, 0x01, 0x00, 0x01, 0x03, 0x01, // char '¼' (0x00BC/188)
    0x10, 0x78, 0x80, 0x40, 0x70, 0x48, 0xC0, 0x00, 0x02, 0x01, 0x00, 0x02, 0x03, 0x02, // char '½' (0x00BD/189)
    0x58, 0x58, 0xF8, 0x40, 0xB0, 0xC8, 0x00, 0x00, 0x02, 0x01, 0x00, 0x01, 0x03, 0x01, // char '¾' (0x00BE/190)
    0x00, 0x90, 0xD0, 0x00, 0x03, 0x04, 0x04, 0x04, // char '¿' (0x00BF/191)
    0x00, 0xC0, 0xB9, 0x9A, 0xE0, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'À' (0x00C0/192)
    0x00, 0xC0, 0xB8, 0x9A, 0xE1, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'Á' (0x00C1/193)
    0x00, 0xC0, 0xBA, 0x99, 0xE2, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'Â' (0x00C2/194)
    0x00, 0xC0, 0xBB, 0x99, 0xE2, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'Ã' (0x00C3/195)
    0x00, 0xC2, 0xBA, 0x98, 0xE2, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'Ä' (0x00C4/196)
    0x00, 0xC7, 0xBD, 0x9F, 0xE0, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03, // char 'Å' (0x00C5/197)
    0x00, 0xC0, 0xB0, 0x88, 0xF8, 0x48, 0x48, 0x48, 0x02, 0x01, 0x00, 0x00, 0x03, 0x02, 0x02, 0x02, // char 'Æ' (0x00C6/198)
    0xF0, 0xF8, 0x08, 0x08, 0x10, 0x01, 0x03, 0x0E, 0x0E, 0x01, // char 'Ç' (0x00C7/199)
    0x00, 0xF9, 0x4A, 0x48, 0x48, 0x00, 0x03, 0x02, 0x02, 0x02, // char 'È' (0x00C8/200)
    0xF8, 0x48, 0x4A, 0x49, 0x03, 0x02, 0x02, 0x02, // char 'É' (0x00C9/201)
    0x00, 0xFA, 0x49, 0x4A, 0x48, 0x00, 0x03, 0x02, 0x02, 0x02, // char 'Ê' (0x00CA/202)
    0xFA, 0x4A, 0x48, 0x4A, 0x02, 0x03, 0x02, 0x02, 0x02, 0x00, // char 'Ë' (0x00CB/203)
    0x00, 0x01, 0xFA, 0x00, 0x00, 0x03, // char 'Ì' (0x00CC/204)
    0x00, 0xFA, 0x01, 0x00, 0x03, 0x00, // char 'Í' (0x00CD/205)
    0x00, 0x02, 0xF9, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, // char 'Î' (0x00CE/206)
    0x02, 0x02, 0xF8, 0x02, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, // char 'Ï' (0x00CF/207)
    0x40, 0xF8, 0x48, 0x08, 0xB8, 0xF0, 0x00, 0x03, 0x02, 0x02, 0x03, 0x01, // char 'Ð' (0x00D0/208)
    0xF8, 0x1B, 0x61, 0x82, 0xFB, 0x03, 0x00, 0x00, 0x03, 0x03, // char 'Ñ' (0x00D1/209)
    0xF0, 0x19, 0x0A, 0x18, 0xF0, 0x01, 0x02, 0x02, 0x03, 0x01, // char 'Ò' (0x00D2/210)
    0xF0, 0x18, 0x0A, 0x19, 0xF0, 0x01, 0x02, 0x02, 0x03, 0x01, // char 'Ó' (0x00D3/211)
    0xF0, 0x1A, 0x09, 0x1A, 0xF0, 0x01, 0x02, 0x02, 0x03, 0x01, // char 'Ô' (0x00D4/212)
    0xF0, 0x1B, 0x09, 0x1A, 0xF3, 0x01, 0x02, 0x02, 0x03, 0x01, // char 'Õ' (0x00D5/213)
    0xF2, 0x1A, 0x08, 0x1A, 0xF2, 0x01, 0x02, 0x02, 0x03, 0x01, // char 'Ö' (0x00D6/214)
    0x20, 0xC0, 0xC0, 0x20, 0x01, 0x00, 0x00, 0x01, // char '×' (0x00D7/215)
    0xF0, 0x08, 0xC8, 0x38, 0x1C, 0xE0, 0x05, 0x03, 0x02, 0x02, 0x01, 0x00, // char 'Ø' (0x00D8/216)
    0xF8, 0x01, 0x02, 0x00, 0xF8, 0x01, 0x02, 0x02, 0x02, 0x01, // char 'Ù' (0x00D9/217)
    0xF8, 0x00, 0x02, 0x01, 0xF8, 0x01, 0x02, 0x02, 0x02, 0x01, // char 'Ú' (0x00DA/218)
    0xF8, 0x02, 0x01, 0x02, 0xF8, 0x01, 0x02, 0x02, 0x02, 0x01, // char 'Û' (0x00DB/219)
    0xFA, 0x02, 0x00, 0x02, 0xFA, 0x01, 0x02, 0x02, 0x02, 0x01, // char 'Ü' (0x00DC/220)
    0x08, 0x30, 0xC0, 0x32, 0x09, 0x00, 0x00, 0x03, 0x00, 0x00, // char 'Ý' (0x00DD/221)
    0xF8, 0x90, 0xF0, 0x70, 0x03, 0x00, 0x00, 0x00, // char 'Þ' (0x00DE/222)
    0xF0, 0x08, 0x68, 0xF8, 0x80, 0x03, 0x00, 0x02, 0x02, 0x03, // char 'ß' (0x00DF/223)
    0xA0, 0xA4, 0xA8, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'à' (0x00E0/224)
    0xA0, 0xA0, 0xA8, 0xE4, 0x03, 0x02, 0x02, 0x03, // char 'á' (0x00E1/225)
    0xA0, 0xA0, 0xAC, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'â' (0x00E2/226)
    0x00, 0xAC, 0xA4, 0xA8, 0xEC, 0x00, 0x03, 0x02, 0x02, 0x03, // char 'ã' (0x00E3/227)
    0xA8, 0xA8, 0xA0, 0xE8, 0x08, 0x03, 0x02, 0x02, 0x03, 0x00, // char 'ä' (0x00E4/228)
    0xAE, 0xAA, 0xAE, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'å' (0x00E5/229)
    0x20, 0xA0, 0xA0, 0xE0, 0xA0, 0xA0, 0xC0, 0x03, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, // char 'æ' (0x00E6/230)
    0xC0, 0x60, 0x20, 0x20, 0x01, 0x0B, 0x0E, 0x02, // char 'ç' (0x00E7/231)
    0xC0, 0xA4, 0xA8, 0xC0, 0x01, 0x02, 0x02, 0x02, // char 'è' (0x00E8/232)
    0xC0, 0xA0, 0xA8, 0xC4, 0x01, 0x02, 0x02, 0x02, // char 'é' (0x00E9/233)
    0xC0, 0xA0, 0xAC, 0xC0, 0x01, 0x02, 0x02, 0x02, // char 'ê' (0x00EA/234)
    0xC8, 0xA8, 0xA0, 0xC8, 0x08, 0x01, 0x02, 0x02, 0x02, 0x00, // char 'ë' (0x00EB/235)
    0x00, 0x04, 0xE8, 0x00, 0x00, 0x03, // char 'ì' (0x00EC/236)
    0x00, 0xE8, 0x04, 0x00, 0x03, 0x00, // char 'í' (0x00ED/237)
    0x00, 0x00, 0xEC, 0x00, 0x00, 0x00, 0x03, 0x00, // char 'î' (0x00EE/238)
    0x00, 0x08, 0xE0, 0x08, 0x00, 0x00, 0x03, 0x00, // char 'ï' (0x00EF/239)
    0x80, 0xD0, 0x58, 0x78, 0xE8, 0x01, 0x03, 0x02, 0x03, 0x01, // char 'ð' (0x00F0/240)
    0x00, 0xEC, 0x24, 0x28, 0xEC, 0x00, 0x03, 0x00, 0x00, 0x03, // char 'ñ' (0x00F1/241)
    0xE0, 0x24, 0x28, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'ò' (0x00F2/242)
    0xE0, 0x20, 0x28, 0xE4, 0x03, 0x02, 0x02, 0x03, // char 'ó' (0x00F3/243)
    0xE0, 0x20, 0x2C, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'ô' (0x00F4/244)
    0x00, 0xEC, 0x24, 0x28, 0xEC, 0x00, 0x03, 0x02, 0x02, 0x03, // char 'õ' (0x00F5/245)
    0xE8, 0x28, 0x20, 0xE8, 0x08, 0x03, 0x02, 0x02, 0x03, 0x00, // char 'ö' (0x00F6/246)
    0x40, 0x40, 0x50, 0x50, 0x40, 0x00, 0x00, 0x01, 0x01, 0x00, // char '÷' (0x00F7/247)
    0xC0, 0x60, 0xE0, 0x70, 0xC0, 0x01, 0x07, 0x03, 0x03, 0x01, // char 'ø' (0x00F8/248)
    0xE0, 0x04, 0x08, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'ù' (0x00F9/249)
    0xE0, 0x00, 0x08, 0xE4, 0x03, 0x02, 0x02, 0x03, // char 'ú' (0x00FA/250)
    0xE0, 0x00, 0x0C, 0xE0, 0x03, 0x02, 0x02, 0x03, // char 'û' (0x00FB/251)
    0xE8, 0x08, 0x00, 0xE8, 0x08, 0x03, 0x02, 0x02, 0x03, 0x00, // char 'ü' (0x00FC/252)
    0x60, 0xC0, 0x08, 0xC4, 0x20, 0x00, 0x09, 0x07, 0x01, 0x00, // char 'ý' (0x00FD/253)
    0xF8, 0x40, 0x60, 0xE0, 0x0F, 0x02, 0x03, 0x01, // char 'þ' (0x00FE/254)
    0x68, 0xC8, 0x00, 0xC8, 0x28, 0x00, 0x09, 0x07, 0x01, 0x00, // char 'ÿ' (0x00FF/255)
    0x00, 0x00, 0x00, // end of unicode tables
    // FONT REQUIRES 1219 BYTES
};


