

#include "Adafruit_FONA.h"

// standard pins for the shield, adjust as necessary
#define FONA_RX 11
#define FONA_TX 10
#define FONA_RST 4

// We default to using software serial. If you want to use hardware serial
// (because softserial isnt supported) comment out the following three lines 
// and uncomment the HardwareSerial line
#include <SoftwareSerial.h>
SoftwareSerial fonaSS = SoftwareSerial(FONA_TX, FONA_RX);
SoftwareSerial *fonaSerial = &fonaSS;

Adafruit_FONA fona = Adafruit_FONA(FONA_RST);

void setup() {
  // put your setup code here, to run once:
while (! Serial);

  Serial.begin(115200);
  Serial.println(F("Adafruit FONA 808 & 3G GPS demo"));
  Serial.println(F("Initializing FONA... (May take a few seconds)"));

  fonaSerial->begin(4800);
  if (! fona.begin(*fonaSerial)) {
    Serial.println(F("Couldn't find FONA"));
    while(1);
  }
  Serial.println(F("FONA is OK"));
  // Try to enable GPRS
  

  Serial.println(F("Enabling GPS..."));
  fona.enableGPS(true);
}

void loop() {
  // put your main code here, to run repeatedly:
  delay(2000);

  float latitude, longitude;
  char clat[10];
  char clong[10];
   boolean gps_success = fona.getGPS(&latitude, &longitude);
   if (gps_success) {

    dtostrf(latitude, 4, 4, clat);
    dtostrf(longitude, 4, 4, clong);
    Serial.print("GPS lat:");
    Serial.println(latitude, 6);
    Serial.print("GPS long:");
    Serial.println(longitude, 6);
    char message[140];
    sprintf(message, "crash detected at %s, %s", clat, clong);
    char number[21] = "7724537459";
    fona.sendSMS(number, message);
    delay(50000);
   }else {
    Serial.println("Waiting for FONA GPS 3D fix...");
  }

}
