// Wire Slave Receiver
// by Nicholas Zambetti <http://www.zambetti.com>

// Demonstrates use of the Wire library
// Receives data as an I2C/TWI slave device
// Refer to the "Wire Master Writer" example for use with this

// Created 29 March 2006

// This example code is in the public domain.

#include <Keyboard.h>
#include <Wire.h>

void setup() {
  Wire.begin(0x8);                // Join i2c bus with address #8
  Wire.onReceive(receiveEvent);   // Register event
  Wire.onRequest(requestEvent);
  
  Serial.begin(9600);             // Start serial for output
  while(!Serial);
  Keyboard.begin();               // Keyboard Set-up
}

void loop() {
  delay(100);
}

// function that executes whenever data is received from master
// this function is registered as an event, see setup()
void receiveEvent(int howMany) {
  while (1 < Wire.available()) {    // loop through all but the last
    char c = Wire.read();           // receive byte as a character
    //Serial.print(c);              // print the character
  }
  int x = Wire.read();              // receive byte as an integer

     //If the Start is pressed
     if (x == 1)
     {
     //Send an ASCII 'S'
     Keyboard.write(83);
     }

     //If the Stop is pressed
     if (x == 0)
     {
     //Send an ASCII 'T'
     Keyboard.write(84);
     }

     if (x == 3)
     {
     //Send an ASCII ' ' (space character)
     Keyboard.write(32);
     delay(3000000);
     Keyboard.write(32);
     delay(300000);
     Keyboard.write(32);
     }
     
  Serial.print(x);                  // print the integer
}

void requestEvent(){

  Serial.println("requested, sending 2");
  Wire.write(02);

  Serial.println("sent 2"); 
  
  
}