﻿using System.Collections;
using System.IO;
using UnityEngine;
using TMPro;

public class update_canvas : MonoBehaviour
{
    public static TextMeshProUGUI tmp;
    private bool isInCorout = false; // coroutine debouncing bool

    void Start()
    {
        tmp = gameObject.GetComponent<TextMeshProUGUI>(); // initialize TMPro
    }

    void Update()
    {
        if (update_anim.startTranslate && File.Exists("ASL\\translate.txt"))
        {
            update_anim.startTranslate = false;
            StartCoroutine(DisplayHandler());
        }
    }

    IEnumerator DisplayHandler()
    {
        Coroutine coroutine;
        coroutine = StartCoroutine(StartDisplay());
        yield return coroutine;
    }

    private IEnumerator StartDisplay()
    {
        if (isInCorout)
            yield break;

        isInCorout = true;
        yield return new WaitForSeconds(0.5f);

        // Display both English and sign language gloss on the canvas.
        string txt = "ENG: " + File.ReadAllText("ASL\\translate.txt") + "\n";
        string pred = "SIGN: " + File.ReadAllText("ASL\\pred.txt");
        string message = txt + pred + "\n";
        tmp.SetText(message); // Display text

        // Remove files to prepare for next translation
        File.Delete("ASL\\translate.txt");
        File.Delete("ASL\\pred.txt");
        isInCorout = false;
    }
}