package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatDialogFragment;

public class AbilityScoreDialog extends AppCompatDialogFragment {
    private AbilityScoreDialogListener listener;
    TextView str_score_dialog, dex_score_dialog, con_score_dialog, int_score_dialog, wis_score_dialog, cha_score_dialog;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.ability_score_dialog, null);

        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Set", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        int str_changed = 0;
                        int dex_changed = 0;
                        int con_changed = 0;
                        int int_changed = 0;
                        int wis_changed = 0;
                        int cha_changed = 0;

                        if (str_score_dialog.getText().toString().equalsIgnoreCase(""))
                            str_changed = 8;
                        else
                            str_changed = Integer.parseInt(str_score_dialog.getText().toString());

                        if (dex_score_dialog.getText().toString().equalsIgnoreCase(""))
                            dex_changed = 8;
                        else
                            dex_changed = Integer.parseInt(dex_score_dialog.getText().toString());

                        if (con_score_dialog.getText().toString().equalsIgnoreCase(""))
                            con_changed = 8;
                        else
                            con_changed = Integer.parseInt(con_score_dialog.getText().toString());

                        if (int_score_dialog.getText().toString().equalsIgnoreCase(""))
                            int_changed = 8;
                        else
                            int_changed = Integer.parseInt(int_score_dialog.getText().toString());

                        if (wis_score_dialog.getText().toString().equalsIgnoreCase(""))
                            wis_changed = 8;
                        else
                            wis_changed = Integer.parseInt(wis_score_dialog.getText().toString());

                        if (cha_score_dialog.getText().toString().equalsIgnoreCase(""))
                            cha_changed = 8;
                        else
                            cha_changed = Integer.parseInt(cha_score_dialog.getText().toString());


                        listener.makeAbilityScore(str_changed, dex_changed, con_changed, int_changed, wis_changed, cha_changed);
                    }
                });

        str_score_dialog = view.findViewById(R.id.str_score_dialog);
        dex_score_dialog = view.findViewById(R.id.dex_score_dialog);
        con_score_dialog = view.findViewById(R.id.con_score_dialog);
        int_score_dialog = view.findViewById(R.id.int_score_dialog);
        wis_score_dialog = view.findViewById(R.id.wis_score_dialog);
        cha_score_dialog = view.findViewById(R.id.cha_score_dialog);

        str_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_str));
        dex_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_dex));
        con_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_con));
        int_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_int));
        wis_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_wis));
        cha_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_cha));

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        try {
            listener = (AbilityScoreDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement ProficiencyDialogListener");
        }

        super.onAttach(context);
    }

    public interface AbilityScoreDialogListener {
        void makeAbilityScore(int str_score_change, int dex_score_change, int con_score_change, int int_score_change,
                              int wis_score_change, int cha_score_change);
    }

}
