package com.sd2group30.gamingwizard;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;

public class CharacterCreation extends AppCompatActivity {
    private static final String TAG = "CharacterCreation";
    TextView vcharacter_name, vstr_input, vdex_input, vcon_input, vint_input, vwis_input, vcha_input;
    Spinner vrace_dropdown, vclass_dropdown;
    CheckBox vacrobatics_checkbox, vanimal_handling_checkbox,varcana_checkbox, vathletics_checkbox,
            vdeception_checkbox, vhistory_checkbox, vinsight_checkbox, vintimidation_checkbox,
            vinvestigation_checkbox, vmedicine_checkbox, vnature_checkbox, vperception_checkbox,
            vperformance_checkbox, vpersuasion_checkbox, vreligion_checkbox, vsleight_of_hand_checkbox,
            vstealth_checkbox, vsurvival_checkbox;
    public static int str_base, dex_base, con_base, int_base, wis_base, cha_base, str_misc = 0, dex_misc = 0, con_misc = 0,
            int_misc = 0, wis_misc = 0, cha_misc = 0, character_speed = 30, character_level = 1, hit_dice = 8, base_hp = 8,
            base_ac = 10, total_ac = 10;
    public static String character_name, character_size, character_race, character_class;
    public static boolean str_proficiency = false, dex_proficiency = false, con_proficiency = false, int_proficiency = false,
                wis_proficiency = false, cha_proficiency = false, acrobatics = false, animal_handling = false,
                arcana = false, athletics = false, deception = false, history = false, insight = false,
                intimidation = false, investigation = false, medicine = false, nature = false, perception = false,
                performance = false, persuasion = false, religion = false, sleight_of_hand = false,
                stealth = false, survival = false;
    Player new_player;

    @Override
    public void onBackPressed() {}

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_character_creation);

        final Spinner race_spinner = findViewById(R.id.race_dropdown);
        ArrayAdapter<String> race_adapter = new ArrayAdapter<>(
                this,
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.races_list)
        );
        race_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        race_spinner.setAdapter(race_adapter);

        final Spinner class_spinner = findViewById(R.id.class_dropdown);
        ArrayAdapter<String> class_adapter = new ArrayAdapter<>(
                this,
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.classes_list)
        );
        class_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        class_spinner.setAdapter(class_adapter);

        race_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long l) {
                String selected_race = race_spinner.getItemAtPosition(position).toString();
                if (selected_race.equalsIgnoreCase("Aarakocra")) {
                    String racial_stats = "Ability Scores: Dex +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 25ft., fly 50ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Aasimar")) {
                    String racial_stats = "Ability Scores: Cha +2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Bugbear")) {
                    String racial_stats = "Ability Scores: Str +2; Dex +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Centaur")) {
                    String racial_stats = "Ability Scores: Str +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 40ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Dragonborn")) {
                    String racial_stats = "Ability Scores: Str +2; Cha +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Dwarf")) {
                    String racial_stats = "Ability Scores: Con +2\n" +
                            "Size: Medium\n" +
                            "Speed: 25ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Elf")) {
                    String racial_stats = "Ability Scores: Dex +2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Firbolg")) {
                    String racial_stats = "Ability Scores: Str +1; Wis +2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Genasi")) {
                    String racial_stats = "Ability Scores: Con +2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Gith")) {
                    String racial_stats = "Ability Scores: Int +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Gnome")) {
                    String racial_stats = "Ability Scores: Int +2\n" +
                            "Size: Small\n" +
                            "Speed: 25ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Goblin")) {
                    String racial_stats = "Ability Scores: Dex +2; Con +1\n" +
                            "Size: Small\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Goliath")) {
                    String racial_stats = "Ability Scores: Str +2; Con +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Grung")) {
                    String racial_stats = "Ability Scores: Dex +2; Con +1\n" +
                            "Size: Small\n" +
                            "Speed: 25ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Half-Orc")) {
                    String racial_stats = "Ability Scores: Str +2; Con +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Halfling")) {
                    String racial_stats = "Ability Scores: Dex +2\n" +
                            "Size: Small\n" +
                            "Speed: 25ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Hobgoblin")) {
                    String racial_stats = "Ability Scores: Con +2; Int +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Human")) {
                    String racial_stats = "Ability Scores: Str +1; Dex +1; Con +1; Int +1; Wis +1; Cha +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Kalashtar")) {
                    String racial_stats = "Ability Scores: Wis +2; Cha +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Kenku")) {
                    String racial_stats = "Ability Scores: Dex +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Kobold")) {
                    String racial_stats = "Ability Scores: Str +2; Dex +2\n" +
                            "Size: Small\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Lizardfolk")) {
                    String racial_stats = "Ability Scores: Con +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft., swim 30 ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Loxodon")) {
                    String racial_stats = "Ability Scores: Con +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Minotaur")) {
                    String racial_stats = "Ability Scores: Str +2; Con +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Orc")) {
                    String racial_stats = "Ability Scores: Str +2; Con +1; Int -2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Tabaxi")) {
                    String racial_stats = "Ability Scores: Dex +2; Cha +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Tiefling")) {
                    String racial_stats = "Ability Scores: Int +1; Cha +2\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Tortle")) {
                    String racial_stats = "Ability Scores: Str +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Triton")) {
                    String racial_stats = "Ability Scores: Str +1; Con +1; Cha +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft., swim 30 ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_race.equalsIgnoreCase("Vedalken")) {
                    String racial_stats = "Ability Scores: Int +2; Wis +1\n" +
                            "Size: Medium\n" +
                            "Speed: 30ft.";
                    Toast.makeText(getApplicationContext(), racial_stats, Toast.LENGTH_LONG).show();
                }
            }
            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        class_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long l) {
                String selected_class = class_spinner.getItemAtPosition(position).toString();
                if (selected_class.equalsIgnoreCase("Artificer")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Con, Int\n";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Barbarian")) {
                    String class_stats = "Hit Dice: 1d12\n" +
                            "Proficiencies: Str, Con";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Bard")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Dex, Cha";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Blood Hunter")) {
                    String class_stats = "Hit Dice: 1d10\n" +
                            "Proficiencies: Str, Wis";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Cleric")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Wis, Cha";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Druid")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Int, Wis";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Fighter")) {
                    String class_stats = "Hit Dice: 1d10\n" +
                            "Proficiencies: Str, Con";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Monk")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Str, Dex";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Paladin")) {
                    String class_stats = "Hit Dice: 1d10\n" +
                            "Proficiencies: Wis, Cha";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Ranger")) {
                    String class_stats = "Hit Dice: 1d10\n" +
                            "Proficiencies: Str, Dex";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Rogue")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Dex, Int";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Sorcerer")) {
                    String class_stats = "Hit Dice: 1d6\n" +
                            "Proficiencies: Con, Cha";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Warlock")) {
                    String class_stats = "Hit Dice: 1d8\n" +
                            "Proficiencies: Wis, Cha";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }
                else if (selected_class.equalsIgnoreCase("Wizard")) {
                    String class_stats = "Hit Dice: 1d6\n" +
                            "Proficiencies: Int, Wis";
                    Toast.makeText(getApplicationContext(), class_stats, Toast.LENGTH_LONG).show();
                }

            }
            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
    }

    // Called when the user taps the Finish Character Creation button
    public void finishCreation(View view) {
        vcharacter_name = findViewById(R.id.character_name);
        character_name = vcharacter_name.getText().toString();

        vrace_dropdown = findViewById(R.id.race_dropdown);
        character_race = vrace_dropdown.getSelectedItem().toString();

        vclass_dropdown = findViewById(R.id.class_dropdown);
        character_class = vclass_dropdown.getSelectedItem().toString();

        vstr_input = findViewById(R.id.str_input);
        String str_string = vstr_input.getText().toString();
        if (str_string.equalsIgnoreCase("")) {
            str_base = 0;
        }
        else {
            str_base = Integer.parseInt(str_string);
        }

        vdex_input = findViewById(R.id.dex_input);
        String dex_string = vdex_input.getText().toString();
        if (dex_string.equalsIgnoreCase("")) {
            dex_base = 0;
        }
        else {
            dex_base = Integer.parseInt(dex_string);
        }

        vcon_input = findViewById(R.id.con_input);
        String con_string = vcon_input.getText().toString();
        if (con_string.equalsIgnoreCase("")) {
            con_base = 0;
        }
        else {
            con_base = Integer.parseInt(con_string);
        }

        vint_input = findViewById(R.id.int_input);
        String int_string = vint_input.getText().toString();
        if (int_string.equalsIgnoreCase("")) {
            int_base = 0;
        }
        else {
            int_base = Integer.parseInt(int_string);
        }

        vwis_input = findViewById(R.id.wis_input);
        String wis_string = vwis_input.getText().toString();
        if (wis_string.equalsIgnoreCase("")) {
            wis_base = 0;
        }
        else {
            wis_base = Integer.parseInt(wis_string);
        }

        vcha_input = findViewById(R.id.cha_input);
        String cha_string = vcha_input.getText().toString();
        if (cha_string.equalsIgnoreCase("")) {
            cha_base = 0;
        }
        else {
            cha_base = Integer.parseInt(cha_string);
        }


        if (character_name.equalsIgnoreCase("")){
            character_name = "no_name";
        }

        if (character_race.equalsIgnoreCase("Choose Race")){
            character_race = "Aarakocra";
        }
        if (character_class.equalsIgnoreCase("Choose Class")){
            character_class = "Artificer";
        }

        if (str_base < 1 || str_base > 30 || dex_base < 1 || dex_base > 30
                || con_base < 1 || con_base > 30 || int_base < 1 || int_base > 30
                || wis_base < 1 || wis_base > 30 || cha_base < 1 || cha_base > 30) {
            showToast("Ability scores must be between 1 and 30");
        }
        else if (checkSkillCount()) {
            showToast("Too many skills selected");
        }
        else {
            // Racial stats
            if (character_race.equalsIgnoreCase("Aarakocra")) {
                dex_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 50;
            }
            else if (character_race.equalsIgnoreCase("Aasimar")) {
                cha_misc = 2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Bugbear")) {
                str_misc = 2;
                dex_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Centaur")) {
                str_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 40;
            }
            else if (character_race.equalsIgnoreCase("Dragonborn")) {
                str_misc = 2;
                cha_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Dwarf")) {
                con_misc = 2;
                character_size = "Medium";
                character_speed = 25;
            }
            else if (character_race.equalsIgnoreCase("Elf")) {
                dex_misc = 2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Firbolg")) {
                str_misc = 1;
                wis_misc = 2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Genasi")) {
                con_misc = 2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Gith")) {
                int_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Gnome")) {
                int_misc = 2;
                character_size = "Small";
                character_speed = 25;
            }
            else if (character_race.equalsIgnoreCase("Goblin")) {
                dex_misc = 2;
                con_misc = 1;
                character_size = "Small";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Goliath")) {
                str_misc = 2;
                con_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Grung")) {
                dex_misc = 2;
                con_misc = 1;
                character_size = "Small";
                character_speed = 25;
            }
            else if (character_race.equalsIgnoreCase("Half-Orc")) {
                str_misc = 2;
                con_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Halfling")) {
                dex_misc = 2;
                character_size = "Small";
                character_speed = 25;
            }
            else if (character_race.equalsIgnoreCase("Hobgoblin")) {
                con_misc = 2;
                int_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Human")) {
                str_misc = 1;
                dex_misc = 1;
                con_misc = 1;
                int_misc = 1;
                wis_misc = 1;
                cha_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Kalashtar")) {
                wis_misc = 2;
                cha_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Kenku")) {
                dex_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Kobold")) {
                str_misc = 2;
                dex_misc = 2;
                character_size = "Small";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Lizardfolk")) {
                con_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Loxodon")) {
                con_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Minotaur")) {
                str_misc = 2;
                con_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Orc")) {
                str_misc = 2;
                con_misc = 1;
                int_misc = -2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Tabaxi")) {
                dex_misc = 2;
                cha_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Tiefling")) {
                int_misc = 1;
                cha_misc = 2;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Tortle")) {
                str_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Triton")) {
                str_misc = 1;
                con_misc = 1;
                cha_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }
            else if (character_race.equalsIgnoreCase("Vedalken")) {
                int_misc = 2;
                wis_misc = 1;
                character_size = "Medium";
                character_speed = 30;
            }

            // Class stats
            if (character_class.equalsIgnoreCase("Artificer")) {
                hit_dice = 8;
                con_proficiency = true;
                int_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Barbarian")) {
                hit_dice = 12;
                str_proficiency = true;
                con_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Bard")) {
                hit_dice = 8;
                dex_proficiency = true;
                cha_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Blood Hunter")) {
                hit_dice = 10;
                str_proficiency = true;
                wis_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Cleric")) {
                hit_dice = 8;
                wis_proficiency = true;
                cha_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Druid")) {
                hit_dice = 8;
                int_proficiency = true;
                wis_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Fighter")) {
                hit_dice = 10;
                str_proficiency = true;
                con_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Monk")) {
                hit_dice = 8;
                str_proficiency = true;
                dex_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Paladin")) {
                hit_dice = 10;
                wis_proficiency = true;
                cha_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Ranger")) {
                hit_dice = 10;
                str_proficiency = true;
                dex_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Rogue")) {
                hit_dice = 8;
                dex_proficiency = true;
                int_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Sorcerer")) {
                hit_dice = 6;
                con_proficiency = true;
                cha_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Warlock")) {
                hit_dice = 8;
                wis_proficiency = true;
                cha_proficiency = true;
            }
            else if (character_class.equalsIgnoreCase("Wizard")) {
                hit_dice = 6;
                int_proficiency = true;
                wis_proficiency = true;
            }

            // Sets checked skills to true
            checkedSkills();

            // Send to PC and refresh character list (currently sending to Character Sheet View)
//            Intent intent = new Intent(this, PlayerCharacterSheet.class);
            Intent intent = new Intent(this, DisplayCharactersList.class);

            base_hp = hit_dice + getModifier((con_base + con_misc));
            total_ac = base_ac + getModifier((dex_base + dex_misc));

            ArrayList<String> empty_attacks_list = new ArrayList<>();
            ArrayList<String> empty_info_list = new ArrayList<>();

            new_player = new Player("","","", "", "", 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,false,false,false,false,
                    false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
                    false,false,false,false,false,false,empty_attacks_list,empty_info_list, "", 0, 0);

            new_player.setCharacter_name(character_name);
            new_player.setCharacter_race(character_race);
            new_player.setCharacter_class(character_class);
            new_player.setBluetooth_id("null");
            new_player.setAction("Create New Player");
            new_player.setCharacter_level(1);
            new_player.setCharacter_ac_total(total_ac);
            new_player.setCharacter_max_hp(base_hp);
            new_player.setCharacter_current_hp(base_hp);
            new_player.setCharacter_proficiency(2);
            new_player.setCharacter_str((str_base + str_misc));
            new_player.setCharacter_str_mod((getModifier(str_base + str_misc)));
            new_player.setCharacter_dex((dex_base + dex_misc));
            new_player.setCharacter_dex_mod((getModifier(dex_base + dex_misc)));
            new_player.setCharacter_con((con_base + con_misc));
            new_player.setCharacter_con_mod((getModifier(con_base + con_misc)));
            new_player.setCharacter_int((int_base + int_misc));
            new_player.setCharacter_int_mod((getModifier(int_base + int_misc)));
            new_player.setCharacter_wis((wis_base + wis_misc));
            new_player.setCharacter_wis_mod((getModifier(wis_base + wis_misc)));
            new_player.setCharacter_cha((cha_base + cha_misc));
            new_player.setCharacter_cha_mod((getModifier(cha_base + cha_misc)));
            new_player.setCharacter_speed(character_speed);
            new_player.setStr_proficiency(str_proficiency);
            new_player.setDex_proficiency(dex_proficiency);
            new_player.setCon_proficiency(con_proficiency);
            new_player.setInt_proficiency(int_proficiency);
            new_player.setWis_proficiency(wis_proficiency);
            new_player.setCha_proficiency(cha_proficiency);
            new_player.setAcrobatics(acrobatics);
            new_player.setAnimal_handling(animal_handling);
            new_player.setArcana(arcana);
            new_player.setAthletics(athletics);
            new_player.setDeception(deception);
            new_player.setHistory(history);
            new_player.setInsight(insight);
            new_player.setIntimidation(intimidation);
            new_player.setInvestigation(investigation);
            new_player.setMedicine(medicine);
            new_player.setNature(nature);
            new_player.setPerception(perception);
            new_player.setPerformance(performance);
            new_player.setPersuasion(persuasion);
            new_player.setReligion(religion);
            new_player.setSleight_of_hand(sleight_of_hand);
            new_player.setStealth(stealth);
            new_player.setSurvival(survival);
            new_player.setCharacter_turn(false);
            empty_attacks_list.add("Unarmed Strike, 1, 4, Bludgeoning, 5, false, str");
            new_player.setAttack_buttons(empty_attacks_list);
            empty_info_list.add(0, "0");
            empty_info_list.add(1, "0");
            empty_info_list.add(2, "0");
            empty_info_list.add(3, "0");
            empty_info_list.add(4, "0");
            empty_info_list.add(5, "0");
            empty_info_list.add(6, "0");
            empty_info_list.add(7, "");
            empty_info_list.add(8, "");
            empty_info_list.add(9, "");
            empty_info_list.add(10, "");
            empty_info_list.add(11, "");
            empty_info_list.add(12, "");
            empty_info_list.add(13, "");
            new_player.setInfo_tab(empty_info_list);
            new_player.setUnique_character_id(UUID.randomUUID().toString());
            new_player.setCharacter_x_coordinate(-1);
            new_player.setCharacter_y_coordinate(-1);

            if (MainActivity.offline_mode) {
                savePlayerData();
            }
            else {
                savePlayerDataBT();
            }

            startActivity(intent);
        }
    }

    private void savePlayerData() {
        DisplayCharactersList.player_list.add(new_player);

        Comparator<Player> compareByName = new Comparator<Player>() {
            @Override
            public int compare(Player o1, Player o2) {
                return o1.getCharacter_name().compareToIgnoreCase(o2.getCharacter_name());
            }
        };
        Collections.sort(DisplayCharactersList.player_list, compareByName);

        SharedPreferences sharedPreferences = getSharedPreferences("shared preferences", MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Gson gson = new Gson();
        String json = gson.toJson(DisplayCharactersList.player_list);
        editor.putString("character_list", json);
        editor.apply();
    }

    private void savePlayerDataBT() {
        Gson gson = new Gson();
        String json = gson.toJson(new_player);

        MainActivity.mBluetoothConnection.write(json.getBytes());
        try {
            Thread.sleep(300);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void showToast(String msg) {
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
    }

    private boolean checkSkillCount() {
        int skill_count = 0;
        vacrobatics_checkbox = findViewById(R.id.acrobatics_checkbox);
        vanimal_handling_checkbox = findViewById(R.id.animal_handling_checkbox);
        varcana_checkbox = findViewById(R.id.arcana_checkbox);
        vathletics_checkbox = findViewById(R.id.athletics_checkbox);
        vdeception_checkbox = findViewById(R.id.deception_checkbox);
        vhistory_checkbox = findViewById(R.id.history_checkbox);
        vinsight_checkbox = findViewById(R.id.insight_checkbox);
        vintimidation_checkbox = findViewById(R.id.intimidation_checkbox);
        vinvestigation_checkbox = findViewById(R.id.investigation_checkbox);
        vmedicine_checkbox = findViewById(R.id.medicine_checkbox);
        vnature_checkbox = findViewById(R.id.nature_checkbox);
        vperception_checkbox = findViewById(R.id.perception_checkbox);
        vperformance_checkbox = findViewById(R.id.performance_checkbox);
        vpersuasion_checkbox = findViewById(R.id.persuasion_checkbox);
        vreligion_checkbox = findViewById(R.id.religion_checkbox);
        vsleight_of_hand_checkbox = findViewById(R.id.sleight_of_hand_checkbox);
        vstealth_checkbox = findViewById(R.id.stealth_checkbox);
        vsurvival_checkbox = findViewById(R.id.survival_checkbox);

        if(vacrobatics_checkbox.isChecked())
            skill_count++;
        if(vanimal_handling_checkbox.isChecked())
            skill_count++;
        if(varcana_checkbox.isChecked())
            skill_count++;
        if(vathletics_checkbox.isChecked())
            skill_count++;
        if(vdeception_checkbox.isChecked())
            skill_count++;
        if(vhistory_checkbox.isChecked())
            skill_count++;
        if(vinsight_checkbox.isChecked())
            skill_count++;
        if(vintimidation_checkbox.isChecked())
            skill_count++;
        if(vinvestigation_checkbox.isChecked())
            skill_count++;
        if(vmedicine_checkbox.isChecked())
            skill_count++;
        if(vnature_checkbox.isChecked())
            skill_count++;
        if(vperception_checkbox.isChecked())
            skill_count++;
        if(vperformance_checkbox.isChecked())
            skill_count++;
        if(vpersuasion_checkbox.isChecked())
            skill_count++;
        if(vreligion_checkbox.isChecked())
            skill_count++;
        if(vsleight_of_hand_checkbox.isChecked())
            skill_count++;
        if(vstealth_checkbox.isChecked())
            skill_count++;
        if(vsurvival_checkbox.isChecked())
            skill_count++;

        if (skill_count > 4)
            return true;

        return false;
    }

    private void checkedSkills() {
        vacrobatics_checkbox = findViewById(R.id.acrobatics_checkbox);
        vanimal_handling_checkbox = findViewById(R.id.animal_handling_checkbox);
        varcana_checkbox = findViewById(R.id.arcana_checkbox);
        vathletics_checkbox = findViewById(R.id.athletics_checkbox);
        vdeception_checkbox = findViewById(R.id.deception_checkbox);
        vhistory_checkbox = findViewById(R.id.history_checkbox);
        vinsight_checkbox = findViewById(R.id.insight_checkbox);
        vintimidation_checkbox = findViewById(R.id.intimidation_checkbox);
        vinvestigation_checkbox = findViewById(R.id.investigation_checkbox);
        vmedicine_checkbox = findViewById(R.id.medicine_checkbox);
        vnature_checkbox = findViewById(R.id.nature_checkbox);
        vperception_checkbox = findViewById(R.id.perception_checkbox);
        vperformance_checkbox = findViewById(R.id.performance_checkbox);
        vpersuasion_checkbox = findViewById(R.id.persuasion_checkbox);
        vreligion_checkbox = findViewById(R.id.religion_checkbox);
        vsleight_of_hand_checkbox = findViewById(R.id.sleight_of_hand_checkbox);
        vstealth_checkbox = findViewById(R.id.stealth_checkbox);
        vsurvival_checkbox = findViewById(R.id.survival_checkbox);

        if(vacrobatics_checkbox.isChecked())
            acrobatics = true;
        if(vanimal_handling_checkbox.isChecked())
            animal_handling = true;
        if(varcana_checkbox.isChecked())
            arcana = true;
        if(vathletics_checkbox.isChecked())
            athletics = true;
        if(vdeception_checkbox.isChecked())
            deception = true;
        if(vhistory_checkbox.isChecked())
            history = true;
        if(vinsight_checkbox.isChecked())
            insight = true;
        if(vintimidation_checkbox.isChecked())
            intimidation = true;
        if(vinvestigation_checkbox.isChecked())
            investigation = true;
        if(vmedicine_checkbox.isChecked())
            medicine = true;
        if(vnature_checkbox.isChecked())
            nature = true;
        if(vperception_checkbox.isChecked())
            perception = true;
        if(vperformance_checkbox.isChecked())
            performance = true;
        if(vpersuasion_checkbox.isChecked())
            persuasion = true;
        if(vreligion_checkbox.isChecked())
            religion = true;
        if(vsleight_of_hand_checkbox.isChecked())
            sleight_of_hand = true;
        if(vstealth_checkbox.isChecked())
            stealth = true;
        if(vsurvival_checkbox.isChecked())
            survival = true;
    }

    private int getModifier(int stat) {
        if (stat <= 1)
            return -5;
        else if (stat == 2 || stat == 3)
            return -4;
        else if (stat == 4 || stat == 5)
            return -3;
        else if (stat == 6 || stat == 7)
            return -2;
        else if (stat == 8 || stat == 9)
            return -1;
        else if (stat == 10 || stat == 11)
            return 0;
        else if (stat == 12 || stat == 13)
            return 1;
        else if (stat == 14 || stat == 15)
            return 2;
        else if (stat == 16 || stat == 17)
            return 3;
        else if (stat == 18 || stat == 19)
            return 4;
        else if (stat == 20 || stat == 21)
            return 5;
        else if (stat == 22 || stat == 23)
            return 6;
        else if (stat == 24 || stat == 25)
            return 7;
        else if (stat == 26 || stat == 27)
            return 8;
        else if (stat == 28 || stat == 29)
            return 9;
        else if (stat >= 30)
            return 10;


        return 0;
    }
}
