package com.sd2group30.gamingwizard;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;

public class DisplayCharactersList extends AppCompatActivity {
    private static final String TAG = "DisplayCharactersList";
    LinearLayout character_layout;
    public static ArrayList<Player> player_list = new ArrayList<>();
    public static Player player_selected = null;
    public static GM gm_selected = null;
    String request_players, total_json = "";

    BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingMessageText = intent.getStringExtra("theMessage");
                Log.d(TAG, "DisplayCharactersList: " + incomingMessageText);

                Gson gson = new Gson();
                total_json = total_json + incomingMessageText;
                try {
                    JsonObject json_message_total = gson.fromJson(total_json, JsonObject.class);
                    total_json = "";
                    Log.d(TAG, "Total Json: " + json_message_total.toString());
                    try {
                        String action_json = json_message_total.get("action").getAsString();

                        if (action_json.equalsIgnoreCase("Player List")) {
                            ArrayList <Player> player_list_PC = gson.fromJson(json_message_total.get("players").getAsJsonArray(), new TypeToken<ArrayList<Player>>(){}.getType());

                            player_list.clear();
                            for (Player token : player_list_PC) {
                                player_list.add(token);
                            }
                            Log.d(TAG, "player_list: " + player_list);
                            characterlist();
                        }

                        if (action_json.equalsIgnoreCase("GMInfo")) {
                            gm_selected = gson.fromJson(json_message_total, new TypeToken<GM>(){}.getType());
                            Log.d(TAG, "gm_selected: " + gm_selected);
                        }
                    } catch (JsonSyntaxException e) {
                        Log.e(TAG, "This is a length JSON");
                    }
                } catch (JsonSyntaxException ex) {
                    Log.d(TAG, "Not able to make JSON");
                    largeLog(total_json);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onBackPressed() {}

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_display_characters_list);

        JSONObject request_players_json = new JSONObject();
        try {
            request_players_json.put("action", "Request All Characters");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        request_players = request_players_json.toString();


        JSONObject request_GM_json = new JSONObject();
        try {
            request_GM_json.put("action", "Request GM Information");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        String request_GM = request_GM_json.toString();


        player_list.clear();
        gm_selected = null;
        player_selected = null;
        if (MainActivity.offline_mode) {
            loadOfflinePlayerData();
            loadOfflineGMData();
        }
        else {
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver, new IntentFilter("incomingMessage"));
            MainActivity.mBluetoothConnection.write(request_players.getBytes());
            try {
                Thread.sleep(300);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            MainActivity.mBluetoothConnection.write(request_GM.getBytes());
        }
        characterlist();
    }

    private void loadOfflineGMData() {
        SharedPreferences sharedPreferences = getSharedPreferences("shared preferences", MODE_PRIVATE);
        Gson gson = new Gson();
        String json = sharedPreferences.getString("gm_offline", null);
        Type type = new TypeToken<GM>(){}.getType();
        gm_selected = gson.fromJson(json, type);

        if (gm_selected == null) {
            ArrayList<NPC> emptynpcs = new ArrayList<>();
            Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
            ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
            ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
            ArrayList<Encounter> encounters_list = new ArrayList<>();
            gm_selected = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);
        }
    }

    private void loadOfflinePlayerData() {
        SharedPreferences sharedPreferences = getSharedPreferences("shared preferences", MODE_PRIVATE);
        Gson gson = new Gson();
        String json = sharedPreferences.getString("character_list", null);
        Type type = new TypeToken<ArrayList<Player>>(){}.getType();
        player_list = gson.fromJson(json, type);

        if (player_list == null) {
            player_list = new ArrayList<>();
        }

        if (player_list.isEmpty()) {
            ArrayList<String> empty_attacks_list = new ArrayList<>();
            ArrayList<String> empty_info_list = new ArrayList<>();

            Player example_offline_player = new Player("","","","","", 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,false,false,false,false,
                    false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
                    false,false,false,false,false,false,empty_attacks_list,empty_info_list, "", 0, 0);

            example_offline_player.setCharacter_name("Offline Player Example");
            example_offline_player.setCharacter_race("Human");
            example_offline_player.setCharacter_class("Wizard");
            example_offline_player.setCharacter_level(1);
            example_offline_player.setCharacter_ac_total(10);
            example_offline_player.setCharacter_max_hp(15);
            example_offline_player.setCharacter_current_hp(15);
            example_offline_player.setCharacter_proficiency(2);
            example_offline_player.setCharacter_str(8);
            example_offline_player.setCharacter_str_mod(-1);
            example_offline_player.setCharacter_dex(8);
            example_offline_player.setCharacter_dex_mod(-1);
            example_offline_player.setCharacter_con(8);
            example_offline_player.setCharacter_con_mod(-1);
            example_offline_player.setCharacter_int(8);
            example_offline_player.setCharacter_int_mod(-1);
            example_offline_player.setCharacter_wis(8);
            example_offline_player.setCharacter_wis_mod(-1);
            example_offline_player.setCharacter_cha(8);
            example_offline_player.setCharacter_cha_mod(-1);
            example_offline_player.setCharacter_speed(30);
            example_offline_player.setStr_proficiency(true);
            example_offline_player.setWis_proficiency(true);
            example_offline_player.setArcana(true);
            example_offline_player.setCharacter_turn(false);

            empty_attacks_list.add("Unarmed Strike, 1, 4, Bludgeoning, 5, false, str");
            example_offline_player.setAttack_buttons(empty_attacks_list);
            empty_info_list.add(0, "0");
            empty_info_list.add(1, "0");
            empty_info_list.add(2, "0");
            empty_info_list.add(3, "0");
            empty_info_list.add(4, "0");
            empty_info_list.add(5, "0");
            empty_info_list.add(6, "0");
            empty_info_list.add(7, "");
            empty_info_list.add(8, "");
            empty_info_list.add(9, "");
            empty_info_list.add(10, "");
            empty_info_list.add(11, "");
            empty_info_list.add(12, "");
            empty_info_list.add(13, "");
            example_offline_player.setInfo_tab(empty_info_list);
            example_offline_player.setUnique_character_id(UUID.randomUUID().toString());
            example_offline_player.setCharacter_x_coordinate(-1);
            example_offline_player.setCharacter_y_coordinate(-1);

            player_list.add(example_offline_player);
        }
    }

    public void characterlist() {
        character_layout = findViewById(R.id.character_layout);
        if(character_layout.getChildCount() > 0)
            character_layout.removeAllViews();

        if (player_list == null)
            player_list = new ArrayList<>();

        for (Player player : player_list) {
            Button btnWord = new Button(this);
            btnWord.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            btnWord.setText(player.getCharacter_name());
            btnWord.setTextColor(Color.BLACK);
            btnWord.setTag(player);
            btnWord.setOnClickListener(btnClicked);
            btnWord.setLongClickable(true);
            btnWord.setOnLongClickListener(btnDeleteClicked);
            character_layout.addView(btnWord);
        }
    }

    View.OnClickListener btnClicked = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            openPlayerSheet(v);
        }
    };

    private void openPlayerSheet(View v) {
        Object tag = v.getTag();
        if (MainActivity.offline_mode) {
            player_selected = (Player) tag;
            player_selected.setBluetooth_id(MainActivity.android_id);
            Intent intent = new Intent(this, PlayerCharacterSheet.class);
            startActivity(intent);
        }
        else {
            player_selected = (Player) tag;
            player_selected.setBluetooth_id(MainActivity.android_id);
            player_selected.setAction("Update Character");

            Gson gson = new Gson();
            String json = gson.toJson(player_selected);

            MainActivity.mBluetoothConnection.write(json.getBytes());
//            try {
//                Thread.sleep(300);
//            } catch (InterruptedException e) {
//                e.printStackTrace();
//            }

            Intent intent = new Intent(this, PlayerCharacterSheet.class);
            startActivity(intent);
        }
    }

    View.OnLongClickListener btnDeleteClicked = new View.OnLongClickListener() {
        @Override
        public boolean onLongClick(View view) {
            Object tag = view.getTag();
            Button deleteThisButton = view.findViewWithTag(tag);
            if (MainActivity.offline_mode) {
                showToast("Character: " + deleteThisButton.getText().toString() + " has been deleted");
                character_layout.removeView(deleteThisButton);
                player_list.remove(tag);
                SharedPreferences sharedPreferences = getSharedPreferences("shared preferences", MODE_PRIVATE);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                Gson gson = new Gson();
                String json = gson.toJson(player_list);
                editor.putString("character_list", json);
                editor.apply();
            }
            else {
//                AlertBox("Delete Character?", "Are you sure you want to permanently delete " + deleteThisButton.getText().toString() + "? This will delete this character for the Game Session and cannot be undone.");
                // Bluetooth send delete character to PC
            }
            return true;
        }
    };

    /** Called when the user taps the "Plus" button */
    public void addCharacter(View view) {
        Intent intent = new Intent(this, CharacterCreation.class);
        startActivity(intent);
    }

    /** Called when the user taps the "GM" button */
    public void chooseGM(View view) {
        if (gm_selected == null) {
            ArrayList<NPC> emptynpcs = new ArrayList<>();
            Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
            ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
            ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
            ArrayList<Encounter> encounters_list = new ArrayList<>();
            gm_selected = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);
        }

        if (gm_selected.getNpcs_list().isEmpty()) {
            gm_selected.setNpcs_list(getExampleNPCList());
        }

        if (MainActivity.offline_mode) {
            gm_selected.setPlayers_list(getPlayerList());
        }
        else {
            gm_selected.getPlayers_list().clear();
            ArrayList<NPC> players_as_npcs = new ArrayList<>();
            ArrayList<String> empty = new ArrayList<>();

            if (player_list == null)
                player_list = new ArrayList<>();

            for (Player player : player_list) {
                NPC player_token_npc = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "nullID", 0, 0);
                player_token_npc.setName(player.getCharacter_name());
                player_token_npc.setPlayer(true);
                player_token_npc.setUnique_character_id(player.getUnique_character_id());
                players_as_npcs.add(player_token_npc);
            }
            gm_selected.setPlayers_list(players_as_npcs);
        }

        if (gm_selected.getEncounters_list().isEmpty() && (gm_selected.getNpcs_list().size() > 2)) {
            gm_selected.setEncounters_list(getExampleEncounterList());
        }

        if (gm_selected.getInfo_tab_gm().isEmpty() || (gm_selected.getInfo_tab_gm().size() < 6)) {
            gm_selected.getInfo_tab_gm().add(0, "");
            gm_selected.getInfo_tab_gm().add(1, "");
            gm_selected.getInfo_tab_gm().add(2, "");
            gm_selected.getInfo_tab_gm().add(3, "");
            gm_selected.getInfo_tab_gm().add(4, "");
            gm_selected.getInfo_tab_gm().add(5, "");
            gm_selected.getInfo_tab_gm().add(6, "");
        }

        gm_selected.setAction("GM selected");
        gm_selected.setBluetooth_id(MainActivity.android_id);

        if (!MainActivity.offline_mode) {
            selectGMData(gm_selected);
        }

        Intent intent = new Intent(this, GMScreen.class);
        startActivity(intent);
    }

    private ArrayList<NPC> getPlayerList() {
        ArrayList<NPC> player_list_examples = new ArrayList<NPC>();
        ArrayList<String> empty = new ArrayList<String>();

        NPC player1 = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        player1.setName("Player 1");
        player1.setPlayer(true);
        player1.setUnique_character_id(UUID.randomUUID().toString());

        NPC player2 = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        player2.setName("Player 2");
        player2.setPlayer(true);
        player2.setUnique_character_id(UUID.randomUUID().toString());

        NPC player3 = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        player3.setName("Player 3");
        player3.setPlayer(true);
        player3.setUnique_character_id(UUID.randomUUID().toString());

        NPC player4 = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        player4.setName("Player 4");
        player4.setPlayer(true);
        player4.setUnique_character_id(UUID.randomUUID().toString());

        player_list_examples.add(player1);
        player_list_examples.add(player2);
        player_list_examples.add(player3);
        player_list_examples.add(player4);

        return player_list_examples;
    }

    private ArrayList<NPC> getExampleNPCList() {
        ArrayList<NPC> npcs_list_examples = new ArrayList<NPC>();
        ArrayList<String> empty = new ArrayList<String>();

        NPC alpha_wolf = new NPC("No Name",0, 0, 0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        alpha_wolf.setName("Alpha Wolf");
        alpha_wolf.setHp(15);
        alpha_wolf.setCurrent_hp(15);
        alpha_wolf.setAc(13);
        alpha_wolf.setSpeed(40);
        alpha_wolf.setStr_score(8);
        alpha_wolf.setDex_score(12);
        alpha_wolf.setCon_score(7);
        alpha_wolf.setInt_score(6);
        alpha_wolf.setWis_score(8);
        alpha_wolf.setCha_score(8);
        alpha_wolf.setChallenge_score(3);
        alpha_wolf.setExp_given(100);

        ArrayList<String> attack_set1 = new ArrayList<String>();

//            splited_strings[0] = attack_name;
//            splited_strings[1] = num_dice
//            splited_strings[2] = type_dice
//            splited_strings[3] = attack_type
//            splited_strings[4] = attack_range
//            splited_strings[5] = mod

        attack_set1.add("Claw, 1, 6, Slashing, 5, dex");
        attack_set1.add("Bite, 1, 6, Piercing, 5, str");

        Collections.sort(attack_set1, String.CASE_INSENSITIVE_ORDER);
        alpha_wolf.setNpc_attack_buttons(attack_set1);


        NPC adult_white_dragon = new NPC("No Name",0, 0, 0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        adult_white_dragon.setName("Adult White Dragon");
        adult_white_dragon.setHp(105);
        adult_white_dragon.setCurrent_hp(105);
        adult_white_dragon.setAc(19);
        adult_white_dragon.setSpeed(60);
        adult_white_dragon.setStr_score(21);
        adult_white_dragon.setDex_score(10);
        adult_white_dragon.setCon_score(23);
        adult_white_dragon.setInt_score(20);
        adult_white_dragon.setWis_score(16);
        adult_white_dragon.setCha_score(15);
        adult_white_dragon.setChallenge_score(14);
        adult_white_dragon.setExp_given(10000);

        ArrayList<String> attack_set2 = new ArrayList<String>();


        attack_set2.add("Tail, 3, 8, Bludgeoning, 15, str");
        attack_set2.add("Bite, 2, 12, Piercing, 5, str");
        attack_set2.add("Claw, 2, 6, Slashing, 10, str");

        Collections.sort(attack_set2, String.CASE_INSENSITIVE_ORDER);
        adult_white_dragon.setNpc_attack_buttons(attack_set2);


        NPC pirate_captain = new NPC("No Name",0, 0, 0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
        pirate_captain.setName("Pirate Captain");
        pirate_captain.setHp(25);
        pirate_captain.setCurrent_hp(25);
        pirate_captain.setAc(15);
        pirate_captain.setSpeed(35);
        pirate_captain.setStr_score(9);
        pirate_captain.setDex_score(15);
        pirate_captain.setCon_score(10);
        pirate_captain.setInt_score(13);
        pirate_captain.setWis_score(10);
        pirate_captain.setCha_score(7);
        pirate_captain.setChallenge_score(5);
        pirate_captain.setExp_given(1800);

        ArrayList<String> attack_set3 = new ArrayList<String>();

        attack_set3.add("Scimitar, 2, 8, Slashing, 5, str");
        attack_set3.add("Dagger, 1, 10, Piercing, 5, dex");

        Collections.sort(attack_set3, String.CASE_INSENSITIVE_ORDER);
        pirate_captain.setNpc_attack_buttons(attack_set3);

        npcs_list_examples.add(alpha_wolf);
        npcs_list_examples.add(adult_white_dragon);
        npcs_list_examples.add(pirate_captain);

        Comparator<NPC> compareByName = new Comparator<NPC>() {
            @Override
            public int compare(NPC o1, NPC o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(npcs_list_examples, compareByName);

        return npcs_list_examples;
    }

    private ArrayList<Encounter> getExampleEncounterList() {
        ArrayList<Encounter> encounters_list_examples = new ArrayList<Encounter>();

        ArrayList<NPC> npcs1 = new ArrayList<NPC>();
        Encounter example1 = new Encounter("No Name", npcs1);
        example1.setEncounterName("Encounter 1");
        npcs1.add(gm_selected.getNpcs_list().get(2));
        npcs1.add(gm_selected.getNpcs_list().get(2));
        npcs1.add(gm_selected.getNpcs_list().get(2));
        for (NPC token : npcs1) {
            token.setUnique_character_id(UUID.randomUUID().toString());
        }
        example1.setNpcs_in_encounter(npcs1);

        ArrayList<NPC> npcs2 = new ArrayList<NPC>();
        Encounter example2 = new Encounter("No Name", npcs2);
        example2.setEncounterName("Encounter 2");
        npcs2.add(gm_selected.getNpcs_list().get(1));
        npcs2.add(gm_selected.getNpcs_list().get(1));
        npcs2.add(gm_selected.getNpcs_list().get(1));
        for (NPC token : npcs2) {
            token.setUnique_character_id(UUID.randomUUID().toString());
        }
        example2.setNpcs_in_encounter(npcs2);

        ArrayList<NPC> npcs3 = new ArrayList<NPC>();
        Encounter example3 = new Encounter("No Name", npcs3);
        example3.setEncounterName("Encounter 3");
        npcs3.add(gm_selected.getNpcs_list().get(0));
        npcs3.add(gm_selected.getNpcs_list().get(1));
        npcs3.add(gm_selected.getNpcs_list().get(2));
        for (NPC token : npcs3) {
            token.setUnique_character_id(UUID.randomUUID().toString());
        }
        example3.setNpcs_in_encounter(npcs3);

        encounters_list_examples.add(example1);
        encounters_list_examples.add(example2);
        encounters_list_examples.add(example3);

        Comparator<Encounter> compareByEncounterName = new Comparator<Encounter>() {
            @Override
            public int compare(Encounter o1, Encounter o2) {
                return o1.getEncounterName().compareToIgnoreCase(o2.getEncounterName());
            }
        };
        Collections.sort(encounters_list_examples, compareByEncounterName);

        return encounters_list_examples;
    }

    private void showToast(String msg) {
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
    }

    private void largeLog(String json) {
        if (json.length() > 4000) {
            Log.d(TAG, json.substring(0, 4000));
            largeLog(json.substring(4000));
        }
        else {
            Log.d(TAG, json);
        }
    }

    private void selectGMData(GM gm_selected) {
        Gson gson = new Gson();
        String json = gson.toJson(gm_selected);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }

    public void AlertBox(String title, String message){
        new AlertDialog.Builder(this)
                .setTitle(title)
                .setMessage(message)
                .setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                    }
                })
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface arg0, int arg1) {
//                        JSONObject delete_player_json = new JSONObject();
//                        try {
//                            delete_player_json.put("action", "Request All Characters");
//                        } catch (JSONException e) {
//                            e.printStackTrace();
//                        }
//                        String request_players = request_players_json.toString();
//                        MainActivity.mBluetoothConnection.write(.getBytes());
                    }
                }).show();
    }
}
