package com.sd2group30.gamingwizard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.sd2group30.gamingwizard.main.tab3gm;
import com.google.gson.Gson;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class EnemyInfo extends AppCompatActivity implements NewEnemyAttackDialog.NewEnemyAttackDialogListener{
    private static final String TAG = "EnemyInfo";
    Integer position;
    TextView enemy_name, enemy_hp_info, enemy_ac_info, enemy_speed_info, enemy_str_info, enemy_dex_info, enemy_con_info,
            enemy_int_info, enemy_wis_info, enemy_cha_info;
    Button save_changes_to_enemy, move_enemy_info, place_enemy_info, end_turn_enemy_info;
    LinearLayout linear_enemy_info;

    @Override
    public void onBackPressed() {}

    BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingMessageText = intent.getStringExtra("theMessage");
                Log.d(TAG, "In EnemyInfo: " + incomingMessageText);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.enemy_info_layout);
        Log.d(TAG, "onCreate: started.");

        getIncomingIntent();

        linear_enemy_info = findViewById(R.id.linear_enemy_info);

        refreshEnemyAttack();

        enemy_name = findViewById(R.id.enemy_name);
        enemy_name.setText(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getName());

        enemy_hp_info = findViewById(R.id.enemy_hp_info);
        enemy_hp_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCurrent_hp()));

        enemy_ac_info = findViewById(R.id.enemy_ac_info);
        enemy_ac_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getAc()));

        enemy_speed_info = findViewById(R.id.enemy_speed_info);
        enemy_speed_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getSpeed()));

        enemy_str_info = findViewById(R.id.enemy_str_info);
        enemy_str_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getStr_score()));
        enemy_dex_info = findViewById(R.id.enemy_dex_info);
        enemy_dex_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getDex_score()));
        enemy_con_info = findViewById(R.id.enemy_con_info);
        enemy_con_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCon_score()));
        enemy_int_info = findViewById(R.id.enemy_int_info);
        enemy_int_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getInt_score()));
        enemy_wis_info = findViewById(R.id.enemy_wis_info);
        enemy_wis_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getWis_score()));
        enemy_cha_info = findViewById(R.id.enemy_cha_info);
        enemy_cha_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCha_score()));

        save_changes_to_enemy = findViewById(R.id.save_changes_to_enemy);
        save_changes_to_enemy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (enemy_name.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setName("No Name");
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setName(enemy_name.getText().toString());

                if (enemy_hp_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCurrent_hp(0);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCurrent_hp(Integer.parseInt(enemy_hp_info.getText().toString()));

                if (enemy_ac_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setAc(10);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setAc(Integer.parseInt(enemy_ac_info.getText().toString()));

                if (enemy_speed_info.getText().toString().equalsIgnoreCase("")) {
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setSpeed(30);
                }
                else {
                    Integer non_rounded = Integer.parseInt(enemy_speed_info.getText().toString());
                    Integer rounded = (int) (5*(Math.ceil(Math.abs(non_rounded/5))));
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setSpeed(rounded);
                }

                if (enemy_str_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setStr_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setStr_score(Integer.parseInt(enemy_str_info.getText().toString()));

                if (enemy_dex_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setDex_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setDex_score(Integer.parseInt(enemy_dex_info.getText().toString()));

                if (enemy_con_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCon_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCon_score(Integer.parseInt(enemy_con_info.getText().toString()));

                if (enemy_int_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setInt_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setInt_score(Integer.parseInt(enemy_int_info.getText().toString()));

                if (enemy_wis_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setWis_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setWis_score(Integer.parseInt(enemy_wis_info.getText().toString()));

                if (enemy_cha_info.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCha_score(8);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setCha_score(Integer.parseInt(enemy_cha_info.getText().toString()));

                move_enemy_info.setText("Move " + GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getSpeed() + "ft.");

                enemy_name.setText(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getName());
                enemy_hp_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCurrent_hp()));
                enemy_ac_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getAc()));
                enemy_speed_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getSpeed()));

                enemy_str_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getStr_score()));
                enemy_dex_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getDex_score()));
                enemy_con_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCon_score()));
                enemy_int_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getInt_score()));
                enemy_wis_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getWis_score()));
                enemy_cha_info.setText(Integer.toString(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCha_score()));

                tab3gm.adapter.notifyDataSetChanged();

                Toast.makeText(EnemyInfo.this, "Changes Saved To " + GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getName(), Toast.LENGTH_SHORT).show();
            }
        });

        move_enemy_info = findViewById(R.id.move_enemy_info);
        move_enemy_info.setText("Move " + GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getSpeed() + "ft.");
        move_enemy_info.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (GMScreen.encounter_selected.getNpcs_in_encounter().get(position).isTurn()) {
                    Toast.makeText(EnemyInfo.this, "Move in game", Toast.LENGTH_SHORT).show();
                    if (!MainActivity.offline_mode) {
                        JSONObject move_character_json = new JSONObject();
                        try {
                            move_character_json.put("action", "Move Character");
                            move_character_json.put("speed", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getSpeed());
                            move_character_json.put("character_x_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_x_coordinate());
                            move_character_json.put("character_y_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_y_coordinate());
                            move_character_json.put("bluetooth_id", MainActivity.android_id);
                            move_character_json.put("unique_character_id", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getUnique_character_id());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String move_character = move_character_json.toString();

                        MainActivity.mBluetoothConnection.write(move_character.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }
                }
                else {
                    Toast.makeText(EnemyInfo.this, "It must be this character's turn to move", Toast.LENGTH_SHORT).show();
                }
            }
        });

        place_enemy_info = findViewById(R.id.place_enemy_info);
        place_enemy_info.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (MainActivity.offline_mode) {
                    Toast.makeText(EnemyInfo.this, "This will not do anything in offline mode", Toast.LENGTH_SHORT).show();
                }
                else {
                    if (GMScreen.encounter_selected.getNpcs_in_encounter().get(position).isTurn()) {
                        Toast.makeText(EnemyInfo.this, "Place character in PC", Toast.LENGTH_SHORT).show();
                        JSONObject changexy_character_json = new JSONObject();
                        try {
                            changexy_character_json.put("action", "MoveXY");
                            changexy_character_json.put("character", "NPC");
                            changexy_character_json.put("character_x_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_x_coordinate());
                            changexy_character_json.put("character_y_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_y_coordinate());
                            changexy_character_json.put("bluetooth_id", MainActivity.android_id);
                            changexy_character_json.put("unique_character_id", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getUnique_character_id());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String changexy_character = changexy_character_json.toString();

                        MainActivity.mBluetoothConnection.write(changexy_character.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }
                    else {
                        Toast.makeText(EnemyInfo.this, "It must be this character's turn to place", Toast.LENGTH_SHORT).show();
                    }
                }
            }
        });


        end_turn_enemy_info = findViewById(R.id.end_turn_enemy_info);
        end_turn_enemy_info.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (GMScreen.encounter_selected.getNpcs_in_encounter().get(position).isTurn()) {
                    Toast.makeText(EnemyInfo.this, "Turn ended", Toast.LENGTH_SHORT).show();
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).setTurn(false);

                    GMScreen.turn_number = GMScreen.turn_number + 1;
                    if (GMScreen.turn_number >= GMScreen.encounter_selected.getNpcs_in_encounter().size()) {
                        GMScreen.turn_number = 0;
                        GMScreen.round_number = GMScreen.round_number + 1;
                        tab3gm.round_textview.setText("Round " + GMScreen.round_number);
                    }

                    if (!(GMScreen.encounter_selected.getNpcs_in_encounter().isEmpty()))
                        GMScreen.encounter_selected.getNpcs_in_encounter().get(GMScreen.turn_number).setTurn(true);
                    tab3gm.adapter.notifyDataSetChanged();

                    if (!MainActivity.offline_mode) {
                        ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
                        GMScreen.turn_order_list.setAction("Update Turn Order");
                        for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                            TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
                            token.setName(character.getName());
                            token.setInitiative(character.getInitiative());
                            token.setTurn(character.isTurn());
                            token.setUnique_character_id(character.getUnique_character_id());
                            token.setPlayer(character.isPlayer());
                            token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
                            token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
                            list_chars.add(token);
                        }
                        GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);

                        Gson gson = new Gson();
                        String json = gson.toJson(GMScreen.turn_order_list);

                        MainActivity.mBluetoothConnection.write(json.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }

                }
                else {
                    Toast.makeText(EnemyInfo.this, "It not this character's turn", Toast.LENGTH_SHORT).show();
                }
            }
        });

        Button new_enemy_attack_button = findViewById(R.id.new_enemy_attack_button);
        new_enemy_attack_button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openNewEnemyAttackDialog();
            }
        });

        if (!MainActivity.offline_mode) {
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver, new IntentFilter("incomingMessage"));
        }
    }

    public void AlertBox(String title, String message){
        new AlertDialog.Builder(this)
                .setTitle(title)
                .setMessage(message)
                .setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                    }
                })
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface arg0, int arg1) {
                    }
                }).show();
    }

    private void getIncomingIntent() {
        Log.d(TAG, "getIncomingIntent: checking for incoming intents.");

        if (getIntent().hasExtra("position")) {
            Log.d(TAG, "getIncomingIntent: found intent extras");

            position = Integer.parseInt(getIntent().getStringExtra("position").toString());
        }
    }

    private ArrayList<String> removeDuplicates(ArrayList<String> list) {
        Set<String> set = new LinkedHashSet<>();

        set.addAll(list);
        list.clear();
        list.addAll(set);

        return list;

    }

    public void openNewEnemyAttackDialog() {
        NewEnemyAttackDialog newEnemyAttackDialog = new NewEnemyAttackDialog();
        newEnemyAttackDialog.show(getSupportFragmentManager(), "new_enemy_attack_dialog");
    }

    @Override
    public void makeNewEnemyAttack(String attack_name, int num_dice, int type_dice, String attack_type, int attack_range, String mod) {
        GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getNpc_attack_buttons()
                .add(attack_name + ", " + num_dice + ", " + type_dice + ", " + attack_type + ", " + attack_range + ", " + mod);

        refreshEnemyAttack();
    }

    private void refreshEnemyAttack() {
        if (linear_enemy_info.getChildCount() > 0)
            linear_enemy_info.removeAllViews();

        removeDuplicates(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getNpc_attack_buttons());
        Collections.sort(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getNpc_attack_buttons(), String.CASE_INSENSITIVE_ORDER);

        for (final String attack_tag : GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getNpc_attack_buttons()) {
            Button btnTag = new Button(this);
//            btnTag.setId(View.generateViewId());
            btnTag.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            btnTag.setTag(attack_tag);

            String[] splited_strings = attack_tag.split(", ");

            btnTag.setText(splited_strings[0] + "   " + splited_strings[1] + "d" + splited_strings[2]
                    + "   " + splited_strings[3] + "\nAdded Mod: " + splited_strings[5] + "   Range: "
                    + splited_strings[4] + "ft.");


            btnTag.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Object tag = v.getTag();
                    if (GMScreen.encounter_selected.getNpcs_in_encounter().get(position).isTurn()) {
                        String attack_tag = (String) tag;
                        String[] splited_strings = attack_tag.split(", ");
                        Random random = new Random();
                        int attack_roll = 0;
                        for (int i = 0; i < Integer.parseInt(splited_strings[1]); i++) {
                            attack_roll = attack_roll + random.nextInt(Integer.parseInt(splited_strings[2])) + 1;
                        }
                        attack_roll = attack_roll + getDamageMod(splited_strings[5]);

                        if (attack_roll < 0)
                            attack_roll = 0;

                        if (MainActivity.offline_mode){
                            Toast.makeText(getApplicationContext(), "You deal " + attack_roll + " " + splited_strings[3] + " damage", Toast.LENGTH_SHORT).show();
                        }
                        else {
                            Toast.makeText(getApplicationContext(), "You deal " + attack_roll + " " + splited_strings[3] + " damage", Toast.LENGTH_SHORT).show();
                            JSONObject npc_attack_json = new JSONObject();
                            try {
                                npc_attack_json.put("action", "attack");
                                npc_attack_json.put("damage_roll", attack_roll);
                                npc_attack_json.put("damage_type", splited_strings[3]);
                                npc_attack_json.put("range", Integer.parseInt(splited_strings[4]));
                                npc_attack_json.put("character_x_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_x_coordinate());
                                npc_attack_json.put("character_y_coordinate", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCharacter_y_coordinate());
                                npc_attack_json.put("bluetooth_id", MainActivity.android_id);
                                npc_attack_json.put("unique_character_id", GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getUnique_character_id());
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            String npc_attack = npc_attack_json.toString();

                            MainActivity.mBluetoothConnection.write(npc_attack.getBytes());
//                            try {
//                                Thread.sleep(300);
//                            } catch (InterruptedException e) {
//                                e.printStackTrace();
//                            }
                        }
                    }
                    else {
                        Toast.makeText(EnemyInfo.this, "It Is Not Your Turn", Toast.LENGTH_SHORT).show();
                    }
                }
            });
            btnTag.setLongClickable(true);
            btnTag.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    Object tag = v.getTag();
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getNpc_attack_buttons().remove(tag);
                    Button deleteThisButton = v.findViewWithTag(tag);
                    linear_enemy_info.removeView(deleteThisButton);
                    tab3gm.adapter.notifyDataSetChanged();
                    Toast.makeText(EnemyInfo.this, "Attack Deleted From " + GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getName(), Toast.LENGTH_SHORT).show();
                    return true;
                }
            });
            linear_enemy_info.addView(btnTag);
        }


    }

    private int getDamageMod(String mod) {
        if (mod.equalsIgnoreCase("str"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getStr_score());
        else if (mod.equalsIgnoreCase("dex"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getDex_score());
        else if (mod.equalsIgnoreCase("con"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCon_score());
        else if (mod.equalsIgnoreCase("int"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getInt_score());
        else if (mod.equalsIgnoreCase("wis"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getWis_score());
        else if (mod.equalsIgnoreCase("cha"))
            return getModifier(GMScreen.encounter_selected.getNpcs_in_encounter().get(position).getCha_score());

        return 0;
    }

    private int getModifier(int stat) {
        if (stat <= 1)
            return -5;
        else if (stat == 2 || stat == 3)
            return -4;
        else if (stat == 4 || stat == 5)
            return -3;
        else if (stat == 6 || stat == 7)
            return -2;
        else if (stat == 8 || stat == 9)
            return -1;
        else if (stat == 10 || stat == 11)
            return 0;
        else if (stat == 12 || stat == 13)
            return 1;
        else if (stat == 14 || stat == 15)
            return 2;
        else if (stat == 16 || stat == 17)
            return 3;
        else if (stat == 18 || stat == 19)
            return 4;
        else if (stat == 20 || stat == 21)
            return 5;
        else if (stat == 22 || stat == 23)
            return 6;
        else if (stat == 24 || stat == 25)
            return 7;
        else if (stat == 26 || stat == 27)
            return 8;
        else if (stat == 28 || stat == 29)
            return 9;
        else if (stat >= 30)
            return 10;


        return 0;
    }
}
