package com.sd2group30.gamingwizard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;

import com.sd2group30.gamingwizard.main.tab1gm;
import com.sd2group30.gamingwizard.main.tab2gm;
import com.sd2group30.gamingwizard.main.tab3gm;
import com.sd2group30.gamingwizard.main.tab4gm;
import com.google.android.material.tabs.TabLayout;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class GMScreen extends AppCompatActivity {
    private static final String TAG = "GMScreen";
    private TabLayout tablayout_gmscreen;
    private ViewPager viewpagergm;
    public PageAdapter mpageradaptergm;
    public static String action;
    public static ArrayList<String> maps_list = new ArrayList<String>(), info_tab_gm = new ArrayList<String>();
    public static ArrayList<NPC> npcs_list = new ArrayList<NPC>();
    public static ArrayList<NPC> players_list = new ArrayList<NPC>();
    public static ArrayList<Encounter> encounters_list = new ArrayList<Encounter>();
    public static Encounter encounter_selected;
    public static Integer turn_number = 0, round_number = 0;
    public static TurnList turn_order_list = new TurnList("", null);
    String total_json = "";

    @Override
    public void onBackPressed() {}

    BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingMessageText = intent.getStringExtra("theMessage");
                Log.d(TAG, "GMScreen: " + incomingMessageText);

                Gson gson = new Gson();
                total_json = total_json + incomingMessageText;
                try {
                    JsonObject json_message_total = gson.fromJson(total_json, JsonObject.class);
                    total_json = "";
                    Log.d(TAG, "Total Json: " + json_message_total.toString());
                    String action_json = json_message_total.get("action").getAsString();

                    if (action_json.equalsIgnoreCase("Player List")) {
                        ArrayList <Player> player_list_PC = gson.fromJson(json_message_total.get("players").getAsJsonArray(), new TypeToken<ArrayList<Player>>(){}.getType());
                        DisplayCharactersList.player_list.clear();
                        DisplayCharactersList.player_list.addAll(player_list_PC);
                        players_list.clear();
                        ArrayList<String> empty = new ArrayList<>();
                        for (Player player : DisplayCharactersList.player_list) {
                            NPC player_token_npc = new NPC("No Name",0,0,0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "nullID", 0, 0);
                            player_token_npc.setName(player.getCharacter_name());
                            player_token_npc.setPlayer(true);
                            player_token_npc.setUnique_character_id(player.getUnique_character_id());
                            players_list.add(player_token_npc);
                        }
                    }

                    if (action_json.equalsIgnoreCase("Update Character XY")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();
                        int character_x_coordinate = json_message_total.get("character_x_coordinate").getAsInt();
                        int character_y_coordinate = json_message_total.get("character_y_coordinate").getAsInt();

                        for (NPC token : encounter_selected.getNpcs_in_encounter()) {
                            if (token.getUnique_character_id().equalsIgnoreCase(unique_id)) {
                                token.setCharacter_x_coordinate(character_x_coordinate);
                                token.setCharacter_y_coordinate(character_y_coordinate);
                            }
                        }
                    }

                    if (action_json.equalsIgnoreCase("Character has been attacked")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();

                        for (NPC token : encounter_selected.getNpcs_in_encounter()) {
                            if (token.getUnique_character_id().equalsIgnoreCase(unique_id)) {
                                int damage_hit_by = json_message_total.get("damage_roll").getAsInt();
                                Toast.makeText(context, token.getName() + " has been dealt " + damage_hit_by + " damage" , Toast.LENGTH_LONG).show();
                            }
                        }
                    }

                    if (action_json.equalsIgnoreCase("GM End Character Turn")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();

                        Intent updating_turns = new Intent("updateTurns");
                        updating_turns.putExtra("theTurnUID", unique_id);
                        LocalBroadcastManager.getInstance(context).sendBroadcast(updating_turns);
                    }

                    if (action_json.equalsIgnoreCase("Save Game GM Info")) {
                        saveOnlineGMData();
                    }

                } catch (JsonSyntaxException ex) {
                    Log.d(TAG, "Not able to make JSON");
                    largeLog(total_json);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_gmscreen);

        mpageradaptergm = new PageAdapter(getSupportFragmentManager());

        viewpagergm = findViewById(R.id.viewpagergm);
        setupViewPager(viewpagergm);

        tablayout_gmscreen = findViewById(R.id.tablayout_gmscreen);
        tablayout_gmscreen.setupWithViewPager(viewpagergm);

        action = null;
        maps_list.clear();
        info_tab_gm.clear();
        npcs_list.clear();
        players_list.clear();
        encounters_list.clear();

        turn_order_list.setAction("Update Turn List");

        for (NPC beast : DisplayCharactersList.gm_selected.getNpcs_list()) {
            ArrayList<String> attacks = new ArrayList<String>();
            NPC tmp_npc = new NPC("No Name", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, attacks, false, 0, false, "", 0, 0);
            tmp_npc.setName(beast.getName());
            tmp_npc.setHp(beast.getHp());
            tmp_npc.setCurrent_hp(beast.getCurrent_hp());
            tmp_npc.setAc(beast.getAc());
            tmp_npc.setSpeed(beast.getSpeed());
            tmp_npc.setStr_score(beast.getStr_score());
            tmp_npc.setDex_score(beast.getDex_score());
            tmp_npc.setCon_score(beast.getCon_score());
            tmp_npc.setInt_score(beast.getInt_score());
            tmp_npc.setWis_score(beast.getWis_score());
            tmp_npc.setCha_score(beast.getCha_score());
            tmp_npc.setChallenge_score(beast.getChallenge_score());
            tmp_npc.setExp_given(beast.getExp_given());

            for (String beast_attack : beast.getNpc_attack_buttons()) {
                attacks.add(beast_attack);
            }

            tmp_npc.setNpc_attack_buttons(attacks);
            tmp_npc.setPlayer(false);
            tmp_npc.setInitiative(0);
            tmp_npc.setTurn(false);

            npcs_list.add(tmp_npc);

            Comparator<NPC> compareByName = new Comparator<NPC>() {
                @Override
                public int compare(NPC o1, NPC o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            };
            Collections.sort(npcs_list, compareByName);
        }


        for (NPC player_token : DisplayCharactersList.gm_selected.getPlayers_list()) {
            ArrayList<String> attacks = new ArrayList<String>();
            NPC tmp_npc = new NPC("No Name", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, attacks, false, 0, false, "", 0, 0);
            tmp_npc.setName(player_token.getName());
            tmp_npc.setHp(player_token.getHp());
            tmp_npc.setCurrent_hp(player_token.getCurrent_hp());
            tmp_npc.setAc(player_token.getAc());
            tmp_npc.setSpeed(player_token.getSpeed());
            tmp_npc.setStr_score(player_token.getStr_score());
            tmp_npc.setDex_score(player_token.getDex_score());
            tmp_npc.setCon_score(player_token.getCon_score());
            tmp_npc.setInt_score(player_token.getInt_score());
            tmp_npc.setWis_score(player_token.getWis_score());
            tmp_npc.setCha_score(player_token.getCha_score());
            tmp_npc.setChallenge_score(player_token.getChallenge_score());
            tmp_npc.setExp_given(player_token.getExp_given());

            for (String beast_attack : player_token.getNpc_attack_buttons()) {
                attacks.add(beast_attack);
            }

            tmp_npc.setNpc_attack_buttons(attacks);
            tmp_npc.setPlayer(true);
            tmp_npc.setInitiative(0);
            tmp_npc.setTurn(false);
            tmp_npc.setUnique_character_id(player_token.getUnique_character_id());

            players_list.add(tmp_npc);
        }

        Comparator<NPC> compareByName = new Comparator<NPC>() {
            @Override
            public int compare(NPC o1, NPC o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(players_list, compareByName);


        for (Encounter encounter : DisplayCharactersList.gm_selected.getEncounters_list()) {
            ArrayList<NPC> empty = new ArrayList<>();
            String encounter_name = encounter.getEncounterName();
            Encounter tmp_encounter = new Encounter("No Encounter Name", empty);
            tmp_encounter.setEncounterName(encounter_name);

            for (NPC in_encounter : encounter.getNpcs_in_encounter()) {
                ArrayList<String> attacks = new ArrayList<String>();
                NPC tmp_npc = new NPC("No Name", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, attacks, false, 0, false, "", 0, 0);
                tmp_npc.setName(in_encounter.getName());
                tmp_npc.setHp(in_encounter.getHp());
                tmp_npc.setCurrent_hp(in_encounter.getCurrent_hp());
                tmp_npc.setAc(in_encounter.getAc());
                tmp_npc.setSpeed(in_encounter.getSpeed());
                tmp_npc.setStr_score(in_encounter.getStr_score());
                tmp_npc.setDex_score(in_encounter.getDex_score());
                tmp_npc.setCon_score(in_encounter.getCon_score());
                tmp_npc.setInt_score(in_encounter.getInt_score());
                tmp_npc.setWis_score(in_encounter.getWis_score());
                tmp_npc.setCha_score(in_encounter.getCha_score());
                tmp_npc.setChallenge_score(in_encounter.getChallenge_score());
                tmp_npc.setExp_given(in_encounter.getExp_given());

                for (String attacks_player : in_encounter.getNpc_attack_buttons()) {
                    attacks.add(attacks_player);
                }

                tmp_npc.setNpc_attack_buttons(attacks);
                tmp_npc.setPlayer(in_encounter.isPlayer());
                tmp_npc.setInitiative(in_encounter.getInitiative());
                tmp_npc.setTurn(in_encounter.isTurn());
                tmp_npc.setUnique_character_id(in_encounter.getUnique_character_id());
                tmp_npc.setCharacter_x_coordinate(in_encounter.getCharacter_x_coordinate());
                tmp_npc.setCharacter_y_coordinate(in_encounter.getCharacter_y_coordinate());

                empty.add(tmp_npc);
            }

            tmp_encounter.setNpcs_in_encounter(empty);
            encounters_list.add(tmp_encounter);
        }

        Comparator<Encounter> compareByEncounterName = new Comparator<Encounter>() {
            @Override
            public int compare(Encounter o1, Encounter o2) {
                return o1.getEncounterName().compareToIgnoreCase(o2.getEncounterName());
            }
        };
        Collections.sort(encounters_list, compareByEncounterName);


        turn_number = DisplayCharactersList.gm_selected.getTurn_number();
        round_number = DisplayCharactersList.gm_selected.getRound_number();

        ArrayList<NPC> emptynpcs = new ArrayList<>();
        encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
        encounter_selected.setEncounterName(DisplayCharactersList.gm_selected.getEncounter_selected().getEncounterName());
        ArrayList <NPC> for_selected = new ArrayList<>();
        for (NPC in_selected_encounter : DisplayCharactersList.gm_selected.getEncounter_selected().getNpcs_in_encounter()) {
            ArrayList<String> attacks = new ArrayList<String>();
            NPC tmp_npc = new NPC("No Name", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, attacks, false, 0, false, "", 0, 0);
            tmp_npc.setName(in_selected_encounter.getName());
            tmp_npc.setHp(in_selected_encounter.getHp());
            tmp_npc.setCurrent_hp(in_selected_encounter.getCurrent_hp());
            tmp_npc.setAc(in_selected_encounter.getAc());
            tmp_npc.setSpeed(in_selected_encounter.getSpeed());
            tmp_npc.setStr_score(in_selected_encounter.getStr_score());
            tmp_npc.setDex_score(in_selected_encounter.getDex_score());
            tmp_npc.setCon_score(in_selected_encounter.getCon_score());
            tmp_npc.setInt_score(in_selected_encounter.getInt_score());
            tmp_npc.setWis_score(in_selected_encounter.getWis_score());
            tmp_npc.setCha_score(in_selected_encounter.getCha_score());
            tmp_npc.setChallenge_score(in_selected_encounter.getChallenge_score());
            tmp_npc.setExp_given(in_selected_encounter.getExp_given());

            for (String attacks_selected : in_selected_encounter.getNpc_attack_buttons()) {
                attacks.add(attacks_selected);
            }

            tmp_npc.setNpc_attack_buttons(attacks);
            tmp_npc.setPlayer(in_selected_encounter.isPlayer());
            tmp_npc.setInitiative(in_selected_encounter.getInitiative());
            tmp_npc.setTurn(in_selected_encounter.isTurn());
            tmp_npc.setUnique_character_id(in_selected_encounter.getUnique_character_id());
            tmp_npc.setCharacter_x_coordinate(in_selected_encounter.getCharacter_x_coordinate());
            tmp_npc.setCharacter_y_coordinate(in_selected_encounter.getCharacter_y_coordinate());

            for_selected.add(tmp_npc);
        }
        encounter_selected.setNpcs_in_encounter(for_selected);

        for (String info_tab_gm_string : DisplayCharactersList.gm_selected.getInfo_tab_gm()) {
            info_tab_gm.add(info_tab_gm_string);
        }

        if (!MainActivity.offline_mode) {
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver, new IntentFilter("incomingMessage"));
        }
    }

    private void setupViewPager(ViewPager viewPager) {
        PageAdapter adapter = new PageAdapter(getSupportFragmentManager());
        adapter.addFragment(new tab1gm(), "Game");
        adapter.addFragment(new tab2gm(), "NPC");
        adapter.addFragment(new tab3gm(), "Turn");
        adapter.addFragment(new tab4gm(), "Info");
        viewPager.setAdapter(adapter);
    }

    public void AlertBox(String title, String message){
        new AlertDialog.Builder(this)
                .setTitle(title)
                .setMessage(message)
                .setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                    }
                })
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface arg0, int arg1) {
                    }
                }).show();
    }

    private void saveOnlineGMData() {
        ArrayList<NPC> emptynpcs = new ArrayList<>();
        Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
        ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
        ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
        ArrayList<Encounter> encounters_list = new ArrayList<>();
        GM savegamegm = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);

        savegamegm.setBluetooth_id(MainActivity.android_id);
        savegamegm.setAction("Save Game GM");
        savegamegm.setTurn_number(GMScreen.turn_number);
        savegamegm.setRound_number(GMScreen.round_number);
        savegamegm.setEncounters_list(GMScreen.encounters_list);
        savegamegm.setPlayers_list(GMScreen.players_list);
        savegamegm.setEncounter_selected(GMScreen.encounter_selected);

        GMScreen.info_tab_gm.set(0, tab4gm.locations_save_text.getText().toString());
        GMScreen.info_tab_gm.set(1, tab4gm.people_save_text.getText().toString());
        GMScreen.info_tab_gm.set(2, tab4gm.factions_save_text.getText().toString());
        GMScreen.info_tab_gm.set(3, tab4gm.quests_save_text.getText().toString());
        GMScreen.info_tab_gm.set(4, tab4gm.loot_save_text.getText().toString());
        GMScreen.info_tab_gm.set(5, tab4gm.notesgm_save_text.getText().toString());
        GMScreen.info_tab_gm.set(6, tab4gm.world_background_save_text.getText().toString());

        savegamegm.setInfo_tab_gm(GMScreen.info_tab_gm);
        savegamegm.setMaps_list(GMScreen.maps_list);
        savegamegm.setNpcs_list(GMScreen.npcs_list);

        Gson gson = new Gson();
        String json = gson.toJson(savegamegm);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }

    private void largeLog(String json) {
        if (json.length() > 4000) {
            Log.d(TAG, json.substring(0, 4000));
            largeLog(json.substring(4000));
        }
        else {
            Log.d(TAG, json);
        }
    }
}