package com.sd2group30.gamingwizard;

import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;

public class MainActivity extends AppCompatActivity implements AdapterView.OnItemClickListener {
    private static final String TAG = "MainActivity";
    public static boolean offline_mode = false;
    public static String android_id = UUID.randomUUID().toString();

    TextView status_text;
    Button enable_bluetooth, make_discoverable, list_paired_devices, join_session_button, offline_mode_button;
    public ArrayList<BluetoothDevice> mBTDevices = new ArrayList<>();
    public DeviceListAdapter mDeviceListAdapter;
    ListView list_view_devices;
    BluetoothAdapter vBlueAdapter;
    public static BluetoothConnectionService mBluetoothConnection;
    BluetoothDevice mBTDevice;
    String incomingConnect = "";

    private static final UUID MY_UUID = UUID.fromString("bc50d0f9-e51e-4d7d-97f6-491aa5116105");

    BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingMessageText = intent.getStringExtra("theMessage");
                Log.d(TAG, "In Main Activity Receive: " + incomingMessageText);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver mReceiverConnect = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                incomingConnect = intent.getStringExtra("theMessageConnect");
                if ((incomingConnect == null) || (incomingConnect.equalsIgnoreCase("FAILED"))) {
                    status_text.setText("No Connection");
                }
                else if (incomingConnect.equalsIgnoreCase("Success")){
                    status_text.setText("Connection Established");
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onDestroy() {
        Log.d(TAG, "onDestroy: called.");
        super.onDestroy();
        try {
            unregisterReceiver(mReceiver);
            unregisterReceiver(mReceiverConnect);
        } catch(IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {}

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mBTDevices.clear();
        mBTDevice = null;
        status_text = findViewById(R.id.status_text);
        list_view_devices = findViewById(R.id.list_view_devices);
        enable_bluetooth = findViewById(R.id.enable_bluetooth);
        make_discoverable = findViewById(R.id.make_discoverable);
        list_paired_devices = findViewById(R.id.list_paired_devices);
        join_session_button = findViewById(R.id.join_session_button);
        offline_mode_button = findViewById(R.id.offline_mode_button);

        vBlueAdapter = BluetoothAdapter.getDefaultAdapter();

        if (vBlueAdapter == null) {
            offline_mode = true;
            showToast("Bluetooth is not available for this device");
        }
        else {
            offline_mode = false;
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver, new IntentFilter("incomingMessage"));
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiverConnect, new IntentFilter("incomingConnected"));
        }

        list_view_devices.setOnItemClickListener(this);

        enable_bluetooth.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (vBlueAdapter == null) {
                    showToast("Bluetooth is not available for this device");
                    Log.d(TAG, "onClick: " + android_id);
                } else {
                    if (!vBlueAdapter.isEnabled()) {
                        showToast("Enabling Bluetooth...");

                        Intent enableBTintent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                        startActivity(enableBTintent);
                    } else {
                        showToast("Bluetooth is already on");
                    }
                }
            }
        });

        make_discoverable.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (vBlueAdapter == null) {
                    showToast("Bluetooth is not available for this device");
                } else {
                    if (!vBlueAdapter.isDiscovering()) {
                        Intent discoverableintent = new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE);
                        discoverableintent.putExtra(BluetoothAdapter.EXTRA_DISCOVERABLE_DURATION, 180);
                        startActivity(discoverableintent);
                    }
                }
            }
        });

        list_paired_devices.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (vBlueAdapter == null) {
                    showToast("Bluetooth is not available for this device");
                }
                else {
                    if (vBlueAdapter.isEnabled()) {
                        Set<BluetoothDevice> devices = vBlueAdapter.getBondedDevices();
                        mBTDevices.clear();
                        for (BluetoothDevice device : devices) {
                            mBTDevices.add(device);
                        }
                        mDeviceListAdapter = new DeviceListAdapter(v.getContext(), R.layout.device_adapter_view, mBTDevices);
                        list_view_devices.setAdapter(mDeviceListAdapter);
                        showToast("Select a paired device to connect to");
                        list_paired_devices.setText("Update Paired Devices");
                    }
                    else {
                        showToast("Bluetooth is off");
                    }
                }
            }
        });
    }

    public void startBTConnection(BluetoothDevice device, UUID uuid) {
        Log.d(TAG, "startBTConnection: Initializing RFCOM Bluetooth Connection");
        mBluetoothConnection.startClient(device, uuid);
    }


//     Called when the user taps the Join Session button
    public void connectSession(View view) {
        offline_mode = false;
        DisplayCharactersList.player_list.clear();
        DisplayCharactersList.gm_selected = null;
        if (vBlueAdapter == null || (!vBlueAdapter.isEnabled()) ||
                vBlueAdapter.getBondedDevices() == null || mBTDevice == null || !(incomingConnect.equalsIgnoreCase("Success"))) {
            showToast("Please connect to the PC using Bluetooth");
        }
        else {
            try {
            unregisterReceiver(mReceiver);
            unregisterReceiver(mReceiverConnect);
            } catch(IllegalArgumentException e) {
                e.printStackTrace();
            }

            Intent intent = new Intent(this, DisplayCharactersList.class);
            startActivity(intent);
        }
    }

    public void offlineMode(View view) {
        offline_mode = true;
        DisplayCharactersList.player_list.clear();
        DisplayCharactersList.gm_selected = null;
        try {
            unregisterReceiver(mReceiver);
        } catch(IllegalArgumentException e) {
            e.printStackTrace();
        }
        Intent intent = new Intent(this, DisplayCharactersList.class);
        startActivity(intent);
    }

    private void showToast(String msg) {
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        vBlueAdapter.cancelDiscovery();

        Log.d(TAG, "onItemClick: You Clicked on a device");
        String deviceName = mBTDevices.get(position).getName();
        String deviceAddress = mBTDevices.get(position).getAddress();

        Log.d(TAG, "onItemClick: deviceName = " + deviceName);
        Log.d(TAG, "onItemClick: deviceAddress = " + deviceAddress);

        Log.d(TAG, "Trying to pair with " + deviceName);
        showToast("Trying to pair with " + deviceName);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            mBTDevices.get(position).createBond();

            mBTDevice = mBTDevices.get(position);
            mBluetoothConnection = new BluetoothConnectionService(this);

            startBTConnection(mBTDevice, MY_UUID);
        }
        else {
            showToast("Cannot Create Connection since API is too low.");
        }
    }

    public static void largeLog(String tag, String json) {
        if (json.length() > 4000) {
            Log.d(tag, json.substring(0, 4000));
            largeLog(tag, json.substring(4000));
        }
        else {
            Log.d(tag, json);
        }
    }
}