package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatDialogFragment;

public class NewAttackDialog extends AppCompatDialogFragment {
    private EditText attack_name_dialog, damage_type_dialog;
    private RadioButton attack_proficient_button_dialog, str_mod_chosen, dex_mod_chosen, con_mod_chosen,
            int_mod_chosen, wis_mod_chosen, cha_mod_chosen;
    private NewAttackDialogListener listener;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());

        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.new_attack_dialog, null);

        final Spinner damage_num_dice = view.findViewById(R.id.damage_num_dice);
        ArrayAdapter<String> damage_num_dice_adapter = new ArrayAdapter<>(
                getActivity(),
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.num_dice)
        );
        damage_num_dice_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        damage_num_dice.setAdapter(damage_num_dice_adapter);

        final Spinner type_dice = view.findViewById(R.id.type_dice);
        ArrayAdapter<String> type_dice_adapter = new ArrayAdapter<>(
                getActivity(),
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.dice_type)
        );
        type_dice_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        type_dice.setAdapter(type_dice_adapter);

        final Spinner attack_range_dialog = view.findViewById(R.id.attack_range_dialog);
        ArrayAdapter<String> attack_range_dialog_adapter = new ArrayAdapter<>(
                getActivity(),
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.attack_range)
        );
        attack_range_dialog_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        attack_range_dialog.setAdapter(attack_range_dialog_adapter);


        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Create", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        String attack_name = attack_name_dialog.getText().toString();
                        int num_dice = Integer.parseInt(damage_num_dice.getSelectedItem().toString());
                        int type_dice_num = Integer.parseInt(type_dice.getSelectedItem().toString());
                        String attack_type = damage_type_dialog.getText().toString();
                        int attack_range = Integer.parseInt(attack_range_dialog.getSelectedItem().toString());
                        boolean proficient = attack_proficient_button_dialog.isChecked();

                        String mod = null;
                        if (str_mod_chosen.isChecked())
                            mod = "str";
                        else if (dex_mod_chosen.isChecked())
                            mod = "dex";
                        else if (con_mod_chosen.isChecked())
                            mod = "con";
                        else if (int_mod_chosen.isChecked())
                            mod = "int";
                        else if (wis_mod_chosen.isChecked())
                            mod = "wis";
                        else if (cha_mod_chosen.isChecked())
                            mod = "cha";

                        if (attack_name.equalsIgnoreCase(""))
                            attack_name = "Unnamed";

                        if (attack_type.equalsIgnoreCase(""))
                            attack_type = "Bludgeoning";

                        listener.makeNewAttack(attack_name, num_dice, type_dice_num,
                        attack_type, attack_range, proficient, mod);
                    }
                });

        str_mod_chosen = view.findViewById(R.id.str_mod_chosen);
        dex_mod_chosen = view.findViewById(R.id.dex_mod_chosen);
        con_mod_chosen = view.findViewById(R.id.con_mod_chosen);
        int_mod_chosen = view.findViewById(R.id.int_mod_chosen);
        wis_mod_chosen = view.findViewById(R.id.wis_mod_chosen);
        cha_mod_chosen = view.findViewById(R.id.cha_mod_chosen);
        attack_name_dialog = view.findViewById(R.id.attack_name_dialog);
        damage_type_dialog = view.findViewById(R.id.damage_type_dialog);
        attack_proficient_button_dialog = view.findViewById(R.id.attack_proficient_button_dialog);

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        try {
            listener = (NewAttackDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement NewAttackDialogListener");
        }

        super.onAttach(context);
    }

    public interface NewAttackDialogListener {
        void makeNewAttack(String attack_name, int num_dice, int type_dice, String attack_type, int attack_range, boolean proficient, String mod);
    }


    private void showToast(String msg) {
        Toast.makeText(getActivity(), msg, Toast.LENGTH_SHORT).show();
    }
}
