package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatDialogFragment;

public class NewEncounterDialog extends AppCompatDialogFragment {
    private static final String TAG = "NewEncounterDialog";
    private NewEncounterDialogListener listener;
    Spinner npc_dialog1, npc_dialog2, npc_dialog3, npc_dialog4, npc_dialog5;
    TextView encounter_dialog_name;



    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        View view = inflater.inflate(R.layout.new_encounter_dialog, null);
        encounter_dialog_name = view.findViewById(R.id.encounter_dialog_name);

        npc_dialog1 = view.findViewById(R.id.npc_dialog1);
        npc_dialog2 = view.findViewById(R.id.npc_dialog2);
        npc_dialog3 = view.findViewById(R.id.npc_dialog3);
        npc_dialog4 = view.findViewById(R.id.npc_dialog4);
        npc_dialog5 = view.findViewById(R.id.npc_dialog5);

        Integer array_length = GMScreen.npcs_list.size() + 1;
        String[] npc_list_array = new String[array_length];

        npc_list_array[0] = "None";
        for (int i = 1; i < npc_list_array.length; i++) {
            npc_list_array[i] = GMScreen.npcs_list.get(i-1).getName() + "  CR: " + GMScreen.npcs_list.get(i-1).getChallenge_score();
        }

        ArrayAdapter<String> spinnerArrayAdapter = new ArrayAdapter<String>
                (getActivity(), android.R.layout.simple_spinner_item, npc_list_array);
        spinnerArrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

        npc_dialog1.setAdapter(spinnerArrayAdapter);
        npc_dialog2.setAdapter(spinnerArrayAdapter);
        npc_dialog3.setAdapter(spinnerArrayAdapter);
        npc_dialog4.setAdapter(spinnerArrayAdapter);
        npc_dialog5.setAdapter(spinnerArrayAdapter);


        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Create", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        String encounter_name = encounter_dialog_name.getText().toString();
                        Integer npc_location1 = (npc_dialog1.getSelectedItemPosition() - 1);
                        Integer npc_location2 = (npc_dialog2.getSelectedItemPosition() - 1);
                        Integer npc_location3 = (npc_dialog3.getSelectedItemPosition() - 1);
                        Integer npc_location4 = (npc_dialog4.getSelectedItemPosition() - 1);
                        Integer npc_location5 = (npc_dialog5.getSelectedItemPosition() - 1);

                        listener.makeNewEncounter(encounter_name, npc_location1, npc_location2, npc_location3,
                                npc_location4, npc_location5);
                    }
                });

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        try {
            listener = (NewEncounterDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement NewEncounterDialogListener");
        }

        super.onAttach(context);
    }

    public interface NewEncounterDialogListener {
        void makeNewEncounter(String encounter_name, Integer npc_location1, Integer npc_location2, Integer npc_location3, Integer npc_location4, Integer npc_location5);
    }


    private void showToast(String msg) {
        Toast.makeText(getActivity(), msg, Toast.LENGTH_SHORT).show();
    }
}
