package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatDialogFragment;

public class NewEnemyAttackDialog extends AppCompatDialogFragment {
    private NewEnemyAttackDialogListener listener;
    TextView new_enemy_attack_name, enemy_attack_damage_type;
    Spinner enemy_attack_damage_num_dice, enemy_attack_type_dice, enemy_attack_range;
    RadioButton str_radio_info, dex_radio_info, con_radio_info, int_radio_info, wis_radio_info, cha_radio_info;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.new_enemy_attack, null);

        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Create", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        String attack_name = new_enemy_attack_name.getText().toString();
                        int num_dice = Integer.parseInt(enemy_attack_damage_num_dice.getSelectedItem().toString());
                        int type_dice_num = Integer.parseInt(enemy_attack_type_dice.getSelectedItem().toString());
                        String attack_type = enemy_attack_damage_type.getText().toString();
                        int attack_range = Integer.parseInt(enemy_attack_range.getSelectedItem().toString());

                        String mod = null;
                        if (str_radio_info.isChecked())
                            mod = "str";
                        else if (dex_radio_info.isChecked())
                            mod = "dex";
                        else if (con_radio_info.isChecked())
                            mod = "con";
                        else if (int_radio_info.isChecked())
                            mod = "int";
                        else if (wis_radio_info.isChecked())
                            mod = "wis";
                        else if (cha_radio_info.isChecked())
                            mod = "cha";

                        if (attack_name.equalsIgnoreCase(""))
                            attack_name = "Unnamed";

                        if (attack_type.equalsIgnoreCase(""))
                            attack_type = "Bludgeoning";

                        listener.makeNewEnemyAttack(attack_name, num_dice, type_dice_num,
                        attack_type, attack_range, mod);
                    }
                });

        str_radio_info = view.findViewById(R.id.str_radio_info);
        dex_radio_info = view.findViewById(R.id.dex_radio_info);
        con_radio_info = view.findViewById(R.id.con_radio_info);
        int_radio_info = view.findViewById(R.id.int_radio_info);
        wis_radio_info = view.findViewById(R.id.wis_radio_info);
        cha_radio_info = view.findViewById(R.id.cha_radio_info);
        new_enemy_attack_name = view.findViewById(R.id.new_enemy_attack_name);
        enemy_attack_damage_type = view.findViewById(R.id.enemy_attack_damage_type);
        enemy_attack_damage_num_dice = view.findViewById(R.id.enemy_attack_damage_num_dice);
        enemy_attack_type_dice = view.findViewById(R.id.enemy_attack_type_dice);
        enemy_attack_range = view.findViewById(R.id.enemy_attack_range);

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            listener = (NewEnemyAttackDialogListener) context;
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement NewEnemyAttackDialogListener");
        }
    }

    public interface NewEnemyAttackDialogListener {
        void makeNewEnemyAttack(String attack_name, int num_dice, int type_dice, String attack_type, int attack_range, String mod);
    }
}
