package com.sd2group30.gamingwizard;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import com.sd2group30.gamingwizard.main.tab1;
import com.sd2group30.gamingwizard.main.tab2;
import com.sd2group30.gamingwizard.main.tab3;
import com.sd2group30.gamingwizard.main.tab4;
import com.google.android.material.tabs.TabLayout;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class PlayerCharacterSheet extends AppCompatActivity {
    private static final String TAG = "PlayerCharacterSheet";
    private TabLayout tabLayout;
    private ViewPager mviewPager;
    public PageAdapter mpageradapter;
    public static String character_name, character_race, character_class, action, unique_character_id;
    public static int character_level, character_ac_total, character_max_hp, character_current_hp, character_proficiency,
            character_str, character_str_mod, character_dex, character_dex_mod, character_con, character_con_mod,
            character_int, character_int_mod, character_wis, character_wis_mod, character_cha, character_cha_mod,
            character_speed;
    public static boolean str_proficiency = false, dex_proficiency = false, con_proficiency = false, int_proficiency = false,
            wis_proficiency = false, cha_proficiency = false, acrobatics = false, animal_handling = false,
            arcana = false, athletics = false, deception = false, history = false, insight = false,
            intimidation = false, investigation = false, medicine = false, nature = false, perception = false,
            performance = false, persuasion = false, religion = false, sleight_of_hand = false,
            stealth = false, survival = false, character_turn = false;
    public static ArrayList<String> attack_buttons = new ArrayList<String>(), info_tab = new ArrayList<String>();
    public static int character_x_coordinate, character_y_coordinate;
    String total_json = "";

    @Override
    public void onBackPressed() {}

    BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingMessageText = intent.getStringExtra("theMessage");
                Log.d(TAG, "Incoming Message in PlayerCharacterSheet: " + incomingMessageText);

                Gson gson = new Gson();
                total_json = total_json + incomingMessageText;
                try {
                    JsonObject json_message_total = gson.fromJson(total_json, JsonObject.class);
                    total_json = "";
                    String action_json = json_message_total.get("action").getAsString();

                    if (action_json.equalsIgnoreCase("Update Character XY")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();
                        if (unique_id.equalsIgnoreCase(unique_character_id)) {
                            character_x_coordinate = json_message_total.get("character_x_coordinate").getAsInt();
                            character_y_coordinate = json_message_total.get("character_y_coordinate").getAsInt();
                        }
                    }

                    if (action_json.equalsIgnoreCase("Character has been attacked")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();
                        if (unique_id.equalsIgnoreCase(unique_character_id)) {
                            int damage_hit_by = json_message_total.get("damage_roll").getAsInt();
                            Toast.makeText(context, "You have been dealt " + damage_hit_by + " damage" , Toast.LENGTH_LONG).show();
                        }
                    }

                    if (action_json.equalsIgnoreCase("Turn Order Has Changed")) {
                        String unique_id = json_message_total.get("unique_character_id").getAsString();
                        if (unique_id.equalsIgnoreCase(unique_character_id)) {
                            character_turn = true;
                            Toast.makeText(context, "It is your turn" , Toast.LENGTH_LONG).show();
                        }
                        else {
                            if (character_turn) {
                                character_turn = false;
                                Toast.makeText(context, "Your turn was ended by the GM", Toast.LENGTH_LONG).show();
                            }
                            else {
                                character_turn = false;
                            }
                        }
                    }

                    if (action_json.equalsIgnoreCase("Save Game")) {
                        saveOnlinePlayerData();
                    }

                } catch (JsonSyntaxException ex) {
                    Log.d(TAG, "Not able to make JSON");
                    MainActivity.largeLog(TAG, total_json);
                }


            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_player_character_sheet);

        mpageradapter = new PageAdapter(getSupportFragmentManager());

        mviewPager = findViewById(R.id.viewpager);
        setupViewPager(mviewPager);

        tabLayout = findViewById(R.id.tablayout_char_sheet);
        tabLayout.setupWithViewPager(mviewPager);

        character_name = DisplayCharactersList.player_selected.getCharacter_name();
        character_race = DisplayCharactersList.player_selected.getCharacter_race();
        character_class = DisplayCharactersList.player_selected.getCharacter_class();
        character_level = DisplayCharactersList.player_selected.getCharacter_level();
        character_ac_total = DisplayCharactersList.player_selected.getCharacter_ac_total();
        character_max_hp = DisplayCharactersList.player_selected.getCharacter_max_hp();
        character_current_hp = DisplayCharactersList.player_selected.getCharacter_current_hp();
        character_proficiency = DisplayCharactersList.player_selected.getCharacter_proficiency();
        character_speed = DisplayCharactersList.player_selected.getCharacter_speed();

        character_str = DisplayCharactersList.player_selected.getCharacter_str();
        character_str_mod = DisplayCharactersList.player_selected.getCharacter_str_mod();
        character_dex = DisplayCharactersList.player_selected.getCharacter_dex();
        character_dex_mod = DisplayCharactersList.player_selected.getCharacter_dex_mod();
        character_con = DisplayCharactersList.player_selected.getCharacter_con();
        character_con_mod = DisplayCharactersList.player_selected.getCharacter_con_mod();
        character_int = DisplayCharactersList.player_selected.getCharacter_int();
        character_int_mod = DisplayCharactersList.player_selected.getCharacter_int_mod();
        character_wis = DisplayCharactersList.player_selected.getCharacter_wis();
        character_wis_mod = DisplayCharactersList.player_selected.getCharacter_wis_mod();
        character_cha = DisplayCharactersList.player_selected.getCharacter_cha();
        character_cha_mod = DisplayCharactersList.player_selected.getCharacter_cha_mod();

        str_proficiency = DisplayCharactersList.player_selected.isStr_proficiency();
        dex_proficiency = DisplayCharactersList.player_selected.isDex_proficiency();
        con_proficiency = DisplayCharactersList.player_selected.isCon_proficiency();
        int_proficiency = DisplayCharactersList.player_selected.isInt_proficiency();
        wis_proficiency = DisplayCharactersList.player_selected.isWis_proficiency();
        cha_proficiency = DisplayCharactersList.player_selected.isCha_proficiency();
        acrobatics = DisplayCharactersList.player_selected.isAcrobatics();
        animal_handling = DisplayCharactersList.player_selected.isAnimal_handling();
        arcana = DisplayCharactersList.player_selected.isArcana();
        athletics = DisplayCharactersList.player_selected.isAthletics();
        deception = DisplayCharactersList.player_selected.isDeception();
        history = DisplayCharactersList.player_selected.isHistory();
        insight = DisplayCharactersList.player_selected.isInsight();
        intimidation = DisplayCharactersList.player_selected.isIntimidation();
        investigation = DisplayCharactersList.player_selected.isInvestigation();
        medicine = DisplayCharactersList.player_selected.isMedicine();
        nature = DisplayCharactersList.player_selected.isNature();
        perception = DisplayCharactersList.player_selected.isPerception();
        performance = DisplayCharactersList.player_selected.isPerformance();
        persuasion = DisplayCharactersList.player_selected.isPersuasion();
        religion = DisplayCharactersList.player_selected.isReligion();
        sleight_of_hand = DisplayCharactersList.player_selected.isSleight_of_hand();
        stealth = DisplayCharactersList.player_selected.isStealth();
        survival = DisplayCharactersList.player_selected.isSurvival();

        attack_buttons.clear();
        for (String player_attacks : DisplayCharactersList.player_selected.getAttack_buttons()) {
            attack_buttons.add(player_attacks);
        }
        removeDuplicates(attack_buttons);
        Collections.sort(attack_buttons, String.CASE_INSENSITIVE_ORDER);

        info_tab.clear();
        for (String info_tab_player : DisplayCharactersList.player_selected.getInfo_tab()) {
            info_tab.add(info_tab_player);
        }

        character_x_coordinate = DisplayCharactersList.player_selected.getCharacter_x_coordinate();
        character_y_coordinate = DisplayCharactersList.player_selected.getCharacter_y_coordinate();

        action = "null";
        unique_character_id = DisplayCharactersList.player_selected.getUnique_character_id();

        if (!MainActivity.offline_mode) {
            LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver, new IntentFilter("incomingMessage"));
        }

//        info_tab[0] = CP;
//        info_tab[1] = SP;
//        info_tab[2] = EP;
//        info_tab[3] = GP;
//        info_tab[4] = PP;
//        info_tab[5] = Initiative;
//        info_tab[6] = Experience;
//        info_tab[7] = Equipment;
//        info_tab[8] = Inventory;
//        info_tab[9] = Proficiencies;
//        info_tab[10] = Feats;
//        info_tab[11] = Languages;
//        info_tab[12] = Notes;
//        info_tab[13] = Background;
    }

    private ArrayList<String> removeDuplicates(ArrayList<String> list) {
        Set<String> set = new LinkedHashSet<>();
        set.addAll(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public void AlertBox(String title, String message){
        new AlertDialog.Builder(this)
                .setTitle(title)
                .setMessage(message)
                .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface arg0, int arg1) {
                    }
                }).show();
    }

    private void setupViewPager(ViewPager viewPager) {
        PageAdapter adapter = new PageAdapter(getSupportFragmentManager());
        adapter.addFragment(new tab1(), "Stats");
        adapter.addFragment(new tab2(), "Saves");
        adapter.addFragment(new tab3(), "Action");
        adapter.addFragment(new tab4(), "Info");
        viewPager.setAdapter(adapter);
    }

    private void saveOnlinePlayerData() {
        info_tab.set(0, tab4.cp_num.getText().toString());
        info_tab.set(1, tab4.sp_num.getText().toString());
        info_tab.set(2, tab4.ep_num.getText().toString());
        info_tab.set(3, tab4.gp_num.getText().toString());
        info_tab.set(4, tab4.pp_num.getText().toString());

        info_tab.set(5, tab4.initiative_box.getText().toString());
        info_tab.set(6, tab4.experience_box.getText().toString());

        info_tab.set(7, tab4.equipment_save_text.getText().toString());
        info_tab.set(8, tab4.inventory_save_text.getText().toString());
        info_tab.set(9, tab4.proficienies_save_text.getText().toString());
        info_tab.set(10, tab4.feats_save_text.getText().toString());
        info_tab.set(11, tab4.languages_save_text.getText().toString());
        info_tab.set(12, tab4.notes_save_text.getText().toString());
        info_tab.set(13, tab4.background_save_text.getText().toString());


        ArrayList<String> updated_attacks_list = new ArrayList<>();
        ArrayList<String> updated_info_list = new ArrayList<>();

        Player updated_player = new Player("","","","","", 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,false,false,false,false,
                false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
                false,false,false,false,false,false,updated_attacks_list,updated_info_list, "", 0, 0);

        updated_player.setCharacter_name(character_name);
        updated_player.setCharacter_race(character_race);
        updated_player.setCharacter_class(character_class);
        updated_player.setBluetooth_id(MainActivity.android_id);
        updated_player.setAction("Update Character");
        updated_player.setCharacter_level(character_level);
        updated_player.setCharacter_ac_total(character_ac_total);
        updated_player.setCharacter_max_hp(character_max_hp);
        updated_player.setCharacter_current_hp(character_current_hp);
        updated_player.setCharacter_proficiency(character_proficiency);
        updated_player.setCharacter_str(character_str);
        updated_player.setCharacter_str_mod(character_str_mod);
        updated_player.setCharacter_dex(character_dex);
        updated_player.setCharacter_dex_mod(character_dex_mod);
        updated_player.setCharacter_con(character_con);
        updated_player.setCharacter_con_mod(character_con_mod);
        updated_player.setCharacter_int(character_int);
        updated_player.setCharacter_int_mod(character_int_mod);
        updated_player.setCharacter_wis(character_wis);
        updated_player.setCharacter_wis_mod(character_wis_mod);
        updated_player.setCharacter_cha(character_cha);
        updated_player.setCharacter_cha_mod(character_cha_mod);
        updated_player.setCharacter_speed(character_speed);
        updated_player.setStr_proficiency(str_proficiency);
        updated_player.setDex_proficiency(dex_proficiency);
        updated_player.setCon_proficiency(con_proficiency);
        updated_player.setInt_proficiency(int_proficiency);
        updated_player.setWis_proficiency(wis_proficiency);
        updated_player.setCha_proficiency(cha_proficiency);
        updated_player.setAcrobatics(acrobatics);
        updated_player.setAnimal_handling(animal_handling);
        updated_player.setArcana(arcana);
        updated_player.setAthletics(athletics);
        updated_player.setDeception(deception);
        updated_player.setHistory(history);
        updated_player.setInsight(insight);
        updated_player.setIntimidation(intimidation);
        updated_player.setInvestigation(investigation);
        updated_player.setMedicine(medicine);
        updated_player.setNature(nature);
        updated_player.setPerception(perception);
        updated_player.setPerformance(performance);
        updated_player.setPersuasion(persuasion);
        updated_player.setReligion(religion);
        updated_player.setSleight_of_hand(sleight_of_hand);
        updated_player.setStealth(stealth);
        updated_player.setSurvival(survival);
        updated_player.setCharacter_turn(character_turn);

        for (String updated_player_attacks : attack_buttons) {
            updated_attacks_list.add(updated_player_attacks);
        }
        updated_player.setAttack_buttons(updated_attacks_list);

        for (String info_tab_player : info_tab) {
            updated_info_list.add(info_tab_player);
        }
        updated_player.setInfo_tab(updated_info_list);
        updated_player.setUnique_character_id((unique_character_id));

        updated_player.setCharacter_x_coordinate(character_x_coordinate);
        updated_player.setCharacter_y_coordinate(character_y_coordinate);

        Gson gson = new Gson();
        String json = gson.toJson(updated_player);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }
}
