package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatDialogFragment;

public class ProficiencyDialog extends AppCompatDialogFragment {
    private ProficiencyDialogListener listener;
    TextView proficiency_score_dialog;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.proficiency_dialog, null);

        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Set", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        int proficiency = 0;
                        if (proficiency_score_dialog.getText().toString().equalsIgnoreCase(""))
                            proficiency = 0;
                        else
                            proficiency = Integer.parseInt(proficiency_score_dialog.getText().toString());


                        listener.makeProficiency(proficiency);
                    }
                });

        proficiency_score_dialog = view.findViewById(R.id.proficiency_score_dialog);
        proficiency_score_dialog.setText(Integer.toString(PlayerCharacterSheet.character_proficiency));

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        try {
            listener = (ProficiencyDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement ProficiencyDialogListener");
        }

        super.onAttach(context);
    }

    public interface ProficiencyDialogListener {
        void makeProficiency(int proficiency_score);
    }

}
