package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatDialogFragment;

public class RaceClassLevelDialog extends AppCompatDialogFragment {
    private RaceClassLevelDialogListener listener;
    Spinner race_dialog_dropdown, class_dialog_dropdown;
    TextView level_dialog;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.race_class_level_dialog, null);

        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Set", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        String changed_race = "";
                        String changed_class = "";
                        int changed_level = 1;

                        changed_race = race_dialog_dropdown.getSelectedItem().toString();
                        if (changed_race.equalsIgnoreCase("Choose Race"))
                            changed_race = "Aarakocra";

                        changed_class = class_dialog_dropdown.getSelectedItem().toString();
                        if (changed_class.equalsIgnoreCase("Choose Class"))
                            changed_class = "Artificer";

                        if (level_dialog.getText().toString().equalsIgnoreCase(""))
                            changed_level = 1;
                        else
                            changed_level = Integer.parseInt(level_dialog.getText().toString());

                        listener.makeRaceClassLevel(changed_race, changed_class, changed_level);
                    }
                });

        race_dialog_dropdown = view.findViewById(R.id.race_dialog_dropdown);
        class_dialog_dropdown = view.findViewById(R.id.class_dialog_dropdown);
        level_dialog = view.findViewById(R.id.level_dialog);

        race_dialog_dropdown.setSelection(getRaceIndex());
        class_dialog_dropdown.setSelection(getClassIndex());
        level_dialog.setText(Integer.toString(PlayerCharacterSheet.character_level));

        return builder.create();
    }

    private int getRaceIndex() {
        if (PlayerCharacterSheet.character_race.equalsIgnoreCase("")) {
            return 0;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Choose Race")) {
            return 0;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Aarakocra")) {
            return 1;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Aasimar")) {
            return 2;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Bugbear")) {
            return 3;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Centaur")) {
            return 4;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Dragonborn")) {
            return 5;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Dwarf")) {
            return 6;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Elf")) {
            return 7;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Firbolg")) {
            return 8;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Genasi")) {
            return 9;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Gith")) {
            return 10;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Gnome")) {
            return 11;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Goblin")) {
            return 12;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Goliath")) {
            return 13;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Grung")) {
            return 14;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Half-Orc")) {
            return 15;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Halfling")) {
            return 16;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Hobgoblin")) {
            return 17;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Human")) {
            return 18;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Kalashtar")) {
            return 19;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Kenku")) {
            return 20;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Kobold")) {
            return 21;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Lizardfolk")) {
            return 22;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Loxodon")) {
            return 23;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Minotaur")) {
            return 24;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Orc")) {
            return 25;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Tabaxi")) {
            return 26;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Tiefling")) {
            return 27;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Tortle")) {
            return 28;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Triton")) {
            return 29;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Vedalken")) {
            return 30;
        }

        return 0;
    }

    private int getClassIndex() {
        if (PlayerCharacterSheet.character_race.equalsIgnoreCase("")) {
            return 0;
        }
        else if (PlayerCharacterSheet.character_race.equalsIgnoreCase("Choose Class")) {
            return 0;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Artificer")) {
            return 1;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Barbarian")) {
            return 2;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Bard")) {
            return 3;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Blood Hunter")) {
            return 4;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Cleric")) {
            return 5;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Druid")) {
            return 6;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Fighter")) {
            return 7;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Monk")) {
            return 8;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Paladin")) {
            return 9;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Ranger")) {
            return 10;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Rogue")) {
            return 11;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Sorcerer")) {
            return 12;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Warlock")) {
            return 13;
        }
        else if (PlayerCharacterSheet.character_class.equalsIgnoreCase("Wizard")) {
            return 14;
        }

        return 0;
    }

    @Override
    public void onAttach(Context context) {
        try {
            listener = (RaceClassLevelDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement RaceClassLevelDialogListener");
        }

        super.onAttach(context);
    }

    public interface RaceClassLevelDialogListener {
        void makeRaceClassLevel(String new_race, String new_class, int new_level);
    }

}
